/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric.archiver;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.FCStatistics;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.SnmpInfo;
import com.qlogic.device.fcfabric.archiver.events.ArchiverEvent;
import com.qlogic.device.fcfabric.archiver.events.ArchiverEventListener;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.event.GuiError;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import com.qlogic.device.fcfabric.zoning.ZoningFile;
import com.qlogic.device.fcfabric.zoning.ZoningFileException;
import com.qlogic.util.JDocument;
import com.qlogic.util.JElement;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import org.jdom.Element;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class SanboxChassisArchiver
implements ChassisEventListener {
    ChassisEvent eventReceived = null;
    int eventWatingFor = -1;
    private static final long TIMEOUT = 120000L;
    Vector listeners = new Vector();

    public void restoreSwitch(SanboxChassis sanboxChassis, Document document) throws IOException {
        this.restoreSwitch(sanboxChassis, document, true, true, true, true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreSwitch(SanboxChassis sanboxChassis, Document document, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws IOException {
        ErrorType errorType;
        Object object;
        boolean bl7 = false;
        sanboxChassis.addChassisEventListener(this);
        Fabric fabric = null;
        Fabric fabric2 = FabricList.getFabric(sanboxChassis);
        if (fabric2 != null) {
            fabric2.disablePolling();
            fabric = fabric2;
        }
        if (!sanboxChassis.getDiscoveredByIpAddress()) {
            this.doneRestoring(fabric, sanboxChassis, false);
            throw new IOException("Can't restore in-band");
        }
        this.setIgnoreNotifcations(sanboxChassis, true);
        org.w3c.dom.Element element = document.getDocumentElement();
        org.w3c.dom.Element element2 = document.getDocumentElement();
        if (element2 == null) {
            this.doneRestoring(fabric, sanboxChassis, false);
            throw new IOException("failed parsing <Sanbox> tag");
        }
        org.w3c.dom.Element element3 = DeviceUtilities.getSubElement(element2, "Ports");
        if (element3 == null) {
            this.doneRestoring(fabric, sanboxChassis, false);
            throw new IOException("failed parsing <Ports> tag");
        }
        org.w3c.dom.Element element4 = DeviceUtilities.getSubElement(element2, "Parameters");
        if (element4 == null) {
            this.doneRestoring(fabric, sanboxChassis, false);
            throw new IOException("failed parsing <Parameters> tag");
        }
        String string = DeviceUtilities.getData(element4, "ChassisType");
        int n = Integer.parseInt(string);
        if (!this.canRestoreChassisType(sanboxChassis, n)) {
            this.doneRestoring(fabric, sanboxChassis, false);
            throw new IOException("Archive file is for a different chassis type.");
        }
        int n2 = 0;
        sanboxChassis.cancelEPortZoningLoad();
        while (sanboxChassis.getComAgent().getMessagesInSendQueue() > 0 && sanboxChassis.getComAgent().getMessagesInResponseQueue() > 0) {
            object = this;
            synchronized (object) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (++n2 <= 30) continue;
            this.doneRestoring(fabric, sanboxChassis, false);
            return;
        }
        sanboxChassis.setFcAddressAndLock(0xFFFFFD);
        object = sanboxChassis.getEportZoningDb();
        if (bl6) {
            this.fireEvent(new ArchiverEvent(this, 9504, true));
            errorType = this.restoreZoning((Zones)object, sanboxChassis, element2);
            this.fireEvent(new ArchiverEvent(this, 9505, errorType));
            bl7 |= errorType != null;
        }
        try {
            if (bl3) {
                this.fireEvent(new ArchiverEvent(this, 9500, true));
                errorType = this.restorePortParameters(sanboxChassis, element3);
                this.fireEvent(new ArchiverEvent(this, 9501, errorType));
                bl7 |= errorType != null;
            }
            if (bl5) {
                this.fireEvent(new ArchiverEvent(this, 9502, true));
                errorType = this.restoreParameters(sanboxChassis, element4, element3, bl2);
                bl7 |= errorType != null;
                this.fireEvent(new ArchiverEvent(this, 9503, errorType));
                ErrorType errorType2 = this.restoreSwitchSpecificParameters(sanboxChassis, element2);
                bl7 |= errorType2 != null;
            }
            if (bl4) {
                this.fireEvent(new ArchiverEvent(this, 9507, true));
                errorType = this.restoreNetworkParameters(sanboxChassis, element4, bl);
                this.fireEvent(new ArchiverEvent(this, 9508, errorType));
                bl7 |= errorType != null;
            }
        }
        catch (IOException iOException) {
            this.doneRestoring(fabric, sanboxChassis, false);
            throw iOException;
        }
        this.doneRestoring(fabric, sanboxChassis, !bl7);
    }

    private void doneRestoring(Object object, SanboxChassis sanboxChassis, boolean bl) {
        Fabric fabric;
        sanboxChassis.unlockAddress();
        this.setIgnoreNotifcations(sanboxChassis, false);
        sanboxChassis.updateAll();
        if (object != null && object instanceof Fabric && (fabric = (Fabric)object) != null) {
            fabric.enablePolling();
        }
        sanboxChassis.removeChassisEventListener(this);
        this.fireEvent(new ArchiverEvent(this, 9506, bl));
    }

    private ErrorType restorePortParameters(SanboxChassis sanboxChassis, org.w3c.dom.Element element) throws IOException {
        String string = element.getAttribute("number");
        int n = Integer.parseInt(string);
        if (sanboxChassis.getPortCount() < n) {
            n = sanboxChassis.getPortCount();
        }
        return this.applyPortInfo(sanboxChassis, element, n);
    }

    public abstract void setIgnoreNotifcations(SanboxChassis var1, boolean var2);

    public abstract ErrorType restoreSwitchSpecificParameters(SanboxChassis var1, org.w3c.dom.Element var2) throws IOException;

    public abstract ErrorType applyPortInfo(SanboxChassis var1, org.w3c.dom.Element var2, int var3) throws IOException;

    public boolean canRestoreChassisType(SanboxChassis sanboxChassis, int n) {
        return sanboxChassis.getChassisType() == n;
    }

    public ErrorType restoreNetworkParameters(SanboxChassis sanboxChassis, org.w3c.dom.Element element, boolean bl) throws IOException {
        IPInfo iPInfo = sanboxChassis.getIpInfo();
        String string = DeviceUtilities.getData(element, "ipAddress");
        if (bl) {
            iPInfo.setIpAddress(InetAddress.getByName(string));
        }
        string = DeviceUtilities.getData(element, "ipGateway");
        iPInfo.setGateway(InetAddress.getByName(string));
        string = DeviceUtilities.getData(element, "arpTimeout");
        iPInfo.setArpTimeout(Integer.parseInt(string));
        string = DeviceUtilities.getData(element, "ipMask");
        iPInfo.setNetMask(Integer.parseInt(string));
        string = DeviceUtilities.getData(element, "ipBroadcast");
        iPInfo.setBroadcast(Integer.parseInt(string));
        string = DeviceUtilities.getData(element, "bootMethod");
        iPInfo.setIpBootProcess(Integer.parseInt(string));
        SnmpInfo snmpInfo = sanboxChassis.getSnmpInfo();
        if (snmpInfo == null) {
            snmpInfo = new SnmpInfo();
        }
        string = DeviceUtilities.getData(element, "Name");
        snmpInfo.setName(string);
        string = DeviceUtilities.getData(element, "snmpContact");
        snmpInfo.setContact(string);
        string = DeviceUtilities.getData(element, "snmpLocation");
        snmpInfo.setLocation(string);
        string = DeviceUtilities.getData(element, "snmpAuthTrap");
        snmpInfo.setDoAuthTrap(Long.parseLong(string));
        try {
            string = DeviceUtilities.getData(element, "snmpProxyEnable");
        }
        catch (Exception exception) {
            string = null;
        }
        if (string != null) {
            boolean bl2 = string.equals("True");
            snmpInfo.setProxyEnabled(bl2);
        }
        return this.applyNetworkParameters(sanboxChassis, snmpInfo, iPInfo, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorType applyNetworkParameters(SanboxChassis sanboxChassis, SnmpInfo snmpInfo, IPInfo iPInfo, org.w3c.dom.Element element) throws IOException {
        ErrorType errorType = null;
        SanboxChassisArchiver sanboxChassisArchiver = this;
        synchronized (sanboxChassisArchiver) {
            sanboxChassis.applySnmpInfo(snmpInfo);
            errorType = this.waitForEvent(214);
            sanboxChassis.applyIpInfo(iPInfo);
            ErrorType errorType2 = this.waitForEvent(202);
            if (errorType == null) {
                errorType = errorType2;
            }
        }
        return errorType;
    }

    private ErrorType restoreParameters(SanboxChassis sanboxChassis, org.w3c.dom.Element element, org.w3c.dom.Element element2, boolean bl) throws IOException {
        int n;
        String string = DeviceUtilities.getData(element, "ConfiguredDomainId");
        int n2 = bl ? Integer.parseInt(string) : sanboxChassis.getConfiguredDomainId();
        try {
            string = DeviceUtilities.getData(element, "DomainIdLock");
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 1;
        }
        string = DeviceUtilities.getData(element, "AdminState");
        int n3 = Integer.parseInt(string);
        string = DeviceUtilities.getData(element, "MfsTimeout");
        int n4 = Integer.parseInt(string);
        string = element2.getAttribute("number");
        int n5 = Integer.parseInt(string);
        int[] nArray = new int[sanboxChassis.getPortCount()];
        int[] nArray2 = new int[sanboxChassis.getPortCount()];
        int[] nArray3 = new int[sanboxChassis.getPortCount()];
        int[] nArray4 = new int[sanboxChassis.getPortCount()];
        Node node = element2.getFirstChild();
        int n6 = 0;
        while (node != null && n6 < n5) {
            if (node.getNodeName().equals("Port")) {
                org.w3c.dom.Element element3 = (org.w3c.dom.Element)node;
                FCPort fCPort = sanboxChassis.getPort(n6);
                nArray[n6] = fCPort.getAdminState();
                nArray2[n6] = fCPort.getMfsMode();
                nArray3[n6] = fCPort.getAlDisabled();
                PortStates portStates = fCPort.getPortStates();
                nArray4[n6] = portStates.getConfigPortType();
                string = DeviceUtilities.getData(element3, "AdminState");
                nArray[n6] = Integer.parseInt(string);
                string = DeviceUtilities.getData(element3, "MfsMode");
                nArray2[n6] = Integer.parseInt(string);
                string = DeviceUtilities.getData(element3, "ALDisabled");
                nArray3[n6] = Integer.parseInt(string);
                string = DeviceUtilities.getData(element3, "PortType");
                nArray4[n6] = Integer.parseInt(string);
                ++n6;
            }
            node = node.getNextSibling();
        }
        string = DeviceUtilities.getData(element, "Ratov");
        int n7 = Integer.parseInt(string);
        string = DeviceUtilities.getData(element, "Rttov");
        int n8 = Integer.parseInt(string);
        string = DeviceUtilities.getData(element, "Edtov");
        int n9 = Integer.parseInt(string);
        return this.applySwitchConfig(sanboxChassis, n2, n, sanboxChassis.getStageType(), n3, n4, nArray, nArray2, nArray3, nArray4, n8, n7, n9, element2, element);
    }

    abstract ErrorType applySwitchConfig(SanboxChassis var1, int var2, int var3, int var4, int var5, int var6, int[] var7, int[] var8, int[] var9, int[] var10, int var11, int var12, int var13, org.w3c.dom.Element var14, org.w3c.dom.Element var15) throws IOException;

    ErrorType waitForEvent(int n) {
        this.eventReceived = null;
        this.eventWatingFor = n;
        if (!this.waitAndCheckForCancel()) {
            return new GuiError(105);
        }
        return this.eventReceived.getErrorType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveEvent(ChassisEvent chassisEvent) {
        SanboxChassisArchiver sanboxChassisArchiver = this;
        synchronized (sanboxChassisArchiver) {
            if (this.eventWatingFor == chassisEvent.getEventType()) {
                this.eventWatingFor = -1;
                this.eventReceived = chassisEvent;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorType restoreZoning(Zones zones, SanboxChassis sanboxChassis, org.w3c.dom.Element element) throws IOException {
        org.w3c.dom.Element element2 = DeviceUtilities.getSubElement(element, "Zoning");
        if (element2 == null) {
            throw new IOException("failed parsing <ConfiguredZoning> tag");
        }
        org.w3c.dom.Element element3 = DeviceUtilities.getSubElement(element2, "ConfiguredZoning");
        if (element3 == null) {
            throw new IOException("failed parsing <ConfiguredZoning> tag");
        }
        org.w3c.dom.Element element4 = DeviceUtilities.getSubElement(element3, "ZoningConfiguration");
        if (element4 == null) {
            throw new IOException("failed parsing <ConfiguredZoning> tag");
        }
        org.w3c.dom.Element element5 = DeviceUtilities.getSubElement(element, "Parameters");
        if (element5 == null) {
            throw new IOException("failed parsing <Parameters> tag");
        }
        try {
            ZoningFile.parseZoningConfigTag(element4, zones);
        }
        catch (ZoningFileException zoningFileException) {
            return new GuiError(106);
        }
        SanboxChassisArchiver sanboxChassisArchiver = this;
        synchronized (sanboxChassisArchiver) {
            long l = System.currentTimeMillis();
            sanboxChassis.applyEPortZoning(zones);
            ErrorType errorType = this.waitForEvent(242);
            if (errorType != null) {
                return errorType;
            }
            ZoningConfig zoningConfig = sanboxChassis.getZoningConfig();
            String string = DeviceUtilities.getData(element5, "zoningConfigAutoSave");
            boolean bl = string.equals("True");
            zoningConfig.setAutoSave(bl);
            string = DeviceUtilities.getData(element5, "zoningConfigDefaultVisibility");
            int n = 0;
            if (string.equals("None")) {
                n = 1;
            }
            zoningConfig.setDefaultVisibility(n);
            string = DeviceUtilities.getData(element5, "zoningConfigMergeMode");
            int n2 = 0;
            if (string.equals("Brocade") || string.equals("Non-FC-SW-2 Compliant")) {
                n2 = 1;
            }
            zoningConfig.setMergeMode(n2);
            try {
                string = DeviceUtilities.getData(element5, "zoningConfigLegacyAddressFormat");
                boolean bl2 = string.equals("True");
                zoningConfig.setNonSw2Legacy(bl2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            sanboxChassis.applyZoningConfig(zoningConfig);
            errorType = this.waitForEvent(278);
            if (errorType != null) {
                return errorType;
            }
        }
        return null;
    }

    public boolean waitAndCheckForCancel() {
        long l = System.currentTimeMillis() + 120000L;
        try {
            this.wait(120000L);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return this.eventReceived != null;
    }

    public void archiveSwitch(SanboxChassis sanboxChassis, JDocument jDocument) {
        Object object;
        JElement jElement = new JElement("Sanbox");
        JElement jElement2 = this.getChassisTag(sanboxChassis);
        jElement.addContent(jElement2);
        this.fireEvent(new ArchiverEvent(this, 9001, true));
        JElement jElement3 = this.getNameServerTag(sanboxChassis);
        jElement.addContent(jElement3);
        this.fireEvent(new ArchiverEvent(this, 9002, true));
        JElement jElement4 = new JElement("Ports");
        jElement4.setAttribute("number", new Integer(sanboxChassis.getPortCount()).toString());
        FCPort fCPort = sanboxChassis.getFirstPort();
        while (fCPort != null) {
            object = this.getPortConfigTag(sanboxChassis, fCPort);
            jElement4.addContent((Element)object);
            fCPort = sanboxChassis.getNextPort(fCPort);
        }
        jElement.addContent(jElement4);
        this.fireEvent(new ArchiverEvent(this, 9000, true));
        object = sanboxChassis.getStats();
        if (object != null) {
            jElement.addContent(this.getStatsTag((FCStatistics)object));
        }
        this.fireEvent(new ArchiverEvent(this, 9003, true));
        JElement jElement5 = this.fillZoningTag(sanboxChassis);
        jElement.addContent(jElement5);
        this.fireEvent(new ArchiverEvent(this, 9004, true));
        jDocument.setRootElement(jElement);
    }

    public JElement getChassisTag(SanboxChassis sanboxChassis) {
        JElement jElement = new JElement("Parameters");
        JElement jElement2 = new JElement("Name");
        jElement.addContent(new JElement("Name").addContent(sanboxChassis.getChassisName()));
        jElement.addContent(new JElement("ChassisTypeName").addContent(sanboxChassis.getChassisTypeString()));
        jElement.addContent(new JElement("ChassisType").addContent(Integer.toString(sanboxChassis.getChassisType())));
        jElement.addContent(new JElement("AdminState").addContent(Integer.toString(sanboxChassis.getAdminMode())));
        jElement.addContent(new JElement("DomainId").addContent(Integer.toString(sanboxChassis.getDomainId())));
        jElement.addContent(new JElement("ConfiguredDomainId").addContent(Integer.toString(sanboxChassis.getConfiguredDomainId())));
        jElement.addContent(new JElement("DomainIdLock").addContent(Integer.toString(sanboxChassis.getDomainIdLock())));
        jElement.addContent(new JElement("Ratov").addContent(Integer.toString(sanboxChassis.getRaTimeout())));
        jElement.addContent(new JElement("Rttov").addContent(Integer.toString(sanboxChassis.getRtTimeout())));
        jElement.addContent(new JElement("Edtov").addContent(Integer.toString(sanboxChassis.getEdTimeout())));
        jElement.addContent(new JElement("islSecurity").addContent(Integer.toString(sanboxChassis.getEPortSecurity())));
        jElement.addContent(new JElement("Wwn").addContent(sanboxChassis.getWWName().toString()));
        jElement.addContent(new JElement("Status").addContent(FabricUtilities.reasonToString(sanboxChassis.getReasonForStatus())));
        jElement.addContent(new JElement("Vendor").addContent(sanboxChassis.getWWName().getCompanyName()));
        jElement.addContent(new JElement("FlashVersion").addContent(sanboxChassis.getFlashVersionString()));
        jElement.addContent(new JElement("PromFlasherVersion").addContent(sanboxChassis.getSwPromVersionString()));
        jElement.addContent(new JElement("MACAddress").addContent(sanboxChassis.delimitMacAddress()));
        jElement.addContent(new JElement("NumberOfPorts").addContent(Integer.toString(sanboxChassis.getPortCount())));
        jElement.addContent(new JElement("MfsTimeout").addContent(Integer.toString(sanboxChassis.getMfsTimeout())));
        jElement.addContent(new JElement("Temperature").addContent(Integer.toString(sanboxChassis.getTemperature())));
        int n = 0;
        while (n < sanboxChassis.getFanCount()) {
            jElement.addContent(new JElement("FanStatus" + n).addContent(Integer.toString(sanboxChassis.getFanStatus(n))));
            ++n;
        }
        int n2 = 0;
        while (n2 < sanboxChassis.getPowerSupplyCount()) {
            jElement.addContent(new JElement("PowerStatus" + n2).addContent(Integer.toString(sanboxChassis.getPowerSupplyStatus(n2))));
            ++n2;
        }
        IPInfo iPInfo = sanboxChassis.getIpInfo();
        if (iPInfo == null) {
            throw new IllegalArgumentException();
        }
        jElement.addContent(new JElement("ipAddress").addContent(iPInfo.getIpAddress().getHostAddress()));
        jElement.addContent(new JElement("ipMask").addContent(Integer.toString(iPInfo.getNetMask())));
        jElement.addContent(new JElement("ipGateway").addContent(iPInfo.getGateway().getHostAddress()));
        jElement.addContent(new JElement("bootMethod").addContent(Integer.toString(iPInfo.getIpBootProcess())));
        jElement.addContent(new JElement("arpTimeout").addContent(Integer.toString(iPInfo.getArpTimeout())));
        jElement.addContent(new JElement("ipBroadcast").addContent(Integer.toString(iPInfo.getBroadcast())));
        SnmpInfo snmpInfo = sanboxChassis.getSnmpInfo();
        if (snmpInfo == null) {
            throw new IllegalArgumentException();
        }
        jElement.addContent(new JElement("snmpContact").addContent(snmpInfo.getContact()));
        jElement.addContent(new JElement("snmpLocation").addContent(snmpInfo.getLocation()));
        jElement.addContent(new JElement("snmpAuthTrap").addContent(Long.toString(snmpInfo.getDoAuthTrap())));
        jElement.addContent(new JElement("snmpProxyEnable").addContent(snmpInfo.getProxyEnabled() ? "True" : "False"));
        ZoningConfig zoningConfig = sanboxChassis.getZoningConfig();
        if (zoningConfig == null) {
            throw new IllegalArgumentException();
        }
        jElement.addContent(new JElement("zoningConfigAutoSave").addContent(zoningConfig.getAutoSave() ? "True" : "False"));
        jElement.addContent(new JElement("zoningConfigDefaultVisibility").addContent(zoningConfig.getDefaultVisibilityString()));
        jElement.addContent(new JElement("zoningConfigMergeMode").addContent(zoningConfig.getMergeModeLongString()));
        jElement.addContent(new JElement("zoningConfigLegacyAddressFormat").addContent(zoningConfig.getNonSw2Legacy() ? "True" : "False"));
        return jElement;
    }

    public JElement getPortConfigTag(SanboxChassis sanboxChassis, FCPort fCPort) {
        JElement jElement = new JElement("Port");
        PortStates portStates = fCPort.getPortStates();
        if (portStates == null) {
            throw new IllegalArgumentException();
        }
        jElement.addContent(new JElement("Number", Integer.toString(fCPort.getPortNumber())));
        jElement.addContent(new JElement("AdminState", Integer.toString(portStates.getActiveAdminState())));
        jElement.addContent(new JElement("ALDisabled", Integer.toString(fCPort.getAlDisabled())));
        jElement.addContent(new JElement("EportConnState", Integer.toString(fCPort.getEPortConnState())));
        jElement.addContent(new JElement("PortType", Integer.toString(portStates.getPortType())));
        jElement.addContent(new JElement("ActiveAdminState", Integer.toString(portStates.getActiveAdminState())));
        jElement.addContent(new JElement("OperationalAdminState", Integer.toString(portStates.getOperationalAdminState())));
        jElement.addContent(new JElement("LoggedIn", Integer.toString(portStates.getLoggedIn())));
        jElement.addContent(new JElement("MfsMode", Integer.toString(portStates.getMfsMode())));
        FCStatistics fCStatistics = fCPort.getStats();
        jElement.addContent(this.getStatsTag(fCStatistics));
        return jElement;
    }

    public JElement getStatsTag(FCStatistics fCStatistics) {
        JElement jElement = new JElement("Stats");
        jElement.setAttribute("Number", new Integer(fCStatistics.getNumberOfStatistics()).toString());
        jElement.setAttribute("TimeStamp", fCStatistics.getTimeStamp().toString());
        jElement.setAttribute("BaseTimeStamp", fCStatistics.getBaseTimeStamp().toString());
        jElement.setAttribute("SecondToLastTimeStamp", fCStatistics.getSecondToLastTimeStamp().toString());
        int n = 0;
        while (n < fCStatistics.getNumberOfStatistics()) {
            JElement jElement2 = new JElement("stat");
            jElement2.addContent(new JElement("Name", fCStatistics.getStatisticsName(n)));
            jElement2.addContent(new JElement("Value", Long.toString(fCStatistics.getStatisticValue(n))));
            jElement2.addContent(new JElement("Rate", Double.toString(fCStatistics.getStatisticRate(n))));
            jElement2.addContent(new JElement("Delta", Long.toString(fCStatistics.getStatisticDelta(n))));
            jElement.addContent(jElement2);
            ++n;
        }
        return jElement;
    }

    public JElement getNameServerTag(SanboxChassis sanboxChassis) {
        JElement jElement = new JElement("NameServer");
        FCNode fCNode = sanboxChassis.getFirstNode();
        while (fCNode != null) {
            JElement jElement2 = new JElement("Node");
            jElement2.addContent(new JElement("FcAddress", Integer.toHexString(fCNode.getFcAddress())));
            jElement2.addContent(new JElement("NodeWwn", fCNode.getNodeWWName().toString()));
            jElement2.addContent(new JElement("PortWwn", fCNode.getPortWWName().toString()));
            jElement2.addContent(new JElement("Fc4Descriptors", fCNode.getFC4Descriptors()));
            jElement2.addContent(new JElement("Fc4Types", fCNode.getFc4TypesText()));
            jElement.addContent(jElement2);
            fCNode = sanboxChassis.getNextNode(fCNode);
        }
        return jElement;
    }

    public JElement fillZoningTag(SanboxChassis sanboxChassis) {
        Zones zones = sanboxChassis.getEportZoningDb();
        if (zones == null || zones.getErrorReading() || !zones.getCurrentWithSwitch()) {
            throw new IllegalArgumentException();
        }
        JElement jElement = new JElement("Zoning");
        JElement jElement2 = new JElement("ConfiguredZoning");
        jElement2.addContent(ZoningFile.getZoningConfigTag(zones));
        jElement.addContent(jElement2);
        return jElement;
    }

    public void removeListener(ArchiverEventListener archiverEventListener) {
        if (this.listeners.contains(archiverEventListener)) {
            this.listeners.remove(archiverEventListener);
        }
    }

    public void addListener(ArchiverEventListener archiverEventListener) {
        if (!this.listeners.contains(archiverEventListener)) {
            this.listeners.add(archiverEventListener);
        }
    }

    protected void fireEvent(ArchiverEvent archiverEvent) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        int n = 0;
        while (n < this.listeners.size()) {
            ArchiverEventListener archiverEventListener = (ArchiverEventListener)this.listeners.elementAt(n);
            archiverEventListener.receiveEvent(archiverEvent);
            ++n;
        }
    }
}

