/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.Pollable;
import com.qlogic.device.fcfabric.PollingItem;
import com.qlogic.device.fcfabric.Updater;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PollingQueue {
    private static final int ROOT = 0;
    private boolean disabled;
    protected List items = new ArrayList();

    public void disable() {
        this.disabled = true;
    }

    public void enable() {
        this.disabled = false;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public synchronized boolean add(Pollable pollable, Updater updater, long l) {
        return this.add(new PollingItem(pollable, updater, l));
    }

    public synchronized boolean add(Pollable pollable, Updater updater, long l, long l2) {
        return this.add(new PollingItem(pollable, updater, l, l2));
    }

    public synchronized boolean add(Pollable pollable, int n, long l) {
        List list = pollable.getUpdaters();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Updater updater = (Updater)iterator.next();
            if (updater.getEvent() != n) continue;
            return this.add(new PollingItem(pollable, updater, l));
        }
        return false;
    }

    public synchronized boolean add(PollingItem pollingItem) {
        int n = this.items.indexOf(pollingItem);
        if (n == -1) {
            this.items.add(pollingItem);
            n = this.items.size() - 1;
        } else {
            PollingItem pollingItem2 = (PollingItem)this.items.get(n);
            if (pollingItem2.compareTo(pollingItem) <= 0) {
                return false;
            }
            pollingItem2.setWakeTime(pollingItem.getWakeTime());
        }
        this.heapifyUp(n);
        return true;
    }

    public synchronized PollingItem removeRoot() {
        long l = this.getRootWakeTime();
        if (this.disabled || l == -1L || l > System.currentTimeMillis()) {
            return null;
        }
        PollingItem pollingItem = (PollingItem)this.items.get(0);
        if (this.disabled || pollingItem.getWakeTime() > System.currentTimeMillis()) {
            return null;
        }
        PollingItem pollingItem2 = (PollingItem)this.items.remove(this.items.size() - 1);
        if (pollingItem2 != pollingItem) {
            this.items.set(0, pollingItem2);
            this.heapifyDown(0);
        }
        return pollingItem;
    }

    public synchronized long getRootWakeTime() {
        if (this.items.size() > 0) {
            return ((PollingItem)this.items.get(0)).getWakeTime();
        }
        return -1L;
    }

    public synchronized boolean remove(PollingItem pollingItem) {
        int n = this.items.indexOf(pollingItem);
        if (n == 0) {
            this.items.remove(0);
        } else {
            this.items.set(n, this.items.remove(this.items.size() - 1));
            this.heapifyDown(n);
        }
        return true;
    }

    public synchronized void remove(Pollable pollable) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            PollingItem pollingItem = (PollingItem)iterator.next();
            if (pollingItem.getTarget() != pollable) continue;
            iterator.remove();
        }
    }

    public synchronized void setIntervals(long[] lArray) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            PollingItem pollingItem = (PollingItem)iterator.next();
            pollingItem.setInterval(this.getDefPollInterval(lArray, pollingItem));
        }
    }

    public synchronized boolean setInterval(Pollable pollable, int n, long l) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            PollingItem pollingItem = (PollingItem)iterator.next();
            if (pollingItem.getTarget() != pollable || pollingItem.getAction().getEvent() != n) continue;
            pollingItem.setInterval(l);
            return true;
        }
        return false;
    }

    public synchronized long getInterval(Pollable pollable, int n) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            PollingItem pollingItem = (PollingItem)iterator.next();
            if (pollingItem.getTarget() != pollable || pollingItem.getAction().getEvent() != n) continue;
            return pollingItem.getInterval();
        }
        return -1L;
    }

    public long getDefPollInterval(long[] lArray, PollingItem pollingItem) {
        switch (pollingItem.getAction().getEvent()) {
            case 212: {
                return lArray[7];
            }
            case 221: {
                return lArray[5];
            }
            case 222: {
                return lArray[4];
            }
            case 219: {
                return lArray[2];
            }
            case 241: {
                return lArray[6];
            }
            case 2010: {
                return lArray[0];
            }
        }
        return lArray[3];
    }

    private void heapifyDown(int n) {
        int n2;
        int n3 = this.items.size();
        while ((n2 = this.lChild(n)) < n3) {
            int n4 = n2;
            int n5 = this.rChild(n);
            if (n5 < n3 && this.get(n5).compareTo(this.get(n2)) < 0) {
                n4 = n5;
            }
            if (this.get(n4).compareTo(this.get(n)) >= 0) break;
            this.swapItems(n4, n);
            n = n4;
        }
    }

    private void heapifyUp(int n) {
        while (n != 0) {
            PollingItem pollingItem;
            int n2 = this.parent(n);
            PollingItem pollingItem2 = (PollingItem)this.items.get(n2);
            if (pollingItem2.compareTo(pollingItem = (PollingItem)this.items.get(n)) > 0) {
                this.swapItems(n2, n);
            }
            n = n2;
        }
    }

    private void swapItems(int n, int n2) {
        PollingItem pollingItem = (PollingItem)this.items.get(n);
        this.items.set(n, this.items.get(n2));
        this.items.set(n2, pollingItem);
    }

    private int lChild(int n) {
        return n * 2 + 1;
    }

    private int rChild(int n) {
        return n * 2 + 2;
    }

    private int parent(int n) {
        return (n - 1) / 2;
    }

    private PollingItem get(int n) {
        return (PollingItem)this.items.get(n);
    }
}

