/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

public class FwVersion
implements Comparable {
    public static final FwVersion UNKNOWN_VERSION = new FwVersion("V0.0.0.0-0");
    int major;
    int minor;
    int branch;
    int tag;

    public FwVersion(int n) {
        this.major = (n & 0xFF000000) >> 24;
        if (this.major < 0) {
            this.major += 256;
        }
        this.minor = (n & 0xFF0000) >> 16;
        if (this.minor < 0) {
            this.minor += 256;
        }
        if (this.major > 1 || this.minor >= 4) {
            this.branch = (n & 0xFF00) >> 8;
            this.tag = n & 0xFF;
        } else {
            this.branch = 0;
            this.tag = n & 0xFFFF;
            if (this.tag < 0) {
                this.tag += 256;
            }
        }
    }

    public FwVersion(String string) {
        String[] stringArray = string.substring(1).split("\\.");
        if (stringArray.length != 2 && stringArray.length != 4) {
            throw new NumberFormatException("Bad version string format");
        }
        this.major = Integer.parseInt(stringArray[0]);
        if (stringArray.length == 2) {
            if ((stringArray = stringArray[1].split("-")).length != 3) {
                throw new NumberFormatException("Bad version string format");
            }
            this.minor = Integer.parseInt(stringArray[0]);
            this.branch = 0;
            this.tag = Integer.parseInt(stringArray[1]);
        } else {
            this.minor = Integer.parseInt(stringArray[1]);
            this.branch = Integer.parseInt(stringArray[2]);
            if ((stringArray = stringArray[3].split("-")).length != 2) {
                throw new NumberFormatException("Bad version string format");
            }
            this.tag = Integer.parseInt(stringArray[0]);
        }
    }

    public String toString() {
        if (this.minor < 4) {
            return this.getMajor() + "." + this.getMinor() + "-" + this.getTag();
        }
        return this.getMajor() + "." + this.getMinor() + "." + this.getBranch() + "." + this.getTag();
    }

    public int getMajor() {
        return this.major;
    }

    public int getRealMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBranch() {
        return this.branch;
    }

    public int getTag() {
        return this.tag;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FwVersion)) {
            return false;
        }
        FwVersion fwVersion = (FwVersion)object;
        return fwVersion.getMajor() == this.getMajor() && fwVersion.getMinor() == this.getMinor() && fwVersion.getBranch() == this.getBranch() && fwVersion.getTag() == this.getTag();
    }

    public int compareTo(Object object) {
        FwVersion fwVersion = (FwVersion)object;
        if (this.getMajor() < fwVersion.getMajor()) {
            return -1;
        }
        if (this.getMajor() > fwVersion.getMajor()) {
            return 1;
        }
        if (this.getMinor() < fwVersion.getMinor()) {
            return -1;
        }
        if (this.getMinor() > fwVersion.getMinor()) {
            return 1;
        }
        if (this.getBranch() < fwVersion.getBranch()) {
            return -1;
        }
        if (this.getBranch() > fwVersion.getBranch()) {
            return 1;
        }
        if (this.getTag() < fwVersion.getTag()) {
            return -1;
        }
        if (this.getTag() > fwVersion.getTag()) {
            return 1;
        }
        return 0;
    }
}

