/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricLink;
import com.qlogic.device.fcfabric.event.FabricListEvent;
import com.qlogic.device.fcfabric.event.FabricListEventListener;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Vector;

public class FabricList {
    private static FabricList instance;
    private Vector fabricList = new Vector();
    private Vector listeners = new Vector();
    private static float pollingLevelMultiplier;

    private FabricList() {
    }

    public static FabricList getInstance() {
        if (instance == null) {
            instance = new FabricList();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fabric getFabric(Chassis chassis) {
        Vector vector;
        if (chassis == null || FabricList.getInstance() == null) {
            return null;
        }
        Vector vector2 = FabricList.instance.fabricList;
        synchronized (vector2) {
            vector = (Vector)FabricList.instance.fabricList.clone();
        }
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Chassis chassis2;
            Fabric fabric = (Fabric)vector.get(n);
            if (fabric != null && (chassis2 = fabric.getSwitchByWWN(chassis.getWWName())) != null && chassis2 == chassis) {
                return fabric;
            }
            ++n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPollingLevelMultiplier(float f) {
        pollingLevelMultiplier = f;
        Vector vector = FabricList.instance.fabricList;
        synchronized (vector) {
            int n = 0;
            int n2 = FabricList.instance.fabricList.size();
            while (n < n2) {
                Fabric fabric = (Fabric)FabricList.instance.fabricList.elementAt(n);
                if (fabric != null) {
                    fabric.setPollingMultiplier(pollingLevelMultiplier);
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fabric getFabric(FabricLink fabricLink) {
        if (fabricLink == null || FabricList.getInstance() == null) {
            return null;
        }
        Vector vector = FabricList.instance.fabricList;
        synchronized (vector) {
            int n = 0;
            int n2 = FabricList.instance.fabricList.size();
            while (n < n2) {
                Fabric fabric = (Fabric)FabricList.instance.fabricList.elementAt(n);
                if (fabric.exists(fabricLink)) {
                    FabricLink fabricLink2 = fabric.getLinkByEnd(fabricLink.getSwitch1(), fabricLink.getPortNumber1());
                    if (fabricLink2 != fabricLink) break;
                    return fabric;
                }
                ++n;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fabric getFabric(String string) {
        if (string == null || FabricList.getInstance() == null) {
            return null;
        }
        Vector vector = FabricList.instance.fabricList;
        synchronized (vector) {
            int n = 0;
            int n2 = FabricList.instance.fabricList.size();
            while (n < n2) {
                Fabric fabric = (Fabric)FabricList.instance.fabricList.elementAt(n);
                if (fabric == null) {
                    return null;
                }
                if (fabric.getFabricName().equals(string)) {
                    return fabric;
                }
                ++n;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasSanbox2() {
        Vector vector = FabricList.instance.fabricList;
        synchronized (vector) {
            Iterator iterator = FabricList.instance.fabricList.iterator();
            while (iterator.hasNext()) {
                Fabric fabric = (Fabric)iterator.next();
                if (!fabric.hasSanbox2()) continue;
                return true;
            }
            return false;
        }
    }

    public static Fabric getFirstFabric() {
        return FabricList.getNextFabric(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Fabric getNextFabric(Fabric fabric) {
        if (FabricList.getInstance() == null) {
            return null;
        }
        if (fabric == null) {
            return (Fabric)FabricList.instance.fabricList.firstElement();
        }
        Vector vector = FabricList.instance.fabricList;
        synchronized (vector) {
            int n = FabricList.instance.fabricList.indexOf(fabric);
            if (n == -1 || ++n >= instance.size()) {
                return null;
            }
            return (Fabric)FabricList.instance.fabricList.elementAt(n);
        }
    }

    public boolean exists(Fabric fabric) {
        return this.fabricList.contains(fabric);
    }

    public int size() {
        return this.fabricList.size();
    }

    public Fabric getFabricAt(int n) {
        return (Fabric)this.fabricList.elementAt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fabricNameExists(String string) {
        Vector vector = this.fabricList;
        synchronized (vector) {
            int n = 0;
            int n2 = this.fabricList.size();
            while (n < n2) {
                Fabric fabric = (Fabric)this.fabricList.elementAt(n);
                if (fabric.getFabricName().equals(string)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fabric addFabric(Fabric fabric) throws IllegalArgumentException {
        if (fabric == null) {
            return null;
        }
        Vector vector = this.fabricList;
        synchronized (vector) {
            if (this.fabricList.indexOf(fabric) != -1) {
                throw new IllegalArgumentException();
            }
            this.fabricList.add(fabric);
        }
        this.fireEvent(5001, fabric);
        return fabric;
    }

    public Fabric addFabric(InetAddress inetAddress, String string, String string2, String string3) throws IllegalArgumentException {
        return this.addFabric(new Fabric(inetAddress, string, string2, string3));
    }

    public Fabric addFabric(InetAddress inetAddress, String string, String string2) throws IllegalArgumentException {
        return this.addFabric(inetAddress, inetAddress.toString(), string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFabric(Fabric fabric) {
        Vector vector = this.fabricList;
        synchronized (vector) {
            int n = this.fabricList.indexOf(fabric);
            if (n < 0) {
                return false;
            }
            this.fabricList.remove(n);
        }
        fabric.die();
        this.fireEvent(5002, fabric);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean removeAllFabrics() {
        if (this.fabricList.size() != 0) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            var1_1 = (Fabric)this.fabricList.remove(0);
            var1_1.die();
            this.fireEvent(5002, var1_1);
lbl6:
            // 2 sources

            ** while (this.fabricList.size() > 0)
        }
lbl7:
        // 1 sources

        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(FabricListEventListener fabricListEventListener) {
        if (fabricListEventListener == null) {
            return;
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            if (!this.listeners.contains(fabricListEventListener)) {
                this.listeners.add(fabricListEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(FabricListEventListener fabricListEventListener) {
        if (fabricListEventListener == null) {
            return;
        }
        Vector vector = this.listeners;
        synchronized (vector) {
            if (this.listeners.contains(fabricListEventListener)) {
                this.listeners.removeElement(fabricListEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(int n, Object object) {
        Vector vector;
        FabricListEvent fabricListEvent = new FabricListEvent(this, n, object);
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            ((FabricListEventListener)vector.elementAt(n2)).receiveEvent(fabricListEvent);
            --n2;
        }
    }

    static {
        pollingLevelMultiplier = 1.0f;
    }
}

