/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import java.util.Date;
import java.util.Vector;

public class FCStatistics {
    Vector stats = new Vector();
    private Date timeStamp = null;
    private Date lastPollTimeStamp = null;
    private Date baseTimeStamp = new Date();

    public Date getTimeStamp() {
        if (this.timeStamp == null) {
            this.timeStamp = new Date();
        }
        return this.timeStamp;
    }

    public Date getSecondToLastTimeStamp() {
        if (this.lastPollTimeStamp == null) {
            this.lastPollTimeStamp = this.getTimeStamp();
        }
        return this.lastPollTimeStamp;
    }

    public Date getBaseTimeStamp() {
        return this.baseTimeStamp;
    }

    public void resetBaseline() {
        int n = 0;
        while (n < this.stats.size()) {
            Stat stat = (Stat)this.stats.elementAt(n);
            stat.setBase(stat.getValue());
            ++n;
        }
        this.baseTimeStamp = this.getTimeStamp();
    }

    public void resetTimeStamp() {
        this.lastPollTimeStamp = this.getTimeStamp();
        this.timeStamp = new Date();
    }

    public int getNumberOfStatistics() {
        return this.stats.size();
    }

    public long getStatisticValue(int n) {
        Stat stat = (Stat)this.stats.elementAt(n);
        return stat.getValue();
    }

    public long getStatisticDelta(int n) {
        Stat stat = (Stat)this.stats.elementAt(n);
        return stat.getDelta();
    }

    public double getStatisticRate(int n) {
        Stat stat = (Stat)this.stats.elementAt(n);
        return stat.getRate();
    }

    public String getStatisticsName(int n) {
        Stat stat = (Stat)this.stats.elementAt(n);
        return stat.getName();
    }

    public void addValue(long l, String string) {
        Stat stat = new Stat(string);
        stat.setValue(l);
        stat.setBase(l);
        this.stats.add(stat);
    }

    public void setValue(long l, int n) {
        Stat stat = (Stat)this.stats.elementAt(n);
        stat.setValue(l);
    }

    class Stat {
        private long value;
        private long lastValue;
        private long base;
        private String name;

        public Stat(String string) {
            this.name = string;
        }

        public long getValue() {
            return this.value;
        }

        public long getBase() {
            return this.base;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(long l) {
            this.lastValue = this.value;
            this.value = l;
        }

        public double getRate() {
            long l = FCStatistics.this.getTimeStamp().getTime() - FCStatistics.this.getSecondToLastTimeStamp().getTime();
            if (l == 0L) {
                return 0.0;
            }
            double d = (double)l / 1000.0;
            double d2 = (double)this.getLastDelta() / d;
            d2 = (double)((long)(d2 * 100.0)) / 100.0;
            return d2;
        }

        public void setBase(long l) {
            this.base = l;
            this.lastValue = l;
        }

        public long getDelta() {
            return this.value - this.base;
        }

        public long getLastDelta() {
            return this.value - this.lastValue;
        }

        public void zeroDelta() {
            this.base = this.value;
        }
    }
}

