/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.FCStatistics;
import com.qlogic.device.fcfabric.InvalidIndexException;
import com.qlogic.device.fcfabric.NameServerEntry;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEventHandler;
import com.qlogic.util.StringUtilities;
import java.util.List;
import java.util.Vector;

public class FCPort {
    public static final int PMODE_UNKNOWN = 0;
    public static final int PMODE_FPORT = 1;
    public static final int PMODE_FLPORT = 2;
    public static final int PMODE_TPORT = 3;
    public static final int PMODE_SLPORT = 4;
    public static final int PMODE_TLPORT = 5;
    public static final int PMODE_DONOR_PORT = 6;
    public static final int PMODE_EPORT = 7;
    public static final int PMODE_GPORT = 8;
    public static final int PMODE_GLPORT = 9;
    public static final int PUBLIC_PORT = 1;
    public static final int PSTATE_ONLINE = 1;
    public static final int PSTATE_OFFLINE = 2;
    public static final int PSTATE_TESTING = 3;
    public static final int PSTATE_FAILED = 4;
    public static final int PSTATE_NOT_INSTALLED = 5;
    public static final int PSTATE_ISOLATED = 6;
    public static final int EP_CONN_STATE_UNKNOWN = -1;
    public static final int EP_CONN_STATE_NONE = 0;
    public static final int EP_CONN_STATE_CONNECTING = 1;
    public static final int EP_CONN_STATE_CONNECTED = 2;
    public static final int EP_CONN_STATE_ISOLATED = 3;
    public static final int ISL_SECURITY_NONE = 0;
    public static final int ISL_SECURITY_INBOX = 1;
    public static final int ISL_SECURITY_ALL = 2;
    public static final int ISL_SECURITY_OURS = 3;
    public static final int LINK_ADDR_GOOD = 1;
    public static final int LINK_ADDR_FAILED = 2;
    public static final int GBIC_OPTICAL_SW0 = 0;
    public static final int GBIC_OPTICAL_LW0 = 1;
    public static final int GBIC_OPTICAL_SW1 = 2;
    public static final int GBIC_COPPER0 = 3;
    public static final int GBIC_OPTICAL_LW1 = 4;
    public static final int GBIC_COPPER1 = 5;
    public static final int GBIC_SERIAL = 6;
    public static final int GBIC_NONE_SB1 = 7;
    public static final int GBIC_BACK_PLANE_PORT = 8;
    public static final int GBIC_NOT_APPLICABLE = 9;
    public static final int GBIC_UNKNOWN = 98;
    public static final int GBIC_NONE = 99;
    protected int portNumber = 0;
    protected boolean backPlanePort;
    protected int fcAddress = 0;
    protected byte AL_PA = 0;
    protected int portMode = 0;
    protected int portState = 0;
    protected Vector nodeList = null;
    protected int nodeCount = 0;
    protected int gbicType = -1;
    protected int linkSwitchFcAddr = 0;
    protected int linkPortNumber = 0;
    protected int portLinkStatus = 0;
    protected FCStatistics stats = null;
    protected PortStates portStates = null;
    protected int ePortConnState = -1;
    protected String ePortIsolatedReason = "N/A";
    protected int adminState = 0;
    protected int alDisabled = 0;
    protected int mfsMode = 0;
    protected SanboxChassis chassis = null;
    protected int ePortSecurity = 2;

    public FCPort(FCStatistics fCStatistics, boolean bl) {
        this.stats = fCStatistics;
        this.backPlanePort = bl;
    }

    public FCPort(int n, SanboxChassis sanboxChassis, FCStatistics fCStatistics, boolean bl) {
        this.portNumber = n;
        this.chassis = sanboxChassis;
        this.stats = fCStatistics;
        this.backPlanePort = bl;
    }

    public FCPort(SanboxChassis sanboxChassis, int n, FCStatistics fCStatistics, boolean bl) {
        this.fcAddress = n;
        this.chassis = sanboxChassis;
        this.portNumber = (n & 0x3F00) >> 8;
        this.stats = fCStatistics;
        this.backPlanePort = bl;
    }

    public boolean isBackPlanePort() {
        return this.backPlanePort;
    }

    public int getGbicType() {
        return this.gbicType;
    }

    public void setGbicType(int n) {
        this.gbicType = n;
    }

    public PortStates getPortStates() {
        return this.portStates;
    }

    public void setPortStates(PortStates portStates) {
        if (this.chassis instanceof Sanbox) {
            this.ePortConnState = this.ePortIsolatedReason.equals("N/A") ? (portStates.getPortType() == 7 ? 2 : 0) : 3;
        }
        this.portStates = portStates;
    }

    public int getEPortSecurity() {
        return this.ePortSecurity;
    }

    public void setEPortSecurity(int n) {
        this.ePortSecurity = n;
    }

    public int getLinkSwitchFcAddr() {
        return this.linkSwitchFcAddr;
    }

    public void setLinkSwitchFcAddr(int n) {
        this.linkSwitchFcAddr = n;
    }

    public int getEPortConnState() {
        return this.ePortConnState;
    }

    public void setEPortConnState(int n) {
        this.ePortConnState = n;
    }

    public String getEPortIsolatedReason() {
        return this.ePortIsolatedReason;
    }

    public void setEPortIsolatedReason(String string) {
        this.ePortIsolatedReason = string;
    }

    public int getLinkPortNumber() {
        return this.linkPortNumber;
    }

    public void setLinkPortNumber(int n) {
        this.linkPortNumber = n;
    }

    public int getPortLinkStatus() {
        return this.portLinkStatus;
    }

    public void setPortLinkStatus(int n) {
        this.portLinkStatus = n;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int n) {
        this.portNumber = n;
    }

    public int getFcAddress() {
        return this.fcAddress;
    }

    public String delimitFCAddress() {
        int n = 0;
        String string = Integer.toHexString(this.fcAddress);
        n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n < 6) {
            int n2 = 6;
            while (n2 > n) {
                stringBuffer.insert(0, "0");
                --n2;
            }
        }
        return stringBuffer.toString();
    }

    public void setFcAddress(int n) {
        this.fcAddress = n;
    }

    public byte getAL_PA() {
        return this.AL_PA;
    }

    public void setAL_PA(byte by) {
        this.AL_PA = by;
    }

    public int getNodeCount() {
        if (this.nodeList != null) {
            return this.nodeList.size();
        }
        return 0;
    }

    public int getPortMode() {
        return this.portMode;
    }

    public void setPortMode(int n) {
        this.portMode = n;
    }

    public int getAlDisabled() {
        return this.alDisabled;
    }

    public void setAlDisabled(int n) {
        this.alDisabled = n;
    }

    public int getMfsMode() {
        return this.mfsMode;
    }

    public void setMfsMode(int n) {
        this.mfsMode = n;
    }

    public int getAdminState() {
        return this.adminState;
    }

    public void setAdminState(int n) {
        this.adminState = n;
    }

    public int getPortState() {
        return this.portState;
    }

    public void setPortState(int n) {
        this.portState = n;
    }

    public SanboxChassis getChassis() {
        return this.chassis;
    }

    public void setChassis(SanboxChassis sanboxChassis) {
        this.chassis = sanboxChassis;
    }

    public FCStatistics getStats() {
        return this.stats;
    }

    public void setStats(FCStatistics fCStatistics) {
        this.stats = fCStatistics;
    }

    public synchronized void clearNodeList() {
        if (this.nodeList != null) {
            this.nodeList.removeAllElements();
            ChassisEventHandler chassisEventHandler = this.chassis.getEventHandler();
            chassisEventHandler.fireChassisEvent(228, (Object)this, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(NameServerEntry nameServerEntry) {
        FCNode fCNode = new FCNode(nameServerEntry, this);
        if (this.nodeList == null) {
            this.nodeList = new Vector();
        }
        Vector vector = this.nodeList;
        synchronized (vector) {
            if (!this.nodeList.contains(fCNode)) {
                this.nodeList.add(fCNode);
                ++this.nodeCount;
                this.chassis.getEventHandler().fireChassisEvent(228, (Object)this, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodes(List list) {
        if (this.nodeList == null) {
            this.nodeList = new Vector();
        }
        Vector vector = this.nodeList;
        synchronized (vector) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                if (!this.nodeList.contains((FCNode)list.get(n2))) {
                    this.nodeList.add((FCNode)list.get(n2));
                    ++this.nodeCount;
                }
                ++n2;
            }
            this.chassis.getEventHandler().fireChassisEvent(228, (Object)this, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeList(List list) {
        if (this.nodeList == null) {
            this.nodeList = new Vector();
        } else {
            this.nodeList.clear();
        }
        Vector vector = this.nodeList;
        synchronized (vector) {
            this.nodeList.addAll(list);
            this.nodeCount = this.nodeList.size();
            this.chassis.getEventHandler().fireChassisEvent(228, (Object)this, true);
        }
    }

    public FCNode getNode(int n) throws InvalidIndexException {
        if (this.nodeList == null || n < 0 || n >= this.nodeList.size()) {
            throw new InvalidIndexException("Unable to return node " + n);
        }
        return (FCNode)this.nodeList.elementAt(n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FCPort)) {
            return false;
        }
        FCPort fCPort = (FCPort)object;
        return this.chassis.equals(fCPort.getChassis()) && this.portNumber == fCPort.getPortNumber();
    }

    public String getZoningStr() {
        int n = (this.fcAddress & 0xFF0000) >> 16;
        String string = Integer.toHexString(n);
        while (string.length() < 2) {
            string = "0" + string;
        }
        String string2 = Integer.toHexString(this.portNumber);
        while (string2.length() < 2) {
            string2 = "0" + string2;
        }
        return string + string2;
    }

    public String getDescription() {
        int n = (this.fcAddress & 0xFF0000) >> 16;
        return new String(DeviceUtilities.getResource("FCPort.domain") + n + " " + DeviceUtilities.getResource("FCPort.portNumber") + this.portNumber);
    }

    public String toString() {
        int n = this.getPortNumber();
        String string = DeviceUtilities.getResource("FCPort.port");
        Object[] objectArray = new Object[]{new Integer(n)};
        return StringUtilities.formatString(string, objectArray);
    }
}

