/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.NameServerEntry;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.zoning.Zones;

public class FCNode {
    public static final int NODE_PMODE_UNKNOWN = 0;
    public static final int NODE_PMODE_NPORT = 1;
    public static final int NODE_PMODE_NLPORT = 2;
    public static final int TI_TARGET = 0;
    public static final int TI_INITIATOR = 1;
    public static final int TI_UNKNOWN = 2;
    public static final int TI_NOT_APP = 3;
    protected WorldWideName nodeWWName;
    protected WorldWideName portWWName;
    protected int portNumber;
    protected int nodePortType;
    protected int fcAddress;
    protected byte AL_PA;
    protected String fc4Types;
    protected String fc4Descriptors;
    protected int targetInitiator;
    protected boolean sharable;
    protected FCPort port;
    protected Chassis chassis;

    public FCNode(NameServerEntry nameServerEntry, FCPort fCPort) {
        this.port = fCPort;
        this.nodePortType = nameServerEntry.getNodePortType();
        this.chassis = this.port.getChassis();
        this.fcAddress = nameServerEntry.getFcAddress();
        this.portNumber = fCPort.getPortNumber();
        this.AL_PA = this.port.getPortMode() != 1 ? (byte)(this.fcAddress & 0xFF) : (byte)0;
        this.nodeWWName = nameServerEntry.getNodeWWName();
        this.portWWName = nameServerEntry.getPortWWName();
        this.fc4Types = nameServerEntry.getFc4TypesText();
        this.fc4Descriptors = nameServerEntry.getFc4Descriptors();
        this.targetInitiator = nameServerEntry.getTargetInitiator();
    }

    public FCNode(NameServerEntry nameServerEntry, Chassis chassis) {
        this.port = null;
        this.nodePortType = nameServerEntry.getNodePortType();
        this.chassis = chassis;
        this.fcAddress = nameServerEntry.getFcAddress();
        this.portNumber = nameServerEntry.getPortNumber();
        this.AL_PA = (byte)(this.fcAddress & 0xFF);
        this.nodeWWName = nameServerEntry.getNodeWWName();
        this.portWWName = nameServerEntry.getPortWWName();
        this.fc4Types = nameServerEntry.getFc4TypesText();
        this.fc4Descriptors = nameServerEntry.getFc4Descriptors();
        this.targetInitiator = nameServerEntry.getTargetInitiator();
    }

    public int getTargetInitiator() {
        return this.targetInitiator;
    }

    public boolean isSharable() {
        return this.sharable;
    }

    public void setSharable(boolean bl) {
        this.sharable = bl;
    }

    public String delimitFCAddress() {
        int n = 0;
        String string = Integer.toHexString(this.fcAddress);
        n = string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n < 6) {
            int n2 = 6;
            while (n2 > n) {
                stringBuffer.insert(0, "0");
                --n2;
            }
        }
        return stringBuffer.toString();
    }

    public int getFcAddress() {
        return this.fcAddress;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public int getNodePortType() {
        return this.nodePortType;
    }

    protected void setFcAddress(int n) {
        this.fcAddress = n;
    }

    public WorldWideName getPortWWName() {
        return this.portWWName;
    }

    public WorldWideName getNodeWWName() {
        return this.nodeWWName;
    }

    public byte getAL_PA() {
        return this.AL_PA;
    }

    protected void setAL_PA(byte by) {
        this.AL_PA = by;
    }

    public String getFC4Descriptors() {
        if (this.fc4Descriptors == null) {
            return this.getNodeWWName().getCompanyName();
        }
        return this.fc4Descriptors;
    }

    protected void setFC4Descriptors(String string) {
        this.fc4Descriptors = string;
    }

    public synchronized String getFc4TypesText() {
        return this.fc4Types;
    }

    public FCPort getPort() {
        return this.port;
    }

    protected void setPort(FCPort fCPort) {
        this.port = fCPort;
    }

    public Chassis getChassis() {
        return this.chassis;
    }

    protected void setChassis(Chassis chassis) {
        this.chassis = chassis;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FCNode)) {
            return false;
        }
        FCNode fCNode = (FCNode)object;
        return this.portWWName.equals(fCNode.getPortWWName()) && this.nodeWWName.equals(fCNode.getNodeWWName());
    }

    public String getZonesList() {
        if (this.chassis instanceof SanboxChassis) {
            SanboxChassis sanboxChassis = (SanboxChassis)this.chassis;
            Zones zones = sanboxChassis.getActiveEportZoning();
            return zones.getZonesList(this);
        }
        return new String();
    }

    public String getNPortZoningStr() {
        String string = Integer.toHexString(this.getFcAddress());
        while (string.length() < 6) {
            string = "0" + string;
        }
        return string;
    }

    public String getWwnZoningStr() {
        String string = this.portWWName.toString();
        while (string.length() < 16) {
            string = "0" + string;
        }
        return string;
    }

    public String toString() {
        return "Node(" + this.portWWName.toString() + ")";
    }
}

