/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.device.fcfabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.Director;
import com.qlogic.device.fcfabric.FCDiscovery;
import com.qlogic.device.fcfabric.ForeignSwitch;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.User;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.util.Sanbox8000Sml;
import com.qlogic.device.fcfabric.util.SanboxUtil;
import com.qlogic.device.fcfabric.util.SwitchBladeSml;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.device.fcfabric.util.messages.UtilDestination;
import com.qlogic.device.fcfabric.util.messages.UtilEventListener;
import com.qlogic.device.fcfabric.util.messages.UtilMessage;
import com.qlogic.device.fcfabric.util.messages.UtilMsgLoginRequest;
import com.qlogic.device.fcfabric.util.messages.UtilMsgVersionReq;

public class FCDiscoverer
implements UtilDestination,
UtilEventListener {
    int fcAddress = 0xFFFFFD;
    Chassis newSwitch = null;
    UtilMessage messageReceived = null;
    Thread waitingThread = null;

    public boolean isReachable() {
        return true;
    }

    public boolean isTimedOut(UtilMessage utilMessage) {
        return System.currentTimeMillis() - utilMessage.getTimeSent() > (long)utilMessage.getTimeoutValue();
    }

    public synchronized FCDiscovery DiscoverSwitch(ComAgent comAgent) {
        FCDiscovery fCDiscovery;
        block3: {
            block2: {
                fCDiscovery = this.locateTheSwitch(0xFFFFFD, comAgent, true);
                if (fCDiscovery.getErrorCode() == 1) break block2;
                if (fCDiscovery.getErrorCode() != 2) break block3;
            }
            ForeignSwitch foreignSwitch = new ForeignSwitch(0xFFFFFD, WorldWideName.getUnknownQlogicWwn(), comAgent, fCDiscovery.getErrorCode());
            fCDiscovery = new FCDiscovery(foreignSwitch, fCDiscovery.getErrorCode());
        }
        return fCDiscovery;
    }

    public synchronized FCDiscovery DiscoverSwitch(int n, WorldWideName worldWideName, ComAgent comAgent) {
        FCDiscovery fCDiscovery = this.locateTheSwitch(n, comAgent, true);
        Chassis chassis = fCDiscovery.getChassis();
        if (chassis == null) {
            chassis = new ForeignSwitch(n, worldWideName, comAgent, fCDiscovery.getErrorCode());
            return new FCDiscovery(chassis, fCDiscovery.getErrorCode());
        }
        return fCDiscovery;
    }

    private synchronized FCDiscovery locateTheSwitch(int n, ComAgent comAgent, boolean bl) {
        if (comAgent instanceof UtilAgent) {
            UtilAgent utilAgent = (UtilAgent)comAgent;
            if (utilAgent.isThisThreadTheReponseThread(Thread.currentThread())) {
                System.err.println("DiscoverSwitch called from inside ComAgent's worker thread -> returning null");
                return null;
            }
            this.fcAddress = n;
            return this.getChassis(utilAgent, bl);
        }
        return new FCDiscovery(null, 5);
    }

    public FCDiscovery getChassis(UtilAgent utilAgent, boolean bl) {
        this.messageReceived = null;
        utilAgent.getVersion(this, this);
        while (this.messageReceived == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.messageReceived instanceof UtilMsgVersionReq) {
            if (this.messageReceived.getStatus() == 103) {
                if (bl && (utilAgent.getLoginInfo().getLevel() == -1 || utilAgent.getLoginInfo().getLevel() == -2)) {
                    utilAgent.getLoginInfo().setLoginLevel(0);
                }
                return FCDiscoverer.createChassis((UtilMsgVersionReq)this.messageReceived, utilAgent);
            }
            if (this.messageReceived.getStatus() == 109) {
                return new FCDiscovery(null, 7);
            }
            if (bl) {
                if (this.messageReceived.getStatus() == 104 && this.messageReceived.getErrorCode() == 14) {
                    int n = this.login(utilAgent);
                    if (n == 0) {
                        return this.getChassis(utilAgent, false);
                    }
                    return new FCDiscovery(null, n);
                }
                if (this.messageReceived.getStatus() == 104) {
                    int n = this.messageReceived.getErrorCode();
                    if (n == 9 || n == 5) {
                        return new FCDiscovery(null, 3);
                    }
                    if (n == 16) {
                        return new FCDiscovery(null, 6);
                    }
                }
            } else {
                return new FCDiscovery(null, 1);
            }
        }
        return new FCDiscovery(null, 4);
    }

    private int login(UtilAgent utilAgent) {
        this.messageReceived = null;
        User user = utilAgent.getLoginInfo();
        utilAgent.sendLoginRequest(this, this, user.getUserName(), user.getPassword());
        while (this.messageReceived == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.messageReceived instanceof UtilMsgLoginRequest) {
            UtilMsgLoginRequest utilMsgLoginRequest = (UtilMsgLoginRequest)this.messageReceived;
            if (utilMsgLoginRequest.getStatus() == 103) {
                if (utilMsgLoginRequest.getLoginStatus() == 0) {
                    this.setLoginLevel(user, utilMsgLoginRequest.getLoginLevel());
                    return 0;
                }
                if (utilMsgLoginRequest.getLoginStatus() == 6) {
                    this.setLoginLevel(user, -2);
                    return 2;
                }
            } else if (utilMsgLoginRequest.getErrorCode() == 5) {
                this.setLoginLevel(user, -2);
                return 3;
            }
        }
        this.setLoginLevel(user, -2);
        return 1;
    }

    private void setLoginLevel(User user, int n) {
        if (this.fcAddress == 0xFFFFFD) {
            user.setLoginLevel(n);
        }
    }

    static FCDiscovery createChassis(UtilMsgVersionReq utilMsgVersionReq, UtilAgent utilAgent) {
        UtilDestination utilDestination = null;
        switch (utilMsgVersionReq.getChassisType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                utilDestination = new Director(utilMsgVersionReq, utilAgent);
                break;
            }
            case 0: 
            case 2: {
                utilDestination = new SanboxUtil(utilMsgVersionReq, utilAgent);
                break;
            }
            case 8: 
            case 16: 
            case 25: 
            case 30: {
                utilDestination = new Sanbox2Sml(utilMsgVersionReq, utilAgent);
                break;
            }
            case 26: {
                utilDestination = new Sanbox8000Sml(utilMsgVersionReq, utilAgent);
                break;
            }
            case 33: {
                utilDestination = new SwitchBladeSml(utilMsgVersionReq, utilAgent);
                break;
            }
            case 35: 
            case 36: {
                utilDestination = new Sanbox2Sml(utilMsgVersionReq, utilAgent);
            }
        }
        if (utilDestination != null) {
            if (utilDestination instanceof SanboxChassis) {
                ((SanboxChassis)((Object)utilDestination)).setChassisStatus(1);
            }
            return new FCDiscovery((Chassis)((Object)utilDestination), 0);
        }
        return new FCDiscovery(null, 5);
    }

    public static Chassis createChassis(String string, WorldWideName worldWideName, int n, UtilAgent utilAgent) {
        switch (n) {
            case 0: 
            case 2: {
                return new SanboxUtil(string, worldWideName, n, utilAgent);
            }
            case 8: 
            case 16: 
            case 25: 
            case 30: {
                return new Sanbox2Sml(string, worldWideName, n, utilAgent);
            }
            case 26: {
                return new Sanbox8000Sml(string, worldWideName, n, utilAgent);
            }
            case 33: {
                return new SwitchBladeSml(string, worldWideName, n, utilAgent);
            }
        }
        return new ForeignSwitch(0xFFFFFD, worldWideName, utilAgent, 5);
    }

    public synchronized void receiveMessage(UtilMessage utilMessage) {
        this.messageReceived = utilMessage;
        this.notify();
    }

    public int getFcAddress() {
        return this.fcAddress;
    }

    public boolean useVersion_0() {
        return false;
    }
}

