/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.util.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class Utilities {
    public static final int INVALID_EXIT_CODE = -1;
    public static final String LOCAL_PROPERTIES = new String("local.properties");
    private static long lLocalModified = -1L;
    private static Properties localProperties = null;
    private static Properties oldLocalProperties = null;
    private static File localFile = new File(LOCAL_PROPERTIES);

    public static String getProperty(String string, String string2) {
        Trace.traceAt(900, "In Utilities.getProperty (key, default).");
        String string3 = System.getProperty(string);
        if (string3 == null) {
            Utilities.readPropertiesFile();
            string3 = System.getProperty(string, string2);
        }
        Trace.traceAt(900, "Out Utilities.getProperty (key, default).  Return:  " + string3 + ".");
        return string3;
    }

    public static String getProperty(String string) {
        Trace.traceAt(900, "In Utilities.getProperty.");
        String string2 = System.getProperty(string);
        if (string2 == null) {
            Utilities.readPropertiesFile();
            string2 = System.getProperty(string);
            if (string2 == null) {
                Trace.warn("Unable to Read Properties File for Key: " + string);
            }
        }
        Trace.traceAt(900, "Out Utilities.getProperty.  Return:  " + string2 + ".");
        return string2;
    }

    public static void setProperty(String string, String string2) {
        Trace.traceAt(900, "In Utilities.setLocalProperty.");
        try {
            if (localProperties != null) {
                localProperties.put(string, string2);
                Utilities.writePropertiesFile();
            } else {
                Utilities.readPropertiesFile();
                localProperties.put(string, string2);
                Utilities.writePropertiesFile();
            }
        }
        catch (Exception exception) {
            Trace.warn("Unable to update Local Properties File ");
            Trace.warn("Exception:  " + exception.toString());
        }
        Trace.traceAt(900, "Out Utilities.setLocalProperty.");
    }

    private static void readPropertiesFile() {
        Trace.traceAt(900, "In Utilities.readLocalPropertiesFile.");
        try {
            if (Utilities.hasPropertiesFileChanged()) {
                oldLocalProperties = localProperties;
                localProperties = new Properties(System.getProperties());
                localProperties.load(new BufferedInputStream(new FileInputStream(LOCAL_PROPERTIES)));
                System.setProperties(localProperties);
            }
        }
        catch (Exception exception) {
            Trace.warn("Failed to Read Local Properties File.");
            Trace.warn("Exception:  " + exception.toString());
        }
        Trace.traceAt(900, "Out Utilities.readLocalPropertiesFile.");
    }

    private static void writePropertiesFile() {
        Trace.traceAt(900, "In Utilities.writeLocalPropertiesFile.");
        try {
            localProperties.store(new FileOutputStream(LOCAL_PROPERTIES), "Properties File");
        }
        catch (Exception exception) {
            Trace.warn("Failed to write Local Properties File.");
            Trace.warn("Exception:  " + exception.toString());
        }
        Trace.traceAt(900, "Out Utilities.writeLocalPropertiesFile.");
    }

    private static boolean hasPropertiesFileChanged() {
        boolean bl = false;
        Trace.traceAt(900, "In Utilities.hasLocalPropertiesFileChanged.");
        long l = localFile.lastModified();
        bl = lLocalModified != l;
        Trace.traceAt(900, "Out Utilities.hasLocalPropertiesFileChanged.  Return:  " + bl + ".");
        return bl;
    }

    private static boolean hasSectionChanged(String string) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        Trace.traceAt(900, "In Utilities.hasLocalSectionChanged.");
        string3 = System.getProperty(string);
        string2 = oldLocalProperties.getProperty(string);
        if (oldLocalProperties != null && !string3.equalsIgnoreCase(string2)) {
            bl = false;
            Trace.traceAt(900, "Out Utilities.hasLocalSectionChanged.  Return:  " + bl + ".");
            return bl;
        }
        bl = true;
        Trace.traceAt(900, "Out Utilities.hasLocalSectionChanged.  Return:  " + bl + ".");
        return bl;
    }

    public static int run(String string) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        int n = -1;
        Trace.traceAt(900, "In Utilities.run.");
        try {
            Trace.traceAt(900, "Starting Command Line:  " + string + ".");
            process = runtime.exec(string);
            try {
                n = process.exitValue();
            }
            catch (Exception exception) {
                Trace.warn("Unable to get exit code from running process Exception:  " + exception.toString() + ".");
                n = 0;
            }
        }
        catch (Exception exception) {
            Trace.warn("Unable to execute command line:  " + string + " Exeception:  " + exception.toString() + ".");
        }
        Trace.traceAt(900, "Out Utilities.run.");
        return n;
    }

    public static String removePathSeperator(String string) {
        Trace.traceAt(900, "In Utilities.removePathSeperator.");
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = new String("\\\\");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (stringTokenizer.countTokens() < 1) continue;
            stringBuffer.append("?");
        }
        Trace.traceAt(900, "Out Utilities.removePathSeperator.  Returns:  " + stringBuffer.toString() + ".");
        return stringBuffer.toString();
    }

    public static String addPathSeperator(String string) {
        Trace.traceAt(900, "In Utilities.addPathSeperator.");
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = new String("?");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (stringTokenizer.countTokens() < 1) continue;
            stringBuffer.append("\\");
        }
        Trace.traceAt(900, "Out Utilities.addPathSeperator.  Returns:  " + stringBuffer.toString() + ".");
        return stringBuffer.toString();
    }
}

