/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.util.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Properties;

public class Trace {
    static final String TRACE_KEY = new String("node.trace.level");
    static final String ABORT_HEADER = new String("ABORT: ");
    static final String WARN_HEADER = new String("WARN : ");
    static final String EVENT_HEADER = new String("Event: ");
    static final String SPAWN_HEADER = new String("Spawn: ");
    static final String TRACE_HEADER = new String("Trace: ");
    static final String COM_HEADER = new String("Com: ");
    static final String CONFIG_HEADER = new String("Config: ");
    static final String MEM_HEADER = new String("Mem: ");
    static final String LOW_HEADER = new String("Low: ");
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_WARN = 100;
    public static final int LEVEL_EVENT = 200;
    public static final int LEVEL_SPAWN = 300;
    public static final int LEVEL_TRACE = 400;
    public static final int LEVEL_COM = 500;
    public static final int LEVEL_MEM = 600;
    public static final int LEVEL_CONFIG = 700;
    public static final int LEVEL_LOW = 900;
    public static final int LEVEL_ALL = 1000;
    public static final int INVALID_MODIFY = -1;
    public static final int NOT_TRACED = 0;
    public static final int TRACED = 1;
    static int iLevel = 0;
    static long lModified = -1L;
    static boolean bLevelTranslated = false;
    static final String TRACE_OUTPUT_DATETIMEPREFIX_KEY = new String("node.trace.output.datetimeprefix");
    static final String TRACE_OUTPUT_CONSOLE_KEY = new String("node.trace.output.console");
    static final String TRACE_OUTPUT_FILE_KEY = new String("node.trace.output.file");
    static final String TRACE_OUTPUT_FILE_FILENAME_KEY = new String("node.trace.output.file.filename");
    static boolean m_bTraceOutputDateTimePrefix = false;
    static boolean m_bTraceOutputConsole = true;
    static boolean m_bTraceOutputFile = false;
    static String m_strTraceOutputFilename = null;
    static final String TRACE_OUTPUT_ONLY_SET_LEVEL_KEY = new String("node.trace.output.setlevelonly");
    static final String TRACE_OUTPUT_FILE_BUFFERED_KEY = new String("node.trace.output.file.buffered");
    static boolean m_bTracingBegan = false;
    static boolean m_bTracingPaused = false;
    static boolean m_bTracingOnlySetLevel = false;
    static boolean m_bTraceWithBufferedStream = false;
    static PrintStream m_streamTraceOutput = null;

    public static boolean isTracing() {
        return m_bTracingBegan;
    }

    public static boolean isTracingPaused() {
        return m_bTracingPaused;
    }

    public static boolean isTracingOnlySetLevel() {
        return m_bTracingOnlySetLevel;
    }

    public static boolean isTracingWithDateTimePrefix() {
        return m_bTraceOutputDateTimePrefix;
    }

    public static boolean isTracingToConsole() {
        return m_bTraceOutputConsole;
    }

    public static boolean isTracingToFile() {
        return m_bTraceOutputFile;
    }

    public static boolean isTracingWithBufferedStream() {
        return m_bTraceWithBufferedStream;
    }

    public static int getLevel() {
        return iLevel;
    }

    public static void setLevel(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 1000) {
            n = 1000;
        }
        iLevel = n;
    }

    public static boolean begin(boolean bl) {
        boolean bl2 = false;
        if (!Trace.isTracing()) {
            bl2 = true;
            if (bl) {
                bl2 = Trace.loadSettingsFromPropertiesFile();
            }
            if (bl2) {
                bl2 = Trace.startFileStream();
            }
            if (bl2) {
                m_bTracingBegan = true;
                m_bTracingPaused = false;
            }
        }
        return bl2;
    }

    public static boolean end() {
        boolean bl = false;
        if (Trace.isTracing()) {
            m_bTracingBegan = false;
            m_bTracingPaused = false;
            bl = Trace.stopFileStream();
        }
        return bl;
    }

    public static boolean pause() {
        boolean bl = false;
        if (Trace.isTracing() && !Trace.isTracingPaused()) {
            m_bTracingPaused = true;
            bl = true;
        }
        return bl;
    }

    public static boolean resume() {
        boolean bl = false;
        if (Trace.isTracing() && Trace.isTracingPaused()) {
            m_bTracingPaused = false;
            bl = true;
        }
        return bl;
    }

    public static void setTraceOnlySetLevel(boolean bl) {
        m_bTracingOnlySetLevel = bl;
    }

    public static void setTraceWithDateTimePrefix(boolean bl) {
        m_bTraceOutputDateTimePrefix = bl;
    }

    public static void setTraceToConsole(boolean bl) {
        m_bTraceOutputConsole = bl;
    }

    public static void setTraceToFile(boolean bl, String string, boolean bl2) {
        boolean bl3 = true;
        if (Trace.isTracing() && Trace.isTracingToFile()) {
            bl3 = Trace.stopFileStream();
        }
        m_bTraceOutputFile = bl;
        m_strTraceOutputFilename = string;
        m_bTraceWithBufferedStream = bl2;
        if (bl3 && Trace.isTracing()) {
            bl3 = Trace.startFileStream();
        }
    }

    public static int trace(String string) {
        int n = 0;
        if (Trace.shouldOutput(400)) {
            n = 1;
            Trace.traceOutput(TRACE_HEADER + string);
        }
        return n;
    }

    public static int traceAt(int n, String string) {
        int n2 = 0;
        if (Trace.shouldOutput(n)) {
            String string2;
            if (n == 100) {
                string2 = WARN_HEADER + string;
                n2 = 1;
            } else if (n == 200) {
                string2 = EVENT_HEADER + string;
                n2 = 1;
            } else if (n == 300) {
                string2 = SPAWN_HEADER + string;
                n2 = 1;
            } else if (n == 400) {
                string2 = TRACE_HEADER + string;
                n2 = 1;
            } else if (n == 500) {
                string2 = COM_HEADER + string;
                n2 = 1;
            } else if (n == 600) {
                string2 = MEM_HEADER + string;
                n2 = 1;
            } else if (n == 700) {
                string2 = CONFIG_HEADER + string;
                n2 = 1;
            } else {
                string2 = LOW_HEADER + string;
                n2 = 1;
            }
            if (n2 == 1) {
                Trace.traceOutput(string2);
            }
        }
        return n2;
    }

    public static int warn(String string) {
        int n = 0;
        if (Trace.shouldOutput(100)) {
            n = 1;
            Trace.traceOutput(WARN_HEADER + string);
        }
        return n;
    }

    private static boolean shouldOutput(int n) {
        boolean bl = false;
        if (Trace.isTracing() && !Trace.isTracingPaused()) {
            if (Trace.isTracingOnlySetLevel()) {
                if (n == iLevel) {
                    bl = true;
                }
            } else if (iLevel >= n) {
                bl = true;
            }
        }
        return bl;
    }

    private static void traceOutput(String string) {
        Date date = new Date(System.currentTimeMillis());
        String string2 = Trace.isTracingWithDateTimePrefix() ? date.toString() + " - " + string : string;
        if (Trace.isTracingToConsole()) {
            System.out.println(string2);
        }
        if (Trace.isTracingToFile()) {
            if (Trace.isTracingWithBufferedStream()) {
                m_streamTraceOutput.println(string2);
                if (m_streamTraceOutput.checkError()) {
                    System.out.println("Error: (traceOutput) cannot write to buffered Trace file stream: " + m_strTraceOutputFilename);
                }
            } else {
                try {
                    PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(m_strTraceOutputFilename, true)));
                    printStream.println(string2);
                    printStream.close();
                }
                catch (Exception exception) {
                    System.out.println("Error: (traceOutput) cannot write to unbuffered Trace file stream: " + m_strTraceOutputFilename);
                    System.out.println("Exception:  " + exception.toString());
                }
            }
        }
    }

    private static void clearTraceOptionsSettings() {
        iLevel = 0;
        m_bTracingOnlySetLevel = false;
        m_bTraceOutputDateTimePrefix = false;
        m_bTraceOutputConsole = true;
        m_bTraceOutputFile = false;
        m_bTraceWithBufferedStream = false;
        m_strTraceOutputFilename = null;
    }

    private static boolean loadSettingsFromPropertiesFile() {
        Properties properties = null;
        String string = null;
        Trace.clearTraceOptionsSettings();
        try {
            properties = new Properties(System.getProperties());
            properties.load(new BufferedInputStream(new FileInputStream(Utilities.LOCAL_PROPERTIES)));
            System.setProperties(properties);
        }
        catch (Exception exception) {
            System.out.println("Error: (loadSettingsFromPropertiesFile) reading trace values from properties file");
        }
        string = System.getProperty(TRACE_KEY);
        if (string != null) {
            iLevel = new Integer(string);
            if (iLevel < 0) {
                iLevel = 0;
            }
            if (iLevel > 1000) {
                iLevel = 1000;
            }
        }
        if ((string = System.getProperty(TRACE_OUTPUT_ONLY_SET_LEVEL_KEY)) != null) {
            m_bTracingOnlySetLevel = new Boolean(string);
        }
        if ((string = System.getProperty(TRACE_OUTPUT_DATETIMEPREFIX_KEY)) != null) {
            m_bTraceOutputDateTimePrefix = new Boolean(string);
        }
        if ((string = System.getProperty(TRACE_OUTPUT_CONSOLE_KEY)) != null) {
            m_bTraceOutputConsole = new Boolean(string);
        }
        if ((string = System.getProperty(TRACE_OUTPUT_FILE_KEY)) != null) {
            m_bTraceOutputFile = new Boolean(string);
        }
        if ((string = System.getProperty(TRACE_OUTPUT_FILE_BUFFERED_KEY)) != null) {
            m_bTraceWithBufferedStream = new Boolean(string);
        }
        if ((string = System.getProperty(TRACE_OUTPUT_FILE_FILENAME_KEY)) != null) {
            m_strTraceOutputFilename = new String(string);
        }
        return true;
    }

    private static boolean startFileStream() {
        boolean bl = true;
        if (m_bTraceOutputFile) {
            if (m_bTraceWithBufferedStream) {
                try {
                    m_streamTraceOutput = new PrintStream(new BufferedOutputStream(new FileOutputStream(m_strTraceOutputFilename)));
                    if (m_streamTraceOutput.checkError()) {
                        bl = false;
                        m_bTraceOutputFile = false;
                        System.out.println("Error: (startFileStream) cannot open Trace file stream: " + m_strTraceOutputFilename);
                    }
                }
                catch (Exception exception) {
                    bl = false;
                    m_bTraceOutputFile = false;
                    System.out.println("Error: (startFileStream) cannot open Trace file stream: " + m_strTraceOutputFilename);
                }
            } else {
                m_streamTraceOutput = null;
                try {
                    File file = new File(m_strTraceOutputFilename);
                    if (file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                }
                catch (Exception exception) {
                    bl = false;
                    m_bTraceOutputFile = false;
                    System.out.println("Error: (startFileStream) cannot truncate Trace file stream: " + m_strTraceOutputFilename);
                }
            }
        }
        return bl;
    }

    private static boolean stopFileStream() {
        boolean bl = true;
        if (m_bTraceWithBufferedStream) {
            m_streamTraceOutput.close();
            if (m_streamTraceOutput.checkError()) {
                bl = false;
                System.out.println("Error: (stopFileStream) cannot close Trace file stream: " + m_strTraceOutputFilename);
            }
            m_bTraceOutputFile = false;
            m_streamTraceOutput = null;
        } else {
            m_bTraceOutputFile = false;
        }
        return bl;
    }

    protected void finalize() throws Throwable {
        Trace.stopFileStream();
        System.out.println("NOTE: (Trace.finalize) invoked");
        super.finalize();
    }
}

