/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.util.CommandInterpreter;
import com.qlogic.util.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class SingleInstance
extends Thread {
    private String m_Greeting = null;
    private CommandInterpreter[] m_Interpreters = null;
    private ServerSocket m_ServerSocket = null;

    public SingleInstance(String string, int n, CommandInterpreter[] commandInterpreterArray) throws IOException {
        this.m_ServerSocket = new ServerSocket(n);
        this.m_Interpreters = commandInterpreterArray;
        this.m_Greeting = string;
    }

    public void run() {
        try {
            while (true) {
                this.handleRequest(this.m_ServerSocket.accept());
            }
        }
        catch (IOException iOException) {
            Trace.warn("SingleInstance: server terminated.");
            Trace.warn(iOException.toString());
            try {
                this.m_ServerSocket.close();
                this.m_ServerSocket = null;
            }
            catch (IOException iOException2) {
                this.m_ServerSocket = null;
                Trace.warn("SingleInstance: error closing server socket.");
            }
            return;
        }
    }

    private void handleRequest(Socket socket) {
        String string = null;
        boolean bl = false;
        try {
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            printWriter.println(this.m_Greeting);
            string = bufferedReader.readLine();
            if (this.m_Interpreters != null) {
                int n = 0;
                while (n < this.m_Interpreters.length) {
                    bl &= this.m_Interpreters[n].processCommand(string);
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            Trace.warn("SingleInstance: error reading/writing to client.");
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            Trace.warn("SingleInstance: error closing client socket.");
        }
        if (!bl) {
            Trace.warn("SingleInstance: bad command " + string);
        }
    }
}

