/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.util.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public abstract class EntryManager {
    protected String m_filePath = "";
    protected RandomAccessFile m_file;
    protected boolean m_enabled = true;
    protected boolean m_open = false;
    protected Vector entryVector = new Vector();

    public boolean open(String string) {
        boolean bl = true;
        Trace.traceAt(900, "In EntryManager.open()");
        bl = this.open(string, false);
        Trace.traceAt(900, "Out EntryManager.open(), Returning:  " + bl + ".");
        return bl;
    }

    public synchronized boolean open(String string, boolean bl) {
        boolean bl2 = true;
        Trace.traceAt(400, "EntryManager.open()");
        try {
            if (this.m_open) {
                this.close();
                this.m_open = false;
            }
            this.m_file = new RandomAccessFile(string, "rw");
            this.m_filePath = string;
            this.m_open = true;
            if (!bl) {
                this.m_file.seek(this.m_file.length());
            } else {
                this.truncate();
            }
        }
        catch (IOException iOException) {
            Trace.warn("File Open Failed.  Exception " + iOException.toString() + ".");
            iOException.printStackTrace();
            bl2 = false;
        }
        return bl2;
    }

    public synchronized void close() {
        Trace.traceAt(400, "EntryManager.close()");
        if (this.m_open) {
            try {
                this.m_file.close();
            }
            catch (IOException iOException) {
                Trace.warn("File close failed.  Exception " + iOException.toString() + ".");
                iOException.printStackTrace();
            }
            this.m_filePath = "";
            this.m_open = false;
        }
    }

    public void enable(boolean bl) {
        Trace.traceAt(900, "In EntryManager.enable()");
        this.m_enabled = bl;
        Trace.traceAt(900, "Out EntryManager.enable()");
    }

    public boolean isEnabled() {
        Trace.traceAt(900, "In EntryManager.isEnabled()");
        Trace.traceAt(900, "Out EntryManager.isEnabled().  Returns:  " + this.m_enabled + ".");
        return this.m_enabled;
    }

    public String getFile() {
        Trace.traceAt(900, "In EntryManager.getFile()");
        Trace.traceAt(900, "Out EntryManager.getFile().  Returns:  " + this.m_filePath + ".");
        return this.m_filePath;
    }

    public synchronized void truncate() {
        Trace.traceAt(900, "In, EntryManager.truncate()");
        if (this.m_open && this.m_file != null) {
            try {
                this.m_file.setLength(0L);
            }
            catch (IOException iOException) {
                Trace.warn("Couldn't set the log file length to zero.");
            }
        }
        Trace.traceAt(900, "Out EntryManager.getAlarmTypeString()");
    }

    public boolean isOpen() {
        Trace.traceAt(900, "In EntryManager.isOpen()");
        Trace.traceAt(900, "Out EntryManager.isOpen().  Returns:  " + this.m_open + ".");
        return this.m_open;
    }

    protected void finalize() throws Throwable {
        Trace.traceAt(600, "In EntryManager.finalize()");
        this.m_filePath = null;
        this.m_file = null;
        super.finalize();
        Trace.traceAt(600, "In EntryManager.finalize()");
    }
}

