/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.util;

import com.qlogic.util.Trace;
import com.sun.crypto.provider.SunJCE;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class Encryption {
    private static final String CLASS_NAME = "Encryption";
    private final byte[] m_aEncryptionKey = new byte[]{-32, 28, -78, 80, -87, -12, 41};
    private static final String m_strSecretKeyAlgorithm = "Blowfish";
    private static final String m_strCypherTransformation = "Blowfish/ECB/NoPadding";
    private static final int EIGHT_BYTE_BOUNDARY = 8;
    private Provider m_sunJceProvider = null;
    private SecretKeySpec m_secretKeySpec = null;
    private boolean m_bEncryptionReady = false;

    public Encryption() {
        String string = CLASS_NAME;
        Trace.traceAt(900, "IN " + string + ".");
        try {
            this.m_sunJceProvider = new SunJCE();
            Security.addProvider(this.m_sunJceProvider);
            this.m_secretKeySpec = new SecretKeySpec(this.m_aEncryptionKey, m_strSecretKeyAlgorithm);
            this.m_bEncryptionReady = true;
        }
        catch (Exception exception) {
            this.m_bEncryptionReady = false;
            Trace.warn(string + ": Error while loading provider: " + exception);
        }
        Trace.traceAt(900, "OUT " + string + ".");
    }

    public boolean isReady() {
        return this.m_bEncryptionReady;
    }

    public String encrypt(String string) {
        String string2 = "Encryption.encrypt";
        Cipher cipher = null;
        String string3 = null;
        byte[] byArray = null;
        Trace.traceAt(900, "IN " + string2 + ".");
        if (!this.isReady()) {
            Trace.warn(string2 + ": object not ready to perform encryption (JCE not loaded)");
            return null;
        }
        try {
            cipher = Cipher.getInstance(m_strCypherTransformation);
            cipher.init(1, this.m_secretKeySpec);
            byArray = cipher.doFinal(this.padArrayTo8ByteBoundary(string.getBytes()));
            string3 = new String(this.toHexString(byArray));
            Trace.traceAt(900, string2 + ": Encrypted String:  *" + string3 + "*");
        }
        catch (Exception exception) {
            Trace.warn(string2 + ": Error while encrypting: " + exception);
        }
        Trace.traceAt(900, "OUT " + string2 + ".");
        return string3;
    }

    public String decrypt(String string) {
        String string2 = "Encryption.decrypt";
        Cipher cipher = null;
        String string3 = null;
        byte[] byArray = null;
        Trace.traceAt(900, "IN " + string2 + ".");
        if (!this.isReady()) {
            Trace.warn(string2 + ": object not ready to perform encryption (JCE not loaded)");
            return null;
        }
        if (string.length() % 8 == 0) {
            try {
                cipher = Cipher.getInstance(m_strCypherTransformation);
                cipher.init(2, this.m_secretKeySpec);
                byArray = cipher.doFinal(this.hexStringToByteArray(string));
                string3 = new String(byArray);
                Trace.traceAt(900, string2 + ": Decrypted String:  *" + string3 + "*");
            }
            catch (Exception exception) {
                Trace.warn(string2 + ": Error while decrypting: " + exception);
            }
        } else {
            Trace.warn(string2 + ": String length not on 8-byte boundary: " + string);
        }
        Trace.traceAt(900, "OUT " + string2 + ".");
        return string3;
    }

    private byte[] hexStringToByteArray(String string) {
        String string2 = "Encryption.hexStringToByteArray";
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        Trace.traceAt(900, "IN " + string2 + ".");
        int n2 = 0;
        while (n2 < n) {
            String string3 = "0x" + string.substring(n2 * 2, n2 * 2 + 2);
            Trace.traceAt(900, string2 + ": String Byte Value:  *" + string3 + "*");
            byte by = (byte)Integer.decode(string3).intValue();
            Trace.traceAt(900, string2 + ": Byte Value:  *" + by + "*");
            byArray[n2] = by;
            ++n2;
        }
        Trace.traceAt(900, string2 + ": Byte Array:  *" + byArray + "*");
        Trace.traceAt(900, "OUT " + string2 + ".");
        return byArray;
    }

    private byte[] padArrayTo8ByteBoundary(byte[] byArray) {
        String string = "Encryption.padTo8ByteBoundary";
        Trace.traceAt(900, "IN " + string + ".");
        Trace.traceAt(900, string + ": arrToPad:  *" + this.toHexString(byArray) + "*");
        int n = byArray.length % 8;
        int n2 = byArray.length;
        if (byArray.length == 0) {
            n2 = 8;
        } else if (n != 0) {
            n2 += 8 - n;
        }
        Trace.traceAt(900, string + ": iOldSize:  *" + byArray.length + "*");
        Trace.traceAt(900, string + ": iPaddedArraySize:  *" + n2 + "*");
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray2[n3] = byArray[n3];
            ++n3;
        }
        int n4 = byArray.length;
        while (n4 < n2) {
            byArray2[n4] = 0;
            ++n4;
        }
        Trace.traceAt(900, string + ": arrPadded:  *" + this.toHexString(byArray2) + "*");
        Trace.traceAt(900, "OUT " + string + ".");
        return byArray2;
    }

    private void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.byte2hex(byArray[n2], stringBuffer);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

