/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic;

import com.qlogic.util.Trace;
import com.qlogic.util.Utilities;
import java.text.DateFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class QConstants {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.qlogic.QResource");
    private static final ResourceBundle[] VENDOR_BUNDLES = QConstants.getVendorResource();
    public static final String VENDOR_RESOURCE_KEY = "vendor";
    public static final String DEFAULT_VENDOR = "com.qlogic.qms.hba.vendor.qlogic.VendorResource";
    public static final String BROWSER_LOCATION_KEY = BUNDLE.getString("node_browser_location");
    public static final String SPLASH_DELAY_KEY = "splash.delay";
    public static final String SPLASH_INFO_KEY = "splash.info";
    public static final String PAINT_VERSION_KEY = "paint.ver";
    public static final String DEFAULT_BROWSER_LOCATION = BUNDLE.getString("iexplore_exe");
    public static final String WARNING_DISPLAY_KEY = BUNDLE.getString("warn_display_key");
    public static final String WARNING_PERSIST_KEY = BUNDLE.getString("node_option_warning_persist_enable");
    public static final String CONFIG_CHANGE_PERSIST_KEY = BUNDLE.getString("node_option_config_change_persist_enable");
    public static final String CONFIG_ALARM_KEY = "node.option.config.change";
    public static final String ALARM_LOG_FILENAME_PATH = BUNDLE.getString("alarms_txt");
    public static final String EVENT_LOG_FILENAME_PATH = BUNDLE.getString("events_txt");
    public static final String HOST_LOG_FILENAME_PATH = BUNDLE.getString("hosts_txt");
    public static final String ALARM_LOG_SIZE_KEY = BUNDLE.getString("node_alarm_log_size");
    public static final String EVENT_LOG_SIZE_KEY = BUNDLE.getString("node_log_size");
    public static final String LOG_INFORMATIONAL_KEY = BUNDLE.getString("node_log");
    public static final String LOG_WARNING_KEY = BUNDLE.getString("node_log_warning");
    public static final String PORT_NUMBER_KEY = "node.instance.portnumber";
    public static final DateFormat DATE_FORMAT = (DateFormat)QConstants.getObject("date_formatter");
    public static final String LOG_DATA_DELIMETER = ", ";

    public static String getString(String string) {
        String string2 = BUNDLE.getString(string);
        Trace.traceAt(900, "returning Bundle String:  " + string2 + " from key:  " + string + ".");
        return string2;
    }

    public static Object getObject(String string) {
        Object object = BUNDLE.getObject(string);
        Trace.traceAt(900, "returning Bundle Object:  " + object + " from key:  " + string + ".");
        return object;
    }

    public static String getVendorString(String string) {
        String string2 = null;
        int n = 0;
        while (n < VENDOR_BUNDLES.length) {
            try {
                string2 = VENDOR_BUNDLES[n].getString(string);
                if (string2 != null) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        Trace.traceAt(900, "returning Vendor String:  " + string2 + " from key:  " + string + ".");
        return string2;
    }

    public static Object getVendorObject(String string) {
        Object object = null;
        int n = 0;
        while (n < VENDOR_BUNDLES.length) {
            try {
                object = VENDOR_BUNDLES[n].getObject(string);
                if (object != null) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        Trace.traceAt(900, "returning Vendor Object:  " + object + " from key:  " + string + ".");
        return object;
    }

    private static final ResourceBundle[] getVendorResource() {
        ResourceBundle[] resourceBundleArray = null;
        String string = null;
        int n = 0;
        int n2 = 0;
        string = Utilities.getProperty(VENDOR_RESOURCE_KEY);
        if (string != null) {
            ++n;
        }
        do {
            string = Utilities.getProperty(VENDOR_RESOURCE_KEY + n2);
            ++n2;
            if (string == null) continue;
            ++n;
        } while (string != null);
        Trace.traceAt(900, "We found " + n + " resource bundles.");
        resourceBundleArray = new ResourceBundle[n];
        n = 0;
        n2 = 0;
        try {
            string = Utilities.getProperty(VENDOR_RESOURCE_KEY);
            if (string != null) {
                resourceBundleArray[n] = ResourceBundle.getBundle(string);
                ++n;
            }
            do {
                string = Utilities.getProperty(VENDOR_RESOURCE_KEY + n2);
                ++n2;
                if (string == null) continue;
                Trace.traceAt(900, "Trying to load resource with key '" + string + "'.");
                resourceBundleArray[n] = ResourceBundle.getBundle(string);
                Trace.traceAt(900, "Loaded resource with key '" + string + "'.");
                ++n;
            } while (string != null);
        }
        catch (MissingResourceException missingResourceException) {
            Trace.warn("Failed to load vendor resource: " + string);
            resourceBundleArray = new ResourceBundle[1];
            try {
                resourceBundleArray[0] = ResourceBundle.getBundle(DEFAULT_VENDOR);
            }
            catch (MissingResourceException missingResourceException2) {
                System.out.println("Fatal Error: No vendor resource!");
                System.exit(1);
            }
        }
        return resourceBundleArray;
    }
}

