/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui;

import com.qlogic.ui.tools.TreeControl;
import com.qlogic.util.Trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MainFrame
extends JFrame
implements ChangeListener,
WindowListener {
    public static final int TREE_PANE_WIDTH = 175;
    public static final int TREE_PANE_HEIGHT = 100;
    private static MainFrame INSTANCE = null;
    private JPanel m_ContentPanel = new JPanel(new BorderLayout());
    private JSplitPane m_SplitPane = new JSplitPane();
    private JTabbedPane m_Tabs = new JTabbedPane();
    private JToolBar m_ToolBar = null;
    private JComponent m_StatusBar = null;
    private TreeControl[] m_Controls = null;

    private MainFrame() {
        this.m_SplitPane.setRightComponent(new Panel());
        this.m_SplitPane.setLeftComponent(this.m_Tabs);
        this.m_ContentPanel.add((Component)this.m_SplitPane, "Center");
        this.getContentPane().add((Component)this.m_ContentPanel, "Center");
        this.setSize(800, 575);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
    }

    public static MainFrame instance() {
        block2: {
            if (INSTANCE != null) break block2;
            try {
                INSTANCE = new MainFrame();
            }
            catch (InternalError internalError) {
                System.exit(1);
            }
        }
        return INSTANCE;
    }

    public void addControls(TreeControl[] treeControlArray) {
        this.m_Controls = treeControlArray;
        int n = 0;
        while (n < this.m_Controls.length) {
            this.m_Controls[n].setTarget(this.m_SplitPane);
            JScrollPane jScrollPane = new JScrollPane(this.m_Controls[n].getTree());
            jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 0));
            jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 1));
            jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 2));
            jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 0));
            jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 1));
            jScrollPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 2));
            jScrollPane.setPreferredSize(new Dimension(175, 100));
            this.m_Tabs.add((Component)jScrollPane, this.m_Controls[n].getTreeName());
            ++n;
        }
        this.updateDisplay(this.m_Tabs.getSelectedIndex());
        this.m_Tabs.addChangeListener(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateDisplay(this.m_Tabs.getSelectedIndex());
    }

    private void updateDisplay(int n) {
        if (n >= 0) {
            this.setJMenuBar(this.m_Controls[n].getMenuBar());
            if (this.m_ToolBar != null) {
                Window window = SwingUtilities.windowForComponent(this.m_ToolBar);
                if (window == this) {
                    this.getContentPane().remove(this.m_ToolBar);
                    this.m_ToolBar.setOrientation(0);
                } else if (window != null) {
                    window.dispose();
                }
            }
            if (this.m_StatusBar != null) {
                this.m_ContentPanel.remove(this.m_StatusBar);
            }
            this.m_ToolBar = this.m_Controls[n].getToolBar();
            this.m_StatusBar = this.m_Controls[n].getStatusBar();
            this.getContentPane().add((Component)this.m_ToolBar, "North");
            this.m_ContentPanel.add((Component)this.m_StatusBar, "South");
            this.m_Controls[n].updateTarget();
            this.setTitle(this.m_Controls[n].getApplicationTitle());
            this.m_StatusBar.updateUI();
            this.validate();
        }
    }

    public void requestShutdown() {
        boolean bl = true;
        int n = 0;
        if (this.m_Controls != null) {
            n = 0;
            while (n < this.m_Controls.length && bl) {
                if (!this.m_Controls[n].isShutdownReady()) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                this.setVisible(false);
                n = 0;
                while (n < this.m_Controls.length) {
                    this.m_Controls[n].shutdown();
                    ++n;
                }
                Trace.warn((String)"Exiting Application");
                System.exit(0);
            } else {
                Trace.warn((String)("Unable to shutdown at this time, Control:  " + n + " is not ready!"));
            }
        } else {
            Trace.warn((String)"No Control(s) to shutdown!");
            System.exit(0);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.requestShutdown();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }
}

