/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.perfmon.PerfFabricTreeControl;
import com.qlogic.perfmon.PopupDialog;
import com.qlogic.perfmon.UserPreferences;
import com.qlogic.perfmon.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.ui.QFileChooser;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class UserPreferencesDialog
extends QDialog {
    protected JLabel workingDirLabel = new JLabel(PerfFabricTreeControl.getResource("UserPreferences.options.workingDir"));
    protected JButton fileChooserButton = new JButton(PerfFabricTreeControl.getResource("UserPreferences.options.browse"));
    protected JTextField workingDirText = new JTextField(18);
    protected JLabel browserPathLabel = new JLabel(PerfFabricTreeControl.getResource("UserPreferences.options.browserPath"));
    protected JButton pathChooserButton = new JButton(PerfFabricTreeControl.getResource("UserPreferences.options.browse"));
    protected JTextField browserPathText = new JTextField(18);
    protected JCheckBox autoLoadSaveCheckBox = new JCheckBox(new AutoLoadSaveBoxAction());
    protected JButton optionApplyButton = new JButton(PerfFabricTreeControl.getResource("UserPreferences.apply"));
    protected JButton optionCancelButton = new JButton(PerfFabricTreeControl.getResource("UserPreferences.cancel"));
    protected JCheckBox disableAllChBox = new JCheckBox(PerfFabricTreeControl.getResource("UserPreferences.layout.disableAll"));
    protected JCheckBox windowSizeChBox = new JCheckBox(PerfFabricTreeControl.getResource("UserPreferences.layout.windowSize"));
    protected JCheckBox splitterBarChBox = new JCheckBox(PerfFabricTreeControl.getResource("UserPreferences.layout.splitterBarPosition"));
    protected JButton layoutApplyButton = new JButton(PerfFabricTreeControl.getResource("UserPreferences.apply"));
    protected JButton layoutCancelButton = new JButton(PerfFabricTreeControl.getResource("UserPreferences.cancel"));
    protected JTabbedPane tabbedPane;
    protected JPanel optionPanel;
    protected JPanel layoutPanel;
    protected JFrame frame = null;
    protected UserPreferences preferences;

    public UserPreferencesDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.setTitle(PerfFabricTreeControl.getResource("UserPreferences.title") + " - " + VendorProperties.getFrameTitle());
        this.preferences = UserPreferences.getInstance();
        this.frame = jFrame;
        this.optionPanel = this.createOptionPanel();
        this.initOptionPanel();
        this.getContentPane().add(this.optionPanel);
        this.getRootPane().setDefaultButton(this.optionApplyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2 - 12, (dimension.height - this.getHeight()) / 2 - 12);
    }

    public JPanel createOptionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 4, 8, 0));
        this.optionApplyButton.addActionListener(new ApplyButtonListener("option", this));
        this.optionApplyButton.setMnemonic('O');
        this.optionCancelButton.addActionListener(new CancelButtonListener(this));
        this.optionCancelButton.setMnemonic('C');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.optionApplyButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.optionCancelButton, gridBagConstraints);
        jPanel2.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.userPreferencesDialogHelp"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.workingDirLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        jPanel3.add((Component)this.workingDirText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.fileChooserButton, gridBagConstraints);
        this.fileChooserButton.addActionListener(new FileChooserButtonListener(this));
        this.fileChooserButton.setMnemonic('B');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.browserPathLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        jPanel3.add((Component)this.browserPathText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.pathChooserButton, gridBagConstraints);
        this.pathChooserButton.addActionListener(new PathChooserButtonListener(this));
        this.pathChooserButton.setMnemonic('w');
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(4, 2, 2, 2);
        jPanel4.add((Component)this.autoLoadSaveCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 4, 8);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 8, 4, 8);
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        JPanel jPanel5 = new JPanel();
        jPanel5.add(jPanel2);
        jPanel.add((Component)jPanel5, gridBagConstraints);
        return jPanel;
    }

    protected void initOptionPanel() {
        Properties properties = this.preferences.getUserProperties();
        this.workingDirText.setText(properties.getProperty("workingDir"));
        this.browserPathText.setText(properties.getProperty("browserPath"));
        String string = properties.getProperty("autoSaveLoad");
        if (string.equals("true")) {
            this.autoLoadSaveCheckBox.setSelected(true);
        } else {
            this.autoLoadSaveCheckBox.setSelected(false);
        }
    }

    protected JPanel createLayoutPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.layoutApplyButton.addActionListener(new ApplyButtonListener("layout", this));
        this.layoutCancelButton.addActionListener(new CancelButtonListener(this));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.layoutApplyButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add(this.layoutCancelButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Disable Auto Save Upon Exit"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        jPanel3.add((Component)this.disableAllChBox, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder("Enable Auto Save Upon Exit"));
        gridBagConstraints.gridy = 0;
        jPanel4.add((Component)this.windowSizeChBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel4.add((Component)this.splitterBarChBox, gridBagConstraints);
        this.disableAllChBox.addActionListener(new LayoutCheckBoxListener(this));
        this.windowSizeChBox.addActionListener(new LayoutCheckBoxListener(this));
        this.splitterBarChBox.addActionListener(new LayoutCheckBoxListener(this));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 8, 8, 8);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    protected void registerForEvents() {
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
    }

    public String selectWorkingDirectory(String string) {
        File file;
        QFileChooser qFileChooser = UserPreferencesDialog.getDirectoryChooser(string);
        if (string != null) {
            file = new File(string);
            qFileChooser.setSelectedFile(file);
            qFileChooser.setCurrentDirectory(file);
        }
        int n = qFileChooser.showDialog(this, "Select");
        file = qFileChooser.getSelectedFile();
        if (n != 0 || file == null) {
            return null;
        }
        return file.toString();
    }

    private static QFileChooser getDirectoryChooser(String string) {
        QFileChooser qFileChooser = new QFileChooser(string);
        qFileChooser.setSelectedFile(new File(string));
        qFileChooser.setFileSelectionMode(1);
        return qFileChooser;
    }

    public String selectBrowserPath(String string) {
        File file;
        QFileChooser qFileChooser = UserPreferencesDialog.getFileChooser(string);
        if (string != null) {
            file = new File(string);
            qFileChooser.setSelectedFile(file);
            qFileChooser.setCurrentDirectory(file);
        }
        int n = qFileChooser.showDialog(this, "Select");
        file = qFileChooser.getSelectedFile();
        if (n != 0 || file == null) {
            return null;
        }
        return file.toString();
    }

    private static QFileChooser getFileChooser(String string) {
        QFileChooser qFileChooser = new QFileChooser(string);
        qFileChooser.setSelectedFile(new File(string));
        qFileChooser.setFileSelectionMode(0);
        return qFileChooser;
    }

    protected int applyOptions() {
        String string;
        boolean bl;
        int n = 1;
        String string2 = this.workingDirText.getText().trim();
        if (string2.length() == 0) {
            PopupDialog.showDialog(this, 3, "Working directory is required.");
            return -1;
        }
        File file = new File(string2);
        if (!file.exists() && (bl = PopupDialog.showDialog(this, 1, PerfFabricTreeControl.getResource("UserPreferences.createDir")))) {
            try {
                boolean bl2 = file.mkdir();
                if (!bl2) {
                    PopupDialog.showDialog(this, 3, PerfFabricTreeControl.getResource("UserPreferences.createDirFailed"));
                }
                n = -1;
            }
            catch (Exception exception) {
                PopupDialog.showDialog(this, 3, PerfFabricTreeControl.getResource("UserPreferences.createDirFailed"));
                n = -1;
            }
        }
        if ((string = this.browserPathText.getText().trim()).length() == 0) {
            PopupDialog.showDialog(this, 3, "Broswer path is required.");
            return -1;
        }
        File file2 = new File(string);
        if (!file2.exists() || !file2.isFile()) {
            PopupDialog.showDialog(this, 3, PerfFabricTreeControl.getResource("UserPreferences.invalidBrowserPath"));
            n = -1;
        }
        String string3 = this.autoLoadSaveCheckBox.isSelected() ? "true" : "false";
        if (n == 1) {
            Properties properties = this.preferences.getUserProperties();
            properties.setProperty("workingDir", string2);
            properties.setProperty("browserPath", string);
            properties.setProperty("autoSaveLoad", string3);
        }
        return n;
    }

    class AutoLoadSaveBoxAction
    extends AbstractAction {
        public AutoLoadSaveBoxAction() {
            super(PerfFabricTreeControl.getResource("UserPreferences.autoLoadSave"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = UserPreferencesDialog.this.autoLoadSaveCheckBox.isSelected();
            if (bl) {
                // empty if block
            }
        }
    }

    class LayoutCheckBoxListener
    implements ActionListener {
        UserPreferencesDialog theDialog = null;

        public LayoutCheckBoxListener(UserPreferencesDialog userPreferencesDialog2) {
            this.theDialog = userPreferencesDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox == UserPreferencesDialog.this.disableAllChBox) {
                if (UserPreferencesDialog.this.disableAllChBox.isSelected()) {
                    UserPreferencesDialog.this.windowSizeChBox.setEnabled(false);
                    UserPreferencesDialog.this.splitterBarChBox.setEnabled(false);
                } else {
                    UserPreferencesDialog.this.windowSizeChBox.setEnabled(true);
                    UserPreferencesDialog.this.splitterBarChBox.setEnabled(true);
                }
            }
        }
    }

    class PathChooserButtonListener
    implements ActionListener {
        UserPreferencesDialog theDialog = null;

        public PathChooserButtonListener(UserPreferencesDialog userPreferencesDialog2) {
            this.theDialog = userPreferencesDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = UserPreferencesDialog.this.preferences.getUserProperties();
            String string = UserPreferencesDialog.this.selectBrowserPath(properties.getProperty("browserPath"));
            if (string != null && string.trim().length() > 0) {
                UserPreferencesDialog.this.browserPathText.setText(string);
            }
        }
    }

    class FileChooserButtonListener
    implements ActionListener {
        UserPreferencesDialog theDialog = null;

        public FileChooserButtonListener(UserPreferencesDialog userPreferencesDialog2) {
            this.theDialog = userPreferencesDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = UserPreferencesDialog.this.preferences.getUserProperties();
            String string = UserPreferencesDialog.this.selectWorkingDirectory(properties.getProperty("workingDir"));
            if (string != null && string.trim().length() > 0) {
                UserPreferencesDialog.this.workingDirText.setText(string);
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        UserPreferencesDialog theDialog = null;

        public CancelButtonListener(UserPreferencesDialog userPreferencesDialog2) {
            this.theDialog = userPreferencesDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        UserPreferencesDialog theDialog = null;
        String theKey;

        public ApplyButtonListener(String string, UserPreferencesDialog userPreferencesDialog2) {
            this.theDialog = userPreferencesDialog2;
            this.theKey = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                if (UserPreferencesDialog.this.preferences == null) break block3;
                int n = 1;
                n = UserPreferencesDialog.this.applyOptions();
                if (n == 1) {
                    try {
                        UserPreferencesDialog.this.preferences.write();
                        PopupDialog.showDialog(this.theDialog, 2, "Preferences have been updated.");
                        this.theDialog.setVisible(false);
                    }
                    catch (Exception exception) {
                        PopupDialog.showDialog(this.theDialog, 3, "Attempt to write preferences out to file failed.\nFilename: " + UserPreferencesDialog.this.preferences.getPropertyFilename() + "\n" + "[ " + exception.toString() + " ]");
                    }
                }
            }
        }
    }
}

