/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.perfmon.PerfFabricTreeControl;
import com.qlogic.ui.tools.RolloverListener;
import java.awt.Container;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;

public class SbmUtilities {
    public static final Toolkit appToolkit = Toolkit.getDefaultToolkit();

    public static Image getImage(String string) {
        JButton jButton = new JButton();
        string = "/Images/" + string;
        URL uRL = jButton.getClass().getResource(string);
        Image image = null;
        if (uRL != null) {
            try {
                MediaTracker mediaTracker = new MediaTracker(jButton);
                image = appToolkit.getImage(uRL);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (image == null) {
            image = appToolkit.getImage(string);
        }
        return image;
    }

    public static String reasonToString(List list) {
        if (list.size() == 0) {
            return PerfFabricTreeControl.getResource("Status.none");
        }
        StringBuffer stringBuffer = new StringBuffer(list.size() * 10);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(PerfFabricTreeControl.getResource((String)iterator.next()));
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public static void setButtonParameters(JButton jButton) {
        jButton.setVerticalTextPosition(3);
        jButton.setHorizontalTextPosition(0);
        jButton.setHorizontalAlignment(0);
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.setAlignmentY(0.5f);
        jButton.setRequestFocusEnabled(false);
        jButton.addMouseListener(new RolloverListener(jButton));
    }

    public static JFrame getFrame(Container container) {
        Container container2;
        if (container == null) {
            return null;
        }
        boolean bl = false;
        while (!bl) {
            if (container instanceof JFrame) {
                bl = true;
                continue;
            }
            container2 = container.getParent();
            if (container2 == container) {
                return null;
            }
            container = container2;
            if (container != null) continue;
            return null;
        }
        container2 = (JFrame)container;
        return container2;
    }

    public static String getPortConfigModeString(PortStates portStates) {
        String string = "";
        if (portStates == null) {
            return "unknown";
        }
        switch (portStates.getConfigPortType()) {
            case 6: {
                string = PerfFabricTreeControl.getResource("AbstractFaceplate.donorPort");
                break;
            }
            case 7: {
                string = PerfFabricTreeControl.getResource("AbstractFaceplate.ePort");
                break;
            }
            case 2: {
                string = PerfFabricTreeControl.getResource("AbstractFaceplate.flPort");
                break;
            }
            case 1: {
                string = PerfFabricTreeControl.getResource("AbstractFaceplate.fPort");
                break;
            }
            case 4: {
                string = PerfFabricTreeControl.getResource("AbstractFaceplate.slPort");
                break;
            }
            case 5: {
                string = PerfFabricTreeControl.getResource("AbstractFaceplate.tlPort");
                break;
            }
            case 3: {
                string = PerfFabricTreeControl.getResource("AbstractFaceplate.tPort");
                break;
            }
            case 8: {
                string = PerfFabricTreeControl.getResource("AbstractFaceplate.gPort");
                break;
            }
            case 9: {
                string = PerfFabricTreeControl.getResource("AbstractFaceplate.glPort");
                break;
            }
            case 0: {
                string = PerfFabricTreeControl.getResource("AbstractFaceplate.unknown");
            }
        }
        return string;
    }

    public static String getPortStateString(int n) {
        switch (n) {
            case 1: {
                return PerfFabricTreeControl.getResource("FCPort.portOnline");
            }
            case 2: {
                return PerfFabricTreeControl.getResource("FCPort.portOffline");
            }
            case 4: {
                return PerfFabricTreeControl.getResource("FCPort.portFailed");
            }
            case 3: {
                return PerfFabricTreeControl.getResource("FCPort.portTesting");
            }
        }
        return PerfFabricTreeControl.getResource("AbstractFaceplate.unknown");
    }

    public static String getPortTypeLongNameString(int n) {
        String string = new String();
        switch (n) {
            case 7: {
                string = PerfFabricTreeControl.getResource("FCPort.ePortLongName");
                break;
            }
            case 2: {
                string = PerfFabricTreeControl.getResource("FCPort.flPortLongName");
                break;
            }
            case 1: {
                string = PerfFabricTreeControl.getResource("FCPort.fPortLongName");
                break;
            }
            case 4: {
                string = PerfFabricTreeControl.getResource("FCPort.slPortLongName");
                break;
            }
            case 5: {
                string = PerfFabricTreeControl.getResource("FCPort.tlPortLongName");
                break;
            }
            case 3: {
                string = PerfFabricTreeControl.getResource("FCPort.tPortLongName");
                break;
            }
            case 8: {
                string = PerfFabricTreeControl.getResource("FCPort.gPortLongName");
                break;
            }
            case 9: {
                string = PerfFabricTreeControl.getResource("FCPort.glPortLongName");
                break;
            }
            case 0: {
                string = PerfFabricTreeControl.getResource("FCPort.unknownLongName");
                break;
            }
            case 6: {
                string = PerfFabricTreeControl.getResource("FCPort.donorPortLongName");
            }
            default: {
                string = PerfFabricTreeControl.getResource("FCPort.inactivePortLongName");
            }
        }
        return string;
    }

    public static String getGbicModeString(FCPort fCPort) {
        String string = PerfFabricTreeControl.getResource("AbstractFaceplate.unknown");
        switch (fCPort.getGbicType()) {
            case 3: 
            case 5: {
                string = PerfFabricTreeControl.getResource("FCPort.copper");
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                string = PerfFabricTreeControl.getResource("FCPort.optical");
                break;
            }
            case 6: {
                string = PerfFabricTreeControl.getResource("FCPort.serial");
                break;
            }
            case 99: {
                string = PerfFabricTreeControl.getResource("FCPort.inactivePort");
                break;
            }
            case 8: {
                string = PerfFabricTreeControl.getResource("FCPort.hardwiredPort");
            }
        }
        return string;
    }
}

