/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class GraphOptionsFile {
    public static final String HEADER = "User Defined Graph Options";
    public static final String PROPERTY_FILE_NAME = "graph.properties";
    public static final String SHOW_BYTES_CHECK = "showBytesCheck";
    public static final String SHOW_TOTAL_BYTES_CHECK = "showTotalBytesCheck";
    public static final String SHOW_TOTAL_TX_BYTES_CHECK = "showTotalTxBytesCheck";
    public static final String SHOW_TOTAL_RX_BYTES_CHECK = "showTotalRxBytesCheck";
    public static final String SHOW_FRAMES_CHECK = "showFramesCheck";
    public static final String SHOW_TOTAL_FRAMES_CHECK = "showTotalFramesCheck";
    public static final String SHOW_TOTAL_TX_FRAMES_CHECK = "showTotalTxFramesCheck";
    public static final String SHOW_TOTAL_RX_FRAMES_CHECK = "showTotalRxFramesCheck";
    public static final String SHOW_ERRORS_CHECK = "showErrorsCheck";
    public static final String SHOW_GRID_CHECK = "showGridCheck";
    public static final String SHOW_TOTAL_BYTES_COLOR = "showTotalBytesColor";
    public static final String SHOW_TOTAL_TX_BYTES_COLOR = "showTotalTxBytesColor";
    public static final String SHOW_TOTAL_RX_BYTES_COLOR = "showTotalRxBytesColor";
    public static final String SHOW_TOTAL_FRAMES_COLOR = "showTotalFramesColor";
    public static final String SHOW_TOTAL_TX_FRAMES_COLOR = "showTotalTxFramesColor";
    public static final String SHOW_TOTAL_RX_FRAMES_COLOR = "showTotalRxFramesColor";
    public static final String SHOW_ERRORS_COLOR = "showErrorsColor";
    public static final String SHOW_GRID_COLOR = "showGridColor";
    public static final String GRAPH_BACKGROUND_COLOR = "gridBackgroundColor";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    protected String userHomeDirname = System.getProperty("user.home");
    protected String propertyFilename = this.userHomeDirname + File.separator + "graph.properties";
    protected File propertyFile = new File(this.propertyFilename);
    protected Properties defaultGraphProperties = this.getDefaultGraphProperties();
    protected Properties userGraphProperties = null;
    private static GraphOptionsFile graphPreferences;

    private GraphOptionsFile() {
    }

    public static GraphOptionsFile getInstance() {
        if (graphPreferences == null) {
            graphPreferences = new GraphOptionsFile();
            graphPreferences.init();
        }
        return graphPreferences;
    }

    public void init() {
        if (this.propertyFile != null && this.propertyFile.exists()) {
            this.userGraphProperties = new Properties(this.defaultGraphProperties);
            try {
                this.userGraphProperties.load(new BufferedInputStream(new FileInputStream(this.propertyFilename)));
            }
            catch (IOException iOException) {
                this.userGraphProperties = this.defaultGraphProperties;
            }
        } else {
            this.userGraphProperties = this.defaultGraphProperties;
        }
    }

    public void write() throws IOException {
        if (!this.propertyFile.exists()) {
            this.propertyFile.createNewFile();
        }
        this.userGraphProperties.store(new BufferedOutputStream(new FileOutputStream(this.propertyFile)), HEADER);
    }

    public Properties getUserGraphProperties() {
        return this.userGraphProperties;
    }

    public String getPropertyFilename() {
        return this.propertyFilename;
    }

    public String getGraphOptionsString(String string) {
        String string2 = null;
        string2 = this.userGraphProperties != null ? this.userGraphProperties.getProperty(string) : this.defaultGraphProperties.getProperty(string);
        return string2;
    }

    public int getGraphOptionsColor(String string) {
        String string2 = null;
        Object var3_3 = null;
        string2 = this.userGraphProperties != null ? this.userGraphProperties.getProperty(string) : this.defaultGraphProperties.getProperty(string);
        if (string2.length() > 0) {
            string2 = string2.substring(2);
        }
        int n = Integer.parseInt(string2, 16);
        return n;
    }

    protected Properties getDefaultGraphProperties() {
        Properties properties = new Properties();
        properties.setProperty(SHOW_BYTES_CHECK, TRUE);
        properties.setProperty(SHOW_TOTAL_BYTES_CHECK, TRUE);
        properties.setProperty(SHOW_TOTAL_BYTES_COLOR, Integer.toHexString(Color.yellow.getRGB()));
        properties.setProperty(SHOW_TOTAL_TX_BYTES_CHECK, FALSE);
        properties.setProperty(SHOW_TOTAL_TX_BYTES_COLOR, Integer.toHexString(Color.magenta.getRGB()));
        properties.setProperty(SHOW_TOTAL_RX_BYTES_CHECK, FALSE);
        properties.setProperty(SHOW_TOTAL_RX_BYTES_COLOR, Integer.toHexString(Color.green.getRGB()));
        properties.setProperty(SHOW_FRAMES_CHECK, FALSE);
        properties.setProperty(SHOW_TOTAL_FRAMES_CHECK, FALSE);
        properties.setProperty(SHOW_TOTAL_FRAMES_COLOR, Integer.toHexString(Color.blue.getRGB()));
        properties.setProperty(SHOW_TOTAL_TX_FRAMES_CHECK, FALSE);
        properties.setProperty(SHOW_TOTAL_TX_FRAMES_COLOR, Integer.toHexString(Color.pink.getRGB()));
        properties.setProperty(SHOW_TOTAL_RX_FRAMES_CHECK, FALSE);
        properties.setProperty(SHOW_TOTAL_RX_FRAMES_COLOR, Integer.toHexString(Color.white.getRGB()));
        properties.setProperty(SHOW_ERRORS_CHECK, FALSE);
        properties.setProperty(SHOW_ERRORS_COLOR, Integer.toHexString(Color.red.getRGB()));
        properties.setProperty(SHOW_GRID_CHECK, TRUE);
        properties.setProperty(SHOW_GRID_COLOR, Integer.toHexString(Color.gray.getRGB()));
        properties.setProperty(GRAPH_BACKGROUND_COLOR, Integer.toHexString(Color.black.getRGB()));
        return properties;
    }
}

