/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.FCDiscoverer;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricLink;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.ForeignSwitch;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.perfmon.DefaultFilePasswordDialog;
import com.qlogic.perfmon.FcFabricFileDialog;
import com.qlogic.perfmon.GraphInternalFrame;
import com.qlogic.perfmon.GraphOption;
import com.qlogic.perfmon.PerfFabricTreeControl;
import com.qlogic.perfmon.PopupDialog;
import com.qlogic.perfmon.UserPreferences;
import com.qlogic.ui.MainFrame;
import com.qlogic.util.Md5Crypt;
import com.qlogic.util.StringUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class FcFabricsFile {
    private static final String SALT = "$1$pyFWwzTk";
    public static final int DEFAULT_VERSION = 1;
    private static final String PI_VERSION = "xml version=\"1.0\" encoding=\"UTF-8\"";
    private static final String FABRIC_LIST_TAG = "FcFabricList";
    private static final String VERSION_TAG = "Version";
    private static final String NAME_TAG = "Name";
    private static final String PROXY_TAG = "Proxy";
    private static final String IP_ADDRESS_TAG = "IpAddress";
    private static final String USER_NAME_TAG = "UserName";
    private static final String PASSWORD_TAG = "Password";
    private static final String FABRIC_TAG = "FcFabric";
    private static final String SWITCH_TAG = "FcSwitch";
    private static final String TYPE_TAG = "Type";
    private static final String WWN_TAG = "WWN";
    private static final String LINK_TAG = "Link";
    private static final String ENDPOINT_TAG = "Endpoint";
    private static final String PORT_TAG = "Port";
    private static final String DOMAIN_ID_TAG = "DomainID";
    private static final String POS_X_TAG = "PosX";
    private static final String POS_Y_TAG = "PosY";
    private static final String BASE_IP_ADDRESS_TAG = "BaseIpAddress";
    private static final String SLOT_NUMBER_TAG = "SlotNumber";
    private static final String VIEW_TAG = "View";
    private static final String GRAPH_LIST_TAG = "GraphList";
    private static final String GRAPH_TAG = "Graph";
    private static final String GRAPH_FAB_TAG = "GraphFabric";
    private static final String GRAPH_SW_TAG = "GraphSwitch";
    private static final String GRAPH_PORT_TAG = "GraphPort";
    private static final String GRAPH_LOC_TAG = "GraphLocation";
    private static final String GRAPH_SIZE_TAG = "GraphSize";
    private static final String WIDTH_TAG = "Width";
    private static final String HEIGHT_TAG = "Height";
    private static final String GRAPH_FOCUS_TAG = "GraphHasFocus";
    private static final String GRAPH_OPT_TAG = "GraphOption";
    private static final String GRAPH_ITEM_TAG = "GraphItem";
    private static final String GRAPH_COLOR_TAG = "GraphColor";
    private static final String GRAPH_STATE_TAG = "GraphItemSelected";
    public static final String DEFAULT_FAB_FILE_NAME = "sfv_view.dft";
    public static File fabricsFile;
    public static String fabricsFilePassword;
    public static boolean fabricsHaveChanged;
    public static boolean saveOnExitComplete;
    public static boolean readOnStartComplete;
    public static File defaultFabricsFile;
    public static String defaultFabricsFilePassword;

    private static Fabric addFabric(String string, InetAddress inetAddress, String string2, String string3) {
        if (string3 == null) {
            string3 = new String("");
        }
        if (string == null) {
            return FabricList.getInstance().addFabric(inetAddress, string, string2, string3);
        }
        Fabric fabric = FcFabricsFile.addFabric2(string, inetAddress, string2, string3);
        if (fabric != null) {
            return fabric;
        }
        int n = 1;
        String string4;
        while ((fabric = FcFabricsFile.addFabric2(string4 = string + '[' + n + ']', inetAddress, string2, string3)) == null) {
            ++n;
        }
        return fabric;
    }

    private static Fabric addFabric2(String string, InetAddress inetAddress, String string2, String string3) {
        Fabric fabric;
        if (string3 == null) {
            string3 = new String("");
        }
        if ((fabric = FabricList.getFabric((String)string)) == null) {
            return FabricList.getInstance().addFabric(inetAddress, string, string2, string3);
        }
        if (fabric.getIpAddr().equals(inetAddress)) {
            return fabric;
        }
        return null;
    }

    private static String parseString(Element element) throws IOException {
        if (element != null) {
            return element.getTextTrim();
        }
        throw new IOException("failed parsing <" + element.getName() + "> tag");
    }

    private static String parseString(Element element, String string) throws IOException {
        Element element2 = element.getChild(string);
        if (element2 == null) {
            throw new IOException("failed parsing <" + string + "> in <" + element.getName() + ">");
        }
        return FcFabricsFile.parseString(element2);
    }

    private static int parseInt(Element element) throws IOException {
        if (element != null) {
            String string = element.getTextTrim();
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IOException("failed parsing <" + element.getName() + "> tag");
    }

    private static int parseInt(Element element, String string) throws IOException {
        return FcFabricsFile.parseInt(element.getChild(string));
    }

    private static InetAddress parseInetAddress(Element element) throws IOException {
        if (element != null) {
            String string = element.getTextTrim();
            try {
                return InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        throw new IOException("failed parsing <" + element.getName() + "> tag");
    }

    private static InetAddress parseInetAddress(Element element, String string) throws IOException {
        Element element2 = element.getChild(string);
        if (element2 == null) {
            throw new IOException("failed parsing <" + string + "> in <" + element.getName() + ">");
        }
        return FcFabricsFile.parseInetAddress(element2);
    }

    private static WorldWideName parseWWN(Element element) throws IOException {
        if (element != null) {
            String string = element.getTextTrim();
            try {
                return new WorldWideName(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new IOException("failed parsing <" + element.getName() + "> tag");
    }

    private static WorldWideName parseWWN(Element element, String string) throws IOException {
        Element element2 = element.getChild(string);
        if (element2 == null) {
            throw new IOException("failed parsing <" + string + "> in <" + element.getName() + ">");
        }
        return FcFabricsFile.parseWWN(element2);
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n2));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static byte[] toBytes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() % 2 > 0) {
            stringBuffer.insert(0, '0');
        }
        byte[] byArray = new byte[stringBuffer.length() / 2];
        int n = 0;
        while (n < byArray.length) {
            int n2 = n * 2;
            byArray[n] = (byte)(Character.digit(stringBuffer.charAt(n2), 16) * 16 + Character.digit(stringBuffer.charAt(n2 + 1), 16));
            ++n;
        }
        return byArray;
    }

    private static void xor(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray2.length) {
            int n2 = n;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray[n % byArray.length]);
            ++n;
        }
    }

    private static byte[] hash(String string) {
        int n = SALT.length() + 1;
        byte[] byArray = Md5Crypt.crypt(string, SALT);
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static String encrypt(String string, String string2) {
        int n;
        byte[] byArray = FcFabricsFile.hash(string);
        byte[] byArray2 = string2.getBytes();
        if (byArray2.length + 2 > (n = byArray.length)) {
            n = ((byArray2.length + 2) / n + 1) * n;
        }
        byte[] byArray3 = new byte[n];
        byArray3[0] = (byte)(byArray2.length / 256);
        byArray3[1] = (byte)(byArray2.length % 256);
        System.arraycopy(byArray2, 0, byArray3, 2, byArray2.length);
        FcFabricsFile.xor(byArray, byArray3);
        return FcFabricsFile.toHexString(byArray3);
    }

    private static String decrypt(String string, String string2) throws IOException {
        byte[] byArray = FcFabricsFile.hash(string);
        byte[] byArray2 = FcFabricsFile.toBytes(string2);
        FcFabricsFile.xor(byArray, byArray2);
        int n = ((byArray2[0] & 0xFF) << 16) + (byArray2[1] & 0xFF);
        if (n > byArray2.length) {
            throw new IOException("File has become corrupted");
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 2, byArray3, 0, n);
        return new String(byArray3);
    }

    public static void parse(String string, String string2) throws IOException {
        FcFabricsFile.parse(new File(string), string2);
    }

    public static void parseDefault() throws IOException {
        String string = "default.fab";
        FcFabricsFile.parse(new File(string), "");
    }

    public static void parse(File file, String string) throws IOException {
        FCPort fCPort;
        Object object;
        UtilAgent utilAgent;
        InetAddress inetAddress;
        Element element;
        Element element2;
        String string2;
        Object object2;
        WorldWideName worldWideName;
        Object object3;
        Object object4;
        Element element3;
        Document document;
        if (string == null) {
            string = new String("");
        }
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            document = sAXBuilder.build(file);
        }
        catch (JDOMException jDOMException) {
            throw new IOException(jDOMException.getMessage());
        }
        Element element4 = document.getRootElement();
        if (element4 == null) {
            throw new IOException("failed parsing <View> tag");
        }
        Element element5 = element4.getChild(FABRIC_LIST_TAG);
        if (element5 == null) {
            throw new IOException("failed parsing <FcFabricList> tag");
        }
        int n = FcFabricsFile.parseInt(element5, VERSION_TAG);
        if (n != 1) {
            throw new IOException("unrecognized version (" + n + ")");
        }
        List list = element5.getChildren(FABRIC_TAG);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object5;
            Object object6;
            Object object7;
            element3 = (Element)iterator.next();
            String string3 = FcFabricsFile.parseString(element3, NAME_TAG);
            object4 = element3.getChild(PROXY_TAG);
            object3 = InetAddress.getByName(object4.getAttributeValue(IP_ADDRESS_TAG));
            worldWideName = null;
            if (object4.getAttributeValue(WWN_TAG) != null) {
                worldWideName = new WorldWideName(object4.getAttributeValue(WWN_TAG));
            }
            object2 = null;
            string2 = null;
            element2 = element3.getChild(USER_NAME_TAG);
            element = element3.getChild(PASSWORD_TAG);
            if (element2 != null && element == null) {
                throw new IOException("failed parsing <Password> tag");
            }
            if (element2 == null && element != null) {
                throw new IOException("failed parsing <UserName> tag");
            }
            if (element2 != null && element != null) {
                object2 = FcFabricsFile.decrypt(string, FcFabricsFile.parseString(element2));
                string2 = FcFabricsFile.decrypt(string, FcFabricsFile.parseString(element));
            }
            inetAddress = FcFabricsFile.addFabric(string3, (InetAddress)object3, (String)object2, string2);
            utilAgent = (UtilAgent)inetAddress.getComAgent();
            utilAgent.setConnectionWwnAndFcAddress(worldWideName, 0);
            list = element3.getChildren(SWITCH_TAG);
            object = list.iterator();
            while (object.hasNext()) {
                object7 = (Element)object.next();
                worldWideName = FcFabricsFile.parseWWN((Element)object7, WWN_TAG);
                int n2 = FcFabricsFile.parseInt((Element)object7, DOMAIN_ID_TAG);
                object6 = object7.getChild(TYPE_TAG);
                if (object6 == null) {
                    fCPort = new ForeignSwitch(n2 << 16, worldWideName, (ComAgent)utilAgent, 5);
                } else {
                    object5 = FcFabricsFile.parseString((Element)object7, NAME_TAG);
                    int n3 = FcFabricsFile.parseInt((Element)object6);
                    fCPort = FCDiscoverer.createChassis((String)object5, (WorldWideName)worldWideName, (int)n3, (UtilAgent)utilAgent);
                    fCPort.setFcAddress(n2 << 16);
                    try {
                        int n4 = FcFabricsFile.parseInt((Element)object7, POS_X_TAG);
                        int n5 = FcFabricsFile.parseInt((Element)object7, POS_Y_TAG);
                        if (n4 < 0) {
                            n4 = 0;
                        }
                        if (n5 < 0) {
                            n5 = 0;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n2 == 0) {
                    fCPort.setNotInFabric();
                }
                inetAddress.addSwitch((Chassis)fCPort);
            }
            list = element3.getChildren(LINK_TAG);
            object7 = list.iterator();
            while (object7.hasNext()) {
                fCPort = (Element)object7.next();
                object6 = fCPort.getChildren(ENDPOINT_TAG);
                object5 = object6.iterator();
                Element element6 = (Element)object5.next();
                Element element7 = (Element)object5.next();
                WorldWideName worldWideName2 = new WorldWideName(element6.getAttributeValue(WWN_TAG));
                int n6 = Integer.parseInt(element6.getAttributeValue(PORT_TAG));
                WorldWideName worldWideName3 = new WorldWideName(element7.getAttributeValue(WWN_TAG));
                int n7 = Integer.parseInt(element7.getAttributeValue(PORT_TAG));
                inetAddress.addLink(inetAddress.getSwitchByWWN(worldWideName2), n6, inetAddress.getSwitchByWWN(worldWideName3), n7);
            }
            inetAddress.start();
        }
        element3 = element4.getChild(GRAPH_LIST_TAG);
        if (element3 != null) {
            int n8 = FcFabricsFile.parseInt(element3, VERSION_TAG);
            object4 = new Vector();
            object3 = element3.getChildren(GRAPH_TAG);
            worldWideName = object3.iterator();
            while (worldWideName.hasNext()) {
                Object object8;
                Object object9;
                object2 = (Element)worldWideName.next();
                string2 = FcFabricsFile.parseString(object2, GRAPH_FAB_TAG);
                element2 = FabricList.getFabric((String)string2);
                if (element2 == null) continue;
                element = object2.getChild(GRAPH_SW_TAG);
                inetAddress = InetAddress.getByName(element.getAttributeValue(IP_ADDRESS_TAG));
                utilAgent = null;
                if (element.getAttribute(WWN_TAG) != null) {
                    utilAgent = new WorldWideName(element.getAttributeValue(WWN_TAG));
                }
                object = element2.getSwitchByWWN((WorldWideName)utilAgent);
                int n9 = FcFabricsFile.parseInt(object2, GRAPH_PORT_TAG);
                fCPort = ((SanboxChassis)object).getPort(n9);
                Element element8 = object2.getChild(GRAPH_LOC_TAG);
                int n10 = Integer.parseInt(element8.getAttributeValue(POS_X_TAG));
                int n11 = Integer.parseInt(element8.getAttributeValue(POS_Y_TAG));
                Element element9 = object2.getChild(GRAPH_SIZE_TAG);
                int n12 = Integer.parseInt(element9.getAttributeValue(WIDTH_TAG));
                int n13 = Integer.parseInt(element9.getAttributeValue(HEIGHT_TAG));
                String string4 = FcFabricsFile.parseString(object2, GRAPH_FOCUS_TAG);
                boolean bl = string4.equals("true");
                Vector<GraphOption> vector = new Vector<GraphOption>();
                list = object2.getChildren(GRAPH_OPT_TAG);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    object9 = (Element)iterator2.next();
                    int n14 = FcFabricsFile.parseInt(object9, GRAPH_ITEM_TAG);
                    object8 = FcFabricsFile.parseString(object9, GRAPH_COLOR_TAG);
                    if (((String)object8).length() > 0) {
                        object8 = ((String)object8).substring(2);
                    }
                    int n15 = Integer.parseInt((String)object8, 16);
                    Color color = new Color(n15);
                    String string5 = FcFabricsFile.parseString(object9, GRAPH_STATE_TAG);
                    boolean bl2 = string5.equals("true");
                    GraphOption graphOption = new GraphOption(n14, color, bl2);
                    vector.add(graphOption);
                }
                object9 = string2 + ": " + ((SanboxChassis)object).getChassisName() + " Port # " + n9;
                Point point = new Point(n10, n11);
                object8 = new GraphInternalFrame((String)object9, (Chassis)object, fCPort, point, vector, string2, false);
                ((Component)object8).setSize(n12, n13);
                ((GraphInternalFrame)object8).setSavedSelectState(bl);
                ((Vector)object4).add(object8);
            }
            PerfFabricTreeControl.instance().setGraphList((Vector)object4);
        }
    }

    public static void save(String string, String string2) throws IOException {
        FcFabricsFile.save(new File(string), string2);
    }

    public static void save(File file, String string) throws IOException {
        FcFabricsFile.save(file, 1, string);
    }

    public static int saveDefault() throws IOException {
        Object object;
        String string = UserPreferences.getInstance().getWorkingDirectory();
        if (defaultFabricsFile == null) {
            defaultFabricsFile = new File(string + File.separator + DEFAULT_FAB_FILE_NAME);
        } else {
            int n;
            object = defaultFabricsFile.getAbsolutePath();
            StringBuffer stringBuffer = new StringBuffer((String)object);
            String string2 = stringBuffer.substring(0, (n = ((String)object).indexOf(DEFAULT_FAB_FILE_NAME)) - 1);
            if (!string.equals(string2)) {
                defaultFabricsFile = new File(string + File.separator + DEFAULT_FAB_FILE_NAME);
            }
        }
        if (defaultFabricsFilePassword == null) {
            object = new DefaultFilePasswordDialog((Frame)MainFrame.instance(), 2);
            ((Dialog)object).setVisible(true);
            int n = ((DefaultFilePasswordDialog)object).getState();
            if (n == 0) {
                defaultFabricsFilePassword = ((DefaultFilePasswordDialog)object).getPassword().trim();
                FcFabricsFile.save(defaultFabricsFile, defaultFabricsFilePassword);
            } else if (n == 1) {
                return -1;
            }
        } else {
            FcFabricsFile.save(defaultFabricsFile, defaultFabricsFilePassword);
        }
        return 1;
    }

    public static void save(File file, int n, String string) throws IOException {
        Element element;
        Object object;
        Object object2;
        Object object3;
        SanboxChassis sanboxChassis;
        String string2;
        Vector vector;
        Document document = new Document();
        if (string == null) {
            string = new String("");
        }
        Element element2 = new Element(VIEW_TAG);
        document.setRootElement(element2);
        Element element3 = new Element(FABRIC_LIST_TAG);
        element2.addContent(element3);
        Element element4 = new Element(VERSION_TAG);
        element4.addContent(Integer.toString(n));
        element3.addContent(element4);
        Object object4 = FabricList.getInstance().size() > 0 ? FabricList.getFirstFabric() : null;
        while (object4 != null) {
            FabricLink fabricLink;
            vector = new Element(FABRIC_TAG);
            string2 = object4.getFabricName();
            if (string2 != null) {
                element4 = new Element(NAME_TAG);
                element4.addContent(string2);
                vector.addContent(element4);
            }
            element4 = new Element(PROXY_TAG);
            InetAddress inetAddress = object4.getComAgent().getIpAddress();
            element4.setAttribute(IP_ADDRESS_TAG, inetAddress.getHostAddress());
            sanboxChassis = object4.getConnectionSwitch();
            if (sanboxChassis != null) {
                element4.setAttribute(WWN_TAG, sanboxChassis.getWWName().delimit());
            }
            vector.addContent(element4);
            object3 = object4.getUserName();
            if (object3 != null) {
                element4 = new Element(USER_NAME_TAG);
                element4.addContent(FcFabricsFile.encrypt(string, (String)object3));
                vector.addContent(element4);
            }
            if ((object2 = object4.getPassword()) != null) {
                element4 = new Element(PASSWORD_TAG);
                element4.addContent(FcFabricsFile.encrypt(string, (String)object2));
                vector.addContent(element4);
            }
            object = object4.getFirstSwitch();
            while (object != null) {
                fabricLink = new Element(SWITCH_TAG);
                if (object instanceof SanboxChassis) {
                    element = (SanboxChassis)object;
                    element4 = new Element(NAME_TAG);
                    element4.addContent(element.getChassisName());
                    fabricLink.addContent(element4);
                    element4 = new Element(TYPE_TAG);
                    element4.addContent(Integer.toString(element.getChassisType()));
                    fabricLink.addContent(element4);
                }
                element4 = new Element(WWN_TAG);
                element4.addContent(object.getWWName().delimit());
                fabricLink.addContent(element4);
                element4 = new Element(DOMAIN_ID_TAG);
                element4.addContent(Integer.toString(object.getDomainId()));
                fabricLink.addContent(element4);
                vector.addContent((Element)fabricLink);
                object = object4.getNextSwitch((Chassis)object);
            }
            fabricLink = object4.getFirstLink();
            while (fabricLink != null) {
                element = new Element(LINK_TAG);
                element4 = new Element(ENDPOINT_TAG);
                element4.setAttribute(WWN_TAG, fabricLink.getSwitch1().getWWName().delimit());
                element4.setAttribute(PORT_TAG, Integer.toString(fabricLink.getPortNumber1()));
                element.addContent(element4);
                element4 = new Element(ENDPOINT_TAG);
                element4.setAttribute(WWN_TAG, fabricLink.getSwitch2().getWWName().delimit());
                element4.setAttribute(PORT_TAG, Integer.toString(fabricLink.getPortNumber2()));
                element.addContent(element4);
                vector.addContent(element);
                fabricLink = object4.getNextLink(fabricLink);
            }
            element3.addContent((Element)vector);
            object4 = FabricList.getNextFabric((Fabric)object4);
        }
        vector = PerfFabricTreeControl.instance().getGraphList();
        if (!vector.isEmpty()) {
            string2 = new Element(GRAPH_LIST_TAG);
            element2.addContent((Element)string2);
            element4 = new Element(VERSION_TAG);
            element4.addContent(Integer.toString(n));
            string2.addContent(element4);
            int n2 = 0;
            while (n2 < vector.size()) {
                sanboxChassis = new Element(GRAPH_TAG);
                object3 = (GraphInternalFrame)vector.get(n2);
                if (object3 != null) {
                    element4 = new Element(GRAPH_FAB_TAG);
                    element4.addContent(((GraphInternalFrame)object3).getFabricName());
                    sanboxChassis.addContent(element4);
                    element4 = new Element(GRAPH_SW_TAG);
                    object2 = ((GraphInternalFrame)object3).getChassis().getComAgent().getIpAddress();
                    element4.setAttribute(IP_ADDRESS_TAG, ((InetAddress)object2).getHostAddress());
                    element4.setAttribute(WWN_TAG, ((GraphInternalFrame)object3).getChassis().getWWName().delimit());
                    sanboxChassis.addContent(element4);
                    element4 = new Element(GRAPH_PORT_TAG);
                    element4.addContent(Integer.toString(((GraphInternalFrame)object3).getPort().getPortNumber()));
                    sanboxChassis.addContent(element4);
                    element4 = new Element(GRAPH_LOC_TAG);
                    element4.setAttribute(POS_X_TAG, Integer.toString(((JComponent)object3).getX()));
                    element4.setAttribute(POS_Y_TAG, Integer.toString(((JComponent)object3).getY()));
                    sanboxChassis.addContent(element4);
                    element4 = new Element(GRAPH_SIZE_TAG);
                    element4.setAttribute(WIDTH_TAG, Integer.toString(((JComponent)object3).getWidth()));
                    element4.setAttribute(HEIGHT_TAG, Integer.toString(((JComponent)object3).getHeight()));
                    sanboxChassis.addContent(element4);
                    element4 = new Element(GRAPH_FOCUS_TAG);
                    element4.addContent(Boolean.toString(((JInternalFrame)object3).isSelected()));
                    sanboxChassis.addContent(element4);
                    object = ((GraphInternalFrame)object3).getGraphOptions();
                    if (!((Vector)object).isEmpty()) {
                        int n3 = 0;
                        while (n3 < ((Vector)object).size()) {
                            element = new Element(GRAPH_OPT_TAG);
                            GraphOption graphOption = (GraphOption)((Vector)object).get(n3);
                            if (graphOption != null) {
                                element4 = new Element(GRAPH_ITEM_TAG);
                                element4.addContent(Integer.toString(graphOption.getGraphItem()));
                                element.addContent(element4);
                                element4 = new Element(GRAPH_COLOR_TAG);
                                element4.addContent(Integer.toHexString(graphOption.getGraphColor().getRGB()));
                                element.addContent(element4);
                                element4 = new Element(GRAPH_STATE_TAG);
                                element4.addContent(Boolean.toString(graphOption.getGraphItemSelected()));
                                element.addContent(element4);
                                sanboxChassis.addContent(element);
                            }
                            ++n3;
                        }
                    }
                    string2.addContent((Element)sanboxChassis);
                }
                ++n2;
            }
        }
        string2 = new XMLOutputter();
        string2.setNewlines(true);
        string2.setIndent("    ");
        string2.output(document, (OutputStream)new FileOutputStream(file));
    }

    public static boolean saveFabrics() {
        if (fabricsFile == null) {
            return FcFabricsFile.saveFabricsAs();
        }
        try {
            FcFabricsFile.save(fabricsFile, fabricsFilePassword);
            fabricsHaveChanged = false;
            return true;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{fabricsFile.getPath()};
            String string = PerfFabricTreeControl.getResource("menu.file.save.failed");
            JOptionPane.showMessageDialog(MainFrame.instance(), StringUtilities.formatString(string, objectArray), PerfFabricTreeControl.getResource("menu.file.save"), 0);
            return false;
        }
    }

    public static boolean saveFabricsAs() {
        try {
            UserPreferences userPreferences;
            Properties properties;
            String string;
            FcFabricFileDialog fcFabricFileDialog = new FcFabricFileDialog((Frame)MainFrame.instance(), 1);
            if (fabricsFile != null) {
                fcFabricFileDialog.setFabricFile(fabricsFile.toString());
            }
            if ((string = (properties = (userPreferences = UserPreferences.getInstance()).getUserProperties()).getProperty("workingDir")) != null && string.length() > 0) {
                FcFabricFileDialog.getFileChooser().setCurrentDirectory(new File(string));
            }
            fcFabricFileDialog.setVisible(true);
            if (fcFabricFileDialog.getState() != 0) {
                return false;
            }
            fabricsFile = new File(fcFabricFileDialog.getFabricFileName());
            fabricsFilePassword = fcFabricFileDialog.getPassword();
            String string2 = fabricsFile.getAbsolutePath();
            File file = new File(string2);
            if (file.exists()) {
                String string3 = PerfFabricTreeControl.getResource("menu.file.saveViewAs.file") + "  '" + string2 + "'  " + PerfFabricTreeControl.getResource("menu.file.saveViewAs.alreadyExists");
                boolean bl = PopupDialog.showDialog(MainFrame.instance(), 1, PerfFabricTreeControl.getResource("menu.file.saveViewAs.fileAlreadyExists"), string3);
                if (!bl) {
                    return false;
                }
            }
            file.createNewFile();
            if (!file.canWrite()) {
                return false;
            }
            fabricsFile = file;
        }
        catch (Exception exception) {
            return false;
        }
        return FcFabricsFile.saveFabrics();
    }

    public static boolean openDefault() {
        Object object;
        if (defaultFabricsFile == null && !(defaultFabricsFile = new File((String)(object = UserPreferences.getInstance().getWorkingDirectory()) + File.separator + DEFAULT_FAB_FILE_NAME)).exists()) {
            return true;
        }
        if (defaultFabricsFilePassword == null) {
            object = new DefaultFilePasswordDialog((Frame)MainFrame.instance(), 1);
            ((Dialog)object).setVisible(true);
            int n = ((DefaultFilePasswordDialog)object).getState();
            if (n == 0) {
                defaultFabricsFilePassword = ((DefaultFilePasswordDialog)object).getPassword().trim();
            } else {
                return n != -1;
            }
        }
        object = fabricsFile;
        String string = fabricsFilePassword;
        try {
            fabricsFile = defaultFabricsFile;
            fabricsFilePassword = defaultFabricsFilePassword;
            FcFabricsFile.parse(fabricsFile, fabricsFilePassword);
            fabricsHaveChanged = false;
        }
        catch (IOException iOException) {
            defaultFabricsFilePassword = null;
            Object[] objectArray = new Object[]{fabricsFile == null ? iOException.getMessage() : fabricsFile.getPath()};
            String string2 = PerfFabricTreeControl.getResource("menu.file.open.failed");
            JOptionPane.showMessageDialog(MainFrame.instance(), StringUtilities.formatString(string2, objectArray), PerfFabricTreeControl.getResource("menu.file.openView"), 0);
        }
        fabricsFile = object;
        fabricsFilePassword = string;
        return true;
    }

    public static void openFabrics() {
        if (fabricsHaveChanged && FabricList.getInstance().size() != 0) {
            int n = JOptionPane.showConfirmDialog(MainFrame.instance(), PerfFabricTreeControl.getResource("menu.file.open.confirmSave"), PerfFabricTreeControl.getResource("menu.file.open.fabricChanged"), 1);
            if (n == 2 || n == -1 || n == 0 && !FcFabricsFile.saveFabricsAs()) {
                return;
            }
            fabricsHaveChanged = false;
        }
        try {
            UserPreferences userPreferences;
            Properties properties;
            String string;
            FcFabricFileDialog fcFabricFileDialog = new FcFabricFileDialog((Frame)MainFrame.instance(), 0);
            if (fabricsFile != null) {
                fcFabricFileDialog.setFabricFile(fabricsFile.toString());
            }
            if ((string = (properties = (userPreferences = UserPreferences.getInstance()).getUserProperties()).getProperty("workingDir")) != null && string.length() > 0) {
                FcFabricFileDialog.getFileChooser().setCurrentDirectory(new File(string));
            }
            fcFabricFileDialog.setVisible(true);
            if (fcFabricFileDialog.getState() != 0) {
                return;
            }
            fabricsFile = new File(fcFabricFileDialog.getFabricFileName());
            fabricsFilePassword = fcFabricFileDialog.getPassword();
            FcFabricsFile.parse(fabricsFile, fabricsFilePassword);
            fabricsHaveChanged = false;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{fabricsFile == null ? exception.getMessage() : fabricsFile.getPath()};
            String string = PerfFabricTreeControl.getResource("menu.file.open.failed");
            JOptionPane.showMessageDialog(MainFrame.instance(), StringUtilities.formatString(string, objectArray), PerfFabricTreeControl.getResource("menu.file.openView"), 0);
        }
    }

    static {
        fabricsHaveChanged = false;
        saveOnExitComplete = false;
        readOnStartComplete = false;
        defaultFabricsFile = null;
        defaultFabricsFilePassword = null;
    }
}

