/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.perfmon;

import com.qlogic.perfmon.PerfFabricTreeControl;
import com.qlogic.perfmon.UserPreferences;
import com.qlogic.perfmon.VendorProperties;
import com.qlogic.ui.GenericFileFilter;
import com.qlogic.ui.QDialog;
import com.qlogic.ui.QFileChooser;
import com.qlogic.util.QHelpUtilities;
import com.qlogic.util.StringUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class FcFabricFileDialog
extends QDialog {
    JPanel displayPanel = new JPanel();
    GridBagLayout displayPanelLayout = new GridBagLayout();
    JLabel fileNameLabel = new JLabel("File name:");
    JLabel passwordLabel = new JLabel("File password:");
    JTextField fileNameTextField = new JTextField();
    JPasswordField passwordField = new JPasswordField();
    JButton browseButton = new JButton("Browse");
    JLabel fabricListLabel = new JLabel("Save Fabric List");
    JPanel buttonPanel = new JPanel();
    GridLayout buttonPanelLayout = new GridLayout();
    JButton okButton = new JButton("Ok");
    JButton cancelButton = new JButton("Cancel");
    private static QFileChooser fileChooser;
    private int option;
    private String shortTitle;
    private int state = 2;
    private File fabricsFile;
    private String password;

    public FcFabricFileDialog(Frame frame, int n) {
        super(frame, true);
        this.option = n;
        this.shortTitle = n == 0 ? PerfFabricTreeControl.getResource("FcFabricFileDialog.openView") : PerfFabricTreeControl.getResource("FcFabricFileDialog.saveView");
        try {
            this.jbInit();
            this.pack();
            this.setSize(2 * this.getWidth(), this.getHeight());
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setTitle(this.shortTitle + " - " + VendorProperties.getFrameTitle());
        this.buttonPanelLayout.setColumns(2);
        this.fileNameLabel.setHorizontalAlignment(4);
        this.passwordLabel.setHorizontalAlignment(4);
        this.getContentPane().add((Component)this.displayPanel, "Center");
        this.displayPanel.setLayout(this.displayPanelLayout);
        this.fabricListLabel.setText(this.shortTitle);
        this.fabricListLabel.setFont(PerfFabricTreeControl.titleFont);
        ButtonListener buttonListener = new ButtonListener();
        this.browseButton.addActionListener(buttonListener);
        this.okButton.addActionListener(buttonListener);
        this.cancelButton.addActionListener(buttonListener);
        this.buttonPanel.setLayout(this.buttonPanelLayout);
        this.buttonPanelLayout.setHgap(8);
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.buttonPanel.add((Component)this.helpContextButton, null);
        if (this.option == 0) {
            this.setContextHelpFile(QHelpUtilities.getResource("QDialog.openFabricFileDialogHelp"));
        } else {
            this.setContextHelpFile(QHelpUtilities.getResource("QDialog.saveFabricFileDialogHelp"));
        }
        this.displayPanel.add((Component)this.fabricListLabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(8, 0, 8, 8), 0, 0));
        this.displayPanel.add((Component)this.fileNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 24, 4, 4), 0, 0));
        this.displayPanel.add((Component)this.passwordLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 24, 4, 4), 0, 0));
        this.displayPanel.add((Component)this.fileNameTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 8), 0, 0));
        this.displayPanel.add((Component)this.passwordField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 8), 0, 0));
        this.displayPanel.add((Component)this.browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.displayPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public String selectFabricFile(int n, String string) {
        File file;
        QFileChooser qFileChooser = FcFabricFileDialog.getFileChooser();
        if (string.length() > 0) {
            file = new File(string);
            qFileChooser.setSelectedFile(file);
            qFileChooser.setCurrentDirectory(file);
        }
        int n2 = n == 0 ? qFileChooser.showOpenDialog(this) : qFileChooser.showSaveDialog(this);
        file = qFileChooser.getSelectedFile();
        if (n2 != 0 || file == null) {
            return null;
        }
        return file.toString();
    }

    public static QFileChooser getFileChooser() {
        if (fileChooser == null) {
            String string = UserPreferences.getInstance().getWorkingDirectory();
            fileChooser = new QFileChooser(string);
            fileChooser.setSelectedFile(new File("default.fab"));
            Object[] objectArray = new Object[]{VendorProperties.getApplicationName()};
            String string2 = PerfFabricTreeControl.getResource("PerfFabricTreeControl.fabricFileDescription");
            String string3 = StringUtilities.formatString(string2, objectArray);
            GenericFileFilter genericFileFilter = new GenericFileFilter("fab", string3);
            fileChooser.addChoosableFileFilter(genericFileFilter);
        }
        return fileChooser;
    }

    public String getFabricFileName() {
        String string = this.fileNameTextField.getText();
        if (string != null) {
            if (string.startsWith("/") || string.startsWith("\\") || string.length() > 1 && string.charAt(1) == ':') {
                return string;
            }
            String string2 = UserPreferences.getInstance().getWorkingDirectory();
            String string3 = string2 + File.separator + string;
            return string3;
        }
        return "";
    }

    public void setFabricFile(String string) {
        try {
            this.fileNameTextField.setText(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getState() {
        return this.state;
    }

    public String getPassword() {
        String string = this.password;
        this.password = null;
        return string;
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == FcFabricFileDialog.this.browseButton) {
                String string = FcFabricFileDialog.this.selectFabricFile(FcFabricFileDialog.this.option, FcFabricFileDialog.this.fileNameTextField.getText());
                if (string != null) {
                    FcFabricFileDialog.this.fileNameTextField.setText(string);
                }
            } else if (object == FcFabricFileDialog.this.okButton) {
                FcFabricFileDialog.this.state = 0;
                FcFabricFileDialog.this.password = new String(FcFabricFileDialog.this.passwordField.getPassword());
                FcFabricFileDialog.this.setVisible(false);
            } else if (object == FcFabricFileDialog.this.cancelButton) {
                FcFabricFileDialog.this.state = 2;
                FcFabricFileDialog.this.password = null;
                FcFabricFileDialog.this.setVisible(false);
            } else {
                System.out.println("FcFabricFileDialog.ButtonListener - unknown source " + object.toString());
                return;
            }
        }
    }
}

