/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.topology;

import com.qlogic.ui.Topology;
import com.qlogic.ui.topology.TopologyLink;
import com.qlogic.ui.topology.TopologyNode;
import com.qlogic.ui.topology.TopologyNodeRenderer;
import com.qlogic.ui.topology.TopologySelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;

public class TopologyUI
extends ComponentUI {
    Color selectedLinkColor = Color.blue;
    Color unselectedLinkColor = Color.black;
    Color unknownColor;
    Color normalColor;
    Color warningColor;
    Topology topology;
    Insets insets;
    MouseListener mouseListener;
    Vector topologyUIListeners = new Vector();

    public TopologyUI(Topology topology) {
    }

    public void installUI(JComponent jComponent) {
        this.topology = (Topology)jComponent;
        this.mouseListener = new MouseListener();
        this.topology.addMouseListener(this.mouseListener);
        this.topology.addMouseMotionListener(this.mouseListener);
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.topology) {
            throw new IllegalComponentStateException(this + " trying to uninstall " + jComponent + " but its TopologyUI is " + this.topology);
        }
        this.insets = this.topology.getInsets();
        this.topology.removeMouseListener(this.mouseListener);
        this.topology.removeMouseMotionListener(this.mouseListener);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        int n = 0;
        while (n < this.topology.getNodeCount()) {
            TopologyNode topologyNode = this.topology.getTopologyNodeAtIndex(n);
            rectangle = rectangle.union(this.getNodeBounds(topologyNode));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.topology.getNodeCount()) {
            TopologyNode topologyNode = this.topology.getTopologyNodeAtIndex(n2);
            Point point = topologyNode.getLocation();
            topologyNode.setLocation(point.x - rectangle.x, point.y - rectangle.y);
            ++n2;
        }
        int n3 = rectangle.width + insets.left + insets.right;
        int n4 = rectangle.height + insets.top + insets.bottom;
        Dimension dimension = this.getMinimumSize(jComponent);
        n3 = Math.max(n3, dimension.width);
        n4 = Math.max(n4, dimension.height);
        return new Dimension(n3, n4);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(400, 300);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return jComponent.getPreferredSize();
    }

    public void nodeToTop(TopologyNode topologyNode) {
        this.topology.reindexTopologyNode(topologyNode, this.topology.getNodeCount() - 1);
    }

    protected Component getNodeComponent(TopologyNode topologyNode) {
        return this.topology.getNodeRenderer(topologyNode);
    }

    protected Rectangle getDefaultRectangle() {
        return new Rectangle(24, 24);
    }

    protected Rectangle getNodeBounds(TopologyNode topologyNode) {
        return this.topology.getNodeRenderer(topologyNode, false).getBounds();
    }

    protected Rectangle getIconBounds(TopologyNode topologyNode) {
        Component component = this.topology.getNodeRenderer(topologyNode, false);
        if (component instanceof TopologyNodeRenderer) {
            return ((TopologyNodeRenderer)((Object)component)).getIconBounds(topologyNode, component);
        }
        return component.getBounds();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        int n = 0;
        while (n < this.topology.getNodeCount()) {
            TopologyNode topologyNode = this.topology.getTopologyNodeAtIndex(n);
            this.paintNode(graphics, topologyNode);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.topology.getLinkCount()) {
            this.topology.getTopologyLinkRenderer().paintLink(graphics, this.topology.getLinkAtIndex(n2));
            ++n2;
        }
    }

    protected void paintNode(Graphics graphics, TopologyNode topologyNode) {
        Component component = this.topology.getNodeRenderer(topologyNode);
        Rectangle rectangle = component.getBounds();
        this.paintComponent(graphics, component, topologyNode.getX(), topologyNode.getY(), rectangle.width, rectangle.height);
    }

    public void paintComponent(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        if (component == null) {
            if (this.topology != null) {
                Color color = graphics.getColor();
                graphics.setColor(this.topology.getBackground());
                graphics.fillRect(n, n2, n3, n4);
                graphics.setColor(color);
            }
            return;
        }
        boolean bl = false;
        if (component instanceof JComponent && ((JComponent)component).isDoubleBuffered()) {
            bl = true;
            ((JComponent)component).setDoubleBuffered(false);
        }
        graphics.translate(n, n2);
        component.paint(graphics);
        graphics.translate(-n, -n2);
        if (bl) {
            ((JComponent)component).setDoubleBuffered(true);
        }
    }

    protected Object getObjectAt(Point point) {
        Serializable serializable;
        int n = 0;
        while (n < this.topology.getLinkCount()) {
            serializable = this.topology.getLinkAtIndex(n);
            if (this.topology.getTopologyLinkRenderer().getBounds((TopologyLink)serializable, 4).contains(point)) {
                return serializable;
            }
            ++n;
        }
        n = 0;
        while (n < this.topology.getNodeCount()) {
            serializable = this.topology.getTopologyNodeAtIndex(n);
            if (this.getIconBounds((TopologyNode)serializable).contains(point)) {
                return serializable;
            }
            ++n;
        }
        return null;
    }

    protected class MouseListener
    extends MouseInputAdapter {
        TopologyNode mousePressedNode = null;
        boolean hasMoved = false;
        Point previousPoint = null;
        Object mouseOverObject = null;
        Window mouseOverWindow = null;

        public void mouseEntered(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu;
            Point point = mouseEvent.getPoint();
            Object object = TopologyUI.this.getObjectAt(point);
            int n = mouseEvent.getModifiers();
            boolean bl = mouseEvent.isShiftDown() || mouseEvent.isControlDown();
            TopologySelectionModel topologySelectionModel = TopologyUI.this.topology.getSelectionModel();
            if ((n & 0x10) != 0) {
                if (object == null) {
                    topologySelectionModel.clearSelection();
                } else if (bl) {
                    if (topologySelectionModel.isSelected(object)) {
                        topologySelectionModel.removeSelection(object);
                    } else {
                        topologySelectionModel.addSelection(object);
                    }
                } else {
                    if (object instanceof TopologyNode) {
                        this.mousePressedNode = (TopologyNode)object;
                        TopologyUI.this.nodeToTop(this.mousePressedNode);
                    } else {
                        this.mousePressedNode = null;
                    }
                    this.hasMoved = false;
                    this.previousPoint = point;
                }
            } else if ((n & 4) != 0 && object != null) {
                if (bl) {
                    topologySelectionModel.addSelection(object);
                } else {
                    topologySelectionModel.setSelection(object);
                }
            }
            if (mouseEvent.isPopupTrigger() && (jPopupMenu = TopologyUI.this.topology.getMenuForObject(object)) != null) {
                jPopupMenu.show(TopologyUI.this.topology, point.x, point.y);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Object object = TopologyUI.this.getObjectAt(point);
            int n = mouseEvent.getModifiers();
            boolean bl = mouseEvent.isShiftDown() || mouseEvent.isControlDown();
            TopologySelectionModel topologySelectionModel = TopologyUI.this.topology.getSelectionModel();
            if ((n & 0x10) != 0) {
                if (object != null && !bl & !this.hasMoved) {
                    topologySelectionModel.setSelection(object);
                }
                this.mousePressedNode = null;
            }
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = TopologyUI.this.topology.getMenuForObject(object);
                if (jPopupMenu != null) {
                    try {
                        jPopupMenu.show(TopologyUI.this.topology, point.x, point.y);
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        // empty catch block
                    }
                }
                return;
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Object object = TopologyUI.this.getObjectAt(point);
            int n = 2 | 1;
            int n2 = mouseEvent.getModifiers();
            boolean bl = mouseEvent.isShiftDown() || mouseEvent.isControlDown();
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    JPopupMenu jPopupMenu;
                    if (!mouseEvent.isPopupTrigger() || (jPopupMenu = TopologyUI.this.topology.getMenuForObject(object)) == null) break;
                    try {
                        jPopupMenu.show(TopologyUI.this.topology, point.x, point.y);
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {}
                    break;
                }
                case 2: {
                    if ((n2 & 0x10) == 0) break;
                    TopologyUI.this.topology.clearSelection();
                    if (object == null) break;
                    TopologyUI.this.topology.activateObject(object);
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!TopologyUI.this.topology.isDragEnabled() || this.mousePressedNode == null) {
                return;
            }
            Point point = mouseEvent.getPoint();
            if (this.mousePressedNode != null) {
                int n = point.x - this.previousPoint.x;
                int n2 = point.y - this.previousPoint.y;
                this.previousPoint = point;
                TopologyUI.this.topology.moveNode(this.mousePressedNode, n, n2);
                this.hasMoved = true;
            }
        }
    }
}

