/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.eventBrowser;

import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.ui.eventBrowser.EventEntry;
import com.qlogic.ui.eventBrowser.EventList;
import com.qlogic.ui.eventBrowser.EventModel;
import com.qlogic.ui.eventBrowser.SortableColumnHeaderRenderer;
import com.qlogic.ui.eventBrowser.SortableTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class EventTable
extends JTable
implements SortableTable,
MouseListener {
    private static Icon debugIcon = new ImageIcon(SbmUtilities.getImage("StatusDebugSm.gif"));
    private static Icon infoIcon = new ImageIcon(SbmUtilities.getImage("StatusInfoSm.gif"));
    private static Icon normalIcon = new ImageIcon(SbmUtilities.getImage("StatusNormalSm.gif"));
    private static Icon warningIcon = new ImageIcon(SbmUtilities.getImage("StatusWarningSm.gif"));
    private static Icon criticalIcon = new ImageIcon(SbmUtilities.getImage("StatusCriticalSm.gif"));
    private static Icon unfilterableIcon = new ImageIcon(SbmUtilities.getImage("StatusUnfilterableSm.gif"));
    private volatile int sortedColumn = -1;
    private volatile int sortDirection = 0;
    private int clickedColumn = -1;
    private boolean columnResized = false;

    public EventTable() {
        this(new EventModel());
    }

    public EventTable(EventList eventList) {
        this(new EventModel(eventList));
    }

    public EventTable(EventModel eventModel) {
        super(eventModel);
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setDefaultRenderer(new SortableColumnHeaderRenderer());
        jTableHeader.addMouseListener(this);
        jTableHeader.setReorderingAllowed(false);
        SeverityIconRenderer severityIconRenderer = new SeverityIconRenderer();
        this.getColumn(eventModel.getColumnName(0)).setCellRenderer(severityIconRenderer);
        this.setRowHeight(Math.max(this.getRowHeight(), severityIconRenderer.getPreferredSize().height));
        int n = 1;
        while (n < eventModel.getColumnCount()) {
            TableColumn tableColumn = this.getColumn(eventModel.getColumnName(n));
            tableColumn.setCellRenderer(new DefaultTableCellRenderer());
            ++n;
        }
    }

    public void add(EventEntry eventEntry) {
        ((EventModel)this.getModel()).add(eventEntry);
    }

    public boolean isSortable(int n) {
        return true;
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    private int getColumnHeaderWidth(TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        Component component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, 0, 0);
        return component.getPreferredSize().width;
    }

    private int getColumnWidth(TableColumn tableColumn) {
        int n = tableColumn.getModelIndex();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.getRowCount()) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(n4, n);
            Component component = tableCellRenderer.getTableCellRendererComponent(this, this.getValueAt(n4, n), false, false, n4, n);
            n2 = component.getPreferredSize().width;
            n3 = Math.max(n2, n3);
            ++n4;
        }
        return n3;
    }

    public int getPreferredColumnWidth(TableColumn tableColumn) {
        return Math.max(this.getColumnHeaderWidth(tableColumn), this.getColumnWidth(tableColumn));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this.columnAtPoint(mouseEvent.getPoint());
        this.resortColumn(n);
    }

    public void resortColumn(int n) {
        if (this.isSortable(n)) {
            this.sortDirection = this.sortedColumn == n ? -this.sortDirection : 1;
            this.sortedColumn = n;
            ((EventModel)this.getModel()).sortBy(n, this.sortDirection);
            this.getTableHeader().repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    class SeverityIconRenderer
    extends DefaultTableCellRenderer {
        public SeverityIconRenderer() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TableModel tableModel = EventTable.this.getModel();
            Integer n3 = (Integer)tableModel.getValueAt(n, n2);
            if (n3 == null) {
                this.setIcon(null);
                return this;
            }
            int n4 = n3;
            if (n4 >= 500) {
                this.setIcon(unfilterableIcon);
            } else if (n4 >= 400) {
                this.setIcon(criticalIcon);
            } else if (n4 >= 300) {
                this.setIcon(warningIcon);
            } else if (n4 >= 200) {
                this.setIcon(normalIcon);
            } else if (n4 >= 100) {
                this.setIcon(null);
            } else {
                this.setIcon(debugIcon);
            }
            return this;
        }

        public Dimension getPreferredSize() {
            return new Dimension(normalIcon.getIconWidth() + 2, normalIcon.getIconHeight() + 2);
        }
    }
}

