/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.eventBrowser;

import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.DateTimeDialog;
import com.qlogic.ui.eventBrowser.EventFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class EventFilterDialog
extends JDialog {
    Frame frame;
    JPanel mainPanel = new JPanel();
    GridBagLayout mainLayout = new GridBagLayout();
    JPanel severityPanel = new JPanel();
    GridBagLayout severityLayout = new GridBagLayout();
    Border severityBeveledBorder;
    TitledBorder severityTitledBorder;
    Border severityPanelBorder;
    JCheckBox infoCheckBox;
    JCheckBox normalCheckBox;
    JCheckBox warningCheckBox;
    JCheckBox criticalCheckBox;
    JCheckBox alarmCheckBox;
    JPanel dateTimePanel = new JPanel();
    GridBagLayout dateTimeLayout = new GridBagLayout();
    Border dateTimeEtchedBorder;
    TitledBorder dateTimeTitledBorder;
    Border dateTimePanelBorder;
    JCheckBox afterCheckBox;
    JTextField afterDateTextField = new JTextField();
    JButton afterTimeButton = new JButton(new SetAfterTimeAction());
    JCheckBox beforeCheckBox;
    JTextField beforeDateTextField = new JTextField();
    JButton beforeTimeButton = new JButton(new SetBeforeTimeAction());
    JPanel matchPanel = new JPanel();
    GridBagLayout matchLayout = new GridBagLayout();
    Border matchPanelBorder;
    JCheckBox sourceCheckBox;
    JTextField sourceTextField = new JTextField();
    JCheckBox typeCheckBox;
    JTextField typeTextField = new JTextField();
    JCheckBox descriptionCheckBox;
    JTextField descriptionTextField = new JTextField();
    JPanel buttonPanel = new JPanel();
    JPanel buttonGridPanel = new JPanel();
    GridLayout buttonGridLayout = new GridLayout();
    JButton filterButton;
    JButton closeButton;
    CheckBoxListener checkBoxListener = new CheckBoxListener();
    String dateTimeFormat;
    SimpleDateFormat simpleDateFormat;
    EventFilter eventFilter;
    int option;

    public EventFilterDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.frame = frame;
        this.dateTimeFormat = FabricTreeControl.getResource("EventFilterDialog.dateTimeFormat");
        this.simpleDateFormat = new SimpleDateFormat(this.dateTimeFormat);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public EventFilterDialog(Frame frame) {
        this(frame, "", true);
    }

    void jbInit() throws Exception {
        this.setTitle(FabricTreeControl.getResource("EventFilterDialog.titleBarText") + " - " + VendorProperties.getFrameTitle());
        this.mainPanel.setLayout(this.mainLayout);
        this.getContentPane().add(this.mainPanel);
        this.severityPanel.setLayout(this.severityLayout);
        this.severityBeveledBorder = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(142, 142, 142), new Color(99, 99, 99));
        this.severityTitledBorder = new TitledBorder(this.severityBeveledBorder, FabricTreeControl.getResource("EventFilterDialog.severity "));
        this.severityPanelBorder = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Severity"), BorderFactory.createEmptyBorder(4, 12, 4, 4));
        this.severityPanel.setBorder(this.severityPanelBorder);
        this.alarmCheckBox = new JCheckBox(FabricTreeControl.getResource("EventFilterDialog.alarm"), true);
        this.severityPanel.add((Component)this.alarmCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.criticalCheckBox = new JCheckBox(FabricTreeControl.getResource("EventFilterDialog.critical"), true);
        this.severityPanel.add((Component)this.criticalCheckBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.warningCheckBox = new JCheckBox(FabricTreeControl.getResource("EventFilterDialog.warning"), true);
        this.severityPanel.add((Component)this.warningCheckBox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.normalCheckBox = new JCheckBox(FabricTreeControl.getResource("EventFilterDialog.normal"), true);
        this.severityPanel.add((Component)this.normalCheckBox, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.infoCheckBox = new JCheckBox(FabricTreeControl.getResource("EventFilterDialog.info"), true);
        this.severityPanel.add((Component)this.infoCheckBox, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.severityPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 8, 0, 8), 0, 0));
        this.dateTimePanel.setLayout(this.dateTimeLayout);
        this.dateTimeEtchedBorder = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        this.dateTimeTitledBorder = new TitledBorder(this.dateTimeEtchedBorder, FabricTreeControl.getResource("EventFilterDialog.dateTime"));
        this.dateTimePanelBorder = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Date/Time"), BorderFactory.createEmptyBorder(4, 12, 4, 4));
        this.dateTimePanel.setBorder(this.dateTimePanelBorder);
        this.afterCheckBox = new JCheckBox(FabricTreeControl.getResource("EventFilterDialog.after"));
        this.afterCheckBox.addActionListener(this.checkBoxListener);
        this.afterCheckBox.setSelected(false);
        this.dateTimePanel.add((Component)this.afterCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.afterDateTextField.setText(this.dateTimeFormat);
        this.afterDateTextField.setEnabled(false);
        this.dateTimePanel.add((Component)this.afterDateTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.afterTimeButton.setEnabled(false);
        this.dateTimePanel.add((Component)this.afterTimeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.beforeCheckBox = new JCheckBox(FabricTreeControl.getResource("EventFilterDialog.before"));
        this.beforeCheckBox.addActionListener(this.checkBoxListener);
        this.beforeCheckBox.setSelected(false);
        this.dateTimePanel.add((Component)this.beforeCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.beforeDateTextField.setText(this.dateTimeFormat);
        this.beforeDateTextField.setEnabled(false);
        this.dateTimePanel.add((Component)this.beforeDateTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.beforeTimeButton.setEnabled(false);
        this.dateTimePanel.add((Component)this.beforeTimeButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.dateTimePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 8, 0, 8), 0, 0));
        this.matchPanelBorder = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), FabricTreeControl.getResource("EventFilterDialog.text")), BorderFactory.createEmptyBorder(4, 12, 4, 4));
        this.matchPanel.setLayout(this.matchLayout);
        this.matchPanel.setBorder(this.matchPanelBorder);
        this.sourceCheckBox = new JCheckBox(FabricTreeControl.getResource("EventFilterDialog.source"));
        this.sourceCheckBox.addActionListener(this.checkBoxListener);
        this.sourceCheckBox.setSelected(false);
        this.matchPanel.add((Component)this.sourceCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.sourceTextField.setEnabled(false);
        this.matchPanel.add((Component)this.sourceTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.typeCheckBox = new JCheckBox(FabricTreeControl.getResource("EventFilterDialog.type"));
        this.typeCheckBox.addActionListener(this.checkBoxListener);
        this.typeCheckBox.setSelected(false);
        this.matchPanel.add((Component)this.typeCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.typeTextField.setEnabled(false);
        this.matchPanel.add((Component)this.typeTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.descriptionCheckBox = new JCheckBox(FabricTreeControl.getResource("EventFilterDialog.description"));
        this.descriptionCheckBox.addActionListener(this.checkBoxListener);
        this.descriptionCheckBox.setSelected(false);
        this.matchPanel.add((Component)this.descriptionCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.descriptionTextField.setEnabled(false);
        this.matchPanel.add((Component)this.descriptionTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.matchPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 8, 0, 8), 0, 0));
        ButtonListener buttonListener = new ButtonListener();
        this.buttonGridPanel.setLayout(this.buttonGridLayout);
        this.buttonPanel.add((Component)this.buttonGridPanel, null);
        this.filterButton = new JButton(FabricTreeControl.getResource("EventFilterDialog.filter"));
        this.filterButton.addActionListener(buttonListener);
        this.buttonGridPanel.add((Component)this.filterButton, null);
        this.closeButton = new JButton(FabricTreeControl.getResource("EventFilterDialog.close"));
        this.closeButton.addActionListener(buttonListener);
        this.buttonGridPanel.add((Component)this.closeButton, null);
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private String editDateTime(String string) {
        Date date;
        DateTimeDialog dateTimeDialog = new DateTimeDialog(this.frame, true);
        try {
            date = this.simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            date = new Date(System.currentTimeMillis());
        }
        dateTimeDialog.setDateTime(date.getTime());
        dateTimeDialog.setVisible(true);
        date = dateTimeDialog.getDateTime();
        return this.simpleDateFormat.format(date);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.option;
    }

    EventFilter createEventFilter() throws ParseException {
        EventFilter eventFilter = new EventFilter();
        eventFilter.acceptAlarm = this.alarmCheckBox.isSelected();
        eventFilter.acceptCritical = this.criticalCheckBox.isSelected();
        eventFilter.acceptWarning = this.warningCheckBox.isSelected();
        eventFilter.acceptNormal = this.normalCheckBox.isSelected();
        eventFilter.acceptInfo = this.infoCheckBox.isSelected();
        eventFilter.filterAfterDate = this.afterCheckBox.isSelected();
        if (eventFilter.filterAfterDate) {
            eventFilter.afterDate = this.simpleDateFormat.parse(this.afterDateTextField.getText()).getTime();
        }
        eventFilter.filterBeforeDate = this.beforeCheckBox.isSelected();
        if (eventFilter.filterBeforeDate) {
            eventFilter.beforeDate = this.simpleDateFormat.parse(this.beforeDateTextField.getText()).getTime();
        }
        eventFilter.filterSource = this.sourceCheckBox.isSelected();
        eventFilter.sourceFilter = this.sourceTextField.getText();
        eventFilter.filterType = this.typeCheckBox.isSelected();
        eventFilter.typeFilter = this.typeTextField.getText();
        eventFilter.filterDescription = this.descriptionCheckBox.isSelected();
        eventFilter.descriptionFilter = this.descriptionTextField.getText();
        return eventFilter;
    }

    public EventFilter getEventFilter() {
        return this.eventFilter;
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == EventFilterDialog.this.filterButton) {
                try {
                    EventFilterDialog.this.eventFilter = EventFilterDialog.this.createEventFilter();
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(EventFilterDialog.this, parseException.getMessage(), EventFilterDialog.this.getTitle(), 0);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                EventFilterDialog.this.option = 0;
                EventFilterDialog.this.setVisible(false);
            } else if (object == EventFilterDialog.this.closeButton) {
                EventFilterDialog.this.eventFilter = null;
                EventFilterDialog.this.option = 2;
                EventFilterDialog.this.setVisible(false);
            } else {
                System.out.println("EventFilterDialog Unrecognized checkbox event: " + actionEvent.toString());
            }
        }
    }

    class SetAfterTimeAction
    extends AbstractAction {
        public SetAfterTimeAction() {
            super("...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EventFilterDialog.this.afterDateTextField.setText(EventFilterDialog.this.editDateTime(EventFilterDialog.this.afterDateTextField.getText()));
        }
    }

    class SetBeforeTimeAction
    extends AbstractAction {
        public SetBeforeTimeAction() {
            super("...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EventFilterDialog.this.beforeDateTextField.setText(EventFilterDialog.this.editDateTime(EventFilterDialog.this.beforeDateTextField.getText()));
        }
    }

    class CheckBoxListener
    implements ActionListener {
        CheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == EventFilterDialog.this.beforeCheckBox) {
                EventFilterDialog.this.beforeDateTextField.setEnabled(EventFilterDialog.this.beforeCheckBox.isSelected());
                EventFilterDialog.this.beforeTimeButton.setEnabled(EventFilterDialog.this.beforeCheckBox.isSelected());
            } else if (object == EventFilterDialog.this.afterCheckBox) {
                EventFilterDialog.this.afterDateTextField.setEnabled(EventFilterDialog.this.afterCheckBox.isSelected());
                EventFilterDialog.this.afterTimeButton.setEnabled(EventFilterDialog.this.afterCheckBox.isSelected());
            } else if (object == EventFilterDialog.this.sourceCheckBox) {
                EventFilterDialog.this.sourceTextField.setEnabled(EventFilterDialog.this.sourceCheckBox.isSelected());
            } else if (object == EventFilterDialog.this.typeCheckBox) {
                EventFilterDialog.this.typeTextField.setEnabled(EventFilterDialog.this.typeCheckBox.isSelected());
            } else if (object == EventFilterDialog.this.descriptionCheckBox) {
                EventFilterDialog.this.descriptionTextField.setEnabled(EventFilterDialog.this.descriptionCheckBox.isSelected());
            } else {
                System.out.println("EventFilterDialog Unrecognized checkbox event: " + actionEvent.toString());
            }
        }
    }
}

