/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.ui.eventBrowser;

import java.util.Date;

public class EventEntry
implements Comparable {
    public static final int SEVERITY = 0;
    public static final int TIMESTAMP = 1;
    public static final int SOURCE = 2;
    public static final int TYPE = 3;
    public static final int DESCRIPTION = 4;
    public Date date;
    public Integer severity;
    public Object source;
    public String type;
    public String description;
    public long sequenceNumber;
    private static long nextSequenceNumber = 1L;

    public EventEntry(long l, int n, Object object, String string, String string2) {
        this.date = new Date(l);
        this.severity = new Integer(n);
        this.source = object.toString();
        this.type = string;
        this.sequenceNumber = ++nextSequenceNumber;
        this.description = string2;
        if (string2 == null) {
            throw new NullPointerException(string + ": " + object);
        }
    }

    public EventEntry(int n, Object object, String string, String string2) {
        this(System.currentTimeMillis(), n, object, string, string2);
    }

    public EventEntry(String string) {
        this(System.currentTimeMillis(), 0, Thread.currentThread(), "Generic", string);
    }

    public EventEntry() {
        this.sequenceNumber = ++nextSequenceNumber;
    }

    public int compareTo(Object object) {
        EventEntry eventEntry = (EventEntry)object;
        if (!this.source.equals(eventEntry.source)) {
            int n = this.source.toString().compareTo(eventEntry.source.toString());
            if (n != 0) {
                return n;
            }
            n = this.source.hashCode() - eventEntry.source.hashCode();
            if (n != 0) {
                return n;
            }
        }
        if (this.date.getTime() != eventEntry.date.getTime()) {
            return (int)(this.date.getTime() - eventEntry.date.getTime());
        }
        return this.description.compareTo(eventEntry.description);
    }

    public static int convertStatus(int n) {
        switch (n) {
            case 2: {
                return 400;
            }
            case 1: {
                return 300;
            }
            case 0: {
                return 200;
            }
        }
        return 100;
    }

    public boolean equals(Object object) {
        try {
            return this.compareTo(object) == 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[time=");
        stringBuffer.append(this.date.getTime());
        stringBuffer.append(",severity=");
        stringBuffer.append(this.severity.toString());
        stringBuffer.append(",source=\"");
        stringBuffer.append(this.source.toString());
        stringBuffer.append("\",type=\"");
        stringBuffer.append(this.type);
        stringBuffer.append("\",description=\"");
        stringBuffer.append(this.description);
        stringBuffer.append("\"]");
        return stringBuffer.toString();
    }
}

