/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.zoning;

import com.qlogic.device.fcfabric.Sanbox;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ZoningConfigDialog
extends QDialog
implements ChassisEventListener {
    private SanboxChassis theSwitch;
    private JLabel autoSaveLabel = new JLabel(FabricTreeControl.getResource("ZoningConfigDialog.autoSave"));
    private JCheckBox autoSave;
    private JLabel defaultLabel = new JLabel(FabricTreeControl.getResource("ZoningConfigDialog.defaultVisibility"));
    private JComboBox defaultMode;
    ZoningConfig config;
    private boolean quitWhenDone = true;
    JButton saveButton = new JButton(new SaveAndQuitAction());
    JButton cancelButton = new JButton(new CancelAction());
    JButton applyButton = new JButton(new SaveAction());
    JFrame frame;

    public ZoningConfigDialog(JFrame jFrame, SanboxChassis sanboxChassis) throws IllegalArgumentException {
        super((Frame)jFrame, true);
        this.frame = jFrame;
        this.setTitle(FabricTreeControl.getResource("ZoningConfigDialog.titleBarText") + " - " + VendorProperties.getFrameTitle());
        this.theSwitch = sanboxChassis;
        this.theSwitch.addChassisEventListener((ChassisEventListener)this);
        this.config = new ZoningConfig(this.theSwitch.getZoningConfig());
        if (this.config.getMergeMode() == -1) {
            throw new IllegalArgumentException();
        }
        try {
            this.jbinit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doClose(boolean bl) {
        this.theSwitch.removeChassisEventListener((ChassisEventListener)this);
        this.setVisible(false);
        if (bl) {
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(new Integer(333));
            WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(this.frame, this.theSwitch, vector, FabricTreeControl.getResource("ZoningConfigDialog.waitingForUpdate"));
            waitForUpdateDialog.setVisible(true);
        }
    }

    private void saveZoningInfo() {
        if (this.defaultMode.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("ZoningConfigDialog.invalidDefaultMode"), this.getTitle(), 0);
            return;
        }
        this.config.setAutoSave(this.autoSave.isSelected());
        this.config.setDefaultVisibility(this.defaultMode.getSelectedIndex());
        this.saveButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.theSwitch.applyZoningConfig(this.config);
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getEventType() == 278) {
            this.saveButton.setEnabled(true);
            this.cancelButton.setEnabled(true);
            this.applyButton.setEnabled(true);
            SwingUtilities.invokeLater(new DoneDialog(chassisEvent));
        }
    }

    public void jbinit() {
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        this.autoSave = new JCheckBox();
        this.autoSave.setSelected(this.config.getAutoSave());
        if (this.theSwitch.isAutoSaveSettable()) {
            jPanel.add((Component)this.autoSaveLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
            jPanel.add((Component)this.autoSave, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        }
        jPanel.add((Component)this.defaultLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.defaultMode = new JComboBox<String>(ZoningConfig.defaultVisibilityStrings);
        this.defaultMode.setPreferredSize(new Dimension(160, 24));
        this.defaultMode.setSelectedIndex(this.config.getDefaultVisibility());
        jPanel.add((Component)this.defaultMode, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.saveButton);
        this.saveButton.setMnemonic('O');
        jPanel2.add(this.cancelButton);
        this.cancelButton.setMnemonic('C');
        jPanel2.add(this.applyButton);
        this.applyButton.setMnemonic('A');
        jPanel2.add((Component)this.helpContextButton, null);
        if (this.theSwitch instanceof Sanbox) {
            this.setContextHelpFile(QHelpUtilities.getResource("QDialog.zoningConfigDialogSanboxHelp"));
        } else if (this.theSwitch instanceof Sanbox8000) {
            this.setContextHelpFile(QHelpUtilities.getResource("QDialog.zoningConfigDialogSanbox8000Help"));
        } else if (this.theSwitch instanceof Sanbox2) {
            this.setContextHelpFile(QHelpUtilities.getResource("QDialog.zoningConfigDialogSanbox2Help"));
        }
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.getRootPane().setDefaultButton(this.saveButton);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            if (this.changesMade()) {
                switch (JOptionPane.showConfirmDialog(this, FabricTreeControl.getResource("ZoningConfigDialog.wouldYouLikeToSaveYourChanges"), this.getTitle(), 1)) {
                    case 0: {
                        this.quitWhenDone = true;
                        this.saveZoningInfo();
                        return;
                    }
                    case 1: {
                        this.doClose(false);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            } else {
                this.doClose(false);
            }
        }
    }

    private boolean changesMade() {
        if (this.autoSave.isSelected() != this.config.getAutoSave()) {
            return true;
        }
        return this.defaultMode.getSelectedIndex() != this.config.getDefaultVisibility();
    }

    class SaveAndQuitAction
    extends AbstractAction {
        public SaveAndQuitAction() {
            super(FabricTreeControl.getResource("ZoningConfigDialog.ok"));
        }

        public SaveAndQuitAction(String string) {
            Image image = SbmUtilities.getImage(string);
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public SaveAndQuitAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ZoningConfigDialog.this.changesMade()) {
                ZoningConfigDialog.this.quitWhenDone = true;
                ZoningConfigDialog.this.saveZoningInfo();
            } else {
                ZoningConfigDialog.this.doClose(false);
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super(FabricTreeControl.getResource("ZoningConfigDialog.apply"));
        }

        public SaveAction(String string) {
            Image image = SbmUtilities.getImage(string);
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public SaveAction(Image image) {
            this.putValue("SmallIcon", new ImageIcon(image));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ZoningConfigDialog.this.quitWhenDone = false;
            ZoningConfigDialog.this.saveZoningInfo();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(FabricTreeControl.getResource("ZoningConfigDialog.cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ZoningConfigDialog.this.changesMade()) {
                switch (JOptionPane.showConfirmDialog(ZoningConfigDialog.this, FabricTreeControl.getResource("ZoningConfigDialog.wouldYouLikeToSaveYourChanges"), ZoningConfigDialog.this.getTitle(), 1)) {
                    case 0: {
                        ZoningConfigDialog.this.quitWhenDone = true;
                        ZoningConfigDialog.this.saveZoningInfo();
                        return;
                    }
                    case 1: {
                        ZoningConfigDialog.this.doClose(false);
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            } else {
                ZoningConfigDialog.this.doClose(false);
            }
        }
    }

    class DoneDialog
    implements Runnable {
        ChassisEvent evt;

        DoneDialog(ChassisEvent chassisEvent) {
            this.evt = chassisEvent;
        }

        public void run() {
            if (this.evt.isSuccessful()) {
                if (ZoningConfigDialog.this.quitWhenDone) {
                    ZoningConfigDialog.this.doClose(true);
                } else {
                    JOptionPane.showMessageDialog(ZoningConfigDialog.this, FabricTreeControl.getResource("ZoningConfigDialog.configurationSaved"), ZoningConfigDialog.this.getTitle(), 1);
                }
            } else {
                JOptionPane.showMessageDialog(ZoningConfigDialog.this, FabricTreeControl.getResource("ZoningConfigDialog.failedToSaveTheConfiguration") + " " + FabricTreeControl.translateErrorType(this.evt.getErrorType()), ZoningConfigDialog.this.getTitle(), 0);
            }
        }
    }
}

