/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.zoning;

import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.ZoneAlias;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.ZoneMemberElement;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.device.fcfabric.zoning.events.ZoneEvent;
import com.qlogic.device.fcfabric.zoning.events.ZoneListener;
import com.qlogic.device.fcfabric.zoning.events.ZoneSetEvent;
import com.qlogic.device.fcfabric.zoning.events.ZoneSetListener;
import com.qlogic.device.fcfabric.zoning.events.ZonesEvent;
import com.qlogic.device.fcfabric.zoning.events.ZonesListener;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.SanSurferTreeNode;
import com.qlogic.qms.fabric.SanSurferTreeNodeRenderer;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.zoning.TreeDragSource;
import com.qlogic.qms.fabric.zoning.TreeDropTarget;
import com.qlogic.qms.fabric.zoning.TreeDropTargetListener;
import com.qlogic.qms.fabric.zoning.ZoneMemberSelection;
import com.qlogic.qms.fabric.zoning.ZoningUtilities;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ZoneSetTree
extends JPanel
implements TreeDropTargetListener,
ZoneListener,
ZoneSetListener,
ZonesListener {
    private String zoneSetStr = new String(FabricTreeControl.getResource("ZoneSetTree.zoneSets"));
    private SanSurferTreeNode zoneSetRoot;
    private DefaultTreeModel model;
    private TreeDropTarget tree;
    private TreeDragSource treeSource;
    private Zones zones;
    private boolean displayOnlyActiveSet;
    private boolean allowEdit;
    private MouseListener mouseListener;
    private JLabel errorLabel;
    private JScrollPane scrollPane;
    private static final int BUFFER = 10;
    private Fabric fabric;

    public ZoneSetTree(Fabric fabric, Zones zones, boolean bl, boolean bl2, MouseListener mouseListener, JLabel jLabel) {
        try {
            this.mouseListener = mouseListener;
            this.allowEdit = bl;
            this.displayOnlyActiveSet = bl2;
            this.zones = zones;
            this.errorLabel = jLabel;
            this.jbInit();
            this.setZones(fabric, zones);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private SanSurferTreeNode createSanSurferTreeNodeAndInsert(Object object, int n, DefaultTreeModel defaultTreeModel, SanSurferTreeNode sanSurferTreeNode, int n2) {
        SanSurferTreeNode sanSurferTreeNode2 = this.createSanSurferTreeNode(object, n);
        this.insertNode(defaultTreeModel, sanSurferTreeNode2, sanSurferTreeNode, n2);
        return sanSurferTreeNode2;
    }

    private SanSurferTreeNode createSanSurferTreeNode(Object object, int n) {
        SanSurferTreeNode sanSurferTreeNode = new SanSurferTreeNode(object, n);
        return sanSurferTreeNode;
    }

    private void jbInit() {
        this.zoneSetRoot = this.createSanSurferTreeNode(this.zoneSetStr, 0);
        this.model = new DefaultTreeModel(this.zoneSetRoot);
        this.tree = new TreeDropTarget(this.model, this.allowEdit, this);
        this.tree.setShowsRootHandles(true);
        if (this.allowEdit) {
            this.treeSource = new TreeDragSource(this.tree, this.zones);
        }
        this.scrollPane = new JScrollPane(this.tree);
        this.scrollPane.setPreferredSize(new Dimension(500, 10));
        this.setLayout(new GridLayout(1, 1));
        this.add(this.scrollPane);
        this.tree.setCellRenderer(new SanSurferTreeNodeRenderer(this.fabric));
        if (this.mouseListener != null) {
            this.tree.addMouseListener(this.mouseListener);
        }
    }

    public void dragLocation(Point point) {
        int n;
        int n2;
        Rectangle rectangle = this.scrollPane.getViewport().getViewRect();
        Dimension dimension = this.scrollPane.getViewport().getViewSize();
        if (point.getY() < rectangle.getY() + 20.0) {
            n2 = 10;
            if (point.getY() < rectangle.getY() + 10.0) {
                n2 *= 10;
            }
            if ((n = (int)rectangle.getY() - n2) < 0) {
                n = 0;
            }
            this.scrollPane.getViewport().setViewPosition(new Point((int)rectangle.getX(), n));
        }
        if (point.getY() > rectangle.getY() + rectangle.getHeight() - 20.0) {
            int n3;
            int n4;
            n2 = 10;
            if (point.getY() > rectangle.getY() + rectangle.getHeight() - 10.0) {
                n2 *= 10;
            }
            if ((n4 = (n = (int)rectangle.getY() + n2) + (int)rectangle.getHeight()) > (n3 = (int)dimension.getHeight())) {
                n = (int)dimension.getHeight() - (int)rectangle.getHeight();
            }
            this.scrollPane.getViewport().setViewPosition(new Point((int)rectangle.getX(), n));
        }
    }

    public void receiveDrop(Vector vector) {
        SwingUtilities.invokeLater(new ReceiveDrop(vector));
    }

    public boolean isDragging() {
        return this.tree.isDragging();
    }

    public boolean removeZoneSet(ZoneSet zoneSet) {
        SanSurferTreeNode sanSurferTreeNode = this.getRootNode();
        int n = 0;
        while (n < sanSurferTreeNode.getChildCount()) {
            SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
            if (sanSurferTreeNode2.getUserObject() == zoneSet) {
                this.model.removeNodeFromParent(sanSurferTreeNode2);
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean removeZoneAlias(ZoneAlias zoneAlias) {
        SanSurferTreeNode sanSurferTreeNode = this.getRootNode();
        int n = 0;
        while (n < sanSurferTreeNode.getChildCount()) {
            SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
            if (sanSurferTreeNode2.getUserObject() == zoneAlias) {
                this.model.removeNodeFromParent(sanSurferTreeNode2);
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean moveZoneFromSetToSet(Zone zone, ZoneSet zoneSet, ZoneSet zoneSet2) {
        SanSurferTreeNode sanSurferTreeNode = this.getRootNode();
        SanSurferTreeNode sanSurferTreeNode2 = null;
        SanSurferTreeNode sanSurferTreeNode3 = null;
        SanSurferTreeNode sanSurferTreeNode4 = null;
        int n = 0;
        while (n < sanSurferTreeNode.getChildCount()) {
            int n2;
            SanSurferTreeNode sanSurferTreeNode5 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
            if (sanSurferTreeNode5.getUserObject() == zoneSet2) {
                sanSurferTreeNode3 = sanSurferTreeNode5;
            }
            if (sanSurferTreeNode5.getUserObject() == zoneSet) {
                sanSurferTreeNode2 = sanSurferTreeNode5;
                n2 = 0;
                while (n2 < sanSurferTreeNode5.getChildCount()) {
                    SanSurferTreeNode sanSurferTreeNode6 = (SanSurferTreeNode)sanSurferTreeNode5.getChildAt(n2);
                    if (sanSurferTreeNode6.getUserObject() == zone) {
                        sanSurferTreeNode4 = sanSurferTreeNode6;
                        break;
                    }
                    ++n2;
                }
            }
            if (sanSurferTreeNode3 != null && sanSurferTreeNode2 != null && sanSurferTreeNode4 != null) {
                this.model.removeNodeFromParent(sanSurferTreeNode4);
                n2 = zoneSet2.getZoneIndex(zone);
                if (n2 >= 0) {
                    this.insertNode(this.model, sanSurferTreeNode4, sanSurferTreeNode3, n2);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean removeZoneFromSet(Zone zone, ZoneSet zoneSet) {
        SanSurferTreeNode sanSurferTreeNode = this.getRootNode();
        int n = 0;
        while (n < sanSurferTreeNode.getChildCount()) {
            SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
            if (sanSurferTreeNode2.getUserObject() == zoneSet) {
                int n2 = 0;
                while (n2 < sanSurferTreeNode2.getChildCount()) {
                    SanSurferTreeNode sanSurferTreeNode3 = (SanSurferTreeNode)sanSurferTreeNode2.getChildAt(n2);
                    if (sanSurferTreeNode3.getUserObject() == zone) {
                        this.model.removeNodeFromParent(sanSurferTreeNode3);
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    public Zone getSelectedZone() {
        Object object;
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        if (sanSurferTreeNode != null && (object = sanSurferTreeNode.getUserObject()) instanceof Zone) {
            Zone zone = (Zone)object;
            return zone;
        }
        return null;
    }

    public ZoneSet getSelectedZoneSet() {
        Object object;
        SanSurferTreeNode sanSurferTreeNode = this.getSelectedNode();
        if (sanSurferTreeNode != null && (object = sanSurferTreeNode.getUserObject()) instanceof ZoneSet) {
            ZoneSet zoneSet = (ZoneSet)object;
            return zoneSet;
        }
        return null;
    }

    public boolean addListToZone(Zone zone, Vector vector) {
        JFrame jFrame = SbmUtilities.getFrame(this);
        if (vector != null) {
            Vector<ZoneMember> vector2 = new Vector<ZoneMember>();
            int n = 0;
            while (n < vector.size()) {
                SanSurferTreeNode sanSurferTreeNode;
                ZoneMember zoneMember = null;
                Object e = vector.elementAt(n);
                if (e instanceof SanSurferTreeNode && (zoneMember = ZoningUtilities.createZoneMember(this.zones, sanSurferTreeNode = (SanSurferTreeNode)vector.elementAt(n))) == null) {
                    this.displayMessage(FabricTreeControl.getResource("ZoneSetTree.maxMembers"));
                    return false;
                }
                if (e instanceof ZoneMember) {
                    zoneMember = (ZoneMember)e;
                }
                if (zoneMember != null) {
                    vector2.add(zoneMember);
                }
                ++n;
            }
            if (vector2.size() > 0) {
                switch (this.zones.addZoneMembersToZone(zone, vector2)) {
                    case 100: {
                        this.displayMessage(FabricTreeControl.getResource("ZoneSetTree.maxMembers"));
                        return false;
                    }
                    case 103: {
                        this.displayMessage(FabricTreeControl.getResource("ZoneSetTree.maxMembersPerZone"));
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private void displayMessage(String string) {
        SwingUtilities.invokeLater(new DisplayClass(string));
    }

    public void setZones(Fabric fabric, Zones zones) {
        SanSurferTreeNodeRenderer sanSurferTreeNodeRenderer;
        this.fabric = fabric;
        this.zones = zones;
        if (this.treeSource != null) {
            this.treeSource.setZones(this.zones);
        }
        if ((sanSurferTreeNodeRenderer = (SanSurferTreeNodeRenderer)this.tree.getCellRenderer()) == null) {
            sanSurferTreeNodeRenderer = new SanSurferTreeNodeRenderer(this.fabric);
        }
        sanSurferTreeNodeRenderer.setFabric(this.fabric);
        if (this.zones != null) {
            this.fillTree();
        }
    }

    public void addMouseListener(MouseInputAdapter mouseInputAdapter) {
        this.tree.addMouseListener(mouseInputAdapter);
    }

    TreeModel getModel() {
        return this.model;
    }

    JTree getTree() {
        return this.tree;
    }

    void showPopup(JPopupMenu jPopupMenu, int n, int n2) {
        jPopupMenu.show(this.tree, n, n2);
    }

    public void selectItemAtPoint(Point point) {
        int[] nArray = this.tree.getSelectionRows();
        int n = 0;
        while (n < this.tree.getRowCount()) {
            Rectangle rectangle = this.tree.getRowBounds(n);
            if (rectangle.contains(point)) {
                int n2 = 0;
                while (nArray != null && n2 < nArray.length) {
                    if (nArray[n2] == n) {
                        return;
                    }
                    ++n2;
                }
                this.tree.setSelectionRow(n);
            }
            ++n;
        }
    }

    private SanSurferTreeNode[] getSelectedNodes() {
        SanSurferTreeNode[] sanSurferTreeNodeArray = null;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            int n = treePathArray.length;
            sanSurferTreeNodeArray = new SanSurferTreeNode[n];
            int n2 = 0;
            while (n2 < n) {
                sanSurferTreeNodeArray[n2] = (SanSurferTreeNode)treePathArray[n2].getLastPathComponent();
                ++n2;
            }
        }
        return sanSurferTreeNodeArray;
    }

    SanSurferTreeNode getSelectedNode() {
        SanSurferTreeNode sanSurferTreeNode = null;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            sanSurferTreeNode = (SanSurferTreeNode)treePath.getLastPathComponent();
        }
        return sanSurferTreeNode;
    }

    private SanSurferTreeNode getRootNode() {
        SanSurferTreeNode sanSurferTreeNode = (SanSurferTreeNode)this.model.getRoot();
        return sanSurferTreeNode;
    }

    void clearTree() {
        SanSurferTreeNode sanSurferTreeNode = this.getRootNode();
        int n = sanSurferTreeNode.getChildCount() - 1;
        while (n >= 0) {
            TreeNode treeNode = sanSurferTreeNode.getChildAt(n);
            this.model.removeNodeFromParent((MutableTreeNode)treeNode);
            --n;
        }
        sanSurferTreeNode.removeAllChildren();
    }

    void fillTree() {
        this.clearTree();
        if (!(this.allowEdit || this.zones != null && this.zones.getCurrentWithSwitch())) {
            return;
        }
        if (this.zones == null) {
            return;
        }
        SanSurferTreeNode sanSurferTreeNode = this.getRootNode();
        if (sanSurferTreeNode != null) {
            if (this.allowEdit) {
                this.zones.addListener((ZonesListener)this);
            }
            if (this.zones != null) {
                this.putSetInTree(sanSurferTreeNode, this.zones.getOrphanZoneSet());
                ZoneSet zoneSet = this.zones.getFirstZoneSet();
                while (zoneSet != null) {
                    this.putSetInTree(sanSurferTreeNode, zoneSet);
                    zoneSet = this.zones.getNextZoneSet(zoneSet);
                }
                ZoneAlias zoneAlias = this.zones.getFirstZoneAlias();
                while (zoneAlias != null) {
                    SanSurferTreeNode sanSurferTreeNode2 = this.addZoneAliasToTree(sanSurferTreeNode, zoneAlias);
                    zoneAlias = this.zones.getNextZoneAlias(zoneAlias);
                }
            }
        }
        this.tree.expandRow(0);
        this.repaint();
    }

    private void putSetInTree(SanSurferTreeNode sanSurferTreeNode, ZoneSet zoneSet) {
        if (!this.displayOnlyActiveSet || zoneSet.getActive()) {
            Object[] objectArray;
            SanSurferTreeNode sanSurferTreeNode2 = ZoningUtilities.findTreeNode(sanSurferTreeNode, zoneSet, 0);
            if (sanSurferTreeNode2 == null) {
                sanSurferTreeNode2 = this.addZoneSetToTree(zoneSet);
            }
            Zone zone = zoneSet.getFirstZone();
            while (zone != null) {
                objectArray = this.addZoneToTree(sanSurferTreeNode2, zone, sanSurferTreeNode2.getChildCount());
                this.fillZoneNode((SanSurferTreeNode)objectArray, zone);
                zone = zoneSet.getNextZone(zone);
            }
            objectArray = new Object[]{sanSurferTreeNode, sanSurferTreeNode2};
            this.tree.expandPath(new TreePath(objectArray));
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.errorLabel == null) {
            return;
        }
        this.errorLabel.setText(ZoneSetTree.getErrorLabel(this.zones, this.displayOnlyActiveSet));
    }

    public static String getErrorLabel(Zones zones, boolean bl) {
        if (zones == null) {
            return "";
        }
        if (!zones.getCurrentWithSwitch()) {
            return FabricTreeControl.getResource("ZoneSetTree.noZoningReadingYet");
        }
        if (zones.getErrorReading()) {
            return FabricTreeControl.getResource("ZoneSetTree.errorReading");
        }
        if (zones.getZoningMergeDiff()) {
            return FabricTreeControl.getResource("ZoneSetTree.configDifferent");
        }
        if (bl && zones.getActiveZoneSet() == null) {
            return FabricTreeControl.getResource("ZoneSetTree.noActiveZoneSet");
        }
        return "";
    }

    private void expandAll() {
        int n = 0;
        while (n < this.tree.getRowCount()) {
            this.tree.expandRow(n);
            ++n;
        }
    }

    private void fillZoneNode(SanSurferTreeNode sanSurferTreeNode, Zone zone) {
        ZoneMember zoneMember = zone.getFirstMember();
        while (zoneMember != null) {
            if (zoneMember instanceof ZoneMemberElement) {
                this.addZoneMemberToTree(sanSurferTreeNode, zoneMember, sanSurferTreeNode.getChildCount());
            }
            if (zoneMember instanceof ZoneAlias) {
                SanSurferTreeNode sanSurferTreeNode2 = this.addZoneAliasToTree(sanSurferTreeNode, (ZoneAlias)zoneMember);
            }
            zoneMember = zone.getNextMember(zoneMember);
        }
    }

    private SanSurferTreeNode addZoneMemberToTree(SanSurferTreeNode sanSurferTreeNode, ZoneMember zoneMember, int n) {
        SanSurferTreeNode sanSurferTreeNode2 = this.createSanSurferTreeNodeAndInsert(zoneMember, 12, this.model, sanSurferTreeNode, n);
        return sanSurferTreeNode2;
    }

    private SanSurferTreeNode addZoneSetToTree(ZoneSet zoneSet) {
        SanSurferTreeNode sanSurferTreeNode = this.getRootNode();
        int n = sanSurferTreeNode.getChildCount();
        if (zoneSet.getIsOrphanZoneSet()) {
            n = 0;
        } else {
            int n2 = 0;
            while (n2 < sanSurferTreeNode.getChildCount()) {
                ZoneSet zoneSet2;
                SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n2);
                if (sanSurferTreeNode2.getUserObject() instanceof ZoneSet && !(zoneSet2 = (ZoneSet)sanSurferTreeNode2.getUserObject()).getIsOrphanZoneSet() && zoneSet2.compareTo((Object)zoneSet) > 0) {
                    n = n2;
                    break;
                }
                if (sanSurferTreeNode2.getUserObject() instanceof ZoneAlias) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        SanSurferTreeNode sanSurferTreeNode3 = zoneSet.getActive() ? this.createSanSurferTreeNodeAndInsert(zoneSet, 9, this.model, sanSurferTreeNode, n) : this.createSanSurferTreeNodeAndInsert(zoneSet, 8, this.model, sanSurferTreeNode, n);
        if (this.allowEdit) {
            zoneSet.addListener((ZoneSetListener)this);
        }
        return sanSurferTreeNode3;
    }

    private SanSurferTreeNode addZoneToTree(SanSurferTreeNode sanSurferTreeNode, Zone zone, int n) {
        if (this.allowEdit) {
            zone.addListener((ZoneListener)this);
        }
        if (n > sanSurferTreeNode.getChildCount()) {
            n = sanSurferTreeNode.getChildCount();
        }
        SanSurferTreeNode sanSurferTreeNode2 = this.createSanSurferTreeNodeAndInsert(zone, 10, this.model, sanSurferTreeNode, n);
        return sanSurferTreeNode2;
    }

    private SanSurferTreeNode addZoneAliasToTree(SanSurferTreeNode sanSurferTreeNode, ZoneAlias zoneAlias) {
        SanSurferTreeNode sanSurferTreeNode2;
        int n = sanSurferTreeNode.getChildCount();
        int n2 = sanSurferTreeNode.getChildCount() - 1;
        while (n2 >= 0) {
            sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n2);
            if (!(sanSurferTreeNode2.getUserObject() instanceof ZoneAlias)) break;
            ZoneAlias zoneAlias2 = (ZoneAlias)sanSurferTreeNode2.getUserObject();
            if (zoneAlias2.compareTo((Object)zoneAlias) < 0) {
                n = n2;
            }
            --n2;
        }
        sanSurferTreeNode2 = this.createSanSurferTreeNodeAndInsert(zoneAlias, 11, this.model, sanSurferTreeNode, n);
        if (this.allowEdit) {
            zoneAlias.addListener((ZoneListener)this);
        }
        this.fillZoneNode(sanSurferTreeNode2, (Zone)zoneAlias);
        return sanSurferTreeNode2;
    }

    private void insertNode(DefaultTreeModel defaultTreeModel, SanSurferTreeNode sanSurferTreeNode, SanSurferTreeNode sanSurferTreeNode2, int n) {
        if (sanSurferTreeNode2.getChildCount() < n) {
            n = sanSurferTreeNode2.getChildCount();
        }
        defaultTreeModel.insertNodeInto(sanSurferTreeNode, sanSurferTreeNode2, n);
    }

    public void zoneChanged(ZoneEvent zoneEvent) {
        SwingUtilities.invokeLater(new ZoneEventRunnable(zoneEvent));
    }

    public void zoneSetChanged(ZoneSetEvent zoneSetEvent) {
        SwingUtilities.invokeLater(new ZoneSetEventRunnable(zoneSetEvent));
    }

    public void zonesChanged(ZonesEvent zonesEvent) {
        SwingUtilities.invokeLater(new ZonesEventRunnable(zonesEvent));
    }

    public class ZonesEventRunnable
    implements Runnable {
        ZonesEvent event;

        public ZonesEventRunnable(ZonesEvent zonesEvent) {
            this.event = zonesEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Cursor cursor = ZoneSetTree.this.getCursor();
            ZoneSetTree.this.setCursor(new Cursor(3));
            try {
                SanSurferTreeNode sanSurferTreeNode = ZoneSetTree.this.getRootNode();
                switch (this.event.getEventType()) {
                    case 4: {
                        ZoneSetTree.this.removeZoneAlias(this.event.getZoneAlias());
                        break;
                    }
                    case 3: {
                        ZoneSetTree.this.addZoneAliasToTree(sanSurferTreeNode, this.event.getZoneAlias());
                        break;
                    }
                    case 2: {
                        ZoneSetTree.this.removeZoneSet(this.event.getZoneSet());
                        break;
                    }
                    case 1: {
                        ZoneSetTree.this.addZoneSetToTree(this.event.getZoneSet());
                    }
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ZoneSetTree.this.setCursor(cursor);
                throw throwable;
            }
            ZoneSetTree.this.setCursor(cursor);
        }
    }

    public class ZoneSetEventRunnable
    implements Runnable {
        ZoneSetEvent event;

        public ZoneSetEventRunnable(ZoneSetEvent zoneSetEvent) {
            this.event = zoneSetEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Cursor cursor = ZoneSetTree.this.getCursor();
            ZoneSetTree.this.setCursor(new Cursor(3));
            try {
                ZoneSet zoneSet = (ZoneSet)this.event.getSource();
                SanSurferTreeNode sanSurferTreeNode = ZoningUtilities.findTreeNode(ZoneSetTree.this.getRootNode(), zoneSet, 0);
                switch (this.event.getEventType()) {
                    case 2: {
                        ZoneSetTree.this.removeZoneFromSet(this.event.getZone(), zoneSet);
                        break;
                    }
                    case 4: {
                        ZoneSetTree.this.moveZoneFromSetToSet(this.event.getZone(), zoneSet, this.event.getSetDest());
                        break;
                    }
                    case 1: {
                        int n = zoneSet.getZoneIndex(this.event.getZone());
                        if (n < 0) break;
                        SanSurferTreeNode sanSurferTreeNode2 = ZoneSetTree.this.addZoneToTree(sanSurferTreeNode, this.event.getZone(), n);
                        ZoneSetTree.this.fillZoneNode(sanSurferTreeNode2, this.event.getZone());
                        break;
                    }
                    case 3: {
                        if (zoneSet.getActive()) {
                            sanSurferTreeNode.setType(9);
                        } else {
                            sanSurferTreeNode.setType(8);
                        }
                        ZoneSetTree.this.model.nodeChanged(sanSurferTreeNode);
                    }
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ZoneSetTree.this.setCursor(cursor);
                throw throwable;
            }
            ZoneSetTree.this.setCursor(cursor);
        }
    }

    public class ZoneEventRunnable
    implements Runnable {
        ZoneEvent event;

        public ZoneEventRunnable(ZoneEvent zoneEvent) {
            this.event = zoneEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Zone zone = (Zone)this.event.getSource();
            Vector vector = this.event.getZoneMemberList();
            Cursor cursor = ZoneSetTree.this.getCursor();
            ZoneSetTree.this.setCursor(new Cursor(3));
            try {
                if (zone instanceof ZoneAlias) {
                    ZoneAlias zoneAlias = (ZoneAlias)zone;
                    switch (this.event.getEventType()) {
                        case 2: {
                            this.removeZoneMembersFromAlias(vector, zoneAlias);
                            break;
                        }
                        case 1: {
                            this.addZoneMembersToAlias(vector, zoneAlias);
                            break;
                        }
                        case 3: {
                            SanSurferTreeNode sanSurferTreeNode = ZoneSetTree.this.getRootNode();
                            ZoneSetTree.this.removeZoneAlias(zoneAlias);
                            ZoneSetTree.this.addZoneAliasToTree(sanSurferTreeNode, zoneAlias);
                        }
                    }
                } else {
                    SanSurferTreeNode sanSurferTreeNode = ZoningUtilities.findTreeNode(ZoneSetTree.this.getRootNode(), zone, 1);
                    switch (this.event.getEventType()) {
                        case 3: {
                            ZoneSetTree.this.model.nodeChanged(sanSurferTreeNode);
                            break;
                        }
                        case 2: {
                            this.removeZoneMembersFromZone(vector, zone);
                            break;
                        }
                        case 1: {
                            this.addZoneMembersToZone(zone, vector);
                        }
                    }
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                ZoneSetTree.this.setCursor(cursor);
                throw throwable;
            }
            ZoneSetTree.this.setCursor(cursor);
        }

        private void addZoneMembersToAlias(Vector vector, ZoneAlias zoneAlias) {
            SanSurferTreeNode sanSurferTreeNode = ZoneSetTree.this.getRootNode();
            int n = sanSurferTreeNode.getChildCount() - 1;
            while (n >= 0) {
                SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
                if (sanSurferTreeNode2.getUserObject() == zoneAlias) {
                    this.addZoneMembersToAliasNode(vector, sanSurferTreeNode2);
                } else {
                    int n2 = 0;
                    while (n2 < sanSurferTreeNode2.getChildCount()) {
                        SanSurferTreeNode sanSurferTreeNode3 = (SanSurferTreeNode)sanSurferTreeNode2.getChildAt(n2);
                        int n3 = sanSurferTreeNode3.getChildCount() - 1;
                        while (n3 >= 0) {
                            SanSurferTreeNode sanSurferTreeNode4 = (SanSurferTreeNode)sanSurferTreeNode3.getChildAt(n3);
                            if (sanSurferTreeNode4.getUserObject() == zoneAlias) {
                                this.addZoneMembersToAliasNode(vector, sanSurferTreeNode4);
                                break;
                            }
                            if (sanSurferTreeNode4.getNodeType() != 11) break;
                            --n3;
                        }
                        ++n2;
                    }
                }
                --n;
            }
        }

        private void addZoneMembersToAliasNode(Vector vector, SanSurferTreeNode sanSurferTreeNode) {
            int n = 0;
            while (n < vector.size()) {
                ZoneMember zoneMember = (ZoneMember)vector.elementAt(n);
                int n2 = sanSurferTreeNode.getChildCount();
                int n3 = 0;
                while (n3 < sanSurferTreeNode.getChildCount()) {
                    SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n3);
                    ZoneMember zoneMember2 = (ZoneMember)sanSurferTreeNode2.getUserObject();
                    if (zoneMember.compareTo((Object)zoneMember2) < 0) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
                ZoneSetTree.this.addZoneMemberToTree(sanSurferTreeNode, zoneMember, n2);
                ++n;
            }
        }

        private boolean removeZoneMembersFromAlias(Vector vector, ZoneAlias zoneAlias) {
            boolean bl = false;
            SanSurferTreeNode sanSurferTreeNode = ZoneSetTree.this.getRootNode();
            int n = 0;
            while (n < sanSurferTreeNode.getChildCount()) {
                SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
                if (sanSurferTreeNode2.getUserObject() == zoneAlias && this.removeMembersFromAlaisNode(sanSurferTreeNode2, vector)) {
                    bl = true;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < sanSurferTreeNode.getChildCount()) {
                SanSurferTreeNode sanSurferTreeNode3 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n2);
                if (sanSurferTreeNode3.getNodeType() != 11) {
                    SanSurferTreeNode sanSurferTreeNode4 = sanSurferTreeNode3;
                    int n3 = 0;
                    while (n3 < sanSurferTreeNode4.getChildCount()) {
                        SanSurferTreeNode sanSurferTreeNode5 = (SanSurferTreeNode)sanSurferTreeNode4.getChildAt(n3);
                        int n4 = 0;
                        while (n4 < sanSurferTreeNode5.getChildCount()) {
                            SanSurferTreeNode sanSurferTreeNode6 = (SanSurferTreeNode)sanSurferTreeNode5.getChildAt(n4);
                            if (sanSurferTreeNode6.getUserObject() == zoneAlias) {
                                if (!this.removeMembersFromAlaisNode(sanSurferTreeNode6, vector)) break;
                                bl = true;
                                break;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            return bl;
        }

        private boolean removeMembersFromAlaisNode(SanSurferTreeNode sanSurferTreeNode, Vector vector) {
            int n = 0;
            while (n < sanSurferTreeNode.getChildCount()) {
                SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
                ZoneMember zoneMember = (ZoneMember)sanSurferTreeNode2.getUserObject();
                if (vector.contains(zoneMember)) {
                    ZoneSetTree.this.model.removeNodeFromParent(sanSurferTreeNode2);
                }
                ++n;
            }
            return false;
        }

        private boolean removeZoneMembersFromZone(Vector vector, Zone zone) {
            boolean bl = false;
            SanSurferTreeNode sanSurferTreeNode = ZoneSetTree.this.getRootNode();
            int n = 0;
            while (n < sanSurferTreeNode.getChildCount()) {
                SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
                int n2 = 0;
                while (n2 < sanSurferTreeNode2.getChildCount()) {
                    SanSurferTreeNode sanSurferTreeNode3 = (SanSurferTreeNode)sanSurferTreeNode2.getChildAt(n2);
                    if (sanSurferTreeNode3.getUserObject() == zone) {
                        int n3 = 0;
                        while (n3 < sanSurferTreeNode3.getChildCount()) {
                            SanSurferTreeNode sanSurferTreeNode4 = (SanSurferTreeNode)sanSurferTreeNode3.getChildAt(n3);
                            ZoneMember zoneMember = (ZoneMember)sanSurferTreeNode4.getUserObject();
                            if (vector.contains(zoneMember)) {
                                ZoneSetTree.this.model.removeNodeFromParent(sanSurferTreeNode4);
                                bl = true;
                            }
                            ++n3;
                        }
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
            return bl;
        }

        private void addZoneMembersToZone(Zone zone, Vector vector) {
            SanSurferTreeNode sanSurferTreeNode = ZoneSetTree.this.getRootNode();
            int n = 0;
            while (n < sanSurferTreeNode.getChildCount()) {
                SanSurferTreeNode sanSurferTreeNode2 = (SanSurferTreeNode)sanSurferTreeNode.getChildAt(n);
                int n2 = 0;
                while (n2 < sanSurferTreeNode2.getChildCount()) {
                    SanSurferTreeNode sanSurferTreeNode3 = (SanSurferTreeNode)sanSurferTreeNode2.getChildAt(n2);
                    if (sanSurferTreeNode3.getUserObject() == zone) {
                        int n3 = 0;
                        while (n3 < vector.size()) {
                            SanSurferTreeNode sanSurferTreeNode4;
                            ZoneMember zoneMember = (ZoneMember)vector.elementAt(n3);
                            if (zoneMember instanceof ZoneAlias) {
                                ZoneAlias zoneAlias = (ZoneAlias)zoneMember;
                                sanSurferTreeNode4 = ZoneSetTree.this.addZoneAliasToTree(sanSurferTreeNode3, zoneAlias);
                            } else {
                                int n4 = 0;
                                n4 = 0;
                                while (n4 < sanSurferTreeNode3.getChildCount()) {
                                    sanSurferTreeNode4 = (SanSurferTreeNode)sanSurferTreeNode3.getChildAt(n4);
                                    ZoneMember zoneMember2 = (ZoneMember)sanSurferTreeNode4.getUserObject();
                                    if (zoneMember.compareTo((Object)zoneMember2) < 0) break;
                                    ++n4;
                                }
                                ZoneSetTree.this.addZoneMemberToTree(sanSurferTreeNode3, zoneMember, n4);
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    private class DisplayClass
    implements Runnable {
        String str;

        DisplayClass(String string) {
            this.str = string;
        }

        public void run() {
            JOptionPane.showMessageDialog(SbmUtilities.getFrame(ZoneSetTree.this), this.str);
        }
    }

    public class ReceiveDrop
    implements Runnable {
        Vector list;

        public ReceiveDrop(Vector vector) {
            this.list = vector;
        }

        public void run() {
            Object e = this.list.firstElement();
            if (e instanceof ZoneMember) {
                Zone zone = ZoneSetTree.this.getSelectedZone();
                if (zone != null) {
                    ZoneSetTree.this.addListToZone(zone, this.list);
                }
            } else {
                int n = 0;
                while (n < this.list.size()) {
                    e = this.list.elementAt(n);
                    if (this.list.elementAt(n) instanceof String) {
                        Object object;
                        JFrame jFrame;
                        ZoneSet zoneSet;
                        String string = (String)this.list.elementAt(n);
                        if (string.indexOf(ZoneMemberSelection.ZONE_TAG) == 0) {
                            zoneSet = ZoneSetTree.this.getSelectedZoneSet();
                            if (zoneSet != null) {
                                jFrame = SbmUtilities.getFrame(ZoneSetTree.this);
                                if (zoneSet.getIsOrphanZoneSet()) {
                                    ZoneSetTree.this.displayMessage(FabricTreeControl.getResource("ZoneSetTree.cantAddToOrphanZoneSet"));
                                } else {
                                    string = string.substring(ZoneMemberSelection.ZONE_TAG.length());
                                    object = ZoneSetTree.this.zones.findZone(string);
                                    if (object != null) {
                                        int n2 = ZoneSetTree.this.zones.addZoneToSet((Zone)object, zoneSet);
                                        switch (n2) {
                                            case 0: {
                                                break;
                                            }
                                            case 108: {
                                                ZoneSetTree.this.displayMessage(object + " " + FabricTreeControl.getResource("ZoneSetTree.isAlreadyAMember") + " " + zoneSet);
                                                break;
                                            }
                                            case 110: {
                                                ZoneSetTree.this.displayMessage(FabricTreeControl.getResource("ZoningDialog.unableToAddZoneToSet"));
                                                break;
                                            }
                                            default: {
                                                ZoneSetTree.this.displayMessage(FabricTreeControl.getResource("ZoneSetTree.unknownZoningError") + " = " + n2);
                                                break;
                                            }
                                        }
                                    }
                                }
                            }
                        } else if (string.indexOf(ZoneMemberSelection.ALIAS_TAG) == 0 && (zoneSet = ZoneSetTree.this.getSelectedZone()) != null) {
                            string = string.substring(ZoneMemberSelection.ALIAS_TAG.length());
                            jFrame = ZoneSetTree.this.zones.findZoneAlias(string);
                            if (jFrame == zoneSet) {
                                return;
                            }
                            if (jFrame != null) {
                                object = new Vector();
                                ((Vector)object).add(jFrame);
                                switch (ZoneSetTree.this.zones.addZoneMembersToZone((Zone)zoneSet, (Vector)object)) {
                                    case 100: {
                                        ZoneSetTree.this.displayMessage(FabricTreeControl.getResource("ZoneSetTree.maxMembers"));
                                        break;
                                    }
                                    case 103: {
                                        ZoneSetTree.this.displayMessage(FabricTreeControl.getResource("ZoneSetTree.maxMembersPerZone"));
                                    }
                                }
                            }
                        }
                    }
                    ++n;
                }
            }
        }
    }
}

