/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.zoning;

import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.ZoneAlias;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.qms.fabric.SanSurferTreeNode;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.zoning.ZoneMemberSelection;
import com.qlogic.qms.fabric.zoning.ZoningUtilities;
import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeDragSource
implements DragSourceListener,
DragGestureListener {
    DragSource dragSource;
    DragGestureRecognizer recognizer;
    Zones zones;
    JTree tree;

    public TreeDragSource(JTree jTree, Zones zones) {
        this.tree = jTree;
        this.zones = zones;
        this.dragSource = new DragSource();
        this.recognizer = this.dragSource.createDefaultDragGestureRecognizer(this.tree, 3, this);
    }

    public void setZones(Zones zones) {
        this.zones = zones;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        block14: {
            ZoneMemberSelection zoneMemberSelection;
            Object[] objectArray = this.getSelectedNodes();
            Vector<ZoneMember> vector = new Vector<ZoneMember>();
            String string = null;
            int n = -1;
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2] instanceof SanSurferTreeNode) {
                        SanSurferTreeNode sanSurferTreeNode = (SanSurferTreeNode)objectArray[n2];
                        switch (sanSurferTreeNode.getNodeType()) {
                            case 5: 
                            case 6: 
                            case 7: {
                                ZoneMember zoneMember = ZoningUtilities.createZoneMember(this.zones, (SanSurferTreeNode)objectArray[n2]);
                                if (zoneMember != null) {
                                    vector.add(zoneMember);
                                    break;
                                }
                                Object object = SbmUtilities.getFrame(this.tree);
                                JOptionPane.showMessageDialog((Component)object, "Unable to create zone member ");
                                break;
                            }
                            case 10: {
                                Object object = (Zone)sanSurferTreeNode.getUserObject();
                                string = object.getName();
                                n = 0;
                                break;
                            }
                            case 11: {
                                ZoneAlias zoneAlias = (ZoneAlias)sanSurferTreeNode.getUserObject();
                                string = zoneAlias.getName();
                                n = 1;
                            }
                        }
                    }
                    ++n2;
                }
            }
            if (vector.size() > 0 && (zoneMemberSelection = new ZoneMemberSelection(vector)).getTransferDataFlavors() != null) {
                try {
                    dragGestureEvent.startDrag(null, zoneMemberSelection, this);
                }
                catch (InvalidDnDOperationException invalidDnDOperationException) {
                    // empty catch block
                }
            }
            if (string == null) break block14;
            ZoneMemberSelection zoneMemberSelection2 = new ZoneMemberSelection(string, n);
            try {
                dragGestureEvent.startDrag(null, zoneMemberSelection2, this);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {}
        }
    }

    private Object[] getSelectedNodes() {
        Object[] objectArray = null;
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null) {
            int n = treePathArray.length;
            objectArray = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = treePathArray[n2].getLastPathComponent();
                ++n2;
            }
        }
        return objectArray;
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragDropEnd() {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }
}

