/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.zoning;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FabricUtilities;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ActivateZoneSetDialog
extends QDialog
implements ChassisEventListener {
    ApplyCompleteDialog applyComplete = null;
    public static final int ACTIVATE_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private int option = 1;
    private String activeZoneSetStr;
    JPanel dataPanel = new JPanel();
    GridBagLayout dataLayout = new GridBagLayout();
    JLabel nameLabel = new JLabel(FabricTreeControl.getResource("ActivateZoneSetDialog.selectZoneSet"));
    JComboBox nameComboField = new JComboBox();
    JPanel buttonPanel = new JPanel();
    GridLayout buttonLayout = new GridLayout(1, 2, 8, 0);
    JButton activateZoneSetButton = new JButton(new ActivateZoneSetItemAction());
    JButton cancelButton = new JButton(new CancelAction());
    GridBagLayout newFabricLayout = new GridBagLayout();
    String title;
    String nameStr;
    Zones zones;
    SanboxChassis chassis;
    private static Cursor busyCursor = new Cursor(3);
    private static Cursor defaultCursor = Cursor.getDefaultCursor();

    public ActivateZoneSetDialog(Frame frame, SanboxChassis sanboxChassis, Zones zones) {
        super(frame, true);
        this.chassis = sanboxChassis;
        this.chassis.getEventHandler().addChassisEventListener((ChassisEventListener)this);
        this.zones = zones;
        try {
            this.jbInit();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ActivateZoneSetDialog(Frame frame, SanboxChassis sanboxChassis, Zones zones, ZoneSet zoneSet) {
        super(frame, true);
        this.chassis = sanboxChassis;
        this.chassis.getEventHandler().addChassisEventListener((ChassisEventListener)this);
        this.zones = zones;
        try {
            this.jbInit();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.nameComboField.setSelectedItem(zoneSet.getName());
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getChassis() != this.chassis) {
            if (chassisEvent.getChassis() != null) {
                chassisEvent.getChassis().getEventHandler().removeChassisEventListener((ChassisEventListener)this);
            }
            return;
        }
        if (chassisEvent.getEventType() == 247 || chassisEvent.getEventType() == 363) {
            while (this.applyComplete != null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.applyComplete = new ApplyCompleteDialog(chassisEvent);
            SwingUtilities.invokeLater(this.applyComplete);
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(FabricTreeControl.getResource("ActivateZoneSetDialog.titleBarText") + " - " + VendorProperties.getFrameTitle());
        ZoneSet zoneSet = this.zones.getFirstZoneSet();
        while (zoneSet != null) {
            String string = zoneSet.getName();
            int n = this.nameComboField.getItemCount();
            n = 0;
            while (n < this.nameComboField.getItemCount()) {
                String string2 = (String)this.nameComboField.getItemAt(n);
                int n2 = string2.compareToIgnoreCase(string);
                if (n2 > 0 || n2 == 0 && string2.compareTo(string) < 0) break;
                ++n;
            }
            this.nameComboField.insertItemAt(zoneSet.getName(), n);
            zoneSet = this.zones.getNextZoneSet(zoneSet);
        }
        this.getContentPane().setLayout(this.newFabricLayout);
        this.nameComboField.setPreferredSize(new Dimension(160, 21));
        this.dataPanel.setLayout(this.dataLayout);
        this.dataPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.nameComboField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.getContentPane().add((Component)this.dataPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.buttonPanel.setLayout(this.buttonLayout);
        this.buttonPanel.add((Component)this.activateZoneSetButton, null);
        this.activateZoneSetButton.setMnemonic('A');
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.cancelButton.setMnemonic('C');
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.activateZoneSetDialogHelp"));
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.getRootPane().setDefaultButton(this.activateZoneSetButton);
        this.pack();
        this.nameComboField.requestFocus();
    }

    public int getOption() {
        return this.option;
    }

    public ZoneSet getZoneSet() {
        int n = this.nameComboField.getSelectedIndex();
        if (n < 0) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("ActivateZoneSetDialog.invalidZoneSetSelection"));
            return null;
        }
        String string = (String)this.nameComboField.getSelectedItem();
        if (string != null) {
            return this.zones.findZoneSet(string);
        }
        return null;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.doClose();
        }
    }

    private void doClose() {
        this.setCursor(defaultCursor);
        this.setVisible(false);
        this.chassis.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(FabricTreeControl.getResource("ActivateZoneSetDialog.cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActivateZoneSetDialog.this.option = 2;
            ActivateZoneSetDialog.this.doClose();
        }
    }

    class ActivateZoneSetItemAction
    extends AbstractAction {
        public ActivateZoneSetItemAction() {
            super(FabricTreeControl.getResource("ActivateZoneSetDialog.activate"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ZoneSet zoneSet = ActivateZoneSetDialog.this.getZoneSet();
            if (zoneSet != null) {
                if (FabricUtilities.willFabricIsolate((ZoneSet)zoneSet, (Chassis)ActivateZoneSetDialog.this.chassis) && JOptionPane.showConfirmDialog(ActivateZoneSetDialog.this, FabricTreeControl.getResource("ZoningDialog.mightIsolate"), FabricTreeControl.getResource("ZoningDialog.applyingZoning"), 0) == 1) {
                    return;
                }
                ActivateZoneSetDialog.this.activeZoneSetStr = zoneSet.getName();
                ActivateZoneSetDialog.this.chassis.applyActivateZoneSet(zoneSet);
                ActivateZoneSetDialog.this.setCursor(busyCursor);
                ActivateZoneSetDialog.this.activateZoneSetButton.setEnabled(false);
            }
        }
    }

    class ApplyCompleteDialog
    implements Runnable {
        ChassisEvent evt;

        ApplyCompleteDialog(ChassisEvent chassisEvent) {
            this.evt = chassisEvent;
        }

        public void run() {
            JFrame jFrame = SbmUtilities.getFrame(ActivateZoneSetDialog.this);
            ActivateZoneSetDialog.this.setCursor(defaultCursor);
            switch (this.evt.getEventType()) {
                case 247: {
                    if (this.evt.isSuccessful()) {
                        JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("ActivateZoneSetDialog.zoneSet") + " " + ActivateZoneSetDialog.this.activeZoneSetStr + " " + FabricTreeControl.getResource("ActivateZoneSetDialog.activated"), ActivateZoneSetDialog.this.getTitle(), -1);
                        ActivateZoneSetDialog.this.doClose();
                        break;
                    }
                    JOptionPane.showMessageDialog(jFrame, FabricTreeControl.getResource("ActivateZoneSetDialog.activateFailed") + " " + FabricTreeControl.translateErrorType(this.evt.getErrorType()), ActivateZoneSetDialog.this.getTitle(), 0);
                    ActivateZoneSetDialog.this.activateZoneSetButton.setEnabled(true);
                    break;
                }
                case 363: {
                    JOptionPane.showMessageDialog(jFrame, FabricTreeControl.translateErrorType(this.evt.getErrorType()), ActivateZoneSetDialog.this.getTitle(), 0);
                }
            }
            ActivateZoneSetDialog.this.applyComplete = null;
        }
    }
}

