/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.wizards.zoning;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.zoning.Zone;
import com.qlogic.device.fcfabric.zoning.ZoneMember;
import com.qlogic.device.fcfabric.zoning.ZoneSet;
import com.qlogic.device.fcfabric.zoning.Zones;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.wizards.ButtonPanelFactory;
import com.qlogic.qms.fabric.wizards.Page;
import com.qlogic.qms.fabric.wizards.QWizard;
import com.qlogic.qms.fabric.wizards.zoning.DedicateNtServerPanel;
import com.qlogic.qms.fabric.wizards.zoning.DoYouWishToGroupTargetsAndInitiatorsPanel;
import com.qlogic.qms.fabric.wizards.zoning.DoYouWishToZoneTLPortsPanel;
import com.qlogic.qms.fabric.wizards.zoning.EnterNameOfNtServerPanel;
import com.qlogic.qms.fabric.wizards.zoning.EnterNameOfTargetInitiatorGroupPanel;
import com.qlogic.qms.fabric.wizards.zoning.EnterNameOfTlPortGroupPanel;
import com.qlogic.qms.fabric.wizards.zoning.GenerationPanel;
import com.qlogic.qms.fabric.wizards.zoning.IntroPanel;
import com.qlogic.qms.fabric.wizards.zoning.MoreNtServersPanel;
import com.qlogic.qms.fabric.wizards.zoning.MoreTargetInitiatorGroupsPanel;
import com.qlogic.qms.fabric.wizards.zoning.MoreTlPortsPanel;
import com.qlogic.qms.fabric.wizards.zoning.NoTargetsOrInitiatorsPanel;
import com.qlogic.qms.fabric.wizards.zoning.PickSharableTargetsPanel;
import com.qlogic.qms.fabric.wizards.zoning.SelectInitiatorPortsInNtServerGroupPanel;
import com.qlogic.qms.fabric.wizards.zoning.SelectInitiatorPortsInTlGroupPanel;
import com.qlogic.qms.fabric.wizards.zoning.SelectInitiatorsInTargetInitiatorGroupPanel;
import com.qlogic.qms.fabric.wizards.zoning.SelectTargetPortsInNtServerGroupPanel;
import com.qlogic.qms.fabric.wizards.zoning.SelectTargetsInTargetInitiatorGroupPanel;
import com.qlogic.qms.fabric.wizards.zoning.SelectTargetsInTlGroupPanel;
import com.qlogic.qms.fabric.wizards.zoning.ZoningGroup;
import com.qlogic.qms.fabric.wizards.zoning.ZoningNavigator;
import java.awt.Dimension;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;

public class ZoningWizard
extends QWizard {
    public static final int NUMBER_OF_ZONING_STEPS = 5;
    static final int PAGE_INTRO = 0;
    static final int PAGE_NO_TARGETS = 1;
    static final int PAGE_DEDICATE_NT = 2;
    static final int PAGE_PICK_SHARABLES = 3;
    static final int PAGE_ENTER_NAME_OF_NT_SERVER = 4;
    static final int PAGE_SELECT_INITIATOR_PORTS_ON_NT_SERVER = 5;
    static final int PAGE_SELECT_TARGET_PORTS_FOR_NT_SERVER = 6;
    static final int PAGE_MORE_NT_SERVERS = 7;
    static final int PAGE_DO_YOU_WISH_TO_GROUP_TARGETS_AND_INITIATORS = 8;
    static final int PAGE_ENTER_NAME_OF_TARGET_INITIATOR_GROUP = 9;
    static final int PAGE_SELECT_INITIATOR_PORTS_IN_TARGET_INITIATOR_GROUP = 10;
    static final int PAGE_SELECT_TARGET_PORTS_FOR_TARGET_INITIATOR_GROUP = 11;
    static final int PAGE_MORE_TARGET_INITIATOR_GROUPS = 12;
    static final int PAGE_DO_YOU_WISH_TO_ZONE_TL_PORTS = 13;
    static final int PAGE_ENTER_NAME_OF_TL_PORT_GROUP = 14;
    static final int PAGE_SELECT_INITIATOR_PORTS_IN_TL_GROUP = 15;
    static final int PAGE_SELECT_TARGETS_IN_TL_GROUP = 16;
    static final int PAGE_MORE_TL_PORTS = 17;
    static final int PAGE_GENERATION = 18;
    Fabric fabric;
    Vector targetList = new Vector();
    Vector initiatorList = new Vector();
    SanboxChassis sanbox;
    Zones zones;
    boolean finishedOk = false;
    Vector ntServers = new Vector();
    int ntServerIndex = -1;
    Vector targetInitiatorGroups = new Vector();
    int targetInitiatorGroupIndex = -1;
    Vector tlPortGroups = new Vector();
    int tlPortGroupIndex = -1;
    IntroPanel introPanel = new IntroPanel();
    NoTargetsOrInitiatorsPanel noTargetsOrInitiatorsPanel = new NoTargetsOrInitiatorsPanel();
    DedicateNtServerPanel dedicateNtServerPanel = new DedicateNtServerPanel();
    PickSharableTargetsPanel pickSharableTargetsPanel = new PickSharableTargetsPanel(this.targetList);
    EnterNameOfNtServerPanel enterNameOfNtServerPanel = new EnterNameOfNtServerPanel(this);
    SelectInitiatorPortsInNtServerGroupPanel selectInitiatorPortsInNtServerGroupPanel = new SelectInitiatorPortsInNtServerGroupPanel(this, this.initiatorList);
    SelectTargetPortsInNtServerGroupPanel selectTargetPortsInNtServerGroupPanel = new SelectTargetPortsInNtServerGroupPanel(this, this.targetList);
    MoreNtServersPanel moreNtServersPanel = new MoreNtServersPanel();
    DoYouWishToGroupTargetsAndInitiatorsPanel doYouWishToGroupTargetsAndInitiatorsPanel = new DoYouWishToGroupTargetsAndInitiatorsPanel();
    EnterNameOfTargetInitiatorGroupPanel enterNameOfTargetInitiatorGroupPanel = new EnterNameOfTargetInitiatorGroupPanel(this);
    SelectInitiatorsInTargetInitiatorGroupPanel selectInitiatorsInTargetInitiatorGroupPanel = new SelectInitiatorsInTargetInitiatorGroupPanel(this, this.initiatorList);
    SelectTargetsInTargetInitiatorGroupPanel selectTargetsInTargetInitiatorGroupPanel = new SelectTargetsInTargetInitiatorGroupPanel(this, this.targetList);
    MoreTargetInitiatorGroupsPanel moreTargetInitiatorGroupsPanel = new MoreTargetInitiatorGroupsPanel();
    DoYouWishToZoneTLPortsPanel doYouWishToZoneTLPortsPanel = new DoYouWishToZoneTLPortsPanel();
    EnterNameOfTlPortGroupPanel enterNameOfTlPortGroupPanel = new EnterNameOfTlPortGroupPanel(this);
    SelectInitiatorPortsInTlGroupPanel selectInitiatorPortsInTlGroupPanel = new SelectInitiatorPortsInTlGroupPanel(this, this.initiatorList);
    SelectTargetsInTlGroupPanel selectTargetsInTlGroupPanel = new SelectTargetsInTlGroupPanel(this, this.targetList);
    MoreTlPortsPanel moreTlPortsPanel = new MoreTlPortsPanel();
    GenerationPanel generationPanel = new GenerationPanel(this);

    public ZoningWizard(JFrame jFrame, Fabric fabric, SanboxChassis sanboxChassis, Zones zones) {
        super(jFrame, FabricTreeControl.getResource("ZoningWizard.title"), sanboxChassis);
        this.setModal(true);
        this.sanbox = sanboxChassis;
        this.fabric = fabric;
        this.zones = zones;
        this.navigator = new ZoningNavigator(this, this.rightPanel, this.bottomPanel, this.leftPanel);
        this.initWizard();
    }

    protected void layoutWizard() {
        super.layoutWizard();
        this.rightPanel.setPreferredSize(new Dimension(600, 400));
    }

    public boolean isFinishedOk() {
        return this.finishedOk;
    }

    public Vector createWizardPageList() {
        Vector<Page> vector = new Vector<Page>();
        vector.add(new Page(FabricTreeControl.getResource("IntroPanel.title"), this.introPanel, ButtonPanelFactory.createDefaultButtonPanel(), 1, 0, 0));
        vector.add(new Page(FabricTreeControl.getResource("NoTargetsOrInitiatorsPanel.title"), this.noTargetsOrInitiatorsPanel, this.noTargetsOrInitiatorsPanel.getButtonPanel(), 3, 1, 0));
        vector.add(new Page(FabricTreeControl.getResource("DedicateNtServerPanel.title"), this.dedicateNtServerPanel, this.dedicateNtServerPanel.getButtonPanel(), 3, 2, 1));
        vector.add(new Page(FabricTreeControl.getResource("PickSharableTargetsPanel.title"), this.pickSharableTargetsPanel, this.pickSharableTargetsPanel.getButtonPanel(), 3, 3, 1));
        vector.add(new Page(FabricTreeControl.getResource("EnterNameOfNtServerPanel.title"), this.enterNameOfNtServerPanel, this.enterNameOfNtServerPanel.getButtonPanel(), 3, 4, 1));
        vector.add(new Page(FabricTreeControl.getResource("SelectInitiatorPortsInNtServerGroupPanel.title"), this.selectInitiatorPortsInNtServerGroupPanel, this.selectInitiatorPortsInNtServerGroupPanel.getButtonPanel(), 3, 5, 1));
        vector.add(new Page(FabricTreeControl.getResource("SelectTargetPortsInNtServerGroupPanel.title"), this.selectTargetPortsInNtServerGroupPanel, this.selectTargetPortsInNtServerGroupPanel.getButtonPanel(), 3, 6, 1));
        vector.add(new Page(FabricTreeControl.getResource("MoreNtServersPanel.title"), this.moreNtServersPanel, this.moreNtServersPanel.getButtonPanel(), 3, 7, 1));
        vector.add(new Page(FabricTreeControl.getResource("DoYouWishToGroupTargetsAndInitiatorsPanel.title"), this.doYouWishToGroupTargetsAndInitiatorsPanel, this.doYouWishToGroupTargetsAndInitiatorsPanel.getButtonPanel(), 3, 8, 2));
        vector.add(new Page(FabricTreeControl.getResource("EnterNameOfTargetInitiatorGroupPanel.title"), this.enterNameOfTargetInitiatorGroupPanel, this.enterNameOfTargetInitiatorGroupPanel.getButtonPanel(), 3, 9, 2));
        vector.add(new Page(FabricTreeControl.getResource("SelectInitiatorsInTargetInitiatorGroupPanel.title"), this.selectInitiatorsInTargetInitiatorGroupPanel, this.selectInitiatorsInTargetInitiatorGroupPanel.getButtonPanel(), 3, 10, 2));
        vector.add(new Page(FabricTreeControl.getResource("SelectTargetsInTargetInitiatorGroupPanel.title"), this.selectTargetsInTargetInitiatorGroupPanel, this.selectTargetsInTargetInitiatorGroupPanel.getButtonPanel(), 3, 11, 2));
        vector.add(new Page(FabricTreeControl.getResource("MoreTargetInitiatorGroupsPanel.title"), this.moreTargetInitiatorGroupsPanel, this.moreTargetInitiatorGroupsPanel.getButtonPanel(), 3, 12, 2));
        vector.add(new Page(FabricTreeControl.getResource("DoYouWishToZoneTLPortsPanel.title"), this.doYouWishToZoneTLPortsPanel, this.doYouWishToZoneTLPortsPanel.getButtonPanel(), 3, 13, 3));
        vector.add(new Page(FabricTreeControl.getResource("EnterNameOfTlPortGroupPanel.title"), this.enterNameOfTlPortGroupPanel, this.enterNameOfTlPortGroupPanel.getButtonPanel(), 3, 14, 3));
        vector.add(new Page(FabricTreeControl.getResource("SelectInitiatorPortsInTlGroupPanel.title"), this.selectInitiatorPortsInTlGroupPanel, this.selectInitiatorPortsInTlGroupPanel.getButtonPanel(), 3, 15, 3));
        vector.add(new Page(FabricTreeControl.getResource("SelectTargetsInTlGroupPanel.title"), this.selectTargetsInTlGroupPanel, this.selectTargetsInTlGroupPanel.getButtonPanel(), 3, 16, 3));
        vector.add(new Page(FabricTreeControl.getResource("MoreTlPortsPanel.title"), this.moreTlPortsPanel, this.moreTlPortsPanel.getButtonPanel(), 3, 17, 1));
        vector.add(new Page(FabricTreeControl.getResource("GenerationPanel.title"), this.generationPanel, this.generationPanel.getButtonPanel(), 3, 18, 4));
        return vector;
    }

    public boolean getDedicateToNtServers() {
        return this.dedicateNtServerPanel.getDedicateToNtServers();
    }

    public boolean getGroupTargetsAndInitatiators() {
        return this.doYouWishToGroupTargetsAndInitiatorsPanel.getGroupTargetsAndInitatiators();
    }

    public boolean getZoneTLPorts() {
        return this.doYouWishToZoneTLPortsPanel.getZoneTlPorts();
    }

    public boolean moreNtServers() {
        return this.moreNtServersPanel.getMoreGroups();
    }

    public boolean moreTargetInitiatorGroups() {
        return this.moreTargetInitiatorGroupsPanel.getMoreGroups();
    }

    public boolean moreTlPorts() {
        return this.moreTlPortsPanel.getMoreGroups();
    }

    int getNtServerIndex() {
        return this.ntServerIndex;
    }

    int getTargetInitiatorGroupIndex() {
        return this.targetInitiatorGroupIndex;
    }

    int getNumberOfUnassignedTlInitiators() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.initiatorList.size()) {
            S16Port s16Port;
            FCNode fCNode = (FCNode)this.initiatorList.elementAt(n2);
            FCPort fCPort = fCNode.getPort();
            if (fCPort instanceof S16Port && (s16Port = (S16Port)fCPort).getTLMode() == 2 && this.getNtServerIndex(fCNode) < 0 && this.getTargetInitiatorGroupIndex(fCNode) < 0 && this.getTlPortGroupIndex(fCNode) < 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    int getNumberOfUnassignedInitiators() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.initiatorList.size()) {
            FCNode fCNode = (FCNode)this.initiatorList.elementAt(n2);
            if (this.getNtServerIndex(fCNode) < 0 && this.getTargetInitiatorGroupIndex(fCNode) < 0 && this.getTlPortGroupIndex(fCNode) < 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    ZoningGroup getNtServerNodeIsIn(FCNode fCNode) {
        int n = this.getNtServerIndex(fCNode);
        if (n < 0) {
            return null;
        }
        return (ZoningGroup)this.ntServers.elementAt(n);
    }

    ZoningGroup getTargetInitiatorGroupNodeIsIn(FCNode fCNode) {
        int n = this.getTargetInitiatorGroupIndex(fCNode);
        if (n < 0) {
            return null;
        }
        return (ZoningGroup)this.targetInitiatorGroups.elementAt(n);
    }

    Vector getGroupsTargetIsIn(FCNode fCNode) {
        Vector<ZoningGroup> vector = new Vector<ZoningGroup>();
        int n = 0;
        while (n < this.ntServers.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)this.ntServers.elementAt(n);
            if (zoningGroup.indexOfTarget(fCNode) >= 0) {
                vector.add(zoningGroup);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.targetInitiatorGroups.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)this.targetInitiatorGroups.elementAt(n2);
            if (zoningGroup.indexOfTarget(fCNode) >= 0) {
                vector.add(zoningGroup);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.tlPortGroups.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)this.tlPortGroups.elementAt(n3);
            if (zoningGroup.indexOfTarget(fCNode) >= 0) {
                vector.add(zoningGroup);
            }
            ++n3;
        }
        return vector;
    }

    ZoningGroup getGroupInitiatorIsIn(FCNode fCNode) {
        int n = 0;
        while (n < this.ntServers.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)this.ntServers.elementAt(n);
            if (zoningGroup.indexOfInitiator(fCNode) >= 0) {
                return zoningGroup;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.targetInitiatorGroups.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)this.targetInitiatorGroups.elementAt(n2);
            if (zoningGroup.indexOfInitiator(fCNode) >= 0) {
                return zoningGroup;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.tlPortGroups.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)this.tlPortGroups.elementAt(n3);
            if (zoningGroup.indexOfInitiator(fCNode) >= 0) {
                return zoningGroup;
            }
            ++n3;
        }
        return null;
    }

    Vector getTargetInitiatorGroupTargetIsIn(FCNode fCNode) {
        Vector<ZoningGroup> vector = new Vector<ZoningGroup>();
        int n = 0;
        while (n < this.targetInitiatorGroups.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)this.targetInitiatorGroups.elementAt(n);
            if (zoningGroup.indexOfTarget(fCNode) >= 0) {
                vector.add(zoningGroup);
            }
            ++n;
        }
        return vector;
    }

    int getNtServerIndex(FCNode fCNode) {
        int n = 0;
        while (n < this.ntServers.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)this.ntServers.elementAt(n);
            if (fCNode.getTargetInitiator() == 0 && zoningGroup.indexOfTarget(fCNode) >= 0) {
                return n;
            }
            if (fCNode.getTargetInitiator() == 1 && zoningGroup.indexOfInitiator(fCNode) >= 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int getTargetInitiatorGroupIndex(FCNode fCNode) {
        int n = 0;
        while (n < this.targetInitiatorGroups.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)this.targetInitiatorGroups.elementAt(n);
            if (fCNode.getTargetInitiator() == 0 && zoningGroup.indexOfTarget(fCNode) >= 0) {
                return n;
            }
            if (fCNode.getTargetInitiator() == 1 && zoningGroup.indexOfInitiator(fCNode) >= 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int getTlPortGroupIndex(FCNode fCNode) {
        int n = 0;
        while (n < this.tlPortGroups.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)this.tlPortGroups.elementAt(n);
            if (fCNode.getTargetInitiator() == 0 && zoningGroup.indexOfTarget(fCNode) >= 0) {
                return n;
            }
            if (fCNode.getTargetInitiator() == 1 && zoningGroup.indexOfInitiator(fCNode) >= 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int getTlPortGroupIndex() {
        return this.tlPortGroupIndex;
    }

    void clearTlPortGroups() {
        this.tlPortGroupIndex = -1;
        this.tlPortGroups.removeAllElements();
    }

    void setTlPortGroupIndex(int n) {
        if (n < 0 || n > this.tlPortGroups.size()) {
            return;
        }
        if (n == this.tlPortGroups.size()) {
            this.tlPortGroups.add(new ZoningGroup());
        }
        this.tlPortGroupIndex = n;
        this.enterNameOfTlPortGroupPanel.setCurrent(this.getCurrentTlGroup());
        this.selectInitiatorPortsInTlGroupPanel.setCurrent(this.getCurrentTlGroup());
        this.selectTargetsInTlGroupPanel.setCurrent(this.getCurrentTlGroup());
    }

    ZoningGroup getCurrentTlGroup() {
        return (ZoningGroup)this.tlPortGroups.elementAt(this.tlPortGroupIndex);
    }

    void clearNtServerGroups() {
        this.ntServerIndex = -1;
        this.ntServers.removeAllElements();
    }

    void setNtServerIndex(int n) {
        if (n < 0 || n > this.ntServers.size()) {
            return;
        }
        if (n == this.ntServers.size()) {
            ZoningGroup zoningGroup = new ZoningGroup();
            zoningGroup.setNtServer(true);
            this.ntServers.add(zoningGroup);
        }
        this.ntServerIndex = n;
        this.enterNameOfNtServerPanel.setCurrent(this.getCurrentNtServer());
        this.selectInitiatorPortsInNtServerGroupPanel.setCurrent(this.getCurrentNtServer());
        this.selectTargetPortsInNtServerGroupPanel.setCurrent(this.getCurrentNtServer());
    }

    void clearTargetInitiatorGroups() {
        this.targetInitiatorGroupIndex = -1;
        this.targetInitiatorGroups.removeAllElements();
    }

    void setTargetInitiatorGroupIndex(int n) {
        if (n < 0 || n > this.targetInitiatorGroups.size()) {
            return;
        }
        if (n == this.targetInitiatorGroups.size()) {
            this.targetInitiatorGroups.add(new ZoningGroup());
        }
        this.targetInitiatorGroupIndex = n;
        this.enterNameOfTargetInitiatorGroupPanel.setCurrent(this.getCurrentTargetInitiatorGroup());
        this.selectInitiatorsInTargetInitiatorGroupPanel.setCurrent(this.getCurrentTargetInitiatorGroup());
        this.selectTargetsInTargetInitiatorGroupPanel.setCurrent(this.getCurrentTargetInitiatorGroup());
    }

    ZoningGroup getCurrentNtServer() {
        return (ZoningGroup)this.ntServers.elementAt(this.ntServerIndex);
    }

    ZoningGroup getCurrentTargetInitiatorGroup() {
        return (ZoningGroup)this.targetInitiatorGroups.elementAt(this.targetInitiatorGroupIndex);
    }

    public void createTargetAndInitiatorLists() {
        this.initiatorList.removeAllElements();
        this.targetList.removeAllElements();
        Chassis chassis = this.fabric.getFirstSwitch();
        while (chassis != null) {
            FCNode fCNode = chassis.getFirstNode();
            while (fCNode != null) {
                fCNode.setSharable(false);
                if (fCNode.getTargetInitiator() == 0) {
                    this.targetList.add(fCNode);
                }
                if (fCNode.getTargetInitiator() == 1) {
                    this.initiatorList.add(fCNode);
                }
                fCNode = chassis.getNextNode(fCNode);
            }
            chassis = this.fabric.getNextSwitch(chassis);
        }
        this.pickSharableTargetsPanel.setData(this.targetList);
    }

    int getNumberOfTargets() {
        if (this.targetList != null) {
            return this.targetList.size();
        }
        return 0;
    }

    int getNumberOfInitiators() {
        if (this.initiatorList != null) {
            return this.initiatorList.size();
        }
        return 0;
    }

    Vector createSummary() {
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.ntServers.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)this.ntServers.elementAt(n);
            object2 = "NT Server " + zoningGroup.getName();
            vector.add(object2);
            zoningGroup.addToSummary(vector);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.targetInitiatorGroups.size()) {
            object2 = (ZoningGroup)this.targetInitiatorGroups.elementAt(n2);
            object = "Target/Initiator group " + ((ZoningGroup)object2).getName();
            vector.add(object);
            ((ZoningGroup)object2).addToSummary(vector);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.tlPortGroups.size()) {
            object = (ZoningGroup)this.tlPortGroups.elementAt(n3);
            String string = "TL port group " + ((ZoningGroup)object).getName();
            vector.add(string);
            ((ZoningGroup)object).addToSummary(vector);
            ++n3;
        }
        return vector;
    }

    public Properties createWizardProperties() {
        return null;
    }

    public void resetWizard() {
    }

    public String[] createWizardStepsList() {
        String[] stringArray = new String[5];
        int n = 0;
        while (n < 5) {
            stringArray[n] = FabricTreeControl.getResource("ZoningWizard.step" + n);
            ++n;
        }
        return stringArray;
    }

    public Zones getZones() {
        return this.zones;
    }

    void shutDown() {
        this.setVisible(false);
    }

    boolean doesZoneSetExist(String string) {
        return this.zones.findZoneSet(string) != null;
    }

    boolean doesZoneExist(String string) {
        return this.zones.findZone(string) != null;
    }

    boolean generateZoning() {
        String string = this.generationPanel.getConfigName();
        ZoneSet zoneSet = this.zones.createZoneSet(string);
        if (zoneSet == null) {
            return false;
        }
        if (!this.createZones(this.zones, zoneSet, this.ntServers)) {
            return false;
        }
        if (!this.createZones(this.zones, zoneSet, this.targetInitiatorGroups)) {
            return false;
        }
        if (!this.createZones(this.zones, zoneSet, this.tlPortGroups)) {
            return false;
        }
        this.finishedOk = true;
        return true;
    }

    boolean createZones(Zones zones, ZoneSet zoneSet, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            ZoningGroup zoningGroup = (ZoningGroup)vector.elementAt(n);
            Zone zone = zones.createZone(zoningGroup.getName());
            if (zone == null) {
                return false;
            }
            if (!this.populateZone(zones, zone, zoningGroup)) {
                return false;
            }
            zone.setZoneType(0);
            if (zones.addZoneToSet(zone, zoneSet) != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean populateZone(Zones zones, Zone zone, ZoningGroup zoningGroup) {
        ZoneMember zoneMember;
        Vector<ZoneMember> vector = new Vector<ZoneMember>();
        int n = 0;
        while (n < zoningGroup.getNumberOfInitiators()) {
            FCNode fCNode = zoningGroup.getInitiator(n);
            zoneMember = zones.createZoneMember(fCNode.getWwnZoningStr());
            if (zoneMember == null) {
                return false;
            }
            vector.add(zoneMember);
            ++n;
        }
        int n2 = 0;
        while (n2 < zoningGroup.getNumberOfTargets()) {
            zoneMember = zoningGroup.getTarget(n2);
            ZoneMember zoneMember2 = zones.createZoneMember(zoneMember.getWwnZoningStr());
            if (zoneMember2 == null) {
                return false;
            }
            vector.add(zoneMember2);
            ++n2;
        }
        return zones.addZoneMembersToZone(zone, vector) == 0;
    }
}

