/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.wizards.zoning;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCNode;
import java.util.Vector;

public class ZoningGroup {
    String name = new String();
    Vector targets = new Vector();
    Vector initiators = new Vector();
    boolean ntServer = false;

    void addToSummary(Vector vector) {
        Object object;
        int n = 0;
        while (n < this.initiators.size()) {
            FCNode fCNode = (FCNode)this.initiators.elementAt(n);
            object = "     Initiator " + ZoningGroup.getDescStr(fCNode);
            vector.add(object);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.targets.size()) {
            object = (FCNode)this.targets.elementAt(n2);
            String string = "     Target " + ZoningGroup.getDescStr(object);
            vector.add(string);
            ++n2;
        }
    }

    public static String getDescStr(FCNode fCNode) {
        Chassis chassis = fCNode.getChassis();
        return fCNode.getPortWWName().delimit() + "(" + fCNode.delimitFCAddress() + ") on " + chassis.toString();
    }

    public boolean isNtServerGroup() {
        return this.ntServer;
    }

    public void setNtServer(boolean bl) {
        this.ntServer = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void addTarget(FCNode fCNode) {
        this.targets.add(fCNode);
    }

    public void removeTarget(FCNode fCNode) {
        this.targets.remove(fCNode);
    }

    public void removeAllTargets() {
        this.targets.removeAllElements();
    }

    public FCNode getTarget(int n) {
        return (FCNode)this.targets.elementAt(n);
    }

    public int getNumberOfTargets() {
        return this.targets.size();
    }

    public int indexOfTarget(FCNode fCNode) {
        return this.targets.indexOf(fCNode);
    }

    public void addInitiator(FCNode fCNode) {
        this.initiators.add(fCNode);
    }

    public void removeInitiator(FCNode fCNode) {
        this.initiators.remove(fCNode);
    }

    public void removeAllInitiators() {
        this.initiators.removeAllElements();
    }

    public FCNode getInitiator(int n) {
        return (FCNode)this.initiators.elementAt(n);
    }

    public int getNumberOfInitiators() {
        return this.initiators.size();
    }

    public int indexOfInitiator(FCNode fCNode) {
        return this.initiators.indexOf(fCNode);
    }
}

