/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.wizards.zoning;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.wizards.ButtonPanel;
import com.qlogic.qms.fabric.wizards.ButtonPanelFactory;
import com.qlogic.qms.fabric.wizards.zoning.ZoningGroup;
import com.qlogic.qms.fabric.wizards.zoning.ZoningPanel;
import com.qlogic.qms.fabric.wizards.zoning.ZoningWizard;
import com.qlogic.ui.tools.SmartScrollingTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class SelectTargetPortsInGroupPanel
extends JPanel
implements ZoningPanel {
    JLabel label;
    PickTableModel tableModel;
    boolean[] enables;
    JTable targetTable;
    Vector targetList;
    ZoningGroup current;
    ButtonPanel buttonPanel;
    ZoningWizard wiz;

    public SelectTargetPortsInGroupPanel(ZoningWizard zoningWizard, Vector vector) {
        this.wiz = zoningWizard;
        this.targetList = vector;
        try {
            this.jbInit();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void jbInit() {
        this.buttonPanel = ButtonPanelFactory.createDefaultButtonPanel();
        this.setLayout(new GridBagLayout());
        this.label = new JLabel();
        this.tableModel = new PickTableModel();
        this.tableModel.setData(this.getData());
        this.targetTable = new SmartScrollingTable((TableModel)this.tableModel);
        this.targetTable.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.targetTable.getTableHeader().setReorderingAllowed(false);
        this.targetTable.setAutoResizeMode(3);
        TableColumn tableColumn = this.targetTable.getColumn(FabricTreeControl.getResource("SelectTargetPortsInGroupPanel.col1"));
        tableColumn.setPreferredWidth(150);
        JScrollPane jScrollPane = new JScrollPane(this.targetTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    private Object[][] getData() {
        Object[][] objectArray = new Object[this.targetList.size()][6];
        this.enables = new boolean[this.targetList.size()];
        int n = 0;
        while (n < this.targetList.size()) {
            FCNode fCNode = (FCNode)this.targetList.elementAt(n);
            objectArray[n][0] = new Boolean(this.current.indexOfTarget(fCNode) > 0);
            objectArray[n][1] = fCNode.getPortWWName().delimit();
            objectArray[n][2] = fCNode.delimitFCAddress();
            Chassis chassis = fCNode.getChassis();
            objectArray[n][3] = chassis.toString();
            String string = new String();
            Vector vector = this.wiz.getGroupsTargetIsIn(fCNode);
            this.enables[n] = true;
            if (vector.size() > 0) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    ZoningGroup zoningGroup = (ZoningGroup)vector.elementAt(n2);
                    string = string + zoningGroup.getName();
                    if (n2 < vector.size() - 1) {
                        string = string + ",";
                    }
                    if (zoningGroup != this.current && zoningGroup.isNtServerGroup() && !fCNode.isSharable()) {
                        this.enables[n] = false;
                    }
                    ++n2;
                }
            }
            objectArray[n][4] = string;
            objectArray[n][5] = fCNode.isSharable() ? FabricTreeControl.getResource("SelectTargetPortsInGroupPanel.sharable") : FabricTreeControl.getResource("SelectTargetPortsInGroupPanel.notSharable");
            ++n;
        }
        return objectArray;
    }

    protected abstract void setLabel();

    public boolean saveData() {
        boolean bl = false;
        this.current.removeAllTargets();
        int n = 0;
        while (n < this.targetList.size()) {
            Boolean bl2 = (Boolean)this.tableModel.getValueAt(n, 0);
            FCNode fCNode = (FCNode)this.targetList.elementAt(n);
            if (bl2.booleanValue()) {
                bl = true;
                this.current.addTarget(fCNode);
            }
            ++n;
        }
        return bl;
    }

    public void fillDataControls() {
        this.setLabel();
        this.tableModel.setData(this.getData());
    }

    public void setCurrent(ZoningGroup zoningGroup) {
        this.current = zoningGroup;
    }

    class PickTableModel
    extends AbstractTableModel {
        Object[][] data;
        final String[] columnNames = new String[]{FabricTreeControl.getResource("SelectTargetPortsInGroupPanel.col0"), FabricTreeControl.getResource("SelectTargetPortsInGroupPanel.col1"), FabricTreeControl.getResource("SelectTargetPortsInGroupPanel.col2"), FabricTreeControl.getResource("SelectTargetPortsInGroupPanel.col3"), FabricTreeControl.getResource("SelectTargetPortsInGroupPanel.col4"), FabricTreeControl.getResource("SelectTargetPortsInGroupPanel.col5")};

        PickTableModel() {
        }

        public void setData(Object[][] objectArray) {
            this.data = objectArray;
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0 && SelectTargetPortsInGroupPanel.this.enables[n];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }
}

