/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.UserAccount;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.QDialog;
import com.qlogic.util.Md5Crypt;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UserAccountDialogSanbox2
extends QDialog
implements ChassisEventListener {
    public static final int MAX_LOGIN_LENGTH = 15;
    public static final String NO_SELECTION = "no selection";
    protected Sanbox2 blade = null;
    protected ChassisEventAdapter eventAdapter = null;
    protected JFrame frame = null;
    protected JPanel listPanel = null;
    protected JTabbedPane tabPane = null;
    protected JPanel buttonPanel = null;
    protected JPanel addAccountPanel = null;
    protected JPanel removeAccountPanel = null;
    protected JPanel changePasswordPanel = null;
    protected JList accountList = new JList();
    protected JScrollPane accountListScrollPane = null;
    protected int selectedAccountListIndex = 0;
    protected AccountListSelectionListener accountListSelectionListener;
    protected String selectedAccountLogin = "";
    protected boolean waitingOnAddAccount = false;
    protected boolean waitingOnRemoveAccount = false;
    protected boolean waitingOnChangePassword = false;
    protected boolean waitingOnExpirationChange = false;
    protected boolean waitingOnRequestAdmin = false;
    protected boolean waitingOnReleaseAdmin = false;
    String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    JButton cancelButton = new JButton(FabricTreeControl.getResource("UserAccountDialog.cancel"));
    JButton addButton = new JButton(FabricTreeControl.getResource("UserAccountDialog.addAccount"));
    JButton removeButton = new JButton(FabricTreeControl.getResource("UserAccountDialog.removeAccount"));
    JButton changePasswordButton = new JButton(FabricTreeControl.getResource("UserAccountDialog.changePassword"));
    JLabel newAccountLoginLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.newAccountLogin"));
    JCheckBox newAccountAdminCheckBox = new JCheckBox(FabricTreeControl.getResource("UserAccountDialog.adminAuthorityEnabled"));
    JLabel newAccountPasswordLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.newPassword"));
    JLabel newAccountVerifyPasswordLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.verifyPassword"));
    JRadioButton noExpirationButton = new JRadioButton(FabricTreeControl.getResource("UserAccountDialog.noExpireChoice"));
    JRadioButton expirationButton = new JRadioButton(FabricTreeControl.getResource("UserAccountDialog.expireChoice1"));
    JLabel daysLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.expireChoice2"));
    JTextField daysText = new JTextField();
    ButtonGroup expireChoiceButtonGroup = new ButtonGroup();
    JTextField newAccountLoginText = new JTextField();
    JPasswordField newAccountPasswordText = new JPasswordField();
    JPasswordField newAccountVerifyPasswordText = new JPasswordField();
    JLabel selectRemoveLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.selectRemove"));
    JLabel selectedAccountLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.selectedAccount"));
    JLabel selectedAccountContentLabel = new JLabel();
    JLabel selectChangePasswordLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.selectChangePassword"));
    JLabel accountLoginLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.accountLogin"));
    JLabel oldPasswordLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.oldPassword"));
    JLabel newPasswordLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.newPassword"));
    JLabel verifyPasswordLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.verifyPassword"));
    JLabel accountLoginContentLabel = new JLabel();
    JPasswordField oldPasswordText = new JPasswordField();
    JPasswordField newPasswordText = new JPasswordField();
    JPasswordField verifyPasswordText = new JPasswordField();
    int month;
    int day;
    int year;

    public UserAccountDialogSanbox2(JFrame jFrame, boolean bl, Sanbox2 sanbox2) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("UserAccountDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.blade = sanbox2;
        this.frame = jFrame;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        this.initAccountList();
        this.listPanel = this.createListPanel();
        this.accountListScrollPane.setViewportView(this.accountList);
        this.listPanel.setPreferredSize(new Dimension(400, 100));
        this.tabPane = new JTabbedPane();
        this.addAccountPanel = this.createAddAccountPanel();
        this.removeAccountPanel = this.createRemoveAccountPanel();
        this.changePasswordPanel = this.createChangePasswordPanel();
        this.buttonPanel = this.createButtonPanel();
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.userAccountDialogSanbox2Help"));
        this.tabPane.add(FabricTreeControl.getResource("UserAccountDialog.addAccount"), this.addAccountPanel);
        this.tabPane.add(FabricTreeControl.getResource("UserAccountDialog.removeAccount"), this.removeAccountPanel);
        this.tabPane.add(FabricTreeControl.getResource("UserAccountDialog.changePassword"), this.changePasswordPanel);
        this.tabPane.setPreferredSize(new Dimension(400, 300));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.listPanel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        this.getContentPane().add((Component)this.tabPane, gridBagConstraints);
        this.tabPane.setTabPlacement(3);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void resetDialog(Sanbox2 sanbox2) {
        this.blade.removeChassisEventListener((ChassisEventListener)this);
        this.enableButtons();
        this.waitingOnRequestAdmin = false;
        this.waitingOnReleaseAdmin = false;
        this.blade = sanbox2;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        this.newAccountLoginText.setText("");
        this.newAccountPasswordText.setText("");
        this.newAccountVerifyPasswordText.setText("");
        this.newAccountAdminCheckBox.setSelected(false);
        this.expirationButton.setSelected(false);
        this.noExpirationButton.setSelected(true);
        this.daysText.setText("365");
        this.oldPasswordText.setText("");
        this.newPasswordText.setText("");
        this.verifyPasswordText.setText("");
        this.initAccountList();
        if (this.accountList.getSelectedIndex() == -1) {
            this.accountLoginContentLabel.setText(NO_SELECTION);
            this.selectedAccountContentLabel.setText(NO_SELECTION);
        } else {
            this.selectedAccountListIndex = this.accountList.getSelectedIndex();
            ListModel listModel = this.accountList.getModel();
            String string = ((String)listModel.getElementAt(this.selectedAccountListIndex)).substring(0, 15).trim();
            this.selectedAccountContentLabel.setText(string);
            this.accountLoginContentLabel.setText(string);
        }
    }

    public JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 4, 8, 0));
        this.cancelButton.addActionListener(new CancelButtonListener(this));
        this.cancelButton.setMnemonic('C');
        jPanel.add(this.cancelButton);
        jPanel.add(this.helpContextButton);
        return jPanel;
    }

    public JPanel createListPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.accountListScrollPane = new JScrollPane();
        this.accountListScrollPane.setPreferredSize(new Dimension(400, 100));
        JLabel jLabel = new JLabel(FabricTreeControl.getResource("UserAccountDialog.listLabel"));
        Font font = this.getFont();
        jLabel.setFont(new Font("Monospaced", 1, 12));
        jLabel.setForeground(Color.white);
        jPanel.setBackground(Color.gray);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.accountListScrollPane, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    public JPanel createAddAccountPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 2);
        jPanel.add((Component)this.newAccountLoginLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 40);
        jPanel.add((Component)this.newAccountLoginText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        jPanel.add((Component)this.newAccountAdminCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 2);
        jPanel.add((Component)this.newAccountPasswordLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 40);
        jPanel.add((Component)this.newAccountPasswordText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 2);
        jPanel.add((Component)this.newAccountVerifyPasswordLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 40);
        jPanel.add((Component)this.newAccountVerifyPasswordText, gridBagConstraints);
        this.expireChoiceButtonGroup.add(this.noExpirationButton);
        this.expireChoiceButtonGroup.add(this.expirationButton);
        this.noExpirationButton.setSelected(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.noExpirationButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this.expirationButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.daysText.setColumns(3);
        this.daysText.setText("365");
        jPanel2.add((Component)this.daysText, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.daysLabel, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("UserAccountDialog.expireDateLabel")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 2);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.addButton.addActionListener(new AddButtonListener(this));
        this.addButton.setMnemonic('A');
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 100, 5, 100);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("UserAccountDialog.addAccount")));
        return jPanel;
    }

    public JPanel createRemoveAccountPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 30, 15, 30);
        jPanel.add((Component)this.selectRemoveLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 10, 20, 5);
        jPanel.add((Component)this.selectedAccountLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 5, 20, 10);
        this.selectedAccountContentLabel.setText(NO_SELECTION);
        jPanel.add((Component)this.selectedAccountContentLabel, gridBagConstraints);
        this.selectedAccountContentLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.removeButton.addActionListener(new RemoveButtonListener(this));
        this.removeButton.setMnemonic('R');
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 60, 95, 60);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("UserAccountDialog.removeAccount")));
        return jPanel;
    }

    public JPanel createChangePasswordPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 50, 20, 50);
        jPanel.add((Component)this.selectChangePasswordLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        jPanel.add((Component)this.accountLoginLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 40);
        this.accountLoginContentLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.accountLoginContentLabel.setText(NO_SELECTION);
        jPanel.add((Component)this.accountLoginContentLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 2);
        jPanel.add((Component)this.oldPasswordLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 40);
        jPanel.add((Component)this.oldPasswordText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 2);
        jPanel.add((Component)this.newPasswordLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 2, 5, 40);
        jPanel.add((Component)this.newPasswordText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 2);
        jPanel.add((Component)this.verifyPasswordLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 2, 5, 40);
        jPanel.add((Component)this.verifyPasswordText, gridBagConstraints);
        this.changePasswordButton.addActionListener(new ChangePasswordButtonListener(this));
        this.changePasswordButton.setMnemonic('P');
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.changePasswordButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(20, 80, 20, 80);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("UserAccountDialog.changePassword")));
        return jPanel;
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(367));
        return vector;
    }

    protected void initAccountList() {
        if (this.accountList != null && this.accountListSelectionListener != null) {
            this.accountList.removeListSelectionListener(this.accountListSelectionListener);
        }
        Vector vector = this.blade.getUserAccountList();
        int n = -1;
        Vector<String> vector2 = new Vector<String>();
        if (vector != null) {
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                UserAccount userAccount = (UserAccount)vector.elementAt(n3);
                String string = this.formatLogin(userAccount.getLogin());
                if (this.selectedAccountLogin.equals(userAccount.getLogin())) {
                    n = n3;
                }
                String string2 = this.formatAdminAuthority(userAccount.getAdminAuthority());
                String string3 = this.formatExpirationDate(userAccount.getExpiration());
                String string4 = string + "   " + string2 + "   " + string3;
                vector2.add(string4);
                ++n3;
            }
        }
        Font font = this.getFont();
        this.accountList = new JList();
        this.accountList.setSelectionMode(0);
        this.accountList.setFont(new Font("Monospaced", 1, 12));
        this.accountListSelectionListener = new AccountListSelectionListener(this);
        this.accountList.addListSelectionListener(this.accountListSelectionListener);
        this.accountList.setListData(vector2);
        if (n > -1) {
            this.selectedAccountListIndex = n;
            this.accountList.setSelectedIndex(n);
        } else {
            this.selectedAccountContentLabel.setText(NO_SELECTION);
            this.accountLoginContentLabel.setText(NO_SELECTION);
        }
        if (this.accountListScrollPane != null) {
            this.accountListScrollPane.setViewportView(this.accountList);
        }
    }

    protected String formatLogin(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("               ");
        return stringBuffer.substring(0, 15);
    }

    protected String formatAdminAuthority(boolean bl) {
        if (bl) {
            return "true           ";
        }
        return "false          ";
    }

    protected String formatExpirationDate(int n) {
        if (n == 0) {
            return "never expires";
        }
        return Integer.toString(n) + " days";
    }

    protected int addAccount() {
        String string = this.newAccountLoginText.getText().trim();
        boolean bl = this.newAccountAdminCheckBox.isSelected();
        char[] cArray = this.newAccountPasswordText.getPassword();
        String string2 = new String(cArray);
        cArray = this.newAccountVerifyPasswordText.getPassword();
        String string3 = new String(cArray);
        int n = 0;
        if (this.expirationButton.isSelected()) {
            boolean bl2;
            try {
                n = Integer.parseInt(this.daysText.getText().trim());
            }
            catch (Exception exception) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserAccountDialog.invalidExpiration"));
                return -1;
            }
            if (n == 0 && !(bl2 = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("UserAccountDialog.zeroExpiration")))) {
                return -1;
            }
            if (n < 0 || n > 2000) {
                PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserAccountDialog.invalidExpiration"));
                return -1;
            }
        }
        if (!string2.equals(string3)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserAccountDialog.passwordMismatch"));
            return -1;
        }
        if (!this.isNewLoginUnique(string)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserAccountDialog.duplicateLogin"));
            return -1;
        }
        if (string.length() < 1 || string.length() > 15) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserAccountDialog.invalidLogin"));
            return -1;
        }
        if (string2.length() < 4 || string2.length() > 20) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserAccountDialog.invalidPassword"));
            return -1;
        }
        byte[] byArray = Md5Crypt.crypt(string2);
        String string4 = new String(byArray);
        this.waitingOnRequestAdmin = true;
        this.waitingOnExpirationChange = true;
        this.waitingOnAddAccount = true;
        this.waitingOnReleaseAdmin = true;
        this.blade.requestAdmin();
        this.blade.applyUserAccountExpiration(n);
        this.blade.applyAddUserAccount(string, bl, string4);
        this.blade.releaseAdmin();
        return 1;
    }

    protected int removeAccount() {
        int n = this.accountList.getSelectedIndex();
        if (n == -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserAccountDialog.mustSelectRemoveAccount"));
            return -1;
        }
        String string = this.selectedAccountContentLabel.getText().trim();
        if (string.equals("images") || string.equals("admin")) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserAccountDialog.specialAccounts"));
            return -1;
        }
        boolean bl = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("UserAccountDialog.confirmRemove"));
        if (!bl) {
            return -1;
        }
        this.waitingOnRequestAdmin = true;
        this.waitingOnRemoveAccount = true;
        this.waitingOnReleaseAdmin = true;
        this.blade.requestAdmin();
        this.blade.applyRemoveUserAccount(string);
        this.blade.releaseAdmin();
        return 1;
    }

    protected int changePassword() {
        int n = this.accountList.getSelectedIndex();
        if (n == -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserAccountDialog.mustSelectRemoveAccount"));
            return -1;
        }
        String string = this.accountLoginContentLabel.getText().trim();
        char[] cArray = this.oldPasswordText.getPassword();
        String string2 = new String(cArray);
        cArray = this.newPasswordText.getPassword();
        String string3 = new String(cArray);
        String string4 = new String(cArray = this.verifyPasswordText.getPassword());
        if (!string3.equals(string4)) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserAccountDialog.passwordMismatch"));
            return -1;
        }
        if (string3.length() < 4 || string3.length() > 20) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("UserAccountDialog.invalidPassword"));
            return -1;
        }
        byte[] byArray = Md5Crypt.crypt(string2);
        String string5 = new String(byArray);
        byArray = Md5Crypt.crypt(string3);
        String string6 = new String(byArray);
        this.waitingOnRequestAdmin = true;
        this.waitingOnChangePassword = true;
        this.waitingOnReleaseAdmin = true;
        this.blade.requestAdmin();
        this.blade.applyChangePassword(string, string5, string6);
        this.blade.releaseAdmin();
        return 1;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.blade.removeChassisEventListener((ChassisEventListener)this);
            this.setVisible(false);
        }
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected boolean isNewLoginUnique(String string) {
        Vector vector = this.blade.getUserAccountList();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            UserAccount userAccount = (UserAccount)vector.elementAt(n2);
            if (userAccount.getLogin().equals(string)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void disableButtons() {
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.changePasswordButton.setEnabled(false);
    }

    public void enableButtons() {
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        this.changePasswordButton.setEnabled(true);
    }

    public void clearAddAccountPanel() {
        this.newAccountAdminCheckBox.setSelected(false);
        this.expirationButton.setSelected(false);
        this.noExpirationButton.setSelected(true);
        this.daysText.setText("365");
        this.newAccountLoginText.setText("");
        this.newAccountPasswordText.setText("");
        this.newAccountVerifyPasswordText.setText("");
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        UserAccountDialogSanbox2 dialog = null;

        public ApplyResponseHandler(UserAccountDialogSanbox2 userAccountDialogSanbox22, ChassisEvent chassisEvent) {
            this.dialog = userAccountDialogSanbox22;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 238: {
                    UserAccountDialogSanbox2.this.waitingOnRequestAdmin = false;
                    if (this.evt.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("UserAccountDialog.adminReqFailed") + "\n" + UserAccountDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    break;
                }
                case 239: {
                    UserAccountDialogSanbox2.this.waitingOnReleaseAdmin = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("UserAccountDialog.adminRelFailed") + "\n" + UserAccountDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    }
                    UserAccountDialogSanbox2.this.enableButtons();
                    break;
                }
                case 366: {
                    UserAccountDialogSanbox2.this.waitingOnExpirationChange = false;
                    if (this.evt.isSuccessful()) break;
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("UserAccountDialog.expirationFailed") + "\n" + UserAccountDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    break;
                }
                case 368: {
                    UserAccountDialogSanbox2.this.waitingOnAddAccount = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("UserAccountDialog.addAccountFailed") + "\n" + UserAccountDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        break;
                    }
                    UserAccountDialogSanbox2.this.clearAddAccountPanel();
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(UserAccountDialogSanbox2.this.frame, (SanboxChassis)UserAccountDialogSanbox2.this.blade, UserAccountDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("PortPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 369: {
                    UserAccountDialogSanbox2.this.waitingOnRemoveAccount = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("UserAccountDialog.removeAccountFailed") + "\n" + UserAccountDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        break;
                    }
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(UserAccountDialogSanbox2.this.frame, (SanboxChassis)UserAccountDialogSanbox2.this.blade, UserAccountDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("PortPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 370: {
                    UserAccountDialogSanbox2.this.waitingOnChangePassword = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("UserAccountDialog.changePasswordFailed") + "\n" + UserAccountDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        break;
                    }
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(UserAccountDialogSanbox2.this.frame, (SanboxChassis)UserAccountDialogSanbox2.this.blade, UserAccountDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("PortPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 367: {
                    if (!this.evt.isSuccessful()) break;
                    UserAccountDialogSanbox2.this.initAccountList();
                }
            }
        }
    }

    class ChangePasswordButtonListener
    implements ActionListener {
        UserAccountDialogSanbox2 theDialog = null;

        public ChangePasswordButtonListener(UserAccountDialogSanbox2 userAccountDialogSanbox22) {
            this.theDialog = userAccountDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.changePassword() == 1) {
                if (UserAccountDialogSanbox2.this.waitingOnChangePassword) {
                    UserAccountDialogSanbox2.this.disableButtons();
                } else {
                    UserAccountDialogSanbox2.this.enableButtons();
                }
            }
        }
    }

    class RemoveButtonListener
    implements ActionListener {
        UserAccountDialogSanbox2 theDialog = null;

        public RemoveButtonListener(UserAccountDialogSanbox2 userAccountDialogSanbox22) {
            this.theDialog = userAccountDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.removeAccount() == 1) {
                if (UserAccountDialogSanbox2.this.waitingOnRemoveAccount) {
                    UserAccountDialogSanbox2.this.disableButtons();
                } else {
                    UserAccountDialogSanbox2.this.enableButtons();
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        UserAccountDialogSanbox2 theDialog = null;

        public CancelButtonListener(UserAccountDialogSanbox2 userAccountDialogSanbox22) {
            this.theDialog = userAccountDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UserAccountDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.theDialog);
            UserAccountDialogSanbox2.this.enableButtons();
            this.theDialog.setVisible(false);
        }
    }

    class AddButtonListener
    implements ActionListener {
        UserAccountDialogSanbox2 theDialog = null;

        public AddButtonListener(UserAccountDialogSanbox2 userAccountDialogSanbox22) {
            this.theDialog = userAccountDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.addAccount() == 1) {
                if (UserAccountDialogSanbox2.this.waitingOnAddAccount) {
                    UserAccountDialogSanbox2.this.disableButtons();
                } else {
                    UserAccountDialogSanbox2.this.enableButtons();
                }
            }
        }
    }

    class AccountListSelectionListener
    implements ListSelectionListener {
        UserAccountDialogSanbox2 theDialog = null;
        ListModel listModel;
        String login;

        public AccountListSelectionListener(UserAccountDialogSanbox2 userAccountDialogSanbox22) {
            this.theDialog = userAccountDialogSanbox22;
            this.listModel = UserAccountDialogSanbox2.this.accountList.getModel();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            UserAccountDialogSanbox2.this.selectedAccountListIndex = UserAccountDialogSanbox2.this.accountList.getSelectedIndex();
            this.listModel = UserAccountDialogSanbox2.this.accountList.getModel();
            UserAccountDialogSanbox2.this.selectedAccountLogin = this.login = ((String)this.listModel.getElementAt(UserAccountDialogSanbox2.this.selectedAccountListIndex)).substring(0, 15).trim();
            UserAccountDialogSanbox2.this.selectedAccountContentLabel.setText(this.login);
            UserAccountDialogSanbox2.this.accountLoginContentLabel.setText(this.login);
        }
    }
}

