/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.Sanbox8000Blade;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class TestBladeDialog
extends QDialog
implements ChassisEventListener {
    private JPanel panel = new JPanel();
    private JTextArea messageLabel;
    private JButton startButton;
    private JButton cancelButton;
    private JButton closeButton;
    private Sanbox8000 sanbox8000;
    private Sanbox2 sb2;
    private Vector blades;
    private int[] bladeStates;

    public TestBladeDialog(Frame frame, Sanbox8000 sanbox8000, Vector vector) {
        super(frame, true);
        this.sanbox8000 = sanbox8000;
        this.sb2 = (Sanbox2)this.sanbox8000;
        this.blades = vector;
        this.bladeStates = new int[this.blades.size()];
        int n = 0;
        while (n < this.blades.size()) {
            Sanbox8000Blade sanbox8000Blade = (Sanbox8000Blade)this.blades.elementAt(n);
            this.bladeStates[n] = sanbox8000Blade.getBladeOperState();
            sanbox8000Blade.setBladeTestStatus(1);
            ++n;
        }
        this.sb2.addChassisEventListener((ChassisEventListener)this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(FabricTreeControl.getResource("TestBladeDialog.titleBarText") + " - " + VendorProperties.getFrameTitle());
        this.getContentPane().setLayout(new GridBagLayout());
        this.messageLabel = new JTextArea();
        this.fillTextArea();
        this.startButton = new JButton(new StartAction());
        this.closeButton = new JButton(new CloseAction());
        this.cancelButton = new JButton(new CancelAction());
        this.getContentPane().add((Component)new JScrollPane(this.messageLabel), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 4, 8, 0));
        this.startButton.setMnemonic('S');
        jPanel.add(this.startButton);
        this.cancelButton.setMnemonic('C');
        jPanel.add(this.cancelButton);
        this.closeButton.setMnemonic('C');
        jPanel.add(this.closeButton);
        jPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.testBladeDialogHelp"));
        this.setButtonsEnabled(true);
        this.getContentPane().add((Component)jPanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        Dimension dimension = this.getRootPane().getPreferredSize();
        this.getRootPane().setPreferredSize(new Dimension((int)(1.5 * dimension.getWidth()), (int)dimension.getHeight()));
        this.getRootPane().setDefaultButton(this.startButton);
        this.pack();
        this.validate();
        this.setResizable(false);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension2.width - this.getWidth()) / 2, (dimension2.height - this.getHeight()) / 2);
    }

    private void fillTextArea() {
        boolean bl = true;
        String string = new String();
        int n = 0;
        while (n < this.blades.size()) {
            Sanbox8000Blade sanbox8000Blade = (Sanbox8000Blade)this.blades.elementAt(n);
            if (sanbox8000Blade.getBladeTestStatus() == 2) {
                bl = false;
            }
            string = string + FabricTreeControl.getResource("TestBladeDialog.blade") + " " + sanbox8000Blade.toString() + " " + this.translateTestStatus(sanbox8000Blade.getBladeTestStatus()) + "\n";
            ++n;
        }
        this.setButtonsEnabled(bl);
        this.messageLabel.setText(string);
    }

    private String translateTestStatus(int n) {
        switch (n) {
            case 4: {
                return FabricTreeControl.getResource("TestBladeDialog.testStatusFailed");
            }
            case 3: {
                return FabricTreeControl.getResource("TestBladeDialog.testStatusPassed");
            }
            case 1: {
                return FabricTreeControl.getResource("TestBladeDialog.testStatusReady");
            }
            case 2: {
                return FabricTreeControl.getResource("TestBladeDialog.testStatusTesting");
            }
        }
        return FabricTreeControl.getResource("TestBladeDialog.testStatusUnknown");
    }

    private void closeDownDialog() {
        if (!this.sanbox8000.applyBladeOperAdminStates(this.blades, this.bladeStates)) {
            this.setVisible(false);
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        switch (chassisEvent.getEventType()) {
            case 339: {
                if (!chassisEvent.isSuccessful()) {
                    SwingUtilities.invokeLater(new DisplayMessage(FabricTreeControl.getResource("TestBladeDialog.failedToStartTest") + FabricTreeControl.translateErrorType(chassisEvent.getErrorType())));
                    this.setButtonsEnabled(true);
                    break;
                }
                SwingUtilities.invokeLater(new FillTextArea());
                break;
            }
            case 340: {
                this.sb2.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
                SwingUtilities.invokeLater(new CloseDialog());
                break;
            }
            case 341: {
                SwingUtilities.invokeLater(new FillTextArea());
            }
        }
    }

    public void addMessage(String string) {
        if (string != null) {
            this.messageLabel.setText(this.messageLabel.getText() + string);
        } else {
            this.messageLabel.setText("");
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.closeDownDialog();
        }
    }

    private void setButtonsEnabled(boolean bl) {
        SwingUtilities.invokeLater(new SetButtonsEnabled(bl));
    }

    private class SetButtonsEnabled
    implements Runnable {
        private boolean enabled;

        public SetButtonsEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void run() {
            TestBladeDialog.this.cancelButton.setEnabled(!this.enabled);
            TestBladeDialog.this.startButton.setEnabled(this.enabled);
            TestBladeDialog.this.closeButton.setEnabled(this.enabled);
        }
    }

    public class FillTextArea
    implements Runnable {
        public void run() {
            TestBladeDialog.this.fillTextArea();
        }
    }

    public class CloseDialog
    implements Runnable {
        public void run() {
            TestBladeDialog.this.setVisible(false);
        }
    }

    public class DisplayMessage
    implements Runnable {
        String str;

        DisplayMessage(String string) {
            this.str = string;
        }

        public void run() {
            JOptionPane.showMessageDialog(TestBladeDialog.this, this.str);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(FabricTreeControl.getResource("TestBladeDialog.cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TestBladeDialog.this.closeDownDialog();
        }
    }

    class StartAction
    extends AbstractAction {
        public StartAction() {
            super(FabricTreeControl.getResource("TestBladeDialog.start"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TestBladeDialog.this.sanbox8000.testBlades(TestBladeDialog.this.blades);
            TestBladeDialog.this.fillTextArea();
            TestBladeDialog.this.setButtonsEnabled(false);
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(FabricTreeControl.getResource("TestBladeDialog.close"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TestBladeDialog.this.closeDownDialog();
        }
    }
}

