/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.DialogCreateException;
import com.qlogic.qms.fabric.propertyDialogs.SwitchProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.FixedLengthTextField;
import com.qlogic.ui.QDialog;
import com.qlogic.ui.QValidatedTextField;
import com.qlogic.util.QHelpUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SwitchPropertiesDialogSanbox2
extends QDialog
implements ChangeListener {
    protected SanboxChassis blade = null;
    protected ChassisEventAdapter chassisEventAdapter = null;
    protected Fabric fabric = null;
    protected JFrame frame = null;
    protected JPanel chassisPanel = null;
    protected JPanel buttonPanel = null;
    protected boolean waitingOnNameChange = false;
    protected boolean waitingOnSwitchConfigChange = false;
    protected boolean waitingOnRequestAdmin = false;
    protected boolean waitingOnReleaseAdmin = false;
    protected boolean waitingOnBroadcastChange = false;
    protected boolean waitingOnInbandEnableChange = false;
    protected boolean waitingOnZoningConfigChange = false;
    protected boolean waitingOnDomainIdLockChange = false;
    protected int newFcAddress;
    protected boolean settingInbandSwitchOffline = false;
    protected boolean settingInbandSwitchTest = false;
    protected boolean settingInbandEnableInband = false;
    protected SwitchProperties properties = new SwitchProperties();
    GridBagLayout baseLayout = new GridBagLayout();
    String[] adminStateChoices = new String[]{FabricTreeControl.getResource("SwitchPropertiesDialog.adminStateChoices.0"), FabricTreeControl.getResource("SwitchPropertiesDialog.adminStateChoices.1"), FabricTreeControl.getResource("SwitchPropertiesDialog.adminStateChoices.2")};
    JPanel idPanel = new JPanel();
    GridBagLayout idLayout = new GridBagLayout();
    JLabel wwNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.wwNameLabel"));
    JLabel wwNameContent = new JLabel();
    JLabel ipAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.ipAddrLabel"));
    JLabel ipAddrContent = new JLabel();
    JLabel opStateLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.opStateLabel"));
    JLabel opStateContent = new JLabel();
    JLabel fcAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.fcAddrLabel"));
    JLabel fcAddrContent = new JLabel();
    JLabel firmwareLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.firmwareLabel"));
    JLabel firmwareContent = new JLabel();
    JLabel curChassisNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.chassisNameLabel"));
    JLabel curChassisNameContent = new JLabel();
    JLabel macAddrLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.macAddrLabel"));
    JLabel macAddrContent = new JLabel();
    JPanel switchPanel = new JPanel();
    GridBagLayout chassisLayout = new GridBagLayout();
    JLabel chassisNameLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.chassisNameLabel"));
    JLabel adminStateLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.adminStateLabel"));
    JLabel stageTypeLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.stageTypeLabel"));
    JLabel domainIdLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.domainIdLabel"));
    JLabel domainIdHexLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.domainIdHexLabel"));
    public FixedLengthTextField chassisNameText = new FixedLengthTextField(63);
    public JComboBox adminStateCombo = new JComboBox<String>(this.adminStateChoices);
    public QValidatedTextField domainIdText = new QValidatedTextField(){

        public boolean isValid(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    };
    public QValidatedTextField domainIdHexText = new QValidatedTextField(){

        public boolean isValid(String string) {
            try {
                Integer.parseInt(string, 16);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    };
    JPanel timeoutPanel = new JPanel();
    GridBagLayout timeoutLayout = new GridBagLayout();
    JLabel timeoutLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.timeoutLabel"));
    JLabel raTovLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.raTovLabel"));
    JLabel edTovLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.edTovLabel"));
    public JTextField raTovText = new JTextField();
    public JTextField edTovText = new JTextField();
    JLabel broadcastLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.broadcast"));
    JRadioButton enableBroadcastButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.enableButton"));
    JRadioButton disableBroadcastButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.disableButton"));
    ButtonGroup broadcastButtonGroup = new ButtonGroup();
    JLabel inbandEnableLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.inbandEnable"));
    JRadioButton enableInbandButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.enableButton"));
    JRadioButton disableInbandButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.disableButton"));
    ButtonGroup inbandEnableButtonGroup = new ButtonGroup();
    JLabel sw2CompliantEnableLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.sw2CompliantEnable"));
    JRadioButton enableSw2CompliantButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.enableButton"));
    JRadioButton disableSw2CompliantButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.disableButton"));
    ButtonGroup sw2CompliantButtonGroup = new ButtonGroup();
    JLabel legacyAddressFormatEnableLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.legacyAddressFormat"));
    JRadioButton enableLegacyAddressFormatButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.enableButton"));
    JRadioButton disableLegacyAddressFormatButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.disableButton"));
    ButtonGroup legacyAddressFormatButtonGroup = new ButtonGroup();
    JLabel domainIdLockLabel = new JLabel(FabricTreeControl.getResource("SwitchPropertiesDialog.domainIdLockLabel"));
    JRadioButton enableDomainIdLockButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.enableButton"));
    JRadioButton disableDomainIdLockButton = new JRadioButton(FabricTreeControl.getResource("SwitchPropertiesDialog.disableButton"));
    ButtonGroup domainIdLockButtonGroup = new ButtonGroup();
    boolean firmwareVersion_1_0_3 = false;

    public SwitchPropertiesDialogSanbox2(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis, Fabric fabric) throws DialogCreateException {
        super((Frame)jFrame, bl);
        if (sanboxChassis == null || sanboxChassis.getSnmpInfo() == null) {
            throw new DialogCreateException();
        }
        if (sanboxChassis.getIpInfo() == null) {
            throw new DialogCreateException();
        }
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.frame = jFrame;
        this.setTitle(FabricTreeControl.getResource("SwitchPropertiesDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        if (((Sanbox2)this.blade).getFirmwareVersion() == 2) {
            this.firmwareVersion_1_0_3 = true;
        }
        this.chassisPanel = this.buildPanel();
        this.setEnabled(true);
        this.resetPanel();
        this.buttonPanel = this.properties.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.switchPropertiesDialogSanbox2Help"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.chassisPanel, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.domainIdText.getDocument().addDocumentListener(new DecimalDomainIdDocumentListener(this));
        this.domainIdHexText.getDocument().addDocumentListener(new HexadecimalDomainIdDocumentListener(this));
        this.getRootPane().setDefaultButton(this.properties.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void setSwitch(SanboxChassis sanboxChassis, Fabric fabric) {
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.unregisterForEvents();
        this.unregisterForAdminEvents();
        this.resetDialog();
    }

    public void resetDialog() {
        this.resetPanel();
        this.setEnabled(true);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.enableSw2CompliantButton) {
            this.setLegacyEnable();
        }
    }

    private void setLegacyEnable() {
        boolean bl = !this.enableSw2CompliantButton.isSelected() && ((Sanbox2)this.blade).supportsNonSw2Legacy();
        this.legacyAddressFormatEnableLabel.setEnabled(bl);
        this.enableLegacyAddressFormatButton.setEnabled(bl);
        this.disableLegacyAddressFormatButton.setEnabled(bl);
    }

    public void resetDialog(SanboxChassis sanboxChassis, Fabric fabric) throws DialogCreateException {
        this.unregisterForEvents();
        if (sanboxChassis == null || sanboxChassis.getSnmpInfo() == null) {
            throw new DialogCreateException();
        }
        if (sanboxChassis.getIpInfo() == null) {
            throw new DialogCreateException();
        }
        this.blade = sanboxChassis;
        this.fabric = fabric;
        this.chassisEventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.resetPanel();
        this.setEnabled(true);
    }

    public void disableButtons() {
        this.properties.applyButton.setEnabled(false);
        this.setEnabled(false);
    }

    public void enableButtons() {
        this.properties.applyButton.setEnabled(true);
        this.properties.cancelButton.setEnabled(true);
        this.setEnabled(true);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.chassisNameText.setEnabled(bl);
        this.adminStateCombo.setEnabled(bl);
        this.domainIdText.setEnabled(bl);
        this.domainIdHexText.setEnabled(bl);
        this.chassisNameText.setEnabled(bl);
        this.adminStateCombo.setEnabled(bl);
        this.raTovText.setEnabled(bl && this.blade.getAdminMode() == 2);
        this.edTovText.setEnabled(bl && this.blade.getAdminMode() == 2);
        this.timeoutLabel.setEnabled(bl && this.blade.getAdminMode() == 2);
        this.raTovLabel.setEnabled(bl && this.blade.getAdminMode() == 2);
        this.edTovLabel.setEnabled(bl && this.blade.getAdminMode() == 2);
    }

    public void resetPanel() {
        this.wwNameContent.setText(this.blade.getWWName().delimit());
        int n = ((Sanbox2)this.blade).getOperAdminState();
        switch (n) {
            case 1: {
                this.opStateContent.setText(FabricTreeControl.getResource("SwitchPropertiesDialog.opStateContent.0"));
                break;
            }
            case 2: {
                this.opStateContent.setText(FabricTreeControl.getResource("SwitchPropertiesDialog.opStateContent.1"));
                break;
            }
            case 3: {
                this.opStateContent.setText(FabricTreeControl.getResource("SwitchPropertiesDialog.opStateContent.2"));
            }
        }
        this.fcAddrContent.setText(this.blade.delimitFCAddress());
        this.firmwareContent.setText(this.blade.getFlashVersionString());
        this.curChassisNameContent.setText(this.blade.getChassisName());
        this.macAddrContent.setText(this.blade.delimitMacAddress());
        IPInfo iPInfo = this.blade.getIpInfo();
        if (iPInfo != null) {
            this.ipAddrContent.setText(iPInfo.getIpAddress().getHostAddress());
        } else {
            this.ipAddrContent.setText("unknown");
        }
        this.chassisNameText.setText(this.blade.getChassisName());
        this.adminStateCombo.setSelectedIndex(n - 1);
        this.domainIdText.setText(Integer.toString(this.blade.getConfiguredDomainId()));
        this.domainIdHexText.setText(Integer.toHexString(this.blade.getConfiguredDomainId()));
        if (((Sanbox2)this.blade).isBroadcastSupportEnabled()) {
            this.enableBroadcastButton.setSelected(true);
            this.disableBroadcastButton.setSelected(false);
        } else {
            this.enableBroadcastButton.setSelected(false);
            this.disableBroadcastButton.setSelected(true);
        }
        if (((Sanbox2)this.blade).getInbandEnable() == 1) {
            this.enableInbandButton.setSelected(true);
            this.disableInbandButton.setSelected(false);
        } else {
            this.enableInbandButton.setSelected(false);
            this.disableInbandButton.setSelected(true);
        }
        ZoningConfig zoningConfig = this.blade.getZoningConfig();
        if (zoningConfig.getMergeMode() == 0) {
            this.enableSw2CompliantButton.setSelected(true);
            this.disableSw2CompliantButton.setSelected(false);
        } else {
            this.enableSw2CompliantButton.setSelected(false);
            this.disableSw2CompliantButton.setSelected(true);
        }
        if (zoningConfig.getNonSw2Legacy()) {
            this.enableLegacyAddressFormatButton.setSelected(true);
            this.disableLegacyAddressFormatButton.setSelected(false);
        } else {
            this.enableLegacyAddressFormatButton.setSelected(false);
            this.disableLegacyAddressFormatButton.setSelected(true);
        }
        if (this.blade.getDomainIdLock() == 1) {
            this.enableDomainIdLockButton.setSelected(true);
            this.disableDomainIdLockButton.setSelected(false);
        } else if (this.blade.getDomainIdLock() == 0) {
            this.enableDomainIdLockButton.setSelected(false);
            this.disableDomainIdLockButton.setSelected(true);
        } else {
            this.enableDomainIdLockButton.setSelected(false);
            this.disableDomainIdLockButton.setSelected(false);
        }
        this.sw2CompliantEnableLabel.setEnabled(this.blade.supportsBrocadeMergeMode());
        this.enableSw2CompliantButton.setEnabled(this.blade.supportsBrocadeMergeMode());
        this.disableSw2CompliantButton.setEnabled(this.blade.supportsBrocadeMergeMode());
        this.setLegacyEnable();
        this.raTovText.setText(Integer.toString(this.blade.getRaTimeout()));
        this.edTovText.setText(Integer.toString(this.blade.getEdTimeout()));
        this.validate();
    }

    protected JPanel buildPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.baseLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 5;
        jPanel.add((Component)this.switchPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 5;
        jPanel.add((Component)this.timeoutPanel, gridBagConstraints);
        this.idPanel.setLayout(this.idLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.idPanel.add((Component)this.wwNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.wwNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.opStateLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.opStateContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.curChassisNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.curChassisNameContent, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.ipAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.ipAddrContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.fcAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.fcAddrContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.firmwareLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.firmwareContent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 20, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.macAddrLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(4, 0, 2, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.idPanel.add((Component)this.macAddrContent, gridBagConstraints);
        this.idPanel.setBorder(BorderFactory.createEtchedBorder());
        this.idPanel.setBackground(Color.white);
        int n = this.wwNameContent.getFont().getSize();
        Font font = new Font("Dialog", 0, n);
        this.wwNameContent.setFont(font);
        this.wwNameContent.setForeground(Color.black);
        this.opStateContent.setFont(font);
        this.opStateContent.setForeground(Color.black);
        this.fcAddrContent.setFont(font);
        this.fcAddrContent.setForeground(Color.black);
        this.firmwareContent.setFont(font);
        this.firmwareContent.setForeground(Color.black);
        this.curChassisNameContent.setFont(font);
        this.curChassisNameContent.setForeground(Color.black);
        this.macAddrContent.setFont(font);
        this.macAddrContent.setForeground(Color.black);
        this.ipAddrContent.setFont(font);
        this.ipAddrContent.setForeground(Color.black);
        this.switchPanel.setLayout(this.chassisLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        this.switchPanel.add((Component)this.chassisNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.chassisNameText.setColumns(10);
        this.switchPanel.add((Component)this.chassisNameText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.gridwidth = 1;
        this.switchPanel.add((Component)this.adminStateLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.adminStateCombo, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.domainIdLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.domainIdText, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.insets = new Insets(8, 0, 4, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.domainIdHexLabel, gridBagConstraints);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.domainIdHexText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.domainIdLockLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 4);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.enableDomainIdLockButton, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        this.switchPanel.add((Component)this.disableDomainIdLockButton, gridBagConstraints);
        this.domainIdLockButtonGroup.add(this.enableDomainIdLockButton);
        this.domainIdLockButtonGroup.add(this.disableDomainIdLockButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.broadcastLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 4);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.enableBroadcastButton, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        this.switchPanel.add((Component)this.disableBroadcastButton, gridBagConstraints);
        this.broadcastButtonGroup.add(this.enableBroadcastButton);
        this.broadcastButtonGroup.add(this.disableBroadcastButton);
        if (!this.firmwareVersion_1_0_3) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.insets = new Insets(8, 20, 8, 2);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.switchPanel.add((Component)this.inbandEnableLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(8, 0, 4, 4);
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.switchPanel.add((Component)this.enableInbandButton, gridBagConstraints);
            gridBagConstraints.gridx = 6;
            this.switchPanel.add((Component)this.disableInbandButton, gridBagConstraints);
            this.inbandEnableButtonGroup.add(this.enableInbandButton);
            this.inbandEnableButtonGroup.add(this.disableInbandButton);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.sw2CompliantEnableLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.enableSw2CompliantButton, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        this.switchPanel.add((Component)this.disableSw2CompliantButton, gridBagConstraints);
        this.sw2CompliantButtonGroup.add(this.enableSw2CompliantButton);
        this.sw2CompliantButtonGroup.add(this.disableSw2CompliantButton);
        this.enableSw2CompliantButton.addChangeListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.legacyAddressFormatEnableLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.switchPanel.add((Component)this.enableLegacyAddressFormatButton, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        this.switchPanel.add((Component)this.disableLegacyAddressFormatButton, gridBagConstraints);
        this.legacyAddressFormatButtonGroup.add(this.enableLegacyAddressFormatButton);
        this.legacyAddressFormatButtonGroup.add(this.disableLegacyAddressFormatButton);
        this.switchPanel.setBorder(BorderFactory.createEtchedBorder());
        this.timeoutPanel.setLayout(this.timeoutLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        this.timeoutPanel.add(this.timeoutLabel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.timeoutPanel.add((Component)this.raTovLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        this.raTovText.setColumns(7);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.timeoutPanel.add((Component)this.raTovText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(8, 20, 8, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.timeoutPanel.add((Component)this.edTovLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(8, 0, 4, 20);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.timeoutPanel.add((Component)this.edTovText, gridBagConstraints);
        this.timeoutPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(253));
        vector.add(new Integer(307));
        vector.add(new Integer(348));
        vector.add(new Integer(332));
        vector.add(new Integer(230));
        return vector;
    }

    protected void registerForEvents() {
        this.chassisEventAdapter.registerEventHandler(254, "receiveChassisEvent");
        this.chassisEventAdapter.registerEventHandler(231, "receiveChassisEvent");
    }

    protected void registerForAdminEvents() {
        this.chassisEventAdapter.registerEventHandler(238, "receiveChassisEvent");
        this.chassisEventAdapter.registerEventHandler(239, "receiveChassisEvent");
        this.chassisEventAdapter.registerEventHandler(237, "receiveChassisEvent");
        this.chassisEventAdapter.registerEventHandler(235, "receiveChassisEvent");
        this.chassisEventAdapter.registerEventHandler(236, "receiveChassisEvent");
        this.chassisEventAdapter.registerEventHandler(264, "receiveChassisEvent");
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.unregisterForEvents();
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
        this.chassisEventAdapter.unregisterEventHandler(254);
        this.chassisEventAdapter.unregisterEventHandler(231);
        this.chassisEventAdapter.unregisterEventHandler(308);
        this.chassisEventAdapter.unregisterEventHandler(349);
        this.chassisEventAdapter.unregisterEventHandler(331);
    }

    protected void unregisterForAdminEvents() {
        this.chassisEventAdapter.unregisterEventHandler(238);
        this.chassisEventAdapter.unregisterEventHandler(239);
        this.chassisEventAdapter.unregisterEventHandler(237);
        this.chassisEventAdapter.unregisterEventHandler(235);
        this.chassisEventAdapter.unregisterEventHandler(236);
        this.chassisEventAdapter.unregisterEventHandler(264);
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyChassisProperties() {
        boolean bl;
        boolean bl2;
        int n;
        Chassis chassis;
        int n2;
        int n3;
        int n4;
        boolean bl3;
        boolean bl4;
        this.waitingOnNameChange = false;
        this.waitingOnSwitchConfigChange = false;
        this.waitingOnRequestAdmin = false;
        this.waitingOnReleaseAdmin = false;
        this.settingInbandSwitchOffline = false;
        this.settingInbandSwitchTest = false;
        this.settingInbandEnableInband = false;
        this.waitingOnBroadcastChange = false;
        this.waitingOnInbandEnableChange = false;
        this.waitingOnZoningConfigChange = false;
        this.waitingOnDomainIdLockChange = false;
        String string = this.chassisNameText.getText().trim();
        if (string.indexOf(44) != -1 || string.indexOf(59) != -1 || string.indexOf(35) != -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.invalidString"));
            return -1;
        }
        if (string.length() > 32 || string.length() < 1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.chassisName.tooLong"));
            return -1;
        }
        if (!string.equals(this.blade.getChassisName())) {
            this.chassisEventAdapter.registerEventHandler(254, "receiveChassisEvent");
            this.waitingOnNameChange = true;
        }
        if ((bl4 = this.enableBroadcastButton.isSelected()) != ((Sanbox2)this.blade).isBroadcastSupportEnabled()) {
            this.chassisEventAdapter.registerEventHandler(308, "receiveChassisEvent");
            this.waitingOnBroadcastChange = true;
        }
        int n5 = 1;
        if (!this.firmwareVersion_1_0_3) {
            if (this.disableInbandButton.isSelected()) {
                n5 = 2;
            }
            if (n5 != ((Sanbox2)this.blade).getInbandEnable()) {
                this.chassisEventAdapter.registerEventHandler(349, "receiveChassisEvent");
                this.waitingOnInbandEnableChange = true;
            }
            this.settingInbandEnableInband = false;
            if (this.waitingOnInbandEnableChange && n5 == 2 && this.fabric != null && this.fabric.getConnectionSwitch() != this.blade) {
                String string2 = FabricTreeControl.getResource("SwitchPropertiesDialog.inband.warning.1") + VendorProperties.getApplicationName() + FabricTreeControl.getResource("SwitchPropertiesDialog.inband.warning.2");
                bl3 = PopupDialog.showDialog(this, 1, string2);
                if (!bl3) {
                    return -1;
                }
                this.settingInbandEnableInband = true;
            }
        }
        int n6 = 0;
        bl3 = true;
        if (this.blade.getZoningConfig().getMergeMode() == 0 != this.enableSw2CompliantButton.isSelected() || this.enableLegacyAddressFormatButton.isSelected() != this.blade.getZoningConfig().getNonSw2Legacy()) {
            this.chassisEventAdapter.registerEventHandler(380, "receiveChassisEvent");
            this.waitingOnZoningConfigChange = true;
            n6 = this.enableSw2CompliantButton.isSelected() ? 0 : 1;
            bl3 = this.enableLegacyAddressFormatButton.isSelected();
        }
        int n7 = -1;
        if (this.enableDomainIdLockButton.isSelected()) {
            n7 = 1;
        } else if (this.disableDomainIdLockButton.isSelected()) {
            n7 = 0;
        }
        if (n7 != -1 && n7 != this.blade.getDomainIdLock()) {
            this.chassisEventAdapter.registerEventHandler(331, "receiveChassisEvent");
            this.waitingOnDomainIdLockChange = true;
        }
        if ((n4 = this.adminStateCombo.getSelectedIndex()) < 0) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidAdminState"));
            return -1;
        }
        int n8 = n4 + 1;
        try {
            n3 = Integer.parseInt(this.domainIdText.getText());
        }
        catch (Exception exception) {
            n3 = 0;
        }
        if (!this.fabric.isUniqueDomainID(this.blade.getDomainId(), n3)) {
            String string3 = FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidDomainId.duplicate") + "\n\n" + FabricTreeControl.getResource("SwitchPropertiesDialog.error.rules") + 1 + " to " + 239 + " ( 0x" + Integer.toHexString(1) + " to " + " 0x" + Integer.toHexString(239) + " ).\n\n";
            PopupDialog.showDialog(this, 3, string3);
            return -1;
        }
        if (n3 < 1 || n3 > 239) {
            String string4 = FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidDomainId.outOfRange") + "\n\n" + FabricTreeControl.getResource("SwitchPropertiesDialog.error.rules") + 1 + " to " + 239 + " ( 0x" + Integer.toHexString(1) + " to " + " 0x" + Integer.toHexString(239) + " ).\n\n";
            PopupDialog.showDialog(this, 3, string4);
            return -1;
        }
        if (this.fabric.hasSanbox() && (n3 < this.fabric.minValidDomainID() || n3 > this.fabric.maxValidDomainID())) {
            String string5 = FabricTreeControl.getResource("SwitchPropertiesDialog.mixedFabricDomainRange.1") + " " + this.fabric.minValidDomainID() + " to " + this.fabric.maxValidDomainID() + " ( 0x" + Integer.toHexString(this.fabric.minValidDomainID()) + " to " + " 0x" + Integer.toHexString(this.fabric.maxValidDomainID()) + " ).\n" + FabricTreeControl.getResource("SwitchPropertiesDialog.mixedFabricDomainRange.2") + n3 + " ( 0x" + Integer.toHexString(n3) + " ) " + FabricTreeControl.getResource("SwitchPropertiesDialog.mixedFabricDomainRange.3");
            n2 = PopupDialog.showDialog(this, 1, string5 = string5 + "\n\n" + FabricTreeControl.getResource("SwitchPropertiesDialog.error.changeAnyway")) ? 1 : 0;
            if (n2 == 0) {
                return -1;
            }
        }
        n2 = 0;
        int n9 = this.blade.getRtTimeout();
        int n10 = 0;
        try {
            n2 = Integer.parseInt(this.raTovText.getText());
            n10 = Integer.parseInt(this.edTovText.getText());
        }
        catch (Exception exception) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalidTimeout"));
            return -1;
        }
        if (n2 < 100 || n2 > 100000) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalid_R_A_TOV"));
            return -1;
        }
        if (n10 < 10 || n10 > 20000) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.invalid_E_D_TOV"));
            return -1;
        }
        if (n2 != this.blade.getRaTimeout()) {
            if (this.fabric.getConnectionSwitch().equals((Object)this.blade)) {
                chassis = this.fabric.getFirstSwitch();
                n = 0;
                while (n < this.fabric.switchCount()) {
                    if (n2 != ((SanboxChassis)chassis).getRaTimeout() && !this.fabric.getConnectionSwitch().equals((Object)chassis)) {
                        if (!PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.unreachableFabConflictingTOVWarning"))) {
                            return -1;
                        }
                        break;
                    }
                    chassis = this.fabric.getNextSwitch(chassis);
                    ++n;
                }
            } else if (n2 != this.fabric.getConnectionSwitch().getRaTimeout() && !PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.unreachableConflictingTOVWarning"))) {
                return -1;
            }
        }
        if (n10 != this.blade.getEdTimeout()) {
            if (this.fabric.getConnectionSwitch().equals((Object)this.blade)) {
                chassis = this.fabric.getFirstSwitch();
                n = 0;
                while (n < this.fabric.switchCount()) {
                    if (n10 != ((SanboxChassis)chassis).getEdTimeout() && !this.fabric.getConnectionSwitch().equals((Object)chassis)) {
                        if (!PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.unreachableFabConflictingTOVWarning"))) {
                            return -1;
                        }
                        break;
                    }
                    chassis = this.fabric.getNextSwitch(chassis);
                    ++n;
                }
            } else if (n10 != this.fabric.getConnectionSwitch().getEdTimeout() && !PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.unreachableConflictingTOVWarning"))) {
                return -1;
            }
        }
        this.settingInbandSwitchOffline = false;
        if (n8 == 2 && this.blade.getAdminMode() != 2 && this.fabric != null && this.fabric.getConnectionSwitch() != this.blade) {
            boolean bl5 = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.switchOfflineWarning"));
            if (!bl5) {
                return -1;
            }
            this.settingInbandSwitchOffline = true;
        }
        this.settingInbandSwitchTest = false;
        if (n8 == 3 && this.blade.getAdminMode() != 3) {
            if (this.fabric != null && this.fabric.getConnectionSwitch() != this.blade) {
                boolean bl6 = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.switchInbandDiagnosticWarning"));
                if (!bl6) {
                    return -1;
                }
                this.settingInbandSwitchTest = true;
            } else {
                boolean bl7 = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.switchDiagResetWarning"));
                if (!bl7) {
                    return -1;
                }
            }
        } else if (n8 != 3 && this.blade.getAdminMode() == 3 && !(bl2 = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.switchNonDiagResetWarning")))) {
            return -1;
        }
        if (this.waitingOnZoningConfigChange && FabricList.getFabric((Chassis)this.blade).switchCount() > 1 && !(bl = PopupDialog.showDialog(this, 1, FabricTreeControl.getResource("SwitchPropertiesDialog.changingZoningConfigWarning")))) {
            return -1;
        }
        if (n8 != ((Sanbox2)this.blade).getOperAdminState() || n3 != this.blade.getConfiguredDomainId() || n2 != this.blade.getRaTimeout() || n10 != this.blade.getEdTimeout()) {
            this.chassisEventAdapter.registerEventHandler(231, "receiveChassisEvent");
            this.waitingOnSwitchConfigChange = true;
            this.waitingOnRequestAdmin = true;
            this.waitingOnReleaseAdmin = true;
            this.registerForAdminEvents();
            ((Sanbox2Sml)this.blade).requestAdmin();
            ((Sanbox2Sml)this.blade).editConfig();
            if (this.waitingOnNameChange) {
                ((Sanbox2)this.blade).applyName(string);
            }
            if (this.waitingOnBroadcastChange) {
                ((Sanbox2)this.blade).applyBroadcastSupport(bl4);
            }
            if (this.waitingOnInbandEnableChange && !this.firmwareVersion_1_0_3) {
                ((Sanbox2)this.blade).applyInbandEnable(n5);
            }
            if (this.waitingOnZoningConfigChange) {
                ZoningConfig zoningConfig = new ZoningConfig(this.blade.getZoningConfig());
                zoningConfig.setMergeMode(n6);
                zoningConfig.setNonSw2Legacy(bl3);
                Sanbox2 sanbox2 = (Sanbox2)this.blade;
                sanbox2.applyZoningConfigWithoutGettingAdmin(zoningConfig);
            }
            if (this.waitingOnDomainIdLockChange) {
                ((Sanbox2)this.blade).applyDomainIdLock(n7);
            }
            int n11 = this.blade.getPortCount();
            FCPort fCPort = null;
            int[] nArray = new int[n11];
            int[] nArray2 = new int[n11];
            int[] nArray3 = new int[n11];
            int[] nArray4 = new int[n11];
            int n12 = 0;
            while (n12 < n11) {
                try {
                    fCPort = this.blade.getPort(n12);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PortStates portStates = fCPort.getPortStates();
                if (portStates != null) {
                    nArray[n12] = portStates.getActiveAdminState();
                    nArray2[n12] = portStates.getMfsMode();
                    nArray3[n12] = portStates.getAlDisabled();
                    nArray4[n12] = portStates.getConfigPortType();
                }
                ++n12;
            }
            ((Sanbox2)this.blade).applySwitchConfig(n3, n8, n2, n10);
            this.newFcAddress = n3 << 16;
            ((Sanbox2Sml)this.blade).saveConfig();
            ((Sanbox2Sml)this.blade).activateConfigAndReleaseAdmin();
        } else if (this.waitingOnNameChange || this.waitingOnBroadcastChange || this.waitingOnDomainIdLockChange || this.waitingOnZoningConfigChange || this.waitingOnInbandEnableChange) {
            this.waitingOnRequestAdmin = true;
            this.waitingOnReleaseAdmin = true;
            this.registerForAdminEvents();
            ((Sanbox2Sml)this.blade).requestAdmin();
            ((Sanbox2Sml)this.blade).editConfig();
            if (this.waitingOnNameChange) {
                ((Sanbox2)this.blade).applyName(string);
            }
            if (this.waitingOnBroadcastChange) {
                ((Sanbox2)this.blade).applyBroadcastSupport(bl4);
            }
            if (this.waitingOnInbandEnableChange && !this.firmwareVersion_1_0_3) {
                ((Sanbox2)this.blade).applyInbandEnable(n5);
            }
            if (this.waitingOnZoningConfigChange) {
                ZoningConfig zoningConfig = new ZoningConfig(this.blade.getZoningConfig());
                zoningConfig.setMergeMode(n6);
                zoningConfig.setNonSw2Legacy(bl3);
                Sanbox2 sanbox2 = (Sanbox2)this.blade;
                sanbox2.applyZoningConfigWithoutGettingAdmin(zoningConfig);
            }
            if (this.waitingOnDomainIdLockChange) {
                ((Sanbox2)this.blade).applyDomainIdLock(n7);
            }
            ((Sanbox2Sml)this.blade).saveConfig();
            ((Sanbox2Sml)this.blade).activateConfigAndReleaseAdmin();
        }
        return 1;
    }

    public void receiveChassisEvent(ChassisEvent chassisEvent) {
        if (!chassisEvent.isSuccessful()) {
            this.unregisterForEvents();
            this.unregisterForAdminEvents();
            this.enableButtons();
        }
        if (chassisEvent.getEventType() == 264 && chassisEvent.isSuccessful() && this.newFcAddress != 0) {
            chassisEvent.getChassis().setFcAddress(this.newFcAddress);
        }
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    class HexadecimalDomainIdDocumentListener
    implements DocumentListener {
        SwitchPropertiesDialogSanbox2 theDialog = null;

        public HexadecimalDomainIdDocumentListener(SwitchPropertiesDialogSanbox2 switchPropertiesDialogSanbox22) {
            this.theDialog = switchPropertiesDialogSanbox22;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateDecDomainID(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateDecDomainID(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void updateDecDomainID(DocumentEvent documentEvent) {
            block2: {
                String string = SwitchPropertiesDialogSanbox2.this.domainIdHexText.getText();
                if (string.length() <= 0 || !SwitchPropertiesDialogSanbox2.this.domainIdHexText.hasFocus()) break block2;
                try {
                    int n = Integer.parseInt(string, 16);
                    SwitchPropertiesDialogSanbox2.this.domainIdText.setText(Integer.toString(n));
                    SwitchPropertiesDialogSanbox2.this.validate();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    class DecimalDomainIdDocumentListener
    implements DocumentListener {
        SwitchPropertiesDialogSanbox2 theDialog = null;

        public DecimalDomainIdDocumentListener(SwitchPropertiesDialogSanbox2 switchPropertiesDialogSanbox22) {
            this.theDialog = switchPropertiesDialogSanbox22;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateHexDomainID(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateHexDomainID(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void updateHexDomainID(DocumentEvent documentEvent) {
            block2: {
                String string = SwitchPropertiesDialogSanbox2.this.domainIdText.getText();
                if (string.length() <= 0 || !SwitchPropertiesDialogSanbox2.this.domainIdText.hasFocus()) break block2;
                try {
                    int n = Integer.parseInt(string);
                    SwitchPropertiesDialogSanbox2.this.domainIdHexText.setText(Integer.toHexString(n));
                    SwitchPropertiesDialogSanbox2.this.validate();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        SwitchPropertiesDialogSanbox2 dialog = null;

        public ApplyResponseHandler(SwitchPropertiesDialogSanbox2 switchPropertiesDialogSanbox22, Object object) {
            this.dialog = switchPropertiesDialogSanbox22;
            this.evt = (ChassisEvent)object;
        }

        public void run() {
            int n = this.evt.getEventType();
            switch (n) {
                case 238: {
                    SwitchPropertiesDialogSanbox2.this.waitingOnRequestAdmin = false;
                    if (this.evt.isSuccessful()) break;
                    SwitchPropertiesDialogSanbox2.this.unregisterForAdminEvents();
                    SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.adminFailed") + "\n" + SwitchPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    SwitchPropertiesDialogSanbox2.this.enableButtons();
                    this.dialog.setVisible(false);
                    SwitchPropertiesDialogSanbox2.this.newFcAddress = 0;
                    return;
                }
                case 237: {
                    if (this.evt.isSuccessful()) break;
                    SwitchPropertiesDialogSanbox2.this.unregisterForAdminEvents();
                    SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.editConfigFailed") + "\n" + SwitchPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    SwitchPropertiesDialogSanbox2.this.enableButtons();
                    this.dialog.setVisible(false);
                    SwitchPropertiesDialogSanbox2.this.newFcAddress = 0;
                    return;
                }
                case 235: {
                    if (this.evt.isSuccessful()) break;
                    SwitchPropertiesDialogSanbox2.this.unregisterForAdminEvents();
                    SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.saveConfigFailed") + "\n" + SwitchPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    SwitchPropertiesDialogSanbox2.this.enableButtons();
                    this.dialog.setVisible(false);
                    SwitchPropertiesDialogSanbox2.this.newFcAddress = 0;
                    return;
                }
                case 264: {
                    SwitchPropertiesDialogSanbox2.this.waitingOnReleaseAdmin = false;
                    SwitchPropertiesDialogSanbox2.this.unregisterForAdminEvents();
                    SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
                    SwitchPropertiesDialogSanbox2.this.enableButtons();
                    this.dialog.setVisible(false);
                    SwitchPropertiesDialogSanbox2.this.newFcAddress = 0;
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(SwitchPropertiesDialogSanbox2.this.frame, SwitchPropertiesDialogSanbox2.this.blade, SwitchPropertiesDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("SwitchPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 254: {
                    if (!SwitchPropertiesDialogSanbox2.this.waitingOnNameChange) break;
                    SwitchPropertiesDialogSanbox2.this.waitingOnNameChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.nameChangeFailed") + "\n" + SwitchPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (SwitchPropertiesDialogSanbox2.this.waitingOnSwitchConfigChange || SwitchPropertiesDialogSanbox2.this.waitingOnReleaseAdmin || SwitchPropertiesDialogSanbox2.this.waitingOnBroadcastChange || SwitchPropertiesDialogSanbox2.this.waitingOnDomainIdLockChange || SwitchPropertiesDialogSanbox2.this.waitingOnInbandEnableChange || SwitchPropertiesDialogSanbox2.this.waitingOnZoningConfigChange) break;
                    SwitchPropertiesDialogSanbox2.this.enableButtons();
                    SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    break;
                }
                case 308: {
                    if (!SwitchPropertiesDialogSanbox2.this.waitingOnBroadcastChange) break;
                    SwitchPropertiesDialogSanbox2.this.waitingOnBroadcastChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.broadcastChangeFailed") + "\n" + SwitchPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (SwitchPropertiesDialogSanbox2.this.waitingOnSwitchConfigChange || SwitchPropertiesDialogSanbox2.this.waitingOnReleaseAdmin || SwitchPropertiesDialogSanbox2.this.waitingOnNameChange || SwitchPropertiesDialogSanbox2.this.waitingOnInbandEnableChange || SwitchPropertiesDialogSanbox2.this.waitingOnDomainIdLockChange || SwitchPropertiesDialogSanbox2.this.waitingOnZoningConfigChange) break;
                    SwitchPropertiesDialogSanbox2.this.enableButtons();
                    SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    break;
                }
                case 349: {
                    if (!SwitchPropertiesDialogSanbox2.this.waitingOnInbandEnableChange) break;
                    SwitchPropertiesDialogSanbox2.this.waitingOnInbandEnableChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.inbandEnableFailed") + "\n" + SwitchPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (SwitchPropertiesDialogSanbox2.this.waitingOnSwitchConfigChange || SwitchPropertiesDialogSanbox2.this.waitingOnReleaseAdmin || SwitchPropertiesDialogSanbox2.this.waitingOnNameChange || SwitchPropertiesDialogSanbox2.this.waitingOnBroadcastChange || SwitchPropertiesDialogSanbox2.this.waitingOnDomainIdLockChange) break;
                    SwitchPropertiesDialogSanbox2.this.enableButtons();
                    SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    break;
                }
                case 380: {
                    if (!SwitchPropertiesDialogSanbox2.this.waitingOnZoningConfigChange) break;
                    SwitchPropertiesDialogSanbox2.this.waitingOnZoningConfigChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.applySw2CompiantFailed") + "\n" + SwitchPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (SwitchPropertiesDialogSanbox2.this.waitingOnSwitchConfigChange || SwitchPropertiesDialogSanbox2.this.waitingOnReleaseAdmin || SwitchPropertiesDialogSanbox2.this.waitingOnNameChange || SwitchPropertiesDialogSanbox2.this.waitingOnBroadcastChange || SwitchPropertiesDialogSanbox2.this.waitingOnInbandEnableChange || SwitchPropertiesDialogSanbox2.this.waitingOnZoningConfigChange) break;
                    SwitchPropertiesDialogSanbox2.this.enableButtons();
                    SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    break;
                }
                case 331: {
                    if (!SwitchPropertiesDialogSanbox2.this.waitingOnDomainIdLockChange) break;
                    SwitchPropertiesDialogSanbox2.this.waitingOnDomainIdLockChange = false;
                    if (!this.evt.isSuccessful()) {
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.domainIdLockFailed") + "\n" + SwitchPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (SwitchPropertiesDialogSanbox2.this.waitingOnSwitchConfigChange || SwitchPropertiesDialogSanbox2.this.waitingOnReleaseAdmin || SwitchPropertiesDialogSanbox2.this.waitingOnNameChange || SwitchPropertiesDialogSanbox2.this.waitingOnBroadcastChange || SwitchPropertiesDialogSanbox2.this.waitingOnInbandEnableChange || SwitchPropertiesDialogSanbox2.this.waitingOnZoningConfigChange) break;
                    SwitchPropertiesDialogSanbox2.this.enableButtons();
                    SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                    break;
                }
                case 231: {
                    SwitchPropertiesDialogSanbox2.this.waitingOnSwitchConfigChange = false;
                    if (!this.evt.isSuccessful()) {
                        SwitchPropertiesDialogSanbox2.this.newFcAddress = 0;
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("SwitchPropertiesDialog.error.chassisConfigChangeFailed") + "\n" + SwitchPropertiesDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    }
                    if (SwitchPropertiesDialogSanbox2.this.waitingOnNameChange || SwitchPropertiesDialogSanbox2.this.waitingOnBroadcastChange || SwitchPropertiesDialogSanbox2.this.waitingOnDomainIdLockChange || SwitchPropertiesDialogSanbox2.this.waitingOnInbandEnableChange || SwitchPropertiesDialogSanbox2.this.waitingOnReleaseAdmin || SwitchPropertiesDialogSanbox2.this.waitingOnZoningConfigChange) break;
                    SwitchPropertiesDialogSanbox2.this.enableButtons();
                    SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
                    this.dialog.setVisible(false);
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        SwitchPropertiesDialogSanbox2 theDialog = null;

        public CancelButtonListener(SwitchPropertiesDialogSanbox2 switchPropertiesDialogSanbox22) {
            this.theDialog = switchPropertiesDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwitchPropertiesDialogSanbox2.this.enableButtons();
            SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
            SwitchPropertiesDialogSanbox2.this.unregisterForAdminEvents();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        SwitchPropertiesDialogSanbox2 theDialog = null;

        public ApplyButtonListener(SwitchPropertiesDialogSanbox2 switchPropertiesDialogSanbox22) {
            this.theDialog = switchPropertiesDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyChassisProperties() == 1) {
                if (SwitchPropertiesDialogSanbox2.this.waitingOnNameChange || SwitchPropertiesDialogSanbox2.this.waitingOnSwitchConfigChange || SwitchPropertiesDialogSanbox2.this.waitingOnRequestAdmin || SwitchPropertiesDialogSanbox2.this.waitingOnReleaseAdmin) {
                    SwitchPropertiesDialogSanbox2.this.disableButtons();
                } else {
                    SwitchPropertiesDialogSanbox2.this.enableButtons();
                    SwitchPropertiesDialogSanbox2.this.unregisterForEvents();
                    SwitchPropertiesDialogSanbox2.this.unregisterForAdminEvents();
                    this.theDialog.setVisible(false);
                }
            }
        }
    }
}

