/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.archiver.SanboxChassisArchiver;
import com.qlogic.device.fcfabric.archiver.events.ArchiverEvent;
import com.qlogic.device.fcfabric.archiver.events.ArchiverEventListener;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.UserPreferences;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.ui.QFileChooser;
import com.qlogic.ui.StringFileFilter;
import com.qlogic.util.Invoker;
import com.qlogic.util.QHelpUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class RestoreDialogSanbox2
extends QDialog
implements ChassisEventListener,
ArchiverEventListener {
    protected Sanbox2 blade = null;
    protected ChassisEventAdapter eventAdapter = null;
    protected JFrame frame = null;
    protected JPanel mainPanel = null;
    protected JPanel filePanel = null;
    protected JPanel outputPanel = null;
    protected JPanel restoreAllPanel = null;
    protected JPanel selectiveRestorePanel = null;
    protected JPanel buttonPanel = null;
    protected JTabbedPane tabPane = null;
    protected JScrollPane outputScrollPane = null;
    protected JTextArea outputText = new JTextArea(10, 60);
    protected JButton restoreAllButton = new JButton(FabricTreeControl.getResource("RestoreDialog.restore"));
    protected JButton selectiveRestoreButton = new JButton(FabricTreeControl.getResource("RestoreDialog.restore"));
    protected JButton cancelRestoreButton = new JButton(FabricTreeControl.getResource("RestoreDialog.cancel"));
    protected JLabel archiveFileLabel = new JLabel(FabricTreeControl.getResource("RestoreDialog.archiveFile"));
    protected JTextField archiveFileText = new JTextField();
    protected JButton browseButton = new JButton(FabricTreeControl.getResource("RestoreDialog.browse"));
    protected JLabel selectLabel = new JLabel(FabricTreeControl.getResource("RestoreDialog.select"));
    protected JCheckBox ipAddressChBox = new JCheckBox(FabricTreeControl.getResource("RestoreDialog.ipAddress"));
    protected JCheckBox networkChBox = new JCheckBox(FabricTreeControl.getResource("RestoreDialog.network"));
    protected JCheckBox switchChBox = new JCheckBox(FabricTreeControl.getResource("RestoreDialog.switch"));
    protected JCheckBox portChBox = new JCheckBox(FabricTreeControl.getResource("RestoreDialog.port"));
    protected JCheckBox domainIdChBox = new JCheckBox(FabricTreeControl.getResource("RestoreDialog.domainId"));
    protected JCheckBox zoningChBox = new JCheckBox(FabricTreeControl.getResource("RestoreDialog.zoning"));
    protected JLabel restoreAllLabel = new JLabel(FabricTreeControl.getResource("RestoreDialog.restoreAll"));
    protected boolean waitingOnRequestAdmin = false;
    protected boolean waitingOnReleaseAdmin = false;
    protected boolean waitingOnRestore = false;
    protected static QFileChooser fileChooser;
    protected SanboxChassisArchiver archiver;
    protected static Invoker invoker;

    public RestoreDialogSanbox2(JFrame jFrame, boolean bl, Sanbox2 sanbox2) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("RestoreDialog.titleBarText") + " - " + VendorProperties.getFrameTitle());
        this.blade = sanbox2;
        this.archiver = this.blade.getArchiver();
        this.archiver.addListener((ArchiverEventListener)this);
        this.frame = jFrame;
        this.blade.addChassisEventListener((ChassisEventListener)this);
        String string = UserPreferences.getInstance().getWorkingDirectory();
        fileChooser = new QFileChooser(string);
        StringFileFilter stringFileFilter = new StringFileFilter(".xml");
        fileChooser.setFileFilter(stringFileFilter);
        fileChooser.addChoosableFileFilter(stringFileFilter);
        this.filePanel = this.createFilePanel();
        this.filePanel.setPreferredSize(new Dimension(400, 30));
        this.outputPanel = this.createOutputPanel();
        this.outputPanel.setPreferredSize(new Dimension(400, 150));
        this.tabPane = new JTabbedPane();
        this.selectiveRestorePanel = this.createSelectiveRestorePanel();
        this.restoreAllPanel = this.createRestoreAllPanel();
        this.buttonPanel = this.createButtonPanel();
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.restoreDialogSanbox2Help"));
        this.tabPane.add(FabricTreeControl.getResource("RestoreDialog.fullRestore"), this.restoreAllPanel);
        this.tabPane.add(FabricTreeControl.getResource("RestoreDialog.selectiveRestore"), this.selectiveRestorePanel);
        this.tabPane.setPreferredSize(new Dimension(400, 250));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.outputPanel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        this.getContentPane().add((Component)this.filePanel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 5;
        this.getContentPane().add((Component)this.tabPane, gridBagConstraints);
        this.tabPane.setTabPlacement(3);
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel = new JPanel();
        jPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void resetDialog(Sanbox2 sanbox2) {
        this.blade.removeChassisEventListener((ChassisEventListener)this);
        if (this.archiver != null) {
            this.archiver.removeListener((ArchiverEventListener)this);
        }
        this.enableButtons();
        this.blade = sanbox2;
        this.archiver = this.blade.getArchiver();
        this.archiver.addListener((ArchiverEventListener)this);
        this.blade.addChassisEventListener((ChassisEventListener)this);
        this.archiveFileText.setText("");
        this.ipAddressChBox.setSelected(false);
        this.domainIdChBox.setSelected(false);
        this.networkChBox.setSelected(true);
        this.switchChBox.setSelected(true);
        this.portChBox.setSelected(true);
        this.zoningChBox.setSelected(false);
        this.ipAddressChBox.setEnabled(true);
        this.domainIdChBox.setEnabled(true);
    }

    public JPanel createOutputPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.outputScrollPane = new JScrollPane(this.outputText);
        this.outputText.setEditable(false);
        this.outputScrollPane.setPreferredSize(new Dimension(400, 100));
        jPanel.add((Component)this.outputScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    public JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 4, 8, 0));
        this.cancelRestoreButton.addActionListener(new CancelRestoreButtonListener(this));
        this.cancelRestoreButton.setMnemonic('C');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.cancelRestoreButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add(this.helpContextButton);
        return jPanel;
    }

    public JPanel createFilePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 2);
        jPanel.add((Component)this.archiveFileLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.archiveFileText.setColumns(10);
        jPanel.add((Component)this.archiveFileText, gridBagConstraints);
        this.browseButton.addActionListener(new BrowseButtonListener(this));
        this.browseButton.setMnemonic('B');
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        jPanel.add((Component)this.browseButton, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    public JPanel createSelectiveRestorePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 20, 10, 20);
        this.selectLabel.setHorizontalAlignment(0);
        jPanel.add((Component)this.selectLabel, gridBagConstraints);
        this.ipAddressChBox.setSelected(false);
        this.domainIdChBox.setSelected(false);
        this.networkChBox.setSelected(true);
        this.switchChBox.setSelected(true);
        this.portChBox.setSelected(true);
        this.zoningChBox.setSelected(false);
        this.networkChBox.addActionListener(new NetworkCheckBoxListener());
        this.switchChBox.addActionListener(new SwitchCheckBoxListener());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        jPanel.add((Component)this.networkChBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 30, 1, 10);
        jPanel.add((Component)this.ipAddressChBox, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 10, 1, 10);
        jPanel.add((Component)this.portChBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 10, 0, 10);
        jPanel.add((Component)this.switchChBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 30, 1, 10);
        jPanel.add((Component)this.domainIdChBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 10, 1, 10);
        jPanel.add((Component)this.zoningChBox, gridBagConstraints);
        this.selectiveRestoreButton.addActionListener(new SelectiveRestoreButtonListener(this));
        this.selectiveRestoreButton.setMnemonic('S');
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.selectiveRestoreButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 110, 10, 110);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("RestoreDialog.selectiveRestore")));
        return jPanel;
    }

    public JPanel createRestoreAllPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 50, 20, 50);
        this.restoreAllLabel.setHorizontalAlignment(0);
        jPanel.add((Component)this.restoreAllLabel, gridBagConstraints);
        this.restoreAllButton.addActionListener(new RestoreAllButtonListener(this));
        this.restoreAllButton.setMnemonic('R');
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)this.restoreAllButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(20, 100, 80, 100);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(FabricTreeControl.getResource("RestoreDialog.fullRestore")));
        return jPanel;
    }

    protected Vector getEventList() {
        Vector vector = new Vector();
        return vector;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.blade.removeChassisEventListener((ChassisEventListener)this);
            this.setVisible(false);
        }
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int restoreAll() {
        Object object;
        this.outputText.setText("");
        String string = this.archiveFileText.getText().trim();
        if (string.length() < 1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("RestoreDialog.noFile"));
            return -1;
        }
        if (!string.endsWith(".xml")) {
            string = string + ".xml";
        }
        if (!(string.startsWith("/") || string.startsWith("\\") || string.length() > 1 && string.charAt(1) == ':')) {
            object = UserPreferences.getInstance().getWorkingDirectory();
            string = (String)object + File.separator + string;
        }
        object = this.getCursor();
        this.disableButtons();
        invoker = new Invoker();
        invoker.invokeLater(new Restore(this, string));
        this.archiveFileText.setEnabled(true);
        this.enableButtons();
        return 1;
    }

    protected int selectiveRestore() {
        this.outputText.setText("");
        String string = this.archiveFileText.getText().trim();
        if (string.length() < 1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("RestoreDialog.noFile"));
            return -1;
        }
        if (!string.endsWith(".xml")) {
            string = string + ".xml";
        }
        if (!(string.startsWith("/") || string.startsWith("\\") || string.length() > 1 && string.charAt(1) == ':')) {
            String string2 = UserPreferences.getInstance().getWorkingDirectory();
            string = string2 + File.separator + string;
        }
        boolean bl = this.ipAddressChBox.isSelected();
        boolean bl2 = this.domainIdChBox.isSelected();
        boolean bl3 = this.portChBox.isSelected();
        boolean bl4 = this.networkChBox.isSelected();
        boolean bl5 = this.switchChBox.isSelected();
        boolean bl6 = this.zoningChBox.isSelected();
        Cursor cursor = this.getCursor();
        this.disableButtons();
        invoker = new Invoker();
        invoker.invokeLater(new Restore(this, string, bl, bl2, bl3, bl4, bl5, bl6));
        this.archiveFileText.setEnabled(true);
        this.enableButtons();
        return 1;
    }

    public void disableButtons() {
        this.selectiveRestoreButton.setEnabled(false);
        this.restoreAllButton.setEnabled(false);
    }

    public void enableButtons() {
        this.selectiveRestoreButton.setEnabled(true);
        this.restoreAllButton.setEnabled(true);
    }

    public void receiveEvent(ArchiverEvent archiverEvent) {
        SwingUtilities.invokeLater(new HandleArchiverEvent(archiverEvent));
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getEventType() == 252) {
            if (chassisEvent.isSuccessful()) {
                SwingUtilities.invokeLater(new AddMessage(FabricTreeControl.getResource("RestoreDialog.resetSwitch")));
            } else {
                SwingUtilities.invokeLater(new AddMessage(FabricTreeControl.getResource("RestoreDialog.failedResettingSwitch") + FabricTreeControl.translateErrorType(chassisEvent.getErrorType())));
            }
        }
    }

    public void addMessage(String string) {
        if (string != null) {
            this.outputText.append(string);
        } else {
            this.outputText.setText("");
        }
        this.repaint();
    }

    static {
        invoker = new Invoker();
    }

    public class HandleArchiverEvent
    implements Runnable {
        ArchiverEvent evt;

        public HandleArchiverEvent(ArchiverEvent archiverEvent) {
            this.evt = archiverEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 9506: {
                    if (this.evt.isSuccessful()) {
                        RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.restoreCompletedOK"));
                    } else {
                        RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.restoreFailed"));
                    }
                    RestoreDialogSanbox2.this.archiveFileText.setEnabled(true);
                    RestoreDialogSanbox2.this.enableButtons();
                    break;
                }
                case 9502: {
                    RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.restoringSwitchConfiguration"));
                    break;
                }
                case 9500: {
                    RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.restoringPortSettings"));
                    break;
                }
                case 9504: {
                    RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.restoringZoning"));
                    break;
                }
                case 9507: {
                    RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.restoringNetworkParameters"));
                    break;
                }
                case 9509: {
                    RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.restoringTrapConfiguration"));
                    break;
                }
                case 9511: {
                    RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.restoringExtendedCredits"));
                    break;
                }
                case 9501: 
                case 9503: 
                case 9505: 
                case 9508: 
                case 9510: 
                case 9512: {
                    if (this.evt.isSuccessful()) {
                        RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.ok") + "\n");
                        break;
                    }
                    String string = FabricTreeControl.translateErrorType(this.evt.getErrorType());
                    if (this.evt.getEventType() != 9508) {
                        RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.failed") + string + "\n");
                        break;
                    }
                    RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.failedNetwork") + string + "\n");
                }
            }
        }
    }

    public class Restore
    implements Runnable {
        RestoreDialogSanbox2 dialog;
        String currentFile;
        boolean ipAddressRestore;
        boolean domainIdRestore;
        boolean portRestore;
        boolean networkRestore;
        boolean switchRestore;
        boolean zoningRestore;

        public Restore(RestoreDialogSanbox2 restoreDialogSanbox22, String string) {
            this.dialog = restoreDialogSanbox22;
            this.currentFile = string;
            this.ipAddressRestore = true;
            this.domainIdRestore = true;
            this.portRestore = true;
            this.networkRestore = true;
            this.switchRestore = true;
            this.zoningRestore = true;
        }

        public Restore(RestoreDialogSanbox2 restoreDialogSanbox22, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
            this.dialog = restoreDialogSanbox22;
            this.currentFile = string;
            this.ipAddressRestore = bl;
            this.domainIdRestore = bl2;
            this.portRestore = bl3;
            this.networkRestore = bl4;
            this.switchRestore = bl5;
            this.zoningRestore = bl6;
        }

        public void run() {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.parsingFile"));
                Document document = documentBuilder.parse(this.currentFile);
                RestoreDialogSanbox2.this.addMessage(FabricTreeControl.getResource("RestoreDialog.ok") + "\n");
                RestoreDialogSanbox2.this.archiver.restoreSwitch((SanboxChassis)RestoreDialogSanbox2.this.blade, document, this.ipAddressRestore, this.domainIdRestore, this.portRestore, this.networkRestore, this.switchRestore, this.zoningRestore);
            }
            catch (SAXException sAXException) {
                PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("RestoreDialog.failedParsing") + " " + this.currentFile + "\n" + sAXException.getMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("RestoreDialog.failedParsing") + " " + this.currentFile + "\n" + parserConfigurationException.getMessage());
            }
            catch (IOException iOException) {
                PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("RestoreDialog.failedParsing") + " " + this.currentFile + "\n" + iOException.getMessage());
            }
        }
    }

    public class ClearMessage
    implements Runnable {
        public void run() {
            RestoreDialogSanbox2.this.outputText.setText("");
        }
    }

    public class AddMessage
    implements Runnable {
        String str;

        public AddMessage(String string) {
            this.str = string;
        }

        public void run() {
            RestoreDialogSanbox2.this.addMessage(this.str);
        }
    }

    public class DisplayMessage
    implements Runnable {
        String str;

        DisplayMessage(String string) {
            this.str = string;
        }

        public void run() {
            JOptionPane.showMessageDialog(RestoreDialogSanbox2.this, this.str);
        }
    }

    class SwitchCheckBoxListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (RestoreDialogSanbox2.this.switchChBox.isSelected()) {
                RestoreDialogSanbox2.this.domainIdChBox.setEnabled(true);
            } else {
                RestoreDialogSanbox2.this.domainIdChBox.setEnabled(false);
                RestoreDialogSanbox2.this.domainIdChBox.setSelected(false);
            }
        }
    }

    class NetworkCheckBoxListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (RestoreDialogSanbox2.this.networkChBox.isSelected()) {
                RestoreDialogSanbox2.this.ipAddressChBox.setEnabled(true);
            } else {
                RestoreDialogSanbox2.this.ipAddressChBox.setEnabled(false);
                RestoreDialogSanbox2.this.ipAddressChBox.setSelected(false);
            }
        }
    }

    class BrowseButtonListener
    implements ActionListener {
        RestoreDialogSanbox2 theDialog = null;

        public BrowseButtonListener(RestoreDialogSanbox2 restoreDialogSanbox22) {
            this.theDialog = restoreDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = UserPreferences.getInstance().getWorkingDirectory();
            if (fileChooser.showOpenDialog(this.theDialog) == 0) {
                RestoreDialogSanbox2.this.archiveFileText.setText(fileChooser.getSelectedFile().toString());
            }
        }
    }

    class CancelRestoreButtonListener
    implements ActionListener {
        RestoreDialogSanbox2 theDialog = null;

        public CancelRestoreButtonListener(RestoreDialogSanbox2 restoreDialogSanbox22) {
            this.theDialog = restoreDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RestoreDialogSanbox2.this.blade.removeChassisEventListener((ChassisEventListener)this.theDialog);
            RestoreDialogSanbox2.this.enableButtons();
            this.theDialog.setVisible(false);
        }
    }

    class RestoreAllButtonListener
    implements ActionListener {
        RestoreDialogSanbox2 theDialog = null;

        public RestoreAllButtonListener(RestoreDialogSanbox2 restoreDialogSanbox22) {
            this.theDialog = restoreDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.restoreAll() == 1) {
                if (RestoreDialogSanbox2.this.waitingOnRestore) {
                    RestoreDialogSanbox2.this.disableButtons();
                } else {
                    RestoreDialogSanbox2.this.enableButtons();
                }
            }
        }
    }

    class SelectiveRestoreButtonListener
    implements ActionListener {
        RestoreDialogSanbox2 theDialog = null;

        public SelectiveRestoreButtonListener(RestoreDialogSanbox2 restoreDialogSanbox22) {
            this.theDialog = restoreDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.selectiveRestore() == 1) {
                if (RestoreDialogSanbox2.this.waitingOnRestore) {
                    RestoreDialogSanbox2.this.disableButtons();
                } else {
                    RestoreDialogSanbox2.this.enableButtons();
                }
            }
        }
    }
}

