/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventAdapter;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.util.Sanbox2Sml;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.PortProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.FixedLengthTextField;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PortNameDialogSanbox2
extends QDialog {
    private static final int MAX_PORT_NAME_LENGTH = 32;
    protected SanboxChassis blade = null;
    protected ChassisEventAdapter eventAdapter = null;
    protected S16Port port = null;
    protected String portName;
    protected JFrame frame = null;
    protected JPanel propertyPanel = null;
    protected JPanel buttonPanel = null;
    protected JPanel portNamePanel = null;
    protected JPanel idPanel = null;
    protected JLabel portNameLabel = null;
    protected FixedLengthTextField portNameText = null;
    protected boolean waitingOnPortNameChange = false;
    protected boolean waitingOnRequestAdmin = false;
    protected boolean waitingOnReleaseAdmin = false;
    protected PortProperties properties = new PortProperties();

    public PortNameDialogSanbox2(JFrame jFrame, boolean bl, SanboxChassis sanboxChassis, S16Port s16Port) {
        super((Frame)jFrame, bl);
        this.setTitle(FabricTreeControl.getResource("PortNameDialog.title") + " - " + VendorProperties.getFrameTitle());
        this.setResizable(false);
        this.blade = sanboxChassis;
        this.frame = jFrame;
        this.port = s16Port;
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.propertyPanel = this.createPropertyPanel();
        this.buttonPanel = this.properties.createButtonPanel(new ApplyButtonListener(this), new CancelButtonListener(this));
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.portNameDialogSanbox2Help"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.propertyPanel, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.properties.applyButton);
        this.pack();
        this.validate();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void resetDialog(SanboxChassis sanboxChassis, S16Port s16Port) {
        this.unregisterForEvents();
        this.setEnabled(true);
        this.blade = sanboxChassis;
        this.port = s16Port;
        this.eventAdapter = new ChassisEventAdapter((Object)this, (Chassis)this.blade);
        this.properties.resetIdPanel(this.blade, (FCPort)this.port);
        this.portNameText.setText(this.port.getPortName());
        this.properties.enableButtons();
    }

    protected JPanel createPropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.idPanel = this.properties.createIdPanel(this.blade, (FCPort)this.port);
        this.portNamePanel = this.createPortNamePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)this.idPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.portNamePanel, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createPortNamePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.portNameLabel = new JLabel(FabricTreeControl.getResource("PortNameDialog.title") + " ");
        this.portNameText = new FixedLengthTextField(32);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 10, 2);
        jPanel.add((Component)this.portNameLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 2, 10, 20);
        jPanel.add((Component)this.portNameText, gridBagConstraints);
        this.portNameText.setMaxLength(32);
        this.portNameText.setSize(80, this.portNameText.getHeight());
        this.portNameText.setText(this.port.getPortName());
        jPanel.setPreferredSize(new Dimension(240, 40));
        return jPanel;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.portNameLabel.setEnabled(bl);
        this.portNameText.setEnabled(bl);
    }

    protected Vector getEventList() {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(356));
        return vector;
    }

    protected void registerForEvents() {
        this.eventAdapter.registerEventHandler(357, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(238, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(237, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(235, "receiveChassisEvent");
        this.eventAdapter.registerEventHandler(264, "receiveChassisEvent");
    }

    public void receiveChassisEvent(ChassisEvent chassisEvent) {
        if (!chassisEvent.isSuccessful()) {
            this.unregisterForEvents();
        }
        SwingUtilities.invokeLater(new ApplyResponseHandler(this, chassisEvent));
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.unregisterForEvents();
            this.setVisible(false);
        }
    }

    protected void unregisterForEvents() {
        this.eventAdapter.unregisterEventHandler(357);
        this.eventAdapter.unregisterEventHandler(238);
        this.eventAdapter.unregisterEventHandler(237);
        this.eventAdapter.unregisterEventHandler(235);
        this.eventAdapter.unregisterEventHandler(264);
    }

    public String getFailedString(ErrorType errorType) {
        return "[Reason: " + FabricTreeControl.translateErrorType(errorType) + "]";
    }

    protected int applyPortName() {
        this.waitingOnPortNameChange = false;
        String string = this.portNameText.getText().trim();
        if (string.indexOf(44) != -1 || string.indexOf(59) != -1 || string.indexOf(35) != -1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("PortNameDialog.invalidString"));
            return -1;
        }
        if (string.length() < 1) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("PortNameDialog.emptyString"));
            return -1;
        }
        if (string.length() > 32) {
            PopupDialog.showDialog(this, 3, FabricTreeControl.getResource("PortNameDialog.tooLong"));
            return -1;
        }
        if (string.equals(this.portName)) {
            this.waitingOnPortNameChange = false;
            this.setVisible(false);
            return 1;
        }
        this.waitingOnPortNameChange = true;
        if (this.waitingOnPortNameChange) {
            this.registerForEvents();
            this.waitingOnRequestAdmin = true;
            ((Sanbox2Sml)this.blade).requestAdmin();
            ((Sanbox2Sml)this.blade).editConfig();
            ((Sanbox2Sml)this.blade).applyPortName(this.port.getPortNumber(), string);
            this.waitingOnReleaseAdmin = true;
            ((Sanbox2)this.blade).saveConfig();
            ((Sanbox2Sml)this.blade).activateConfigAndReleaseAdmin();
        }
        return 1;
    }

    class ApplyResponseHandler
    implements Runnable {
        ChassisEvent evt = null;
        PortNameDialogSanbox2 dialog = null;

        public ApplyResponseHandler(PortNameDialogSanbox2 portNameDialogSanbox22, ChassisEvent chassisEvent) {
            this.dialog = portNameDialogSanbox22;
            this.evt = chassisEvent;
        }

        public void run() {
            switch (this.evt.getEventType()) {
                case 238: {
                    PortNameDialogSanbox2.this.waitingOnRequestAdmin = false;
                    if (this.evt.isSuccessful()) break;
                    PortNameDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.adminFailed") + "\n" + PortNameDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    PortNameDialogSanbox2.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    return;
                }
                case 237: {
                    if (this.evt.isSuccessful()) break;
                    PortNameDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.editSwitchConfigFailed") + "\n" + PortNameDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    PortNameDialogSanbox2.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    return;
                }
                case 235: {
                    if (this.evt.isSuccessful()) break;
                    PortNameDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.saveSwitchConfigFailed") + "\n" + PortNameDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    PortNameDialogSanbox2.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    return;
                }
                case 264: {
                    PortNameDialogSanbox2.this.waitingOnReleaseAdmin = false;
                    if (!this.evt.isSuccessful()) {
                        PortNameDialogSanbox2.this.unregisterForEvents();
                        PopupDialog.showDialog(this.dialog, 3, FabricTreeControl.getResource("PortPropertiesDialog.saveAndActivateSwitchConfigFailed") + "\n" + PortNameDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                        PortNameDialogSanbox2.this.properties.enableButtons();
                        this.dialog.setVisible(false);
                        return;
                    }
                    PortNameDialogSanbox2.this.unregisterForEvents();
                    PortNameDialogSanbox2.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                    WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(PortNameDialogSanbox2.this.frame, PortNameDialogSanbox2.this.blade, PortNameDialogSanbox2.this.getEventList(), FabricTreeControl.getResource("PortPropertiesDialog.updating"));
                    waitForUpdateDialog.setVisible(true);
                    break;
                }
                case 357: {
                    PortNameDialogSanbox2.this.waitingOnPortNameChange = false;
                    if (this.evt.isSuccessful()) break;
                    PortNameDialogSanbox2.this.unregisterForEvents();
                    PopupDialog.showDialog(this.dialog, 3, "Attempt to change port name failed\n" + PortNameDialogSanbox2.this.getFailedString(this.evt.getErrorType()));
                    PortNameDialogSanbox2.this.properties.enableButtons();
                    this.dialog.setVisible(false);
                }
            }
        }
    }

    class CancelButtonListener
    implements ActionListener {
        PortNameDialogSanbox2 theDialog = null;

        public CancelButtonListener(PortNameDialogSanbox2 portNameDialogSanbox22) {
            this.theDialog = portNameDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PortNameDialogSanbox2.this.unregisterForEvents();
            PortNameDialogSanbox2.this.properties.enableButtons();
            this.theDialog.setVisible(false);
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        PortNameDialogSanbox2 theDialog = null;

        public ApplyButtonListener(PortNameDialogSanbox2 portNameDialogSanbox22) {
            this.theDialog = portNameDialogSanbox22;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.theDialog.applyPortName() == 1) {
                if (PortNameDialogSanbox2.this.waitingOnPortNameChange) {
                    PortNameDialogSanbox2.this.properties.disableButtons();
                } else {
                    PortNameDialogSanbox2.this.unregisterForEvents();
                    PortNameDialogSanbox2.this.properties.enableButtons();
                    this.theDialog.setVisible(false);
                }
            }
        }
    }
}

