/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric.propertyDialogs;

import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.Sanbox8000Blade;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.WaitForUpdateDialog;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class BladePropertiesDialog
extends QDialog
implements ChassisEventListener {
    private JPanel panel = new JPanel();
    private JButton okButton;
    private JButton cancelButton;
    private JRadioButton onlineButton;
    private JRadioButton offlineButton;
    private JRadioButton testButton;
    private ButtonGroup stateButtonGroup = new ButtonGroup();
    private JLabel bladeStatesLabel = new JLabel(FabricTreeControl.getResource("BladePropertiesDialog.bladeStatesLabel"));
    private Sanbox8000 sanbox8000;
    private Sanbox2 sb2;
    private Vector blades;
    private JFrame pFrame;

    public BladePropertiesDialog(JFrame jFrame, Sanbox8000 sanbox8000, Vector vector) {
        super((Frame)jFrame, true);
        this.pFrame = jFrame;
        this.sanbox8000 = sanbox8000;
        this.sb2 = (Sanbox2)this.sanbox8000;
        this.blades = vector;
        this.sb2.addChassisEventListener((ChassisEventListener)this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Object object;
        this.onlineButton = new JRadioButton(FabricTreeControl.getResource("BladePropertiesDialog.onlineButton"));
        this.offlineButton = new JRadioButton(FabricTreeControl.getResource("BladePropertiesDialog.offlineButton"));
        this.testButton = new JRadioButton(FabricTreeControl.getResource("BladePropertiesDialog.testButton"));
        String string = new String();
        int n = -1;
        int n2 = 0;
        while (n2 < this.blades.size()) {
            object = (Sanbox8000Blade)this.blades.elementAt(n2);
            string = string + object.toString();
            if (n2 < this.blades.size() - 1) {
                string = string + ",";
            }
            if (object.getBladeConfigState() != n) {
                n = n == -1 ? object.getBladeConfigState() : -2;
            }
            ++n2;
        }
        switch (n) {
            case 1: {
                this.offlineButton.setSelected(true);
                break;
            }
            case 0: {
                this.onlineButton.setSelected(true);
                break;
            }
            case 2: {
                this.testButton.setSelected(true);
            }
        }
        this.setTitle(FabricTreeControl.getResource("BladePropertiesDialog.titleBarText") + " " + string + " - " + VendorProperties.getFrameTitle());
        this.getContentPane().setLayout(new GridBagLayout());
        this.okButton = new JButton(new OkAction());
        this.cancelButton = new JButton(new CancelAction());
        object = new JPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout());
        ((Container)object).add(jPanel);
        this.okButton.setMnemonic('O');
        jPanel.add(this.okButton);
        this.cancelButton.setMnemonic('C');
        jPanel.add(this.cancelButton);
        jPanel.add(this.helpContextButton);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.bladePropertiesDialogHelp"));
        this.setButtonsEnabled(true);
        this.getContentPane().add((Component)this.createPortStatesPanel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.getContentPane().add((Component)object, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.validate();
        this.setResizable(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public JPanel createPortStatesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.stateButtonGroup.add(this.onlineButton);
        this.stateButtonGroup.add(this.offlineButton);
        this.stateButtonGroup.add(this.testButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 10);
        jPanel.add((Component)this.bladeStatesLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 7);
        jPanel.add((Component)this.onlineButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.offlineButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.testButton, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        return jPanel;
    }

    private String translateTestStatus(int n) {
        switch (n) {
            case 4: {
                return FabricTreeControl.getResource("BladePropertiesDialog.testStatusFailed");
            }
            case 3: {
                return FabricTreeControl.getResource("BladePropertiesDialog.testStatusPassed");
            }
            case 1: {
                return FabricTreeControl.getResource("BladePropertiesDialog.testStatusReady");
            }
            case 2: {
                return FabricTreeControl.getResource("BladePropertiesDialog.testStatusTesting");
            }
        }
        return FabricTreeControl.getResource("BladePropertiesDialog.testStatusUnknown");
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        switch (chassisEvent.getEventType()) {
            case 342: {
                if (!chassisEvent.isSuccessful()) {
                    SwingUtilities.invokeLater(new DisplayMessage(FabricTreeControl.getResource("BladePropertiesDialog.failedToSetAdminState") + FabricTreeControl.translateErrorType(chassisEvent.getErrorType())));
                    this.setButtonsEnabled(true);
                    break;
                }
                SwingUtilities.invokeLater(new CloseDialog());
            }
        }
    }

    private void setButtonsEnabled(boolean bl) {
        SwingUtilities.invokeLater(new SetButtonsEnabled(bl));
    }

    private class SetButtonsEnabled
    implements Runnable {
        private boolean enabled;

        public SetButtonsEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void run() {
            BladePropertiesDialog.this.cancelButton.setEnabled(this.enabled);
            BladePropertiesDialog.this.okButton.setEnabled(this.enabled);
        }
    }

    public class CloseDialog
    implements Runnable {
        public void run() {
            BladePropertiesDialog.this.setVisible(false);
            BladePropertiesDialog.this.sanbox8000.removeChassisEventListener((ChassisEventListener)BladePropertiesDialog.this);
            Vector<Integer> vector = new Vector<Integer>();
            vector.add(new Integer(330));
            WaitForUpdateDialog waitForUpdateDialog = WaitForUpdateDialog.getInstance(BladePropertiesDialog.this.pFrame, (SanboxChassis)BladePropertiesDialog.this.sanbox8000, vector, FabricTreeControl.getResource("BladePropertiesDialog.waitingForUpdate"));
            waitForUpdateDialog.setVisible(true);
        }
    }

    public class DisplayMessage
    implements Runnable {
        String str;

        DisplayMessage(String string) {
            this.str = string;
        }

        public void run() {
            JOptionPane.showMessageDialog(BladePropertiesDialog.this, this.str);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(FabricTreeControl.getResource("BladePropertiesDialog.cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BladePropertiesDialog.this.setVisible(false);
            BladePropertiesDialog.this.sanbox8000.removeChassisEventListener((ChassisEventListener)BladePropertiesDialog.this);
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super(FabricTreeControl.getResource("BladePropertiesDialog.ok"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BladePropertiesDialog.this.onlineButton.isSelected()) {
                n = 0;
            } else if (BladePropertiesDialog.this.offlineButton.isSelected()) {
                n = 1;
            } else if (BladePropertiesDialog.this.testButton.isSelected()) {
                n = 2;
            } else {
                return;
            }
            BladePropertiesDialog.this.sanbox8000.applyBladeConfigAdminStates(BladePropertiesDialog.this.blades, n);
            BladePropertiesDialog.this.setButtonsEnabled(false);
        }
    }
}

