/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.util.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class UserPreferences {
    public static final String HEADER = "User Defined Properties";
    public static final String PROPERTY_FILE_NAME = "fc_user.properties";
    public static final String WORKING_DIR = "workingDir";
    public static final String BROWSER_PATH = "browserPath";
    public static final String POLLING_LEVEL = "pollingLevel";
    public static final String AUTO_SAVE_LOAD = "autoSaveLoad";
    public static final String PORT_VIEW = "portView";
    public static final String START_UP_DIALOG = "startUpDialog";
    public static final String EVENT_BROWSER = "eventBrowser";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final int POLL_RAPID = 1;
    public static final int POLL_MEDIUM = 2;
    public static final int POLL_SLOW = 3;
    public static final float POLL_RAPID_MULTIPLIER = 1.0f;
    public static final float POLL_MEDIUM_MULTIPLIER = 1.5f;
    public static final float POLL_SLOW_MULTIPLIER = 2.0f;
    public static final String PORT_VIEW_MODES = "modes";
    public static final String PORT_VIEW_STATES = "states";
    public static final String PORT_VIEW_SPEEDS = "speeds";
    public static final String PORT_VIEW_MEDIA = "media";
    public static final String LAYOUT_DISABLE_ALL = "layout.disableAll";
    public static final String LAYOUT_SCREEN_LOC = "layout.screenLocation";
    public static final String LAYOUT_SCREEN_X = "layout.screenLocation.x";
    public static final String LAYOUT_SCREEN_Y = "layout.screenLocation.y";
    public static final String LAYOUT_WINDOW_SIZE = "layout.windowSize";
    public static final String LAYOUT_WINDOW_WIDTH = "layout.windowSize.width";
    public static final String LAYOUT_WINDOW_HEIGHT = "layout.windowSize.height";
    public static final String LAYOUT_SPLITTER_BAR = "layout.splitterBar";
    public static final String LAYOUT_SPLITTER_BAR_LOC = "layout.splitterBar.loc";
    protected String userHomeDirname = System.getProperty("user.home");
    protected String browserPath = System.getProperty("node.browser.location");
    protected String propertyFilename = this.userHomeDirname + File.separator + "fc_user.properties";
    protected File propertyFile = new File(this.propertyFilename);
    protected Properties defaultProperties = this.getDefaultProperties();
    protected Properties userProperties = null;
    private static UserPreferences userPreferences;

    private UserPreferences() {
    }

    public static UserPreferences getInstance() {
        if (userPreferences == null) {
            userPreferences = new UserPreferences();
            userPreferences.init();
        }
        FabricList fabricList = FabricList.getInstance();
        FabricList.setPollingLevelMultiplier((float)userPreferences.getPollingLevelMultiplier());
        return userPreferences;
    }

    public void init() {
        if (this.propertyFile != null && this.propertyFile.exists()) {
            this.userProperties = new Properties(this.defaultProperties);
            try {
                this.userProperties.load(new BufferedInputStream(new FileInputStream(this.propertyFilename)));
            }
            catch (IOException iOException) {
                this.userProperties = this.defaultProperties;
            }
        } else {
            this.userProperties = this.defaultProperties;
        }
    }

    public void write() throws IOException {
        if (!this.propertyFile.exists()) {
            this.propertyFile.createNewFile();
        }
        this.userProperties.store(new BufferedOutputStream(new FileOutputStream(this.propertyFile)), HEADER);
        Utilities.setProperty((String)"node.browser.location", (String)Utilities.removePathSeperator((String)this.userProperties.getProperty(BROWSER_PATH)));
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    public String getWorkingDirectory() {
        String string = null;
        if (this.userProperties != null) {
            string = this.userProperties.getProperty(WORKING_DIR);
            if (string == null) {
                string = this.userHomeDirname;
            }
        } else {
            string = this.defaultProperties.getProperty(WORKING_DIR);
        }
        return string;
    }

    public String getPropertyFilename() {
        return this.propertyFilename;
    }

    public String getBrowserPath() {
        String string = null;
        if (this.userProperties != null) {
            string = this.userProperties.getProperty(BROWSER_PATH);
            if (string == null) {
                string = this.browserPath;
            }
        } else {
            string = this.defaultProperties.getProperty(BROWSER_PATH);
        }
        return string;
    }

    public int getPollingLevel() {
        int n = 1;
        if (this.userProperties != null) {
            try {
                n = Integer.parseInt(this.userProperties.getProperty(POLLING_LEVEL));
            }
            catch (Exception exception) {
                n = 1;
            }
        } else {
            n = Integer.parseInt(this.defaultProperties.getProperty(POLLING_LEVEL));
        }
        return n;
    }

    public float getPollingLevelMultiplier() {
        float f;
        int n = 1;
        if (this.userProperties != null) {
            try {
                n = Integer.parseInt(this.userProperties.getProperty(POLLING_LEVEL));
            }
            catch (Exception exception) {
                n = 1;
            }
        } else {
            n = Integer.parseInt(this.defaultProperties.getProperty(POLLING_LEVEL));
        }
        switch (n) {
            case 1: {
                f = 1.0f;
                break;
            }
            case 2: {
                f = 1.5f;
                break;
            }
            case 3: {
                f = 2.0f;
                break;
            }
            default: {
                f = 1.0f;
            }
        }
        return f;
    }

    public boolean isEventBrowserEnabled() {
        String string = null;
        if (this.userProperties != null) {
            string = this.userProperties.getProperty(EVENT_BROWSER);
            if (string == null) {
                string = TRUE;
            }
        } else {
            string = this.defaultProperties.getProperty(EVENT_BROWSER);
        }
        return string.equals(TRUE);
    }

    public boolean isAutoSaveLoadEnabled() {
        String string = null;
        if (this.userProperties != null) {
            string = this.userProperties.getProperty(AUTO_SAVE_LOAD);
            if (string == null) {
                string = TRUE;
            }
        } else {
            string = this.defaultProperties.getProperty(AUTO_SAVE_LOAD);
        }
        return string.equals(TRUE);
    }

    public boolean isStartUpDialogEnabled() {
        String string = null;
        if (this.userProperties != null) {
            string = this.userProperties.getProperty(START_UP_DIALOG);
            if (string == null) {
                string = TRUE;
            }
        } else {
            string = this.defaultProperties.getProperty(START_UP_DIALOG);
        }
        return string.equals(TRUE);
    }

    public String getPortView() {
        String string = "";
        if (this.userProperties != null) {
            string = this.userProperties.getProperty(PORT_VIEW);
            if (string == null) {
                string = PORT_VIEW_MODES;
            }
        } else {
            string = this.defaultProperties.getProperty(PORT_VIEW);
        }
        return string;
    }

    protected Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty(WORKING_DIR, this.userHomeDirname);
        properties.setProperty(BROWSER_PATH, this.browserPath);
        properties.setProperty(POLLING_LEVEL, Integer.toString(1));
        properties.setProperty(AUTO_SAVE_LOAD, TRUE);
        properties.setProperty(PORT_VIEW, PORT_VIEW_MODES);
        properties.setProperty(START_UP_DIALOG, TRUE);
        properties.setProperty(EVENT_BROWSER, TRUE);
        return properties;
    }
}

