/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.FixedLengthTextField;
import com.qlogic.ui.QDialog;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class TrapConfigDialogSanbox2
extends QDialog
implements ChassisEventListener {
    private Sanbox2 sanbox2;
    public static final int OK_OPTION = 1;
    public static final int CANCEL_OPTION = 2;
    private int option = 1;
    JPanel dataPanel;
    GridBagLayout dataLayout;
    JLabel trapsEnableLabel;
    JCheckBox trapsEnableBox;
    JLabel trapNameLabel;
    JComboBox trapNameComboBox;
    int lastTrapName = -1;
    JLabel risingLabel;
    FixedLengthTextField risingTextField;
    JLabel fallingLabel;
    FixedLengthTextField fallingTextField;
    JLabel enableLabel;
    JCheckBox enableBox;
    JLabel sampleIntervalLabel;
    FixedLengthTextField sampleIntervalTextField;
    JPanel buttonPanel;
    GridLayout buttonLayout;
    JButton okItemButton;
    JButton cancelButton;
    GridBagLayout newFabricLayout;
    String nameStr;
    Frame parentFrame;

    public TrapConfigDialogSanbox2(Frame frame, Sanbox2 sanbox2) {
        super(frame);
        this.parentFrame = frame;
        this.sanbox2 = sanbox2;
        try {
            this.jbInit();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        if (this.sanbox2.getNumberOfTraps() == 0) {
            JOptionPane.showMessageDialog(this, FabricTreeControl.getResource("TrapConfigDialogSanbox2.mustWait"));
            this.setVisible(false);
            return;
        }
        this.setTitle(FabricTreeControl.getResource("TrapConfigDialogSanbox2.titleBarText") + " - " + VendorProperties.getFrameTitle());
        this.sanbox2.setEditingTrapConfig(true);
        this.sanbox2.addChassisEventListener((ChassisEventListener)this);
        this.setModal(true);
        this.dataPanel = new JPanel();
        this.dataLayout = new GridBagLayout();
        this.trapsEnableLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialogSanbox2.enableAll"));
        this.trapsEnableBox = new JCheckBox();
        this.trapNameLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialogSanbox2.trap"));
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.sanbox2.getNumberOfTraps()) {
            vector.add(this.getTrapDef(n));
            ++n;
        }
        this.trapNameComboBox = new JComboBox(vector);
        this.trapNameComboBox.addActionListener(new MyComboBoxListener());
        this.risingLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialog.risingThresh"));
        this.risingTextField = new FixedLengthTextField(4);
        this.fallingLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialog.fallingThresh"));
        this.fallingTextField = new FixedLengthTextField(4);
        this.enableLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialog.enable"));
        this.enableBox = new JCheckBox();
        this.sampleIntervalLabel = new JLabel(FabricTreeControl.getResource("TrapConfigDialogSanbox2.sampleInterval"));
        this.sampleIntervalTextField = new FixedLengthTextField(4);
        this.buttonPanel = new JPanel();
        this.buttonLayout = new GridLayout(1, 2, 8, 0);
        this.okItemButton = new JButton(new OkItemAction());
        this.cancelButton = new JButton(new CancelAction());
        this.newFabricLayout = new GridBagLayout();
        this.getContentPane().setLayout(this.newFabricLayout);
        this.trapNameLabel.setPreferredSize(new Dimension(160, 21));
        this.dataPanel.setLayout(this.dataLayout);
        this.dataPanel.add((Component)this.trapsEnableLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.trapsEnableBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.trapNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.trapNameComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(20, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.enableLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.enableBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.risingLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.risingTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.fallingLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.fallingTextField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.dataPanel.add((Component)this.sampleIntervalLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 4, 4), 0, 0));
        this.dataPanel.add((Component)this.sampleIntervalTextField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0));
        this.getContentPane().add((Component)this.dataPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.buttonPanel.setLayout(this.buttonLayout);
        this.buttonPanel.add((Component)this.okItemButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.trapConfigDialogSanbox2Help"));
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.getRootPane().setDefaultButton(this.okItemButton);
        this.fillTrapData(0);
        this.trapsEnableBox.setSelected(this.sanbox2.getTrapsEnabled());
        this.pack();
        this.trapNameLabel.requestFocus();
    }

    private String getTrapDef(int n) {
        switch (n) {
            case 0: {
                return FabricTreeControl.getResource("TrapConfigDialogSanbox2.crcErrors");
            }
            case 1: {
                return FabricTreeControl.getResource("TrapConfigDialogSanbox2.decodeErrors");
            }
            case 2: {
                return FabricTreeControl.getResource("TrapConfigDialogSanbox2.islMonitoring");
            }
            case 3: {
                return FabricTreeControl.getResource("TrapConfigDialogSanbox2.loginMonitoring");
            }
            case 4: {
                return FabricTreeControl.getResource("TrapConfigDialogSanbox2.logoutMonitoring");
            }
            case 5: {
                return FabricTreeControl.getResource("TrapConfigDialogSanbox2.losMonitoring");
            }
        }
        return null;
    }

    public int getOption() {
        return this.option;
    }

    private boolean takeTrapData(int n) {
        if (n >= 0) {
            int n2 = 0;
            boolean bl = true;
            try {
                n2 = Integer.parseInt("0" + this.risingTextField.getText());
            }
            catch (Exception exception) {
                bl = false;
            }
            if (n2 < 1 || n2 > 1000) {
                bl = false;
            }
            if (!bl) {
                PopupDialog.showDialog(this.parentFrame, 3, FabricTreeControl.getResource("TrapConfigDialogSanbox2.invalidRisingThresh"));
                return false;
            }
            int n3 = 0;
            try {
                n3 = Integer.parseInt("0" + this.fallingTextField.getText());
            }
            catch (Exception exception) {
                bl = false;
            }
            if (n3 < 0 || n3 > 1000) {
                bl = false;
            }
            if (!bl) {
                PopupDialog.showDialog(this.parentFrame, 3, FabricTreeControl.getResource("TrapConfigDialogSanbox2.invalidFallingThresh"));
                return false;
            }
            boolean bl2 = this.enableBox.isSelected();
            boolean bl3 = this.trapsEnableBox.isSelected();
            int n4 = 0;
            try {
                n4 = Integer.parseInt("0" + this.sampleIntervalTextField.getText());
            }
            catch (Exception exception) {
                bl = false;
            }
            if (n4 < 1 || n4 > 1000) {
                bl = false;
            }
            if (!bl) {
                PopupDialog.showDialog(this.parentFrame, 3, FabricTreeControl.getResource("TrapConfigDialogSanbox2.invalidSampleInterval"));
                return false;
            }
            this.sanbox2.setTrapsEnabled(bl3);
            this.sanbox2.setTrapConfig(n, n2, n3, n4, bl2);
            return bl;
        }
        return false;
    }

    private void fillTrapData(int n) {
        if (n >= 0) {
            this.enableBox.setSelected(this.sanbox2.getTrapEnable(n));
            this.sampleIntervalTextField.setText(Integer.toString(this.sanbox2.getTrapSampleInterval(n)));
            this.risingTextField.setText(Integer.toString(this.sanbox2.getTrapRisingThreadhold(n)));
            this.fallingTextField.setText(Integer.toString(this.sanbox2.getTrapFallingThreadhold(n)));
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getChassis() != this.sanbox2) {
            chassisEvent.getChassis().getEventHandler().removeChassisEventListener((ChassisEventListener)this);
            return;
        }
        if (chassisEvent.getEventType() == 275) {
            SwingUtilities.invokeLater(new ApplyDoneClass(chassisEvent));
        }
    }

    private void setControlsEnabled(boolean bl) {
        this.okItemButton.setEnabled(bl);
        this.cancelButton.setEnabled(bl);
        this.trapNameComboBox.setEnabled(bl);
        this.trapsEnableBox.setEnabled(bl);
        this.risingTextField.setEnabled(bl);
        this.fallingTextField.setEnabled(bl);
        this.enableBox.setEnabled(bl);
        this.sampleIntervalTextField.setEnabled(bl);
    }

    private void shutdownDialog() {
        this.sanbox2.setEditingTrapConfig(false);
        this.sanbox2.removeChassisEventListener((ChassisEventListener)this);
        this.sanbox2.updateTrapInfo();
        this.setVisible(false);
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(FabricTreeControl.getResource("TrapConfigDialog.cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TrapConfigDialogSanbox2.this.option = 2;
            TrapConfigDialogSanbox2.this.shutdownDialog();
        }
    }

    class OkItemAction
    extends AbstractAction {
        public OkItemAction() {
            super(FabricTreeControl.getResource("TrapConfigDialog.ok"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = TrapConfigDialogSanbox2.this.trapNameComboBox.getSelectedIndex();
            if (n < 0) {
                PopupDialog.showDialog(TrapConfigDialogSanbox2.this.parentFrame, 3, FabricTreeControl.getResource("TrapConfigDialogSanbox2.invalidTrapSelection"));
                return;
            }
            if (TrapConfigDialogSanbox2.this.takeTrapData(n)) {
                TrapConfigDialogSanbox2.this.option = 1;
                TrapConfigDialogSanbox2.this.setControlsEnabled(false);
                TrapConfigDialogSanbox2.this.sanbox2.applyTrapConfig();
            }
        }
    }

    class MyComboBoxListener
    implements ActionListener {
        int lastIndex = 0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (TrapConfigDialogSanbox2.this.takeTrapData(this.lastIndex)) {
                this.lastIndex = TrapConfigDialogSanbox2.this.trapNameComboBox.getSelectedIndex();
                if (this.lastIndex >= 0) {
                    TrapConfigDialogSanbox2.this.fillTrapData(this.lastIndex);
                }
            } else {
                TrapConfigDialogSanbox2.this.trapNameComboBox.setSelectedIndex(this.lastIndex);
            }
        }
    }

    class ApplyDoneClass
    implements Runnable {
        ChassisEvent evt;

        public ApplyDoneClass(ChassisEvent chassisEvent) {
            this.evt = chassisEvent;
        }

        public void run() {
            TrapConfigDialogSanbox2.this.setControlsEnabled(true);
            if (this.evt.isSuccessful()) {
                JOptionPane.showMessageDialog(TrapConfigDialogSanbox2.this, FabricTreeControl.getResource("TrapConfigDialogSanbox2.trapConfiguredOk"));
                TrapConfigDialogSanbox2.this.shutdownDialog();
            } else {
                JOptionPane.showMessageDialog(TrapConfigDialogSanbox2.this, FabricTreeControl.getResource("TrapConfigDialogSanbox2.trapConfigureFailed") + " " + FabricTreeControl.translateErrorType(this.evt.getErrorType()));
            }
        }
    }
}

