/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.qms.fabric.ComDisplayPanel;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.LinkDisplayPanel;
import com.qlogic.qms.fabric.NameServerPanel;
import com.qlogic.qms.fabric.NotificationPanel;
import com.qlogic.qms.fabric.SwitchDisplayPanel;
import com.qlogic.qms.fabric.ZoningPanel;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TopologyTabPanel
extends JPanel
implements ChassisEventListener,
FabricEventListener,
ChangeListener {
    private static final String notStr = new String("Notifications");
    public SwitchDisplayPanel switchDisplayPanel;
    public LinkDisplayPanel linkDisplayPanel;
    public NameServerPanel nameServerPanel;
    public ComDisplayPanel comDisplayPanel;
    public NotificationPanel notifyPanel;
    public HashMap notifyPanels = new HashMap();
    public ZoningPanel activeZoningPanel;
    public ComAgent agent;
    public Fabric fabric;
    JTabbedPane tabbedPane;
    SanboxChassis chassis;
    private static final String activeZoneSetStr = FabricTreeControl.getResource("FaceplateTabPanel.activeZoneSet");

    public TopologyTabPanel(Vector vector, ComAgent comAgent, Fabric fabric) {
        this.activeZoningPanel = new ZoningPanel(fabric, null, false, true, null);
        this.agent = comAgent;
        try {
            this.jbInit(vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setFabric(fabric);
    }

    public NameServerPanel getNameServerPanel() {
        return this.nameServerPanel;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        FabricTreeControl fabricTreeControl = FabricTreeControl.instance();
        fabricTreeControl.setStatusBarText("");
    }

    public void setFabric(Fabric fabric) {
        this.assignNotifyPanel(fabric);
        if (this.chassis != null) {
            this.chassis.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
        }
        if (this.fabric != null) {
            this.fabric.removeEventListener((FabricEventListener)this);
        }
        this.fabric = fabric;
        boolean bl = false;
        if (this.fabric != null) {
            this.fabric.addEventListener((FabricEventListener)this);
            this.linkDisplayPanel.setFabric(this.fabric);
            SanboxChassis sanboxChassis = this.fabric.getConnectionSwitch();
            if (sanboxChassis != null && sanboxChassis instanceof SanboxChassis) {
                this.chassis = sanboxChassis;
                this.chassis.getEventHandler().addChassisEventListener((ChassisEventListener)this);
                this.activeZoningPanel.setZones(this.fabric, this.chassis.getActiveEportZoning());
                bl = true;
            }
        }
        if (!bl) {
            this.activeZoningPanel.setZones(null, null);
        }
    }

    private void jbInit(Vector vector) throws Exception {
        this.linkDisplayPanel = new LinkDisplayPanel();
        this.switchDisplayPanel = new SwitchDisplayPanel(vector);
        this.nameServerPanel = new NameServerPanel();
        this.tabbedPane = new JTabbedPane(3);
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.addTab(FabricTreeControl.getResource("TopologyTabPanel.nameServer"), null, this.nameServerPanel, FabricTreeControl.getResource("TopologyTabPanel.nameServerTT"));
        this.tabbedPane.addTab(activeZoneSetStr, null, this.activeZoningPanel, activeZoneSetStr);
        this.tabbedPane.addTab(FabricTreeControl.getResource("TopologyTabPanel.switch"), null, this.switchDisplayPanel, FabricTreeControl.getResource("TopologyTabPanel.switchTT"));
        this.tabbedPane.addTab(FabricTreeControl.getResource("TopologyTabPanel.link"), null, new JScrollPane(this.linkDisplayPanel), FabricTreeControl.getResource("TopologyTabPanel.linkTT"));
        String string = System.getProperty("monitor");
        if (string != null) {
            this.comDisplayPanel = new ComDisplayPanel(this.agent);
            this.tabbedPane.addTab("Com agent", null, new JScrollPane(this.comDisplayPanel), "Com display");
        }
        this.assignNotifyPanel(this.fabric);
        this.agent = null;
        this.tabbedPane.setSelectedIndex(0);
        this.setLayout(new GridLayout(1, 1));
        this.doLayout();
        this.add(this.tabbedPane);
    }

    private void assignNotifyPanel(Fabric fabric) {
        String string = System.getProperty("monitor");
        if (string != null) {
            int n = this.tabbedPane.getSelectedIndex();
            int n2 = this.tabbedPane.indexOfTab(notStr);
            if (n2 >= 0) {
                this.tabbedPane.remove(n2);
            }
            if (fabric != null) {
                this.notifyPanel = (NotificationPanel)this.notifyPanels.get(fabric);
                if (this.notifyPanel == null) {
                    this.notifyPanel = new NotificationPanel(fabric);
                    this.notifyPanels.put(fabric, this.notifyPanel);
                }
                this.tabbedPane.addTab(notStr, null, new JScrollPane(this.notifyPanel), "Notifications");
            }
            this.tabbedPane.setSelectedIndex(n);
        }
    }

    public void receiveEvent(FabricEvent fabricEvent) {
        if (fabricEvent.getEventType() == 2002) {
            this.setFabric(this.fabric);
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getChassis() != this.chassis) {
            chassisEvent.getChassis().getEventHandler().removeChassisEventListener((ChassisEventListener)this);
            return;
        }
        if (chassisEvent.getEventType() == 219) {
            this.activeZoningPanel.repaint();
        }
        if (chassisEvent.getEventType() == 377 && chassisEvent.getChassis() instanceof SanboxChassis) {
            SanboxChassis sanboxChassis = (SanboxChassis)chassisEvent.getChassis();
            this.activeZoningPanel.setZones(this.fabric, sanboxChassis.getActiveEportZoning());
            this.repaint();
        }
    }

    public void setComAgent(ComAgent comAgent) {
        if (this.comDisplayPanel != null) {
            this.comDisplayPanel.setAgent(comAgent);
        }
    }

    public void setSelectedSwitches(Vector vector) {
        this.switchDisplayPanel.setSwitchList(vector);
        this.nameServerPanel.setSwitchList(vector);
    }

    public void setSelectedLinks(Vector vector) {
        this.linkDisplayPanel.setLinkList(vector);
    }
}

