/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Director;
import com.qlogic.device.fcfabric.ForeignSwitch;
import com.qlogic.device.fcfabric.IPHost;
import com.qlogic.device.fcfabric.IPInfo;
import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.Status;
import com.qlogic.device.fcfabric.SwitchBlade;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.device.fcfabric.zoning.ZoningConfig;
import com.qlogic.qms.fabric.FabricTableModel;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.ui.tools.SmartScrollingTable;
import com.qlogic.util.StringUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.net.InetAddress;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class SwitchDisplayPanel
extends JPanel
implements ChassisEventListener {
    private static final int STATUS_ROW = 2;
    private static final String[] rowLabels = new String[]{FabricTreeControl.getResource("SwitchDisplayPanel.fcAddress"), FabricTreeControl.getResource("SwitchDisplayPanel.wwn"), FabricTreeControl.getResource("SwitchDisplayPanel.reasonForStatus"), FabricTreeControl.getResource("SwitchDisplayPanel.userName"), FabricTreeControl.getResource("SwitchDisplayPanel.loginLevel"), FabricTreeControl.getResource("SwitchDisplayPanel.securityEnabled"), FabricTreeControl.getResource("SwitchDisplayPanel.vendor"), FabricTreeControl.getResource("SwitchDisplayPanel.flashVer"), FabricTreeControl.getResource("SwitchDisplayPanel.inactiveFlashVer"), FabricTreeControl.getResource("SwitchDisplayPanel.pendingFlashVer"), FabricTreeControl.getResource("SwitchDisplayPanel.promVer"), FabricTreeControl.getResource("SwitchDisplayPanel.macAddr"), FabricTreeControl.getResource("SwitchDisplayPanel.ipAddr"), FabricTreeControl.getResource("SwitchDisplayPanel.mask"), FabricTreeControl.getResource("SwitchDisplayPanel.gateway"), FabricTreeControl.getResource("SwitchDisplayPanel.negDomainId"), FabricTreeControl.getResource("SwitchDisplayPanel.configDomainId"), FabricTreeControl.getResource("SwitchDisplayPanel.domainLock"), FabricTreeControl.getResource("SwitchDisplayPanel.numberOfPorts"), FabricTreeControl.getResource("SwitchDisplayPanel.switchType"), FabricTreeControl.getResource("SwitchDisplayPanel.opState"), FabricTreeControl.getResource("SwitchDisplayPanel.adminState"), FabricTreeControl.getResource("SwitchDisplayPanel.configAdminState"), FabricTreeControl.getResource("SwitchDisplayPanel.raTimeout"), FabricTreeControl.getResource("SwitchDisplayPanel.edTimeout"), FabricTreeControl.getResource("SwitchDisplayPanel.mergeMode"), FabricTreeControl.getResource("SwitchDisplayPanel.legacyAddressFormat"), FabricTreeControl.getResource("SwitchDisplayPanel.zoningAutoSave"), FabricTreeControl.getResource("SwitchDisplayPanel.ZoningDefVis"), FabricTreeControl.getResource("SwitchDisplayPanel.temp"), FabricTreeControl.getResource("SwitchDisplayPanel.fan1"), FabricTreeControl.getResource("SwitchDisplayPanel.fan2"), FabricTreeControl.getResource("SwitchDisplayPanel.fan3"), FabricTreeControl.getResource("SwitchDisplayPanel.ps1Status"), FabricTreeControl.getResource("SwitchDisplayPanel.ps2Status"), FabricTreeControl.getResource("SwitchDisplayPanel.beaconStatus"), FabricTreeControl.getResource("SwitchDisplayPanel.broadcastSupport"), FabricTreeControl.getResource("SwitchDisplayPanel.inbandEnabled"), FabricTreeControl.getResource("SwitchDisplayPanel.tempMonEnabled"), FabricTreeControl.getResource("SwitchDisplayPanel.warningTemp"), FabricTreeControl.getResource("SwitchDisplayPanel.failureTemp")};
    FabricTableModel model = new FabricTableModel();
    JTable table = new SmartScrollingTable((TableModel)this.model);
    Vector switchList;
    static /* synthetic */ Class class$java$lang$Object;

    public SwitchDisplayPanel(Vector vector) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setSwitchList(vector);
    }

    private void jbInit() throws Exception {
        this.table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = SwitchDisplayPanel.class$("java.lang.Object")) : class$java$lang$Object, new QTableCellRenderer());
        this.table.getColumnModel().setColumnSelectionAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.setLayout(new GridLayout(1, 1));
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.add(new JScrollPane(this.table));
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        Chassis chassis = chassisEvent.getChassis();
        switch (chassisEvent.getEventType()) {
            case 200: 
            case 201: 
            case 203: 
            case 204: 
            case 206: 
            case 208: 
            case 209: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 230: 
            case 232: 
            case 240: 
            case 244: 
            case 246: 
            case 248: 
            case 249: 
            case 253: 
            case 261: 
            case 262: 
            case 263: 
            case 286: 
            case 293: 
            case 294: 
            case 295: 
            case 297: 
            case 299: 
            case 306: 
            case 307: 
            case 309: 
            case 311: 
            case 312: 
            case 316: 
            case 332: 
            case 337: 
            case 348: 
            case 359: {
                SwingUtilities.invokeLater(new UpdateTableClass(chassis));
            }
        }
    }

    public void setSwitchList(Vector vector) {
        int n;
        if (this.switchList != null) {
            n = 0;
            while (n < this.switchList.size()) {
                Chassis chassis = (Chassis)this.switchList.elementAt(n);
                chassis.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
                ++n;
            }
        }
        if (vector == null) {
            this.switchList = null;
        } else {
            this.switchList = new Vector();
            n = 0;
            while (n < vector.size()) {
                if (vector.elementAt(n) instanceof Chassis) {
                    this.switchList.add(vector.elementAt(n));
                }
                ++n;
            }
        }
        SwingUtilities.invokeLater(new UpdateTableClass());
    }

    public void updateTable(Chassis chassis) {
        if (chassis == null) {
            this.model.setColumnCount(0);
            this.model.addColumn("   " + FabricTreeControl.getResource("SwitchDisplayPanel.field") + "     ");
            if (this.switchList.size() > 0) {
                Chassis chassis2 = (Chassis)this.switchList.elementAt(0);
            }
            this.fillSwitchFirstCol();
            if (this.switchList != null) {
                int n = 0;
                while (n < this.switchList.size()) {
                    Chassis chassis3 = (Chassis)this.switchList.elementAt(n);
                    chassis3.getEventHandler().addChassisEventListener((ChassisEventListener)this);
                    this.updateChassisCol(chassis3);
                    ++n;
                }
            }
        } else {
            this.updateChassisCol(chassis);
        }
        this.repaint();
    }

    private void updateChassisCol(Chassis chassis) {
        Object object = this.getChassisKey(chassis);
        int n = -1;
        int n2 = 0;
        while (n2 < this.model.getColumnCount()) {
            Object object2 = this.model.getColumnKey(n2);
            if (object2.equals(object)) {
                n = n2;
                break;
            }
            ++n2;
        }
        this.fillChassisCol(chassis, n);
    }

    private String formatFabricAddr(String string) {
        return null;
    }

    private String formatDateString(String string) {
        int n;
        int n2;
        boolean bl;
        int n3;
        int n4;
        int n5;
        if (string.equals("Unknown") || string.length() != 12) {
            return FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
        }
        String string2 = string.substring(0, 2);
        String string3 = string.substring(2, 4);
        String string4 = string.substring(4, 6);
        String string5 = string.substring(6, 8);
        String string6 = string.substring(8);
        try {
            n5 = Integer.parseInt(string2);
            n4 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
            bl = n3 <= 12;
            n3 = n3 > 12 ? n3 - 12 : n3;
            n2 = Integer.parseInt(string5);
            n = Integer.parseInt(string6);
        }
        catch (NumberFormatException numberFormatException) {
            return FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (n5) {
            case 1: {
                stringBuffer.append("January");
                break;
            }
            case 2: {
                stringBuffer.append("February");
                break;
            }
            case 3: {
                stringBuffer.append("March");
                break;
            }
            case 4: {
                stringBuffer.append("April");
                break;
            }
            case 5: {
                stringBuffer.append("May");
                break;
            }
            case 6: {
                stringBuffer.append("June");
                break;
            }
            case 7: {
                stringBuffer.append("July");
                break;
            }
            case 8: {
                stringBuffer.append("August");
                break;
            }
            case 9: {
                stringBuffer.append("September");
                break;
            }
            case 10: {
                stringBuffer.append("October");
                break;
            }
            case 11: {
                stringBuffer.append("November");
                break;
            }
            case 12: {
                stringBuffer.append("December");
            }
        }
        stringBuffer.append(" " + Integer.toString(n4));
        if (n3 < 10) {
            stringBuffer.append(" 0" + Integer.toString(n3) + ":");
        } else {
            stringBuffer.append(" " + Integer.toString(n3) + ":");
        }
        if (n2 < 10) {
            stringBuffer.append("0" + Integer.toString(n2));
        } else {
            stringBuffer.append(Integer.toString(n2));
        }
        stringBuffer.append(bl ? " am" : " pm");
        stringBuffer.append(" " + Integer.toString(n));
        return stringBuffer.toString();
    }

    private void fillSwitchFirstCol() {
        this.model.setRowCount(rowLabels.length);
        int n = 0;
        while (n < rowLabels.length) {
            this.setValue(this.model, rowLabels[n], n, 0);
            ++n;
        }
    }

    private Object getChassisKey(Chassis chassis) {
        return chassis.getWWName();
    }

    private void fillChassisCol(Chassis chassis, int n) {
        Object object;
        Object object2;
        String string;
        SanboxChassis sanboxChassis;
        int n2;
        boolean bl = false;
        if (n < 0) {
            this.model.addColumn((Object)chassis.toString(), this.getChassisKey(chassis));
            n = this.model.getColumnCount() - 1;
            bl = true;
        } else if (!this.model.getColumnName(n).equals(chassis.toString())) {
            Vector<String> vector = new Vector<String>();
            n2 = 0;
            while (n2 < this.model.getColumnCount()) {
                if (n2 == n) {
                    vector.add(chassis.toString());
                } else {
                    vector.add(this.model.getColumnName(n2));
                }
                ++n2;
            }
            this.model.setColumnIdentifiers(vector);
        }
        int n3 = chassis.getOverallStatus();
        n2 = 0;
        if (chassis instanceof SanboxChassis) {
            String string2;
            String string3;
            String string4;
            int n4;
            SanboxChassis sanboxChassis2;
            Object object3;
            sanboxChassis = (SanboxChassis)chassis;
            this.setValue(this.model, sanboxChassis.delimitFCAddress(), n2++, n);
            this.setValue(this.model, sanboxChassis.getWWName().delimit(), n2++, n);
            this.setValue(this.model, SbmUtilities.reasonToString(sanboxChassis.getReasonForStatus()), n2++, n);
            if (sanboxChassis.getDiscoveredByIpAddress()) {
                object3 = sanboxChassis.getComAgent().getLoginInfo();
                switch (object3.getLevel()) {
                    case -1: 
                    case 0: {
                        this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
                        break;
                    }
                    default: {
                        this.setValue(this.model, sanboxChassis.getComAgent().getLoginInfo().getUserName(), n2++, n);
                    }
                }
                this.setValue(this.model, sanboxChassis.getComAgent().getLoginInfo().getLevelString(), n2++, n);
            } else {
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
            }
            this.setValue(this.model, this.getSecurityEnabled(sanboxChassis), n2++, n);
            if (sanboxChassis instanceof Sanbox2 && ((Sanbox2)sanboxChassis).getMfgVendorName() != null) {
                this.setValue(this.model, ((Sanbox2)sanboxChassis).getMfgVendorName(), n2++, n);
            } else {
                this.setValue(this.model, sanboxChassis.getWWName().getCompanyName(), n2++, n);
            }
            this.setValue(this.model, sanboxChassis.getFlashVersionString(), n2++, n);
            if (chassis instanceof Sanbox2) {
                object3 = (Sanbox2)sanboxChassis;
                this.setValue(this.model, object3.getInactiveFlashVersionString(), n2++, n);
                if (object3.getFirmwareVersion() < 6) {
                    this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
                } else {
                    this.setValue(this.model, object3.getPendingVersionString(), n2++, n);
                }
            } else {
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
            }
            this.setValue(this.model, sanboxChassis.getSwPromVersionString(), n2++, n);
            this.setValue(this.model, sanboxChassis.delimitMacAddress(), n2++, n);
            object3 = FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
            string = FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
            object2 = FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
            if (sanboxChassis instanceof IPHost && (object = (sanboxChassis2 = sanboxChassis).getIpInfo()) != null) {
                object3 = object.getIpAddress().getHostAddress();
                n4 = object.getNetMask();
                string = "" + (n4 >> 24 & 0xFF) + "." + (n4 >> 16 & 0xFF) + "." + (n4 >> 8 & 0xFF) + "." + (n4 & 0xFF);
                object2 = object.getGateway().getHostAddress();
            }
            this.setValue(this.model, (String)object3, n2++, n);
            this.setValue(this.model, string, n2++, n);
            this.setValue(this.model, (String)object2, n2++, n);
            int n5 = sanboxChassis.getDomainId();
            object = Integer.toString(n5) + " (0x" + Integer.toHexString(n5) + ")";
            this.setValue(this.model, (String)object, n2++, n);
            n4 = sanboxChassis.getConfiguredDomainId();
            String string5 = Integer.toString(n4) + " (0x" + Integer.toHexString(n4) + ")";
            this.setValue(this.model, string5, n2++, n);
            this.setValue(this.model, sanboxChassis.getDomainIdLockString(), n2++, n);
            this.setValue(this.model, Integer.toString(sanboxChassis.getPortCount()), n2++, n);
            this.setValue(this.model, sanboxChassis.getSysDesc(), n2++, n);
            if (sanboxChassis instanceof Sanbox2) {
                this.setValue(this.model, ((Sanbox2)sanboxChassis).getOperationalStateString(), n2++, n);
            } else {
                this.setValue(this.model, sanboxChassis.getChassisModeString(), n2++, n);
            }
            if (sanboxChassis instanceof Sanbox2) {
                this.setValue(this.model, ((Sanbox2)sanboxChassis).getOperAdminStateString(), n2++, n);
            } else {
                this.setValue(this.model, sanboxChassis.getAdminModeString(), n2++, n);
            }
            this.setValue(this.model, sanboxChassis.getAdminModeString(), n2++, n);
            this.setValue(this.model, Integer.toString(sanboxChassis.getRaTimeout()), n2++, n);
            this.setValue(this.model, Integer.toString(sanboxChassis.getEdTimeout()), n2++, n);
            ZoningConfig zoningConfig = sanboxChassis.getZoningConfig();
            switch (zoningConfig.getMergeMode()) {
                case 1: {
                    this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.false"), n2++, n);
                    this.setValue(this.model, zoningConfig.getNonSw2Legacy() ? FabricTreeControl.getResource("SwitchDisplayPanel.true") : FabricTreeControl.getResource("SwitchDisplayPanel.false"), n2++, n);
                    break;
                }
                case 0: {
                    this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.true"), n2++, n);
                    this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
                    break;
                }
                default: {
                    this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.unknown"), n2++, n);
                    this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
                }
            }
            this.setValue(this.model, ZoningConfig.getAutoSaveString((boolean)zoningConfig.getAutoSave()), n2++, n);
            this.setValue(this.model, zoningConfig.getDefaultVisibilityString(), n2++, n);
            if (sanboxChassis instanceof Sanbox8000) {
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
            } else {
                string4 = Integer.toString(sanboxChassis.getTemperature()) + "\u00b0C(" + StringUtilities.formatNumber((double)sanboxChassis.getTemperature() * 9.0 / 5.0 + 32.0) + "\u00b0F)";
                this.setValue(this.model, string4, n2++, n);
            }
            string4 = this.getFanStatus(sanboxChassis, 0);
            this.setValue(this.model, string4, n2++, n);
            string4 = this.getFanStatus(sanboxChassis, 1);
            this.setValue(this.model, string4, n2++, n);
            string4 = this.getFanStatus(sanboxChassis, 2);
            this.setValue(this.model, string4, n2++, n);
            if (sanboxChassis instanceof SwitchBlade) {
                string3 = FabricTreeControl.getResource("SwitchDisplayPanel.na");
                this.setValue(this.model, string3, n2++, n);
                this.setValue(this.model, string3, n2++, n);
            } else {
                string3 = this.getPowerSupplyStatus(sanboxChassis, 0);
                this.setValue(this.model, string3, n2++, n);
                string3 = this.getPowerSupplyStatus(sanboxChassis, 1);
                this.setValue(this.model, string3, n2++, n);
            }
            string3 = this.getSwitchBeaconStatus(sanboxChassis);
            this.setValue(this.model, string3, n2++, n);
            if (sanboxChassis instanceof Sanbox2) {
                string2 = FabricTreeControl.getResource("SwitchDisplayPanel.enabled");
                if (!((Sanbox2)sanboxChassis).isBroadcastSupportEnabled()) {
                    string2 = FabricTreeControl.getResource("SwitchDisplayPanel.disabled");
                }
                this.setValue(this.model, string2, n2++, n);
            } else {
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
            }
            if (sanboxChassis instanceof Sanbox2) {
                string2 = FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
                if (((Sanbox2)sanboxChassis).getFirmwareVersion() == 2) {
                    string2 = FabricTreeControl.getResource("SwitchDisplayPanel.true");
                } else if (((Sanbox2)sanboxChassis).getInbandEnable() == 1) {
                    string2 = FabricTreeControl.getResource("SwitchDisplayPanel.true");
                } else if (((Sanbox2)sanboxChassis).getInbandEnable() == 2) {
                    string2 = FabricTreeControl.getResource("SwitchDisplayPanel.false");
                }
                this.setValue(this.model, string2, n2++, n);
            } else {
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
            }
            if (sanboxChassis instanceof Sanbox2 && !(sanboxChassis instanceof Sanbox8000)) {
                int n6 = ((Sanbox2)sanboxChassis).getTempMonEnable();
                if (n6 == 0) {
                    this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.unknown"), n2++, n);
                } else if (n6 == 1) {
                    this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.enabled"), n2++, n);
                } else {
                    this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.disabled"), n2++, n);
                }
                int n7 = ((Sanbox2)sanboxChassis).getWarningTemp();
                this.setValue(this.model, Integer.toString(n7), n2++, n);
                int n8 = ((Sanbox2)sanboxChassis).getFailureTemp();
                this.setValue(this.model, Integer.toString(n8), n2++, n);
            } else {
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n2++, n);
            }
        }
        if (chassis instanceof ForeignSwitch) {
            sanboxChassis = (ForeignSwitch)chassis;
            int n9 = 0;
            while (n9 < this.model.getRowCount()) {
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n9, n);
                ++n9;
            }
            this.setValue(this.model, sanboxChassis.delimitFCAddress(), 0, n);
            this.setValue(this.model, sanboxChassis.getWWName().delimit(), 1, n);
            this.setValue(this.model, SbmUtilities.reasonToString(sanboxChassis.getReasonForStatus()), 2, n);
            this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.unknown"), 5, n);
            this.setValue(this.model, sanboxChassis.getWWName().getCompanyName(), 6, n);
            string = FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
            object2 = sanboxChassis.getIpAddr();
            if (object2 != null) {
                string = ((InetAddress)object2).getHostAddress();
            }
            this.setValue(this.model, string, 12, n);
            this.setValue(this.model, Integer.toString(sanboxChassis.getDomainId()), 15, n);
        }
        if (chassis instanceof Director) {
            IPInfo iPInfo;
            sanboxChassis = (Director)chassis;
            int n10 = 0;
            while (n10 < this.model.getRowCount()) {
                this.setValue(this.model, FabricTreeControl.getResource("SwitchDisplayPanel.na"), n10, n);
                ++n10;
            }
            this.setValue(this.model, sanboxChassis.delimitFCAddress(), 0, n);
            this.setValue(this.model, sanboxChassis.getWWName().delimit(), 1, n);
            this.setValue(this.model, SbmUtilities.reasonToString(sanboxChassis.getReasonForStatus()), 2, n);
            this.setValue(this.model, sanboxChassis.getWWName().getCompanyName(), 6, n);
            string = FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
            object2 = FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
            String string6 = FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
            if (sanboxChassis instanceof IPHost && (iPInfo = (object = (IPHost)sanboxChassis).getIpInfo()) != null) {
                string = iPInfo.getIpAddress().getHostAddress();
                int n11 = iPInfo.getNetMask();
                object2 = "" + (n11 >> 24 & 0xFF) + "." + (n11 >> 16 & 0xFF) + "." + (n11 >> 8 & 0xFF) + "." + (n11 & 0xFF);
                string6 = iPInfo.getGateway().getHostAddress();
            }
            this.setValue(this.model, string, 12, n);
            this.setValue(this.model, (String)object2, 13, n);
            this.setValue(this.model, string6, 14, n);
            this.setValue(this.model, Integer.toString(sanboxChassis.getDomainId()), 15, n);
        }
    }

    private void setValue(FabricTableModel fabricTableModel, String string, int n, int n2) {
        if (fabricTableModel.getValueAt(n, n2) instanceof String) {
            String string2 = (String)fabricTableModel.getValueAt(n, n2);
            if (!string2.equals(string)) {
                fabricTableModel.setValueAt(string, n, n2);
            }
        } else {
            fabricTableModel.setValueAt(string, n, n2);
        }
    }

    private String getSecurityEnabled(SanboxChassis sanboxChassis) {
        switch (sanboxChassis.getSecurityEnabled()) {
            case 1: {
                return FabricTreeControl.getResource("SwitchDisplayPanel.false");
            }
            case 2: {
                return FabricTreeControl.getResource("SwitchDisplayPanel.true");
            }
        }
        return FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
    }

    private String getFanStatus(SanboxChassis sanboxChassis, int n) {
        int n2 = sanboxChassis.getFanStatus(n);
        return this.convertStatus(n2);
    }

    private String getPowerSupplyStatus(SanboxChassis sanboxChassis, int n) {
        int n2 = sanboxChassis.getPowerSupplyStatus(n);
        return this.convertStatus(n2);
    }

    private String convertStatus(int n) {
        switch (n) {
            case 0: {
                return FabricTreeControl.getResource("SwitchDisplayPanel.ok");
            }
            case 1: {
                return FabricTreeControl.getResource("SwitchDisplayPanel.warning");
            }
            case 2: {
                return FabricTreeControl.getResource("SwitchDisplayPanel.critical");
            }
            case 4: {
                return FabricTreeControl.getResource("SwitchDisplayPanel.notPresent");
            }
            case 5: {
                return FabricTreeControl.getResource("SwitchDisplayPanel.na");
            }
        }
        return FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
    }

    private String getSwitchBeaconStatus(SanboxChassis sanboxChassis) {
        int n = sanboxChassis.getSwitchBeaconStatus();
        String string = "";
        switch (n) {
            case 1: {
                string = FabricTreeControl.getResource("SwitchDisplayPanel.on");
                break;
            }
            case 0: {
                string = FabricTreeControl.getResource("SwitchDisplayPanel.off");
                break;
            }
            default: {
                string = FabricTreeControl.getResource("SwitchDisplayPanel.unknown");
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class QTableCellRenderer
    extends DefaultTableCellRenderer {
        public QTableCellRenderer() {
            this.setFont(this.getFont().deriveFont(0));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = 0;
            if (n2 > 0 && n2 <= SwitchDisplayPanel.this.switchList.size()) {
                n3 = ((Chassis)SwitchDisplayPanel.this.switchList.get(n2 - 1)).getOverallStatus();
            }
            this.setOpaque(true);
            if (n2 > 0 && n == 2 && n3 != 0) {
                Color color = Status.getColor((int)n3);
                this.setBackground(Status.getColor((int)n3));
                this.setForeground(n3 == 3 ? Color.white : jTable.getForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setText((String)object);
            return this;
        }
    }

    class UpdateTableClass
    implements Runnable {
        Chassis fcSwitch = null;

        public UpdateTableClass() {
        }

        public UpdateTableClass(Chassis chassis) {
            this.fcSwitch = chassis;
        }

        public void run() {
            SwitchDisplayPanel.this.updateTable(this.fcSwitch);
        }
    }
}

