/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCStatistics;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.FabricTableModel;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;

public class SwitchCountersPanel
extends JPanel
implements ChassisEventListener,
ActionListener {
    private static final int ABSOLUTE = 0;
    private static final int RATE = 1;
    private static final int DELTA = 2;
    public static final long secondsInMinute = 60L;
    public static final long secondsInHour = 3600L;
    public static final long secondsInDay = 86400L;
    FabricTableModel model = new FabricTableModel();
    JTable table = new JTable(this.model);
    JButton zeroDeltas = new JButton(new ClearDeltaAction());
    JComboBox displayMode;
    SanboxChassis theSwitch = null;
    static String absoulteStr = FabricTreeControl.getResource("PortCountersPanel.absoulte");
    static String rateStr = FabricTreeControl.getResource("PortCountersPanel.rate");
    static String deltaStr = FabricTreeControl.getResource("PortCountersPanel.delta");
    static String baseTimeStr = FabricTreeControl.getResource("PortCountersPanel.baseTime");
    static String lastTimeStr = FabricTreeControl.getResource("PortCountersPanel.lastTime");
    static String totalTimeStr = FabricTreeControl.getResource("PortCountersPanel.totalTime");
    static String secStr = FabricTreeControl.getResource("PortCountersPanel.sec");
    static String secondsStr = FabricTreeControl.getResource("PortCountersPanel.seconds");
    static String clearStr = FabricTreeControl.getResource("PortCountersPanel.clear");

    public SwitchCountersPanel() {
        this.setupEmptyTable();
        this.setLayout(new BorderLayout());
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setVisible(true);
        this.add((Component)new JScrollPane(this.table), "Center");
        Vector<String> vector = new Vector<String>();
        vector.add(absoulteStr);
        vector.add(rateStr);
        vector.add(deltaStr);
        this.displayMode = new JComboBox(vector);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.displayMode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        jPanel.add((Component)this.zeroDeltas, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)jPanel, "North");
        this.displayMode.setSelectedIndex(0);
        this.zeroDeltas.setEnabled(false);
        this.displayMode.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.displayMode) {
            this.zeroDeltas.setEnabled(this.displayMode.getSelectedIndex() == 2);
            this.setupEmptyTable();
            this.fillTableData();
            this.repaint();
        }
    }

    public void setSelectedSwitch(Chassis chassis) {
        if (this.theSwitch != null) {
            this.theSwitch.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
        }
        if (chassis instanceof SanboxChassis) {
            this.theSwitch = (SanboxChassis)chassis;
            this.theSwitch.getEventHandler().addChassisEventListener((ChassisEventListener)this);
        } else {
            this.theSwitch = null;
        }
        this.setupEmptyTable();
        this.fillTableData();
        this.repaint();
    }

    private void setupEmptyTable() {
        this.model.setColumnCount(0);
        this.model.setRowCount(0);
        if (this.theSwitch != null) {
            this.model.addColumn("            ");
            this.model.addColumn(this.theSwitch.getChassisName());
            FCStatistics fCStatistics = this.theSwitch.getStats();
            if (fCStatistics != null) {
                this.model.addRow(baseTimeStr);
                this.model.addRow(lastTimeStr);
                this.model.addRow(totalTimeStr);
                int n = 0;
                while (n < fCStatistics.getNumberOfStatistics()) {
                    this.model.addRow(fCStatistics.getStatisticsName(n));
                    ++n;
                }
            }
        }
    }

    public String formatTimeString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (l == 0L) {
            return "0 sec";
        }
        if (l >= 86400L) {
            long l2 = l / 86400L;
            stringBuffer.append(l2 + " days ");
            l %= 86400L;
        }
        if (l >= 3600L) {
            long l3 = l / 3600L;
            stringBuffer.append(l3 + " hrs ");
            l %= 3600L;
        }
        if (l >= 60L) {
            long l4 = l / 60L;
            stringBuffer.append(l4 + " min ");
            l %= 60L;
        }
        if (l > 0L) {
            stringBuffer.append(l + " sec");
        }
        return stringBuffer.toString();
    }

    private void fillTableData() {
        if (this.theSwitch == null) {
            return;
        }
        FCStatistics fCStatistics = this.theSwitch.getStats();
        if (fCStatistics != null) {
            int n = 0;
            int n2 = 1;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            tableColumnModel.getColumn(n2).setHeaderValue(this.theSwitch.toString());
            if (this.model.getRowCount() < 3) {
                this.model.addRow(baseTimeStr);
                this.model.addRow(lastTimeStr);
                this.model.addRow(totalTimeStr);
            }
            switch (this.displayMode.getSelectedIndex()) {
                case 0: {
                    this.model.setValueAt(FabricTreeControl.getResource("SwitchDisplayPanel.na"), n++, n2);
                    this.model.setValueAt(FabricTreeControl.getResource("SwitchDisplayPanel.na"), n++, n2);
                    this.model.setValueAt(FabricTreeControl.getResource("SwitchDisplayPanel.na"), n++, n2);
                    break;
                }
                case 1: {
                    this.model.setValueAt(fCStatistics.getSecondToLastTimeStamp(), n++, n2);
                    this.model.setValueAt(fCStatistics.getTimeStamp(), n++, n2);
                    long l = fCStatistics.getTimeStamp().getTime() - fCStatistics.getSecondToLastTimeStamp().getTime();
                    this.model.setValueAt(this.formatTimeString(l / 1000L), n++, n2);
                    break;
                }
                case 2: {
                    this.model.setValueAt(fCStatistics.getBaseTimeStamp(), n++, n2);
                    this.model.setValueAt(fCStatistics.getTimeStamp(), n++, n2);
                    long l = fCStatistics.getTimeStamp().getTime() - fCStatistics.getBaseTimeStamp().getTime();
                    this.model.setValueAt(this.formatTimeString(l / 1000L), n++, n2);
                }
            }
            int n3 = 0;
            while (n3 < fCStatistics.getNumberOfStatistics()) {
                if (this.model.getRowCount() - 1 < n) {
                    this.model.addRow(fCStatistics.getStatisticsName(n3));
                }
                String string = new String();
                switch (this.displayMode.getSelectedIndex()) {
                    case 0: {
                        string = Long.toString(fCStatistics.getStatisticValue(n3));
                        break;
                    }
                    case 2: {
                        string = Long.toString(fCStatistics.getStatisticDelta(n3));
                        break;
                    }
                    case 1: {
                        Object[] objectArray = new Object[]{new Double(fCStatistics.getStatisticRate(n3))};
                        string = StringUtilities.formatString("{0,number,#.##}", objectArray) + "/" + secStr;
                    }
                }
                this.model.setValueAt(string, n++, n2);
                ++n3;
            }
        }
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        if (chassisEvent.getEventType() == 222) {
            SwingUtilities.invokeLater(new UpdateTableClass());
        }
    }

    class UpdateTableClass
    implements Runnable {
        UpdateTableClass() {
        }

        public void run() {
            SwitchCountersPanel.this.fillTableData();
            SwitchCountersPanel.this.repaint();
        }
    }

    class ClearDeltaAction
    extends AbstractAction {
        public ClearDeltaAction() {
            super(clearStr);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FCStatistics fCStatistics;
            if (SwitchCountersPanel.this.theSwitch != null && (fCStatistics = SwitchCountersPanel.this.theSwitch.getStats()) != null) {
                fCStatistics.resetBaseline();
                SwitchCountersPanel.this.setupEmptyTable();
                SwitchCountersPanel.this.fillTableData();
                SwitchCountersPanel.this.repaint();
            }
        }
    }
}

