/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.PortStates;
import com.qlogic.device.fcfabric.S16Port;
import com.qlogic.device.fcfabric.SwitchBlade;
import com.qlogic.qms.fabric.AbstractFaceplate;
import com.qlogic.qms.fabric.SbmUtilities;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class SwitchBladeFaceplate
extends AbstractFaceplate {
    private Rectangle[] portLocations = new Rectangle[16];
    private static final int PORT_0_X = 16;
    private static final int PORT_0_Y = 60;
    private static final int PORT_1_X = 74;
    private static final int PORT_1_Y = 126;
    private static final int PORT_15_X = 16;
    private static final int PORT_15_Y = 36;
    private static final int PORT_OFFSET_X = 30;
    private static final int PORT_WIDTH = 17;
    private static final int PORT_HEIGHT = 22;
    private static final int ROW_COUNT = 2;
    private static final int COLUMN_COUNT = 1;
    static ImageIcon genericFaceplateIcon;
    static ImageIcon ibmFaceplateIcon;

    public SwitchBladeFaceplate(SwitchBlade switchBlade) throws IllegalArgumentException {
        super((Chassis)switchBlade);
        if (switchBlade.getChassisType() == 38) {
            if (genericFaceplateIcon == null) {
                genericFaceplateIcon = new ImageIcon(SbmUtilities.getImage("SwitchBladeFaceplate.gif"));
            }
            this.setFaceplateIcon(genericFaceplateIcon);
        } else if (switchBlade.getChassisType() == 33) {
            if (ibmFaceplateIcon == null) {
                ibmFaceplateIcon = new ImageIcon(SbmUtilities.getImage("IbmSwitchBladeFaceplate.gif"));
            }
            this.setFaceplateIcon(ibmFaceplateIcon);
        }
        if (this.fcSwitch.getPortCount() != 16) {
            throw new IllegalArgumentException();
        }
    }

    protected Icon getGbicIcon(FCPort fCPort, int n) {
        int n2 = fCPort.getPortNumber();
        if (n2 == 0 || n2 == 15) {
            return this.getSFPIconV(fCPort, n);
        }
        return this.getSFPIcon(fCPort, n);
    }

    protected void prepareGbicModeRenderer(JLabel jLabel, FCPort fCPort) {
        if (this.isInternalPort(fCPort.getPortNumber())) {
            jLabel.setIcon(null);
            jLabel.setText(null);
            jLabel.setBackground(this.getGbicModeColor(fCPort));
        } else {
            super.prepareGbicModeRenderer(jLabel, fCPort);
        }
    }

    public boolean placeFaceplateOnLeft() {
        return false;
    }

    private boolean isInternalPort(int n) {
        return n > 0 && n < 15;
    }

    protected void verifyPortTypeConsisent(int n) {
        boolean bl = this.isInternalPort(n);
        this.m_SelectionModel.setValueIsAdjusting(true);
        int n2 = 0;
        while (n2 < this.fcSwitch.getPortCount()) {
            if (this.m_SelectionModel.isSelectedIndex(n2) && bl != this.isInternalPort(n2)) {
                this.m_SelectionModel.removeSelectionInterval(n2, n2);
            }
            ++n2;
        }
        this.m_SelectionModel.setValueIsAdjusting(false);
    }

    public Rectangle getPort(int n) {
        if (this.portLocations[n] == null) {
            if (n == 0) {
                this.portLocations[0] = new Rectangle(16, 60, 17, 22);
            } else if (n == 15) {
                this.portLocations[15] = new Rectangle(16, 36, 17, 22);
            } else {
                int n2 = 74 + (n - 1) * 30;
                int n3 = 126;
                this.portLocations[n] = new Rectangle(n2, n3, 22, 17);
            }
        }
        return this.portLocations[n];
    }

    public int getPortCount() {
        return 16;
    }

    protected String getPortModeTooltip(FCPort fCPort) {
        String string = "";
        PortStates portStates = fCPort.getPortStates();
        if (portStates != null) {
            switch (portStates.getConfigPortType()) {
                case 7: {
                    string = "E-port";
                    break;
                }
                case 2: {
                    string = "FL-port";
                    break;
                }
                case 1: {
                    string = "F-port";
                    break;
                }
                case 4: {
                    string = "SL-port";
                    break;
                }
                case 5: {
                    string = "TL-port";
                    break;
                }
                case 3: {
                    string = "T-port";
                    break;
                }
                case 8: {
                    string = "G-port";
                    break;
                }
                case 9: {
                    string = "GL-port";
                    break;
                }
                case 0: {
                    string = "Inactive";
                }
            }
        } else {
            string = "Unknown";
        }
        if (fCPort instanceof S16Port) {
            string = string + " " + AbstractFaceplate.getOperPortSpeedString(fCPort);
        }
        return string;
    }

    protected int getPowerSupplyCount() {
        return 0;
    }

    protected String getLedTooltip(int n, int n2) {
        return null;
    }
}

