/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.DeviceUtilities;
import com.qlogic.device.fcfabric.FCPort;
import com.qlogic.device.fcfabric.Sanbox8000;
import com.qlogic.device.fcfabric.Sanbox8000Blade;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.AbstractFaceplate;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.FaceplateListener;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.qms.fabric.propertyDialogs.BladePropertiesDialog;
import com.qlogic.qms.fabric.propertyDialogs.TestBladeDialog;
import com.qlogic.util.StringUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Sanbox8000Faceplate
extends AbstractFaceplate {
    private JMenuItem bladePropertiesMenuItem = new JMenuItem();
    private JMenuItem testBladeMenuItem = new JMenuItem();
    private JMenuItem resetBladeMenuItem = new JMenuItem();
    static final int NUMBER_OF_PORTS = 64;
    static final int NUMBER_OF_BLADES = 8;
    private Rectangle[] portLocations = new Rectangle[64];
    private Rectangle[] bladeLocations = new Rectangle[8];
    private Vector selectedBlades = new Vector();
    private int bladeAnchor = -1;
    private int bladesToReset = 0;
    private static final int FIRST_BLADE_X = 88;
    private static final int FIRST_BLADE_Y = 5;
    private static final int BLADE_OFFSET_X = 59;
    private static final int CPU_WIDTH = 69;
    private static final int BLADE_WIDTH = 59;
    private static final int BLADE_HEIGHT = 286;
    private static final int FIRST_PORT_X = 107;
    private static final int FIRST_PORT_Y = 36;
    private static final int PORT_OFFSET_X = 59;
    private static final int PORT_OFFSET_Y = 26;
    private static final int PORT_WIDTH = 17;
    private static final int PORT_HEIGHT = 22;
    private static final int ROW_COUNT = 8;
    private static final int COLUMN_COUNT = 8;
    private static final int BOTTOM_RIGHT_X = 430;
    private static final int BOTTOM_RIGHT_Y = 204;
    private static final int OVERLAY_X = 99;
    private static final int OVERLAY_Y = 39;
    static ImageIcon noBladeIcon = null;
    static ImageIcon bladeIcon = null;
    static ImageIcon bladeSelectedIcon = null;
    static ImageIcon noBladeSelectedIcon = null;
    static ImageIcon unknownIcon = null;
    static ImageIcon tempIcon = null;
    static ImageIcon badIcon = null;
    static ImageIcon goodIcon = null;
    static ImageIcon overlayIcon = null;
    private Sanbox8000 sanbox8000Sw;
    JMenuItem bladePropertiesItem;
    JMenuItem selectAllBladesItem;

    public Sanbox8000Faceplate(Sanbox8000 sanbox8000) throws IllegalArgumentException {
        super((Chassis)sanbox8000);
        this.sanbox8000Sw = sanbox8000;
        this.bladePropertiesMenuItem.setAction(new BladePropertiesAction());
        this.testBladeMenuItem.setAction(new TestBladeAction());
        this.resetBladeMenuItem.setAction(new ResetBladeAction());
        this.setBladeMenuItemEnables();
        if (this.faceplateIcon == null) {
            this.faceplateIcon = new ImageIcon(SbmUtilities.getImage("Sanbox8000Faceplate.gif"));
            bladeIcon = new ImageIcon(SbmUtilities.getImage("Sanbox8000Blade.gif"));
            bladeSelectedIcon = new ImageIcon(SbmUtilities.getImage("Sanbox8000BladeSelected.gif"));
            noBladeSelectedIcon = new ImageIcon(SbmUtilities.getImage("Sanbox8000NoBladeSelected.gif"));
            noBladeIcon = new ImageIcon(SbmUtilities.getImage("Sanbox8000BladeNotInstalled.gif"));
            goodIcon = new ImageIcon(SbmUtilities.getImage("StatusNormal.gif"));
            unknownIcon = new ImageIcon(SbmUtilities.getImage("StatusUnknown.gif"));
            tempIcon = new ImageIcon(SbmUtilities.getImage("StatusTempBad.gif"));
            badIcon = new ImageIcon(SbmUtilities.getImage("StatusCritical.gif"));
            overlayIcon = new ImageIcon(SbmUtilities.getImage("Sanbox8000overlay.gif"));
        }
        this.setFaceplateIcon(this.faceplateIcon);
        if (this.fcSwitch.getPortCount() != 64) {
            throw new IllegalArgumentException();
        }
    }

    protected int getPowerSupplyCount() {
        return 2;
    }

    public Vector getMenuBarExtension() {
        Vector vector = super.getMenuBarExtension();
        if (!this.isReadOnly()) {
            JMenu jMenu = new JMenu(FabricTreeControl.getResource("Sanbox8000Faceplate.blade"));
            jMenu.add(this.bladePropertiesMenuItem);
            jMenu.add(this.testBladeMenuItem);
            jMenu.add(this.resetBladeMenuItem);
            vector.insertElementAt(jMenu, 1);
        }
        return vector;
    }

    protected void paintPowerSupply(int n, Graphics graphics) {
        int n2 = 0;
        int n3 = 199;
        int n4 = 51;
        int n5 = 38;
        switch (n) {
            case 0: {
                n2 = 22;
                break;
            }
            case 1: {
                n2 = 645;
                break;
            }
            default: {
                return;
            }
        }
        this.paintPowerSupply(n, graphics, n2, n3, n4, n5);
    }

    protected Icon getGbicIcon(FCPort fCPort, int n) {
        return this.getSFPIconV(fCPort, n);
    }

    public boolean placeFaceplateOnLeft() {
        return false;
    }

    public Rectangle getBlade(int n) {
        if (this.bladeLocations[n] == null) {
            int n2 = 88 + 59 * n;
            int n3 = 5;
            if (n > 3) {
                n2 += 69;
            }
            this.bladeLocations[n] = new Rectangle(n2, n3, 59, 286);
        }
        return this.bladeLocations[n];
    }

    public Rectangle getPort(int n) {
        if (this.portLocations[n] == null) {
            int n2 = 107 + 59 * (n / 8);
            int n3 = 36 + n % 8 * 26;
            if (n > 31) {
                n2 += 69;
            }
            this.portLocations[n] = new Rectangle(n2, n3, 17, 22);
        }
        return this.portLocations[n];
    }

    protected void paintFaceplate(Graphics graphics) {
        super.paintFaceplate(graphics);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this.sanbox8000Sw.getNumberOfBlades()) {
            Sanbox8000Blade sanbox8000Blade = this.sanbox8000Sw.getBlade(n);
            Rectangle rectangle = this.getBlade(n);
            if (sanbox8000Blade.isInstalled()) {
                if (this.selectedBlades.contains(sanbox8000Blade)) {
                    bladeSelectedIcon.paintIcon(this, graphics, rectangle.x, rectangle.y);
                } else {
                    bladeIcon.paintIcon(this, graphics, rectangle.x, rectangle.y);
                }
            } else if (this.selectedBlades.contains(sanbox8000Blade)) {
                noBladeSelectedIcon.paintIcon(this, graphics, rectangle.x, rectangle.y);
            } else {
                noBladeIcon.paintIcon(this, graphics, rectangle.x, rectangle.y);
            }
            int n2 = rectangle.x + bladeIcon.getIconWidth() / 2;
            int n3 = rectangle.y + 1;
            switch (sanbox8000Blade.getBladeState()) {
                case 3: {
                    break;
                }
                case 1: {
                    switch (sanbox8000Blade.getDiagStatus()) {
                        case 1: {
                            switch (sanbox8000Blade.getTempStatus()) {
                                case 1: {
                                    break;
                                }
                                case 0: {
                                    unknownIcon.paintIcon(this, graphics, n2, n3);
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    tempIcon.paintIcon(this, graphics, n2, n3);
                                }
                            }
                            break;
                        }
                        case 2: 
                        case 3: {
                            badIcon.paintIcon(this, graphics, n2, n3);
                            break;
                        }
                        case 0: {
                            unknownIcon.paintIcon(this, graphics, n2, n3);
                        }
                    }
                    break;
                }
                case 0: {
                    unknownIcon.paintIcon(this, graphics, n2, n3);
                    break;
                }
                case 2: {
                    badIcon.paintIcon(this, graphics, n2, n3);
                }
            }
            graphics.setFont(new Font("SansSerif", 0, 9));
            graphics.setColor(Color.white);
            int n4 = rectangle.x + 10;
            int n5 = rectangle.y + bladeIcon.getIconHeight() - 30;
            String string = StringUtilities.formatString(DeviceUtilities.getResource((String)"Sanbox8000Blade.blade"), new Object[]{StringUtilities.formatNumber(sanbox8000Blade.getBladeNumber())});
            String string2 = StringUtilities.formatString(DeviceUtilities.getResource((String)"Sanbox8000Blade.slot"), new Object[]{StringUtilities.formatNumber(sanbox8000Blade.getSlotNumber())});
            graphics.drawString(string, n4, n5);
            graphics.drawString(string2, n4, n5 + 15);
            if (n == 0) {
                string = StringUtilities.formatString(DeviceUtilities.getResource((String)"Sanbox8000Blade.ps"), new Object[]{"0"});
                string2 = StringUtilities.formatString(DeviceUtilities.getResource((String)"Sanbox8000Blade.slot"), new Object[]{StringUtilities.formatNumber(sanbox8000Blade.getSlotNumber() - 1)});
                graphics.drawString(string, 15, n5);
                graphics.drawString(string2, 15, n5 + 15);
            } else if (n == 3) {
                string = DeviceUtilities.getResource((String)"Sanbox8000Blade.cpu");
                string2 = StringUtilities.formatString(DeviceUtilities.getResource((String)"Sanbox8000Blade.slot"), new Object[]{StringUtilities.formatNumber(sanbox8000Blade.getSlotNumber() + 1)});
                graphics.drawString(string, n4 + bladeIcon.getIconWidth(), n5);
                graphics.drawString(string2, n4 + bladeIcon.getIconWidth(), n5 + 15);
            } else if (n == 7) {
                string = StringUtilities.formatString(DeviceUtilities.getResource((String)"Sanbox8000Blade.ps"), new Object[]{"1"});
                string2 = StringUtilities.formatString(DeviceUtilities.getResource((String)"Sanbox8000Blade.slot"), new Object[]{StringUtilities.formatNumber(sanbox8000Blade.getSlotNumber() + 1)});
                graphics.drawString(string, n4 + bladeIcon.getIconWidth(), n5);
                graphics.drawString(string2, n4 + bladeIcon.getIconWidth(), n5 + 15);
            }
            ++n;
        }
        overlayIcon.paintIcon(this, graphics, 99, 39);
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        String string = VendorProperties.getFrameTitle();
        if (chassisEvent.getChassis() != this.fcSwitch) {
            chassisEvent.getChassis().getEventHandler().removeChassisEventListener((ChassisEventListener)this);
            return;
        }
        switch (chassisEvent.getEventType()) {
            case 338: {
                if (!chassisEvent.isSuccessful()) {
                    SwingUtilities.invokeLater(new AbstractFaceplate.DisplayMessageRunnable(FabricTreeControl.getResource("Sanbox8000Faceplate.bladeResetFailed") + FabricTreeControl.translateErrorType(chassisEvent.getErrorType())));
                    break;
                }
                SwingUtilities.invokeLater(new AbstractFaceplate.DisplayMessageRunnable(FabricTreeControl.getResource("Sanbox8000Faceplate.bladeResetOk")));
                break;
            }
        }
        super.receiveEvent(chassisEvent);
    }

    public int getPortCount() {
        return 64;
    }

    protected void paintLeds(Graphics graphics) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        JFrame jFrame = SbmUtilities.getFrame(this);
        if (jFrame == null) {
            return;
        }
        this.handlePortViewCheckbox(object);
        if (!this.fcSwitch.isReachable()) {
            PopupDialog.showDialog(jFrame, 3, "Unable to perform request.\nSwitch is currently unreachable.");
            return;
        }
        super.actionPerformed(actionEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        block17: {
            block12: {
                block14: {
                    int n;
                    int n2;
                    Sanbox8000Blade sanbox8000Blade;
                    block15: {
                        block16: {
                            boolean bl;
                            block13: {
                                int n3;
                                boolean bl2 = mouseEvent.isControlDown();
                                bl = mouseEvent.isShiftDown();
                                int n4 = mouseEvent.getX();
                                if (this.getPort(n4, n3 = mouseEvent.getY()) != null) {
                                    super.mouseReleased(mouseEvent);
                                    return;
                                }
                                sanbox8000Blade = this.getBlade(n4, n3);
                                if (sanbox8000Blade == null) break block12;
                                if (!bl2) break block13;
                                this.bladeAnchor = sanbox8000Blade.getBladeNumber();
                                if (this.selectedBlades.contains(sanbox8000Blade)) {
                                    this.selectedBlades.remove(sanbox8000Blade);
                                } else {
                                    int n5 = 0;
                                    int n6 = 0;
                                    while (n6 < this.selectedBlades.size()) {
                                        Sanbox8000Blade sanbox8000Blade2 = (Sanbox8000Blade)this.selectedBlades.elementAt(n6);
                                        if (sanbox8000Blade2.getBladeNumber() < sanbox8000Blade.getBladeNumber()) {
                                            n5 = n6 + 1;
                                        }
                                        ++n6;
                                    }
                                    this.selectedBlades.insertElementAt(sanbox8000Blade, n5);
                                }
                                break block14;
                            }
                            if (bl) break block15;
                            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) break block16;
                            this.selectedBlades.clear();
                            this.selectedBlades.add(sanbox8000Blade);
                            this.bladeAnchor = sanbox8000Blade.getBladeNumber();
                            break block14;
                        }
                        if (this.selectedBlades.contains(sanbox8000Blade)) break block14;
                        this.selectedBlades.clear();
                        this.selectedBlades.add(sanbox8000Blade);
                        break block14;
                    }
                    int n7 = sanbox8000Blade.getBladeNumber();
                    if (this.bladeAnchor < 0) {
                        n2 = n7;
                        n = n7;
                        this.bladeAnchor = n7;
                    } else if (n7 < this.bladeAnchor) {
                        n2 = n7;
                        n = this.bladeAnchor;
                    } else {
                        n2 = this.bladeAnchor;
                        n = n7;
                    }
                    this.selectedBlades.clear();
                    int n8 = n2;
                    while (n8 <= n) {
                        this.selectedBlades.add(this.sanbox8000Sw.getBlade(n8));
                        ++n8;
                    }
                }
                this.fireBladeSelectionChanged();
                this.repaint();
                break block17;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                super.mouseReleased(mouseEvent);
                this.selectedBlades.clear();
                this.fireBladeSelectionChanged();
                this.repaint();
            }
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.doPopupMenu(mouseEvent);
        }
    }

    protected void setupPopmenu() {
        super.setupPopmenu();
        if (this.bladePropertiesItem == null) {
            this.bladePropertiesItem = new JMenuItem(new BladePropertiesAction());
            this.selectAllBladesItem = new JMenuItem(new SelectAllBladesAction());
        }
        this.popupMenu.add(this.selectAllBladesItem);
        this.popupMenu.add(this.bladePropertiesItem);
    }

    private void setBladeMenuItemEnables() {
        Sanbox8000Blade sanbox8000Blade;
        this.bladePropertiesMenuItem.setEnabled(!this.selectedBlades.isEmpty());
        boolean bl = false;
        int n = 0;
        while (n < this.selectedBlades.size()) {
            sanbox8000Blade = (Sanbox8000Blade)this.selectedBlades.elementAt(n);
            if (sanbox8000Blade.getBladeState() == 3) {
                bl = false;
                break;
            }
            bl = true;
            ++n;
        }
        this.resetBladeMenuItem.setEnabled(bl);
        this.bladePropertiesItem.setEnabled(this.selectedBlades.size() > 0);
        bl = false;
        if (this.selectedBlades.size() == 1 && (sanbox8000Blade = (Sanbox8000Blade)this.selectedBlades.firstElement()).getBladeState() != 3) {
            bl = true;
        }
        this.testBladeMenuItem.setEnabled(bl);
    }

    public void fireBladeSelectionChanged() {
        this.setBladeMenuItemEnables();
        int n = 0;
        while (n < this.listeners.size()) {
            FaceplateListener faceplateListener = (FaceplateListener)this.listeners.elementAt(n);
            faceplateListener.bladeSelectionChanged(this.selectedBlades);
            ++n;
        }
    }

    public void fireSelectionChanged() {
        this.fireBladeSelectionChanged();
        super.fireSelectionChanged();
    }

    protected Sanbox8000Blade getBlade(int n, int n2) {
        Sanbox8000Blade sanbox8000Blade = null;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.sanbox8000Sw.getNumberOfBlades()) {
            Rectangle rectangle = this.getBlade(n3);
            if (rectangle != null && rectangle.contains(n, n2)) {
                sanbox8000Blade = this.sanbox8000Sw.getBlade(n3);
            }
            ++n3;
        }
        return sanbox8000Blade;
    }

    public class TestBladeAction
    extends AbstractAction {
        public TestBladeAction() {
            super(FabricTreeControl.getResource("Sanbox8000Faceplate.testBlade"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = SbmUtilities.getFrame(Sanbox8000Faceplate.this);
            TestBladeDialog testBladeDialog = new TestBladeDialog((Frame)jFrame, Sanbox8000Faceplate.this.sanbox8000Sw, Sanbox8000Faceplate.this.selectedBlades);
            testBladeDialog.setVisible(true);
        }
    }

    public class ResetBladeAction
    extends AbstractAction {
        public ResetBladeAction() {
            super(FabricTreeControl.getResource("Sanbox8000Faceplate.resetBlade"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = SbmUtilities.getFrame(Sanbox8000Faceplate.this);
            if (JOptionPane.showConfirmDialog(jFrame, FabricTreeControl.getResource("Sanbox8000Faceplate.resetBladeWarning"), FabricTreeControl.getResource("Sanbox8000Faceplate.resetBlade"), 0) == 0) {
                Sanbox8000Faceplate.this.sanbox8000Sw.resetBlades(Sanbox8000Faceplate.this.selectedBlades);
            }
        }
    }

    public class BladePropertiesAction
    extends AbstractAction {
        public BladePropertiesAction() {
            super(FabricTreeControl.getResource("Sanbox8000Faceplate.bladeProperties"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = SbmUtilities.getFrame(Sanbox8000Faceplate.this);
            BladePropertiesDialog bladePropertiesDialog = new BladePropertiesDialog(jFrame, Sanbox8000Faceplate.this.sanbox8000Sw, Sanbox8000Faceplate.this.selectedBlades);
            bladePropertiesDialog.setVisible(true);
        }
    }

    public class SelectAllBladesAction
    extends AbstractAction {
        public SelectAllBladesAction() {
            super(FabricTreeControl.getResource("Sanbox8000Faceplate.selectAllBlades"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Sanbox8000Faceplate.this.selectedBlades.clear();
            int n = 0;
            while (n < Sanbox8000Faceplate.this.sanbox8000Sw.getNumberOfBlades()) {
                Sanbox8000Faceplate.this.selectedBlades.add(Sanbox8000Faceplate.this.sanbox8000Sw.getBlade(n));
                ++n;
            }
            Sanbox8000Faceplate.this.fireBladeSelectionChanged();
            Sanbox8000Faceplate.this.repaint();
        }
    }
}

