/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.FCNode;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.event.ChassisEvent;
import com.qlogic.device.fcfabric.event.ChassisEventListener;
import com.qlogic.qms.fabric.FabricTableModel;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.SbmUtilities;
import com.qlogic.ui.tools.SmartScrollingTable;
import com.qlogic.ui.topology.TopologyNode;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class NameServerPanel
extends JPanel
implements ChassisEventListener {
    FabricTableModel tableModel = new FabricTableModel();
    JTable nodeTable = new SmartScrollingTable((TableModel)this.tableModel);
    Vector switchList = null;

    public NameServerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.tableModel.addColumn(FabricTreeControl.getResource("NameServerPanel.ti"));
        this.tableModel.addColumn(FabricTreeControl.getResource("NameServerPanel.switch"));
        this.tableModel.addColumn(FabricTreeControl.getResource("NameServerPanel.port"));
        this.tableModel.addColumn(FabricTreeControl.getResource("NameServerPanel.address"));
        this.tableModel.addColumn(FabricTreeControl.getResource("NameServerPanel.type"));
        this.tableModel.addColumn(FabricTreeControl.getResource("NameServerPanel.wwwn"));
        this.tableModel.addColumn(FabricTreeControl.getResource("NameServerPanel.wwpn"));
        this.tableModel.addColumn(FabricTreeControl.getResource("NameServerPanel.vendor"));
        this.tableModel.addColumn(FabricTreeControl.getResource("NameServerPanel.fc4"));
        this.tableModel.addColumn(FabricTreeControl.getResource("NameServerPanel.zones"));
        TableColumn tableColumn = this.nodeTable.getColumn(FabricTreeControl.getResource("NameServerPanel.ti"));
        tableColumn = this.nodeTable.getColumn(FabricTreeControl.getResource("NameServerPanel.switch"));
        tableColumn = this.nodeTable.getColumn(FabricTreeControl.getResource("NameServerPanel.port"));
        tableColumn = this.nodeTable.getColumn(FabricTreeControl.getResource("NameServerPanel.address"));
        tableColumn = this.nodeTable.getColumn(FabricTreeControl.getResource("NameServerPanel.type"));
        tableColumn = this.nodeTable.getColumn(FabricTreeControl.getResource("NameServerPanel.wwwn"));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.nodeTable.getColumn(FabricTreeControl.getResource("NameServerPanel.wwpn"));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.nodeTable.getColumn(FabricTreeControl.getResource("NameServerPanel.vendor"));
        tableColumn = this.nodeTable.getColumn(FabricTreeControl.getResource("NameServerPanel.fc4"));
        tableColumn = this.nodeTable.getColumn(FabricTreeControl.getResource("NameServerPanel.zones"));
        this.cleanoutTableData();
        this.setLayout(new GridLayout(1, 1));
        this.nodeTable.setPreferredScrollableViewportSize(new Dimension(500, 10));
        this.nodeTable.getTableHeader().setReorderingAllowed(false);
        this.nodeTable.setAutoResizeMode(3);
        JScrollPane jScrollPane = new JScrollPane(this.nodeTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.add(jScrollPane);
    }

    void cleanoutTableData() {
        this.tableModel.setRowCount(0);
    }

    public void setSwitchList(Vector vector) {
        this.registerToListen(this.switchList, false);
        this.switchList = vector;
        this.registerToListen(this.switchList, true);
        SwingUtilities.invokeLater(new UpdateTableDataClass());
    }

    public void receiveEvent(ChassisEvent chassisEvent) {
        switch (chassisEvent.getEventType()) {
            case 219: 
            case 241: 
            case 377: {
                SwingUtilities.invokeLater(new UpdateTableDataClass());
            }
        }
    }

    public void registerToListen(Vector vector, boolean bl) {
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Chassis chassis = (Chassis)vector.elementAt(n);
                if (bl) {
                    chassis.getEventHandler().addChassisEventListener((ChassisEventListener)this);
                } else {
                    chassis.getEventHandler().removeChassisEventListener((ChassisEventListener)this);
                }
                ++n;
            }
        }
    }

    public void updateTableData() {
        int n = 0;
        if (this.switchList != null) {
            this.cleanoutTableData();
            int n2 = 0;
            while (n2 < this.switchList.size()) {
                TopologyNode topologyNode;
                Object object = this.switchList.elementAt(n2);
                if (object instanceof TopologyNode) {
                    topologyNode = (TopologyNode)object;
                    object = topologyNode.getObject();
                }
                if (object instanceof Chassis) {
                    topologyNode = (Chassis)object;
                    n = this.addChassisNodes((Chassis)topologyNode, n);
                }
                ++n2;
            }
        }
        if (n < this.tableModel.getRowCount()) {
            this.tableModel.setRowCount(n);
        }
        this.repaint();
    }

    private int addChassisNodes(Chassis chassis, int n) {
        FCNode fCNode = chassis.getFirstNode();
        while (fCNode != null) {
            this.putNodeData(fCNode, ++n);
            fCNode = chassis.getNextNode(fCNode);
        }
        return n;
    }

    private void putNodeData(FCNode fCNode, int n) {
        int n2 = 0;
        int n3 = n - 1;
        if (n3 >= this.tableModel.getRowCount()) {
            this.tableModel.setRowCount(n3 + 1);
        }
        String string = FabricTreeControl.getResource("NameServerPanel.unknown");
        switch (fCNode.getTargetInitiator()) {
            case 1: {
                string = FabricTreeControl.getResource("NameServerPanel.initiator");
                break;
            }
            case 0: {
                string = FabricTreeControl.getResource("NameServerPanel.target");
                break;
            }
            case 3: {
                string = FabricTreeControl.getResource("NameServerPanel.notApplicable");
            }
        }
        this.setValueAt(string, n3, n2++);
        Chassis chassis = fCNode.getChassis();
        this.setValueAt(chassis.toString(), n3, n2++);
        Object var7_7 = null;
        if (fCNode.getPortNumber() < 0) {
            this.setValueAt(FabricTreeControl.getResource("NameServerPanel.unknown"), n3, n2++);
        } else {
            this.setValueAt(Integer.toString(fCNode.getPortNumber()), n3, n2++);
        }
        this.setValueAt(fCNode.delimitFCAddress(), n3, n2++);
        this.setValueAt(SbmUtilities.getNodeTypeLongNameString(fCNode.getNodePortType()), n3, n2++);
        this.setValueAt(fCNode.getNodeWWName().delimit(), n3, n2++);
        this.setValueAt(fCNode.getPortWWName().delimit(), n3, n2++);
        this.setValueAt(fCNode.getFC4Descriptors(), n3, n2++);
        this.setValueAt(fCNode.getFc4TypesText(), n3, n2++);
        this.setValueAt(fCNode.getZonesList(), n3, n2++);
    }

    private void setValueAt(String string, int n, int n2) {
        if (!string.equals(this.tableModel.getValueAt(n, n2))) {
            this.tableModel.setValueAt(string, n, n2);
        }
    }

    public String exportData(Object object) {
        String string;
        String string2 = new String();
        int n = this.tableModel.getColumnCount();
        int n2 = this.tableModel.getRowCount();
        if (object != null && object instanceof Fabric) {
            Fabric fabric = (Fabric)object;
            string = fabric.toString();
            string = this.removeDoubleQuotes(string);
            string2 = string2 + "\"Fabric:\",\"" + string + "\"\n";
        }
        if (this.switchList.size() > 0) {
            string2 = string2 + "\"Switch List:\",";
            int n3 = 0;
            while (n3 < this.switchList.size()) {
                string = (Chassis)this.switchList.elementAt(n3);
                String string3 = string.toString();
                string3 = this.removeDoubleQuotes(string3);
                string2 = string2 + '\"' + string3 + '\"';
                if (n3 < this.switchList.size() - 1) {
                    string2 = string2 + ",";
                }
                ++n3;
            }
            string2 = string2 + "\n";
        }
        string2 = string2 + "\n";
        int n4 = 0;
        while (n4 < n) {
            string = this.tableModel.getColumnName(n4).toString();
            string = this.removeDoubleQuotes(string);
            string2 = string2 + '\"' + string + '\"' + ',';
            ++n4;
        }
        string2 = string2 + "\n";
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n) {
                String string4 = this.tableModel.getValueAt(n5, n6).toString();
                string4 = this.removeDoubleQuotes(string4);
                string2 = string2 + '\"' + string4 + '\"' + ',';
                ++n6;
            }
            string2 = string2 + "\n";
            ++n5;
        }
        return string2;
    }

    private String removeDoubleQuotes(String string) {
        int n = string.indexOf(34);
        while (n >= 0) {
            string = string.substring(0, n) + string.substring(n + 1);
            n = string.indexOf(34);
        }
        return string;
    }

    class UpdateTableDataClass
    implements Runnable {
        UpdateTableDataClass() {
        }

        public void run() {
            NameServerPanel.this.updateTableData();
        }
    }
}

