/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Sanbox2;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.event.ErrorType;
import com.qlogic.device.fcfabric.event.FwLoadError;
import com.qlogic.device.fcfabric.event.FwLoaderEvent;
import com.qlogic.device.fcfabric.event.FwLoaderEventListener;
import com.qlogic.device.fcfabric.util.FwLoader;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.FwFileFilter;
import com.qlogic.qms.fabric.UserPreferences;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.QDialog;
import com.qlogic.ui.QFileChooser;
import com.qlogic.util.QHelpUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class LoadFirmwareDialog
extends QDialog
implements FwLoaderEventListener {
    private static final int LG_IMAGE = 12000000;
    String title;
    long fileSize;
    long startTime;
    long timeElapsed;
    long timeLeft;
    int rate;
    Sanbox2 sw;
    FwLoader loader;
    boolean closeOnCancel;
    boolean canceling;
    boolean terminating;
    boolean successful;
    ErrorType errorType;
    private static QFileChooser fileChooser;
    JPanel panel = new JPanel();
    GridBagLayout layout = new GridBagLayout();
    Insets textFieldInsets = new Insets(2, 2, 2, 2);
    ButtonListener buttonListener = new ButtonListener();
    JPanel messagePanel = new JPanel();
    JLabel messageLabel = new JLabel(" ");
    JPanel fileNamePanel = new JPanel();
    GridBagLayout fileNameLayout = new GridBagLayout();
    JLabel localFileLabel = new JLabel(FabricTreeControl.getResource("FlashLoad.localFileLabel"));
    JButton selectButton = new JButton(FabricTreeControl.getResource("FlashLoad.selectButton"));
    JTextField localFileTextField = new JTextField(40);
    JPanel buttonPanel = new JPanel();
    GridLayout buttonLayout = new GridLayout(1, 4, 4, 0);
    JButton startButton = new JButton(FabricTreeControl.getResource("FlashLoad.startButton"));
    JButton cancelButton = new JButton(FabricTreeControl.getResource("FlashLoad.cancelButton"));
    JButton closeButton = new JButton(FabricTreeControl.getResource("FlashLoad.closeButton"));
    JPanel optionsPanel = new JPanel();
    GridBagLayout optionsLayout = new GridBagLayout();
    JLabel fileTypeLabel = new JLabel(FabricTreeControl.getResource("FlashLoad.fileTypeLabel"));
    ButtonGroup buttonGroup = new ButtonGroup();
    JPanel progressPanel = new JPanel();
    GridBagLayout progressLayout = new GridBagLayout();
    JProgressBar progressBar = new JProgressBar();
    Object[] msgArgs = new Object[4];
    String sentFormat = FabricTreeControl.getResource("FlashLoad.sentFormat");
    String timeFormat = FabricTreeControl.getResource("FlashLoad.timeFormat");
    String notSentFormat = FabricTreeControl.getResource("FlashLoad.notSent");
    MessageFormat sentFormatter = new MessageFormat(this.sentFormat);
    MessageFormat timeFormatter = new MessageFormat(this.timeFormat);
    JLabel sentLabel = new JLabel(" ");
    JLabel timeLabel = new JLabel(" ");
    private boolean loading;

    public LoadFirmwareDialog(Frame frame, Sanbox2 sanbox2) {
        super(frame, true);
        this.title = FabricTreeControl.getResource("FlashLoad.title") + " - " + VendorProperties.getFrameTitle();
        this.sw = sanbox2;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.localFileTextField.setMaximumSize(this.localFileTextField.getSize());
    }

    public LoadFirmwareDialog(Frame frame) {
        super(frame, true);
        this.title = FabricTreeControl.getResource("FlashLoad.title") + " - " + VendorProperties.getFrameTitle();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(this.title);
        this.buttonLayout.setHgap(12);
        this.panel.setLayout(this.layout);
        this.fileNamePanel.setLayout(this.fileNameLayout);
        this.selectButton.addActionListener(this.buttonListener);
        this.localFileTextField.setMargin(this.textFieldInsets);
        if (fileChooser != null) {
            this.localFileTextField.setText(fileChooser.getSelectedFile().getCanonicalPath());
        }
        this.optionsPanel.setLayout(this.optionsLayout);
        this.buttonPanel.setLayout(this.buttonLayout);
        this.startButton.addActionListener(this.buttonListener);
        this.cancelButton.addActionListener(this.buttonListener);
        this.closeButton.addActionListener(this.buttonListener);
        this.progressPanel.setLayout(this.progressLayout);
        this.progressBar.setStringPainted(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.panel.add((Component)this.fileNamePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.fileNamePanel.add((Component)this.selectButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.fileNamePanel.add((Component)this.localFileTextField, new GridBagConstraints(1, 1, 7, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.fileNamePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), FabricTreeControl.getResource("FlashLoad.localFileLabel")));
        this.panel.add((Component)this.progressPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 8, 2, 8), 0, 0));
        this.progressPanel.add((Component)this.messagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 4, 8, 4), 0, 0));
        this.messagePanel.add((Component)this.messageLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.messagePanel.setBorder(BorderFactory.createBevelBorder(1));
        this.progressPanel.add((Component)this.progressBar, new GridBagConstraints(0, 1, 7, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.progressBar.setBorder(BorderFactory.createBevelBorder(1));
        this.progressPanel.add((Component)this.sentLabel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 2, 0), 0, 0));
        this.progressPanel.add((Component)this.timeLabel, new GridBagConstraints(0, 4, 7, 1, 1.0, 0.0, 10, 2, new Insets(4, 4, 4, 0), 0, 0));
        this.progressPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), FabricTreeControl.getResource("FlashLoad.progressLabel")));
        this.panel.add((Component)this.buttonPanel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.buttonPanel.add(this.startButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add((Component)this.helpContextButton, null);
        this.setContextHelpFile(QHelpUtilities.getResource("QDialog.loadFirmwareDialogHelp"));
        this.localFileTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoadFirmwareDialog.this.setSelectStartCloseButtonsEnabled(true);
                LoadFirmwareDialog.this.setCancelButtonEnabled(false);
            }
        });
        this.setSelectStartCloseButtonsEnabled(true);
        this.setCancelButtonEnabled(false);
        this.resetProgress();
        this.getRootPane().setDefaultButton(this.closeButton);
        this.pack();
        this.validate();
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    private void setSelectStartCloseButtonsEnabled(boolean bl) {
        SwingUtilities.invokeLater(new SetSelectStartCloseButtonsEnabled(bl));
    }

    private void setCancelButtonEnabled(boolean bl) {
        SwingUtilities.invokeLater(new SetCancelButtonEnabled(bl));
    }

    private void doSelectFile() {
        FileFilter[] fileFilterArray;
        if (fileChooser == null) {
            fileFilterArray = UserPreferences.getInstance().getWorkingDirectory();
            fileChooser = new QFileChooser((String)fileFilterArray);
        }
        fileFilterArray = fileChooser.getChoosableFileFilters();
        int n = fileFilterArray.length - 1;
        while (n > 0) {
            fileChooser.removeChoosableFileFilter(fileFilterArray[n--]);
        }
        FwFileFilter fwFileFilter = new FwFileFilter((SanboxChassis)this.sw);
        fileChooser.addChoosableFileFilter(fwFileFilter);
        fileChooser.setFileFilter(fwFileFilter);
        if (fileChooser.showOpenDialog(this) == 0) {
            this.localFileTextField.setText(fileChooser.getSelectedFile().toString());
        }
        this.setSelectStartCloseButtonsEnabled(true);
    }

    private void showError(String string) {
        this.showMessage(0, string);
        this.setSelectStartCloseButtonsEnabled(true);
        this.updateMessage(" ");
    }

    private void doPutFile() {
        this.resetProgress();
        this.successful = false;
        this.setSelectStartCloseButtonsEnabled(false);
        this.loading = true;
        File file = new File(this.localFileTextField.getText());
        if (!file.exists()) {
            this.showError(FabricTreeControl.getResource("FlashLoad.fileNotFound"));
            return;
        }
        if (!file.canRead()) {
            this.showError(FabricTreeControl.getResource("FlashLoad.fileNotReadable"));
            return;
        }
        this.fileSize = file.length();
        this.updateMessage(FabricTreeControl.getResource("FlashLoad.verifyChksum"));
        if (!this.sw.verifyFwChecksum(file)) {
            this.startTime = System.currentTimeMillis();
            this.errorType = new FwLoadError(2);
            this.startTerminate();
            return;
        }
        this.updateMessage(FabricTreeControl.getResource("FlashLoad.connecting"));
        this.startTime = System.currentTimeMillis();
        this.timeElapsed = 0L;
        try {
            this.loader = new FwLoader(this.sw, file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.showError(FabricTreeControl.getResource("FlashLoad.fileNotFound"));
            return;
        }
        this.loader.addEventListener((FwLoaderEventListener)this);
        this.loader.start();
        this.setCancelButtonEnabled(true);
    }

    public boolean wasSuccessful() {
        return this.successful;
    }

    public void receiveEvent(FwLoaderEvent fwLoaderEvent) {
        block0 : switch (fwLoaderEvent.getEventType()) {
            case 6001: {
                if (fwLoaderEvent.isSuccessful()) {
                    this.successful = true;
                    this.doClose();
                    break;
                }
                this.setCancelButtonEnabled(false);
                if (fwLoaderEvent.getErrorType() instanceof FwLoadError) {
                    switch (((FwLoadError)fwLoaderEvent.getErrorType()).getError()) {
                        case 11: {
                            this.successful = false;
                            if (this.isCanceling()) {
                                this.finishCancel();
                                break block0;
                            }
                            if (!this.terminating) break block0;
                            this.finishTerminate();
                            break block0;
                        }
                        case 13: {
                            this.successful = false;
                            this.showMessage(0, FabricTreeControl.getResource("FlashLoad.unpackUnknown"));
                            this.setSelectStartCloseButtonsEnabled(true);
                            this.resetProgress();
                            break block0;
                        }
                    }
                    this.errorType = (FwLoadError)fwLoaderEvent.getErrorType();
                    if (this.terminating) break;
                    this.startTerminate();
                    break;
                }
                this.errorType = fwLoaderEvent.getErrorType();
                if (this.terminating) break;
                this.startTerminate();
                break;
            }
            case 6000: {
                this.showProgress((Long)fwLoaderEvent.getValue());
                break;
            }
            case 6005: {
                this.updateMessage(FabricTreeControl.getResource("FlashLoad.uploading"));
                break;
            }
            case 6004: {
                this.setCancelButtonEnabled(false);
                break;
            }
            case 6002: {
                this.setCancelButtonEnabled(false);
                this.updateMessage(FabricTreeControl.getResource("FlashLoad.waitForUnpack"));
            }
        }
    }

    public void setSwitch(Sanbox2 sanbox2) {
        this.sw = sanbox2;
        this.resetProgress();
        this.successful = false;
        this.selectButton.requestFocus();
        this.setSelectStartCloseButtonsEnabled(true);
    }

    private synchronized boolean isCanceling() {
        return this.canceling;
    }

    private synchronized void startCancel(boolean bl) {
        this.canceling = true;
        this.closeOnCancel = bl;
        this.setCancelButtonEnabled(false);
        this.updateMessage(FabricTreeControl.getResource("FlashLoad.cancelling"));
        this.loader.cancel();
    }

    private void finishCancel() {
        this.updateMessage(" ");
        this.showMessage(1, FabricTreeControl.getResource("FlashLoad.uploadCanceled"));
        this.loading = false;
        this.canceling = false;
        this.setSelectStartCloseButtonsEnabled(true);
        if (this.closeOnCancel) {
            this.closeOnCancel = false;
            this.hide();
        }
    }

    private void startTerminate() {
        this.terminating = true;
        this.finishTerminate();
    }

    private void finishTerminate() {
        if (this.errorType != null) {
            if (this.errorType instanceof FwLoadError) {
                switch (this.errorType.getError()) {
                    case 2: {
                        this.showMessage(0, FabricTreeControl.getResource("FlashLoad.badchksum"));
                        this.successful = false;
                        this.resetProgress();
                        break;
                    }
                    case 12: {
                        this.showMessage(0, FabricTreeControl.getResource("FlashLoad.uploadTimedOut"));
                        break;
                    }
                    case 10: {
                        String string = FabricTreeControl.translateErrorType(this.errorType);
                        if (this.fileSize > 12000000L) {
                            string = string + "\n";
                            string = string + FabricTreeControl.getResource("FlashLoad.largeImage");
                        }
                        this.showMessage(0, string);
                        break;
                    }
                    default: {
                        String string = FabricTreeControl.translateErrorType(this.errorType);
                        String string2 = ((FwLoadError)this.errorType).getCause();
                        if (string2 != null) {
                            string = string + "\n" + string2;
                        }
                        this.showMessage(0, string);
                        break;
                    }
                }
            } else {
                String string = FabricTreeControl.translateErrorType(this.errorType);
                this.showMessage(0, string);
            }
        }
        this.updateMessage(" ");
        this.loading = false;
        this.terminating = false;
        if (this.loader != null) {
            this.loader.removeEventListener((FwLoaderEventListener)this);
        }
        this.setSelectStartCloseButtonsEnabled(true);
    }

    private void doClose() {
        this.updateMessage(" ");
        this.resetProgress();
        this.loading = false;
        this.setVisible(false);
        if (this.loader != null) {
            this.loader.removeEventListener((FwLoaderEventListener)this);
        }
    }

    private void resetProgress() {
        SwingUtilities.invokeLater(new ResetProgress());
    }

    private void updateMessage(String string) {
        SwingUtilities.invokeLater(new UpdateMessage(string));
    }

    private void showProgress(long l) {
        SwingUtilities.invokeLater(new UpdateProgress(l));
    }

    protected void showMessage(int n, String string) {
        JOptionPane.showMessageDialog(this, string, this.title, n);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            if (this.closeButton.isEnabled()) {
                this.doClose();
            } else if (this.cancelButton.isEnabled()) {
                this.startCancel(true);
            }
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    static /* synthetic */ void access$400(LoadFirmwareDialog loadFirmwareDialog) {
        loadFirmwareDialog.doPutFile();
    }

    private class UpdateProgress
    implements Runnable {
        long byteCount;

        public UpdateProgress(long l) {
            this.byteCount = l;
        }

        public void run() {
            LoadFirmwareDialog.this.timeElapsed = (System.currentTimeMillis() - LoadFirmwareDialog.this.startTime) / 1000L;
            if (LoadFirmwareDialog.this.timeElapsed > 0L) {
                LoadFirmwareDialog.this.rate = (int)(this.byteCount / LoadFirmwareDialog.this.timeElapsed) / 1024;
                if (LoadFirmwareDialog.this.rate > 0) {
                    LoadFirmwareDialog.this.timeLeft = (LoadFirmwareDialog.this.fileSize - this.byteCount) / (long)(LoadFirmwareDialog.this.rate * 1024);
                }
                LoadFirmwareDialog.this.msgArgs[0] = new Long(this.byteCount);
                LoadFirmwareDialog.this.msgArgs[1] = new Long(LoadFirmwareDialog.this.fileSize);
                LoadFirmwareDialog.this.msgArgs[2] = new Float(LoadFirmwareDialog.this.rate);
                LoadFirmwareDialog.this.sentLabel.setText(LoadFirmwareDialog.this.sentFormatter.format(LoadFirmwareDialog.this.msgArgs));
                LoadFirmwareDialog.this.msgArgs[0] = new Long(LoadFirmwareDialog.this.timeElapsed / 60L);
                LoadFirmwareDialog.this.msgArgs[1] = new Long(LoadFirmwareDialog.this.timeElapsed % 60L);
                LoadFirmwareDialog.this.msgArgs[2] = new Long(LoadFirmwareDialog.this.timeLeft / 60L);
                LoadFirmwareDialog.this.msgArgs[3] = new Long(LoadFirmwareDialog.this.timeLeft % 60L);
                LoadFirmwareDialog.this.timeLabel.setText(LoadFirmwareDialog.this.timeFormatter.format(LoadFirmwareDialog.this.msgArgs));
            }
            if (LoadFirmwareDialog.this.fileSize > 0L) {
                LoadFirmwareDialog.this.progressBar.setValue((int)(this.byteCount * (long)LoadFirmwareDialog.this.progressBar.getMaximum() / LoadFirmwareDialog.this.fileSize));
            }
        }
    }

    private class UpdateMessage
    implements Runnable {
        String msg;

        public UpdateMessage(String string) {
            this.msg = string;
        }

        public void run() {
            LoadFirmwareDialog.this.messageLabel.setText(this.msg);
        }
    }

    private class ResetProgress
    implements Runnable {
        private ResetProgress() {
        }

        public void run() {
            LoadFirmwareDialog.this.progressBar.setValue(0);
            LoadFirmwareDialog.this.sentLabel.setText(" ");
            LoadFirmwareDialog.this.timeLabel.setText(" ");
            LoadFirmwareDialog.this.progressBar.setEnabled(false);
        }
    }

    private class SetCancelButtonEnabled
    implements Runnable {
        private boolean enabled;

        public SetCancelButtonEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void run() {
            LoadFirmwareDialog.this.cancelButton.setEnabled(this.enabled);
        }
    }

    private class SetSelectStartCloseButtonsEnabled
    implements Runnable {
        private boolean enabled;

        public SetSelectStartCloseButtonsEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void run() {
            LoadFirmwareDialog.this.selectButton.setEnabled(this.enabled);
            if (LoadFirmwareDialog.this.localFileTextField.getText().length() > 0) {
                LoadFirmwareDialog.this.startButton.setEnabled(this.enabled);
            } else {
                LoadFirmwareDialog.this.startButton.setEnabled(false);
            }
            LoadFirmwareDialog.this.closeButton.setEnabled(this.enabled);
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == LoadFirmwareDialog.this.selectButton) {
                LoadFirmwareDialog.this.doSelectFile();
            } else if (object == LoadFirmwareDialog.this.startButton) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ ButtonListener this$1;
                    {
                        this.this$1 = buttonListener;
                    }

                    public void run() {
                        LoadFirmwareDialog.access$400(ButtonListener.access$300(this.this$1));
                    }
                };
                thread.start();
            } else if (object == LoadFirmwareDialog.this.cancelButton) {
                LoadFirmwareDialog.this.startCancel(false);
            } else if (object == LoadFirmwareDialog.this.closeButton) {
                LoadFirmwareDialog.this.doClose();
            }
        }

        static /* synthetic */ LoadFirmwareDialog access$300(ButtonListener buttonListener) {
            return buttonListener.LoadFirmwareDialog.this;
        }
    }
}

