/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.ComAgent;
import com.qlogic.device.fcfabric.FCDiscoverer;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricLink;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.ForeignSwitch;
import com.qlogic.device.fcfabric.SanboxChassis;
import com.qlogic.device.fcfabric.WorldWideName;
import com.qlogic.device.fcfabric.util.messages.UtilAgent;
import com.qlogic.qms.fabric.DefaultFilePasswordDialog;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.FcFabricFileDialog;
import com.qlogic.qms.fabric.PopupDialog;
import com.qlogic.qms.fabric.TopologyPanel;
import com.qlogic.qms.fabric.UserPreferences;
import com.qlogic.ui.MainFrame;
import com.qlogic.util.Md5Crypt;
import com.qlogic.util.StringUtilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class FcFabricsFile {
    private static final String SALT = "$1$pyFWwzTk";
    public static final int DEFAULT_VERSION = 1;
    private static final String PI_VERSION = "xml version=\"1.0\" encoding=\"UTF-8\"";
    private static final String FABRIC_LIST_TAG = "FcFabricList";
    private static final String VERSION_TAG = "Version";
    private static final String NAME_TAG = "Name";
    private static final String PROXY_TAG = "Proxy";
    private static final String IP_ADDRESS_TAG = "IpAddress";
    private static final String USER_NAME_TAG = "UserName";
    private static final String PASSWORD_TAG = "Password";
    private static final String FABRIC_TAG = "FcFabric";
    private static final String SWITCH_TAG = "FcSwitch";
    private static final String TYPE_TAG = "Type";
    private static final String WWN_TAG = "WWN";
    private static final String LINK_TAG = "Link";
    private static final String ENDPOINT_TAG = "Endpoint";
    private static final String PORT_TAG = "Port";
    private static final String DOMAIN_ID_TAG = "DomainID";
    private static final String POS_X_TAG = "PosX";
    private static final String POS_Y_TAG = "PosY";
    private static final String BASE_IP_ADDRESS_TAG = "BaseIpAddress";
    private static final String SLOT_NUMBER_TAG = "SlotNumber";
    private static final String VIEW_TAG = "View";
    public static final String DEFAULT_FAB_FILE_NAME = "fc_view.dft";
    public static File fabricsFile;
    public static String fabricsFilePassword;
    public static boolean fabricsHaveChanged;
    public static boolean saveOnExitComplete;
    public static boolean readOnStartComplete;
    public static File defaultFabricsFile;
    public static String defaultFabricsFilePassword;

    private static Fabric addFabric(String string, InetAddress inetAddress, String string2, String string3) {
        if (string3 == null) {
            string3 = new String("");
        }
        if (string == null) {
            return FabricList.getInstance().addFabric(inetAddress, string, string2, string3);
        }
        Fabric fabric = FcFabricsFile.addFabric2(string, inetAddress, string2, string3);
        if (fabric != null) {
            return fabric;
        }
        int n = 1;
        String string4;
        while ((fabric = FcFabricsFile.addFabric2(string4 = string + '[' + n + ']', inetAddress, string2, string3)) == null) {
            ++n;
        }
        return fabric;
    }

    private static Fabric addFabric2(String string, InetAddress inetAddress, String string2, String string3) {
        Fabric fabric;
        if (string3 == null) {
            string3 = new String("");
        }
        if ((fabric = FabricList.getFabric((String)string)) == null) {
            return FabricList.getInstance().addFabric(inetAddress, string, string2, string3);
        }
        if (fabric.getIpAddr().equals(inetAddress)) {
            return fabric;
        }
        return null;
    }

    private static String parseString(Element element) throws IOException {
        if (element != null) {
            return element.getTextTrim();
        }
        throw new IOException("failed parsing <" + element.getName() + "> tag");
    }

    private static String parseString(Element element, String string) throws IOException {
        Element element2 = element.getChild(string);
        if (element2 == null) {
            throw new IOException("failed parsing <" + string + "> in <" + element.getName() + ">");
        }
        return FcFabricsFile.parseString(element2);
    }

    private static int parseInt(Element element) throws IOException {
        if (element != null) {
            String string = element.getTextTrim();
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IOException("failed parsing <" + element.getName() + "> tag");
    }

    private static int parseInt(Element element, String string) throws IOException {
        return FcFabricsFile.parseInt(element.getChild(string));
    }

    private static InetAddress parseInetAddress(Element element) throws IOException {
        if (element != null) {
            String string = element.getTextTrim();
            try {
                return InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        throw new IOException("failed parsing <" + element.getName() + "> tag");
    }

    private static InetAddress parseInetAddress(Element element, String string) throws IOException {
        Element element2 = element.getChild(string);
        if (element2 == null) {
            throw new IOException("failed parsing <" + string + "> in <" + element.getName() + ">");
        }
        return FcFabricsFile.parseInetAddress(element2);
    }

    private static WorldWideName parseWWN(Element element) throws IOException {
        if (element != null) {
            String string = element.getTextTrim();
            try {
                return new WorldWideName(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new IOException("failed parsing <" + element.getName() + "> tag");
    }

    private static WorldWideName parseWWN(Element element, String string) throws IOException {
        Element element2 = element.getChild(string);
        if (element2 == null) {
            throw new IOException("failed parsing <" + string + "> in <" + element.getName() + ">");
        }
        return FcFabricsFile.parseWWN(element2);
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n2));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static byte[] toBytes(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() % 2 > 0) {
            stringBuffer.insert(0, '0');
        }
        byte[] byArray = new byte[stringBuffer.length() / 2];
        int n = 0;
        while (n < byArray.length) {
            int n2 = n * 2;
            byArray[n] = (byte)(Character.digit(stringBuffer.charAt(n2), 16) * 16 + Character.digit(stringBuffer.charAt(n2 + 1), 16));
            ++n;
        }
        return byArray;
    }

    private static void xor(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray2.length) {
            int n2 = n;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray[n % byArray.length]);
            ++n;
        }
    }

    private static byte[] hash(String string) {
        int n = SALT.length() + 1;
        byte[] byArray = Md5Crypt.crypt(string, SALT);
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static String encrypt(String string, String string2) {
        int n;
        byte[] byArray = FcFabricsFile.hash(string);
        byte[] byArray2 = string2.getBytes();
        if (byArray2.length + 2 > (n = byArray.length)) {
            n = ((byArray2.length + 2) / n + 1) * n;
        }
        byte[] byArray3 = new byte[n];
        byArray3[0] = (byte)(byArray2.length / 256);
        byArray3[1] = (byte)(byArray2.length % 256);
        System.arraycopy(byArray2, 0, byArray3, 2, byArray2.length);
        FcFabricsFile.xor(byArray, byArray3);
        return FcFabricsFile.toHexString(byArray3);
    }

    private static String decrypt(String string, String string2) throws IOException {
        byte[] byArray = FcFabricsFile.hash(string);
        byte[] byArray2 = FcFabricsFile.toBytes(string2);
        FcFabricsFile.xor(byArray, byArray2);
        int n = ((byArray2[0] & 0xFF) << 16) + (byArray2[1] & 0xFF);
        if (n > byArray2.length) {
            throw new IOException("File has become corrupted");
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 2, byArray3, 0, n);
        return new String(byArray3);
    }

    public static void parse(String string, String string2) throws IOException {
        FcFabricsFile.parse(new File(string), string2);
    }

    public static void parseDefault() throws IOException {
        String string = "default.fab";
        FcFabricsFile.parse(new File(string), "");
    }

    public static void parse(File file, String string) throws IOException {
        Document document;
        if (string == null) {
            string = new String("");
        }
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            document = sAXBuilder.build(file);
        }
        catch (JDOMException jDOMException) {
            throw new IOException(jDOMException.getMessage());
        }
        Element element = document.getRootElement();
        if (element == null) {
            throw new IOException("failed parsing <View> tag");
        }
        Element element2 = element.getChild(FABRIC_LIST_TAG);
        if (element2 == null) {
            throw new IOException("failed parsing <FcFabricList> tag");
        }
        int n = FcFabricsFile.parseInt(element2, VERSION_TAG);
        if (n != 1) {
            throw new IOException("unrecognized version (" + n + ")");
        }
        List list = element2.getChildren(FABRIC_TAG);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element3;
            Object object;
            Object object2;
            Element element4 = (Element)iterator.next();
            String string2 = FcFabricsFile.parseString(element4, NAME_TAG);
            Element element5 = element4.getChild(PROXY_TAG);
            InetAddress inetAddress = InetAddress.getByName(element5.getAttributeValue(IP_ADDRESS_TAG));
            WorldWideName worldWideName = null;
            if (element5.getAttribute(WWN_TAG) != null) {
                worldWideName = new WorldWideName(element5.getAttributeValue(WWN_TAG));
            }
            String string3 = null;
            String string4 = null;
            Element element6 = element4.getChild(USER_NAME_TAG);
            Element element7 = element4.getChild(PASSWORD_TAG);
            if (element6 != null && element7 == null) {
                throw new IOException("failed parsing <Password> tag");
            }
            if (element6 == null && element7 != null) {
                throw new IOException("failed parsing <UserName> tag");
            }
            if (element6 != null && element7 != null) {
                string3 = FcFabricsFile.decrypt(string, FcFabricsFile.parseString(element6));
                string4 = FcFabricsFile.decrypt(string, FcFabricsFile.parseString(element7));
            }
            Fabric fabric = FcFabricsFile.addFabric(string2, inetAddress, string3, string4);
            UtilAgent utilAgent = (UtilAgent)fabric.getComAgent();
            utilAgent.setConnectionWwnAndFcAddress(worldWideName, 0);
            list = element4.getChildren(SWITCH_TAG);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                int n2;
                object2 = (Element)iterator2.next();
                worldWideName = FcFabricsFile.parseWWN((Element)object2, WWN_TAG);
                int n3 = FcFabricsFile.parseInt((Element)object2, DOMAIN_ID_TAG);
                object = object2.getChild(TYPE_TAG);
                if (object == null) {
                    element3 = new ForeignSwitch(n3 << 16, worldWideName, (ComAgent)utilAgent, 5);
                } else {
                    String string5 = FcFabricsFile.parseString((Element)object2, NAME_TAG);
                    n2 = FcFabricsFile.parseInt((Element)object);
                    element3 = FCDiscoverer.createChassis((String)string5, (WorldWideName)worldWideName, (int)n2, (UtilAgent)utilAgent);
                    element3.setFcAddress(n3 << 16);
                }
                if (n3 == 0) {
                    element3.setNotInFabric();
                }
                try {
                    int n4 = FcFabricsFile.parseInt((Element)object2, POS_X_TAG);
                    n2 = FcFabricsFile.parseInt((Element)object2, POS_Y_TAG);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    TopologyPanel.saveChassisPos(fabric.getName(), worldWideName, n4, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fabric.addSwitch((Chassis)element3);
            }
            list = element4.getChildren(LINK_TAG);
            object2 = list.iterator();
            while (object2.hasNext()) {
                element3 = (Element)object2.next();
                object = element3.getChildren(ENDPOINT_TAG);
                Iterator iterator3 = object.iterator();
                Element element8 = (Element)iterator3.next();
                Element element9 = (Element)iterator3.next();
                WorldWideName worldWideName2 = new WorldWideName(element8.getAttributeValue(WWN_TAG));
                int n5 = Integer.parseInt(element8.getAttributeValue(PORT_TAG));
                WorldWideName worldWideName3 = new WorldWideName(element9.getAttributeValue(WWN_TAG));
                int n6 = Integer.parseInt(element9.getAttributeValue(PORT_TAG));
                fabric.addLink(fabric.getSwitchByWWN(worldWideName2), n5, fabric.getSwitchByWWN(worldWideName3), n6);
            }
            fabric.start();
        }
    }

    public static void save(String string, String string2) throws IOException {
        FcFabricsFile.save(new File(string), string2);
    }

    public static void save(File file, String string) throws IOException {
        FcFabricsFile.save(file, 1, string);
    }

    public static int saveDefault() throws IOException {
        Object object;
        String string = UserPreferences.getInstance().getWorkingDirectory();
        if (defaultFabricsFile == null) {
            defaultFabricsFile = new File(string + File.separator + DEFAULT_FAB_FILE_NAME);
        } else {
            int n;
            object = defaultFabricsFile.getAbsolutePath();
            StringBuffer stringBuffer = new StringBuffer((String)object);
            String string2 = stringBuffer.substring(0, (n = ((String)object).indexOf(DEFAULT_FAB_FILE_NAME)) - 1);
            if (!string.equals(string2)) {
                defaultFabricsFile = new File(string + File.separator + DEFAULT_FAB_FILE_NAME);
            }
        }
        if (defaultFabricsFilePassword == null) {
            object = new DefaultFilePasswordDialog((Frame)MainFrame.instance(), 2);
            ((Dialog)object).setVisible(true);
            int n = ((DefaultFilePasswordDialog)object).getState();
            if (n == 0) {
                defaultFabricsFilePassword = ((DefaultFilePasswordDialog)object).getPassword().trim();
                FcFabricsFile.save(defaultFabricsFile, defaultFabricsFilePassword);
            } else if (n == 1) {
                return -1;
            }
        } else {
            FcFabricsFile.save(defaultFabricsFile, defaultFabricsFilePassword);
        }
        return 1;
    }

    public static void save(File file, int n, String string) throws IOException {
        XMLOutputter xMLOutputter;
        Document document = new Document();
        if (string == null) {
            string = new String("");
        }
        Element element = new Element(VIEW_TAG);
        document.setRootElement(element);
        Element element2 = new Element(FABRIC_LIST_TAG);
        element.addContent(element2);
        Element element3 = new Element(VERSION_TAG);
        element3.addContent(Integer.toString(n));
        element2.addContent(element3);
        Object object = FabricList.getInstance().size() > 0 ? FabricList.getFirstFabric() : null;
        while (object != null) {
            Object object2;
            FabricLink fabricLink;
            String string2;
            xMLOutputter = new Element(FABRIC_TAG);
            String string3 = object.getFabricName();
            if (string3 != null) {
                element3 = new Element(NAME_TAG);
                element3.addContent(string3);
                xMLOutputter.addContent(element3);
            }
            element3 = new Element(PROXY_TAG);
            InetAddress inetAddress = object.getComAgent().getIpAddress();
            element3.setAttribute(IP_ADDRESS_TAG, inetAddress.getHostAddress());
            SanboxChassis sanboxChassis = object.getConnectionSwitch();
            if (sanboxChassis != null) {
                element3.setAttribute(WWN_TAG, sanboxChassis.getWWName().delimit());
            }
            xMLOutputter.addContent(element3);
            String string4 = object.getUserName();
            if (string4 != null) {
                element3 = new Element(USER_NAME_TAG);
                element3.addContent(FcFabricsFile.encrypt(string, string4));
                xMLOutputter.addContent(element3);
            }
            if ((string2 = object.getPassword()) != null) {
                element3 = new Element(PASSWORD_TAG);
                element3.addContent(FcFabricsFile.encrypt(string, string2));
                xMLOutputter.addContent(element3);
            }
            Chassis chassis = object.getFirstSwitch();
            while (chassis != null) {
                fabricLink = new Element(SWITCH_TAG);
                if (chassis instanceof SanboxChassis) {
                    object2 = (SanboxChassis)chassis;
                    element3 = new Element(NAME_TAG);
                    element3.addContent(object2.getChassisName());
                    fabricLink.addContent(element3);
                    element3 = new Element(TYPE_TAG);
                    element3.addContent(Integer.toString(object2.getChassisType()));
                    fabricLink.addContent(element3);
                }
                element3 = new Element(WWN_TAG);
                element3.addContent(chassis.getWWName().delimit());
                fabricLink.addContent(element3);
                element3 = new Element(DOMAIN_ID_TAG);
                element3.addContent(Integer.toString(chassis.getDomainId()));
                fabricLink.addContent(element3);
                object2 = TopologyPanel.getPos(chassis, object);
                if (object2 != null) {
                    element3 = new Element(POS_X_TAG);
                    element3.addContent(Integer.toString(object2.x));
                    fabricLink.addContent(element3);
                    element3 = new Element(POS_Y_TAG);
                    element3.addContent(Integer.toString(object2.y));
                    fabricLink.addContent(element3);
                }
                xMLOutputter.addContent((Element)fabricLink);
                chassis = object.getNextSwitch(chassis);
            }
            fabricLink = object.getFirstLink();
            while (fabricLink != null) {
                object2 = new Element(LINK_TAG);
                element3 = new Element(ENDPOINT_TAG);
                element3.setAttribute(WWN_TAG, fabricLink.getSwitch1().getWWName().delimit());
                element3.setAttribute(PORT_TAG, Integer.toString(fabricLink.getPortNumber1()));
                object2.addContent(element3);
                element3 = new Element(ENDPOINT_TAG);
                element3.setAttribute(WWN_TAG, fabricLink.getSwitch2().getWWName().delimit());
                element3.setAttribute(PORT_TAG, Integer.toString(fabricLink.getPortNumber2()));
                object2.addContent(element3);
                xMLOutputter.addContent(object2);
                fabricLink = object.getNextLink(fabricLink);
            }
            element2.addContent((Element)xMLOutputter);
            object = FabricList.getNextFabric((Fabric)object);
        }
        xMLOutputter = new XMLOutputter();
        xMLOutputter.setNewlines(true);
        xMLOutputter.setIndent("    ");
        xMLOutputter.output(document, (OutputStream)new FileOutputStream(file));
    }

    public static boolean saveFabrics() {
        if (fabricsFile == null) {
            return FcFabricsFile.saveFabricsAs();
        }
        try {
            FcFabricsFile.save(fabricsFile, fabricsFilePassword);
            fabricsHaveChanged = false;
            return true;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{fabricsFile.getPath()};
            String string = FabricTreeControl.getResource("menu.file.save.failed");
            JOptionPane.showMessageDialog((Component)MainFrame.instance(), StringUtilities.formatString(string, objectArray), FabricTreeControl.getResource("menu.file.save"), 0);
            return false;
        }
    }

    public static boolean saveFabricsAs() {
        try {
            UserPreferences userPreferences;
            Properties properties;
            String string;
            FcFabricFileDialog fcFabricFileDialog = new FcFabricFileDialog((Frame)MainFrame.instance(), 1);
            if (fabricsFile != null) {
                fcFabricFileDialog.setFabricFile(fabricsFile.toString());
            }
            if ((string = (properties = (userPreferences = UserPreferences.getInstance()).getUserProperties()).getProperty("workingDir")) != null && string.length() > 0) {
                FcFabricFileDialog.getFileChooser().setCurrentDirectory(new File(string));
            }
            fcFabricFileDialog.setVisible(true);
            if (fcFabricFileDialog.getState() != 0) {
                return false;
            }
            fabricsFile = new File(fcFabricFileDialog.getFabricFileName());
            fabricsFilePassword = fcFabricFileDialog.getPassword();
            String string2 = fabricsFile.getAbsolutePath();
            File file = new File(string2);
            if (file.exists()) {
                String string3 = FabricTreeControl.getResource("menu.file.saveViewAs.file") + "  '" + string2 + "'  " + FabricTreeControl.getResource("menu.file.saveViewAs.alreadyExists");
                boolean bl = PopupDialog.showDialog((Frame)MainFrame.instance(), 1, FabricTreeControl.getResource("menu.file.saveViewAs.fileAlreadyExists"), string3);
                if (!bl) {
                    return false;
                }
            }
            file.createNewFile();
            if (!file.canWrite()) {
                return false;
            }
            fabricsFile = file;
        }
        catch (Exception exception) {
            return false;
        }
        return FcFabricsFile.saveFabrics();
    }

    public static boolean defaultFileExists() {
        if (defaultFabricsFile == null) {
            String string = UserPreferences.getInstance().getWorkingDirectory();
            defaultFabricsFile = new File(string + File.separator + DEFAULT_FAB_FILE_NAME);
        }
        return defaultFabricsFile.exists();
    }

    public static boolean openDefault() {
        Object object;
        if (defaultFabricsFile == null && !(defaultFabricsFile = new File((String)(object = UserPreferences.getInstance().getWorkingDirectory()) + File.separator + DEFAULT_FAB_FILE_NAME)).exists()) {
            return true;
        }
        if (defaultFabricsFilePassword == null) {
            object = new DefaultFilePasswordDialog((Frame)MainFrame.instance(), 1);
            ((Dialog)object).setVisible(true);
            int n = ((DefaultFilePasswordDialog)object).getState();
            if (n == 0) {
                defaultFabricsFilePassword = ((DefaultFilePasswordDialog)object).getPassword().trim();
            } else {
                return n != -1;
            }
        }
        object = fabricsFile;
        String string = fabricsFilePassword;
        try {
            fabricsFile = defaultFabricsFile;
            fabricsFilePassword = defaultFabricsFilePassword;
            FcFabricsFile.parse(fabricsFile, fabricsFilePassword);
            fabricsHaveChanged = false;
        }
        catch (IOException iOException) {
            defaultFabricsFilePassword = null;
            Object[] objectArray = new Object[]{fabricsFile == null ? iOException.getMessage() : fabricsFile.getPath()};
            String string2 = FabricTreeControl.getResource("menu.file.open.failed");
            JOptionPane.showMessageDialog((Component)MainFrame.instance(), StringUtilities.formatString(string2, objectArray), FabricTreeControl.getResource("menu.file.openView"), 0);
        }
        fabricsFile = object;
        fabricsFilePassword = string;
        return true;
    }

    public static void openFabrics() {
        if (fabricsHaveChanged && FabricList.getInstance().size() != 0) {
            int n = JOptionPane.showConfirmDialog((Component)MainFrame.instance(), FabricTreeControl.getResource("menu.file.open.confirmSave"), FabricTreeControl.getResource("menu.file.open.fabricChanged"), 1);
            if (n == 2 || n == -1 || n == 0 && !FcFabricsFile.saveFabricsAs()) {
                return;
            }
            fabricsHaveChanged = false;
        }
        try {
            UserPreferences userPreferences;
            Properties properties;
            String string;
            FcFabricFileDialog fcFabricFileDialog = new FcFabricFileDialog((Frame)MainFrame.instance(), 0);
            if (fabricsFile != null) {
                fcFabricFileDialog.setFabricFile(fabricsFile.toString());
            }
            if ((string = (properties = (userPreferences = UserPreferences.getInstance()).getUserProperties()).getProperty("workingDir")) != null && string.length() > 0) {
                FcFabricFileDialog.getFileChooser().setCurrentDirectory(new File(string));
            }
            fcFabricFileDialog.setVisible(true);
            if (fcFabricFileDialog.getState() != 0) {
                return;
            }
            fabricsFile = new File(fcFabricFileDialog.getFabricFileName());
            fabricsFilePassword = fcFabricFileDialog.getPassword();
            FcFabricsFile.parse(fabricsFile, fabricsFilePassword);
            fabricsHaveChanged = false;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{fabricsFile == null ? exception.getMessage() : fabricsFile.getPath()};
            String string = FabricTreeControl.getResource("menu.file.open.failed");
            JOptionPane.showMessageDialog((Component)MainFrame.instance(), StringUtilities.formatString(string, objectArray), FabricTreeControl.getResource("menu.file.openView"), 0);
        }
    }

    static {
        fabricsHaveChanged = false;
        saveOnExitComplete = false;
        readOnStartComplete = false;
        defaultFabricsFile = null;
        defaultFabricsFilePassword = null;
    }
}

