/*
 * Decompiled with CFR 0.152.
 */
package com.qlogic.qms.fabric;

import com.qlogic.device.fcfabric.Chassis;
import com.qlogic.device.fcfabric.Fabric;
import com.qlogic.device.fcfabric.FabricList;
import com.qlogic.device.fcfabric.event.FabricEvent;
import com.qlogic.device.fcfabric.event.FabricEventListener;
import com.qlogic.qms.fabric.FabricTreeControl;
import com.qlogic.qms.fabric.VendorProperties;
import com.qlogic.ui.QDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CloseSessionsDialog
extends QDialog
implements FabricEventListener {
    private static final String titleTxt = FabricTreeControl.getResource("CloseSessionsDialog.title") + "-" + VendorProperties.getFrameTitle();
    private static final String okTxt = FabricTreeControl.getResource("CloseSessionsDialog.okButton");
    private static final String closingSessionsTxt = FabricTreeControl.getResource("CloseSessionsDialog.closingSessions");
    private static final String statusTitleTxt = FabricTreeControl.getResource("CloseSessionsDialog.statusTitle");
    private static final String failText = FabricTreeControl.getResource("CloseSessionsDialog.failedClosing");
    private static final String closeText = FabricTreeControl.getResource("CloseSessionsDialog.closed");
    private JButton okButton = new JButton(okTxt);
    private JLabel message = new JLabel(closingSessionsTxt);
    private JTextArea status = new JTextArea(9, 32);
    private JScrollPane statusPane = new JScrollPane(this.status, 22, 32);
    private Container contentPane;
    private FabricList fabricList;
    private int fabricsClosing;
    private boolean sessionCloseFailed;

    public CloseSessionsDialog(Frame frame) {
        super(frame, true);
        this.buildDialog();
    }

    private void buildDialog() {
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(new GridBagLayout());
        this.okButton.addActionListener(new ButtonListener());
        this.status.setEditable(false);
        this.statusPane.setBorder(BorderFactory.createTitledBorder(statusTitleTxt));
        this.setTitle(titleTxt);
        this.contentPane.add((Component)this.message, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.contentPane.add((Component)this.statusPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 4, 0, 4), 0, 0));
        this.contentPane.add((Component)this.okButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 0, 4, 0), 0, 0));
        this.pack();
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    public void closeSessions(Fabric fabric) {
        this.fabricsClosing = 1;
        this.status.setText("");
        fabric.addEventListener((FabricEventListener)this);
        fabric.closeSessions();
        this.show();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void closeSessions(FabricList fabricList) {
        this.fabricsClosing = fabricList.size();
        this.status.setText("");
        Fabric fabric = null;
        while ((fabric = FabricList.getNextFabric(fabric)) != null) {
            if (fabric.hasSanbox2()) {
                fabric.addEventListener((FabricEventListener)this);
                fabric.closeSessions();
                continue;
            }
            --this.fabricsClosing;
        }
        this.show();
    }

    public void receiveEvent(FabricEvent fabricEvent) {
        if (fabricEvent.getEventType() != 2019) {
            return;
        }
        Fabric fabric = fabricEvent.getFabric();
        Vector vector = (Vector)fabricEvent.getValue();
        fabric.removeEventListener((FabricEventListener)this);
        if (vector != null && vector.size() > 0) {
            this.sessionCloseFailed = true;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Chassis chassis = (Chassis)iterator.next();
                this.status.append(failText + "   " + fabric.getFabricName() + " - " + chassis.toString() + "\n");
            }
        } else {
            this.status.append(closeText + "  " + fabric.getFabricName() + "\n");
        }
        --this.fabricsClosing;
        if (this.fabricsClosing == 0 && !this.sessionCloseFailed) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.hide();
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == CloseSessionsDialog.this.okButton) {
                if (CloseSessionsDialog.this.fabricsClosing != 0) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                CloseSessionsDialog.this.hide();
            }
        }
    }
}

