/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DerInputStream;
import com.sun.crypto.provider.DerOutputStream;
import com.sun.crypto.provider.DerValue;
import com.sun.crypto.provider.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

class AlgorithmId {
    private ObjectIdentifier oid;
    private DerValue paramsDerVal;
    private byte[] params;

    public AlgorithmId(DerValue derValue) throws IOException {
        if (derValue.tag != 48) {
            throw new IOException("algid parse error: not a sequence");
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        this.oid = derInputStream.getOID();
        if (derInputStream.available() == 0) {
            this.paramsDerVal = null;
        } else {
            this.paramsDerVal = derInputStream.getDerValue();
            if (this.paramsDerVal.tag == 5) {
                this.paramsDerVal = null;
            }
        }
        if (this.paramsDerVal != null) {
            this.params = this.paramsDerVal.toByteArray();
        }
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        this.oid = objectIdentifier;
        this.params = (byte[])byArray.clone();
        this.paramsDerVal = new DerValue(this.params);
    }

    public AlgorithmId(String string, byte[] byArray) throws IOException {
        this.oid = new ObjectIdentifier(string);
        this.params = (byte[])byArray.clone();
        this.paramsDerVal = new DerValue(this.params);
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        if (this.paramsDerVal == null) {
            derOutputStream.putNull();
        } else {
            derOutputStream.putDerValue(this.paramsDerVal);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public byte[] getParameters() {
        return this.params;
    }
}

