/*
 * Copyright (c) 2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SBDP_H
#define	_SBDP_H

#pragma ident	"@(#)sbdp.h	1.1	00/12/08 SMI"

#include <sys/types.h>
#include <sys/daktari.h>

#ifdef	__cplusplus
extern "C" {
#endif

enum sbdp_fru_type {
	SBDP_FRU_UNKNOWN = 0, SBDP_FRU_ERROR, SBDP_FRU_CPU_DUAL_DAK
};

/*
 * So that sbdp knows it's a fru struct and not an ASCII options string.
 * This can be any value that can't be confused with an ASCII string.
 * (The fact that the first byte is zero should do the trick.)
 */

#define	SBDP_FRU_MAGIC	0x000a000b


/*
 * TYPES
 */

struct sbdp_cpuinfo {
	/*
	 * The hex numbers are the offset in the dak_dualcpumodule
	 * FRUprom.  This is informational only.  DR daemon knows this
	 * authoritatively.
	 */
	uint8_t  cache_sz;				/* 0x1911 */
	uint8_t  cache_timing;				/* 0x1912 */
	uint16_t ecache_features;			/* 0x1913 */
	uint16_t cpu_speed;				/* 0x1915 */
	uint32_t cpu_features[DAK_CPUS_PER_BOARD];   	/* 0x1945, 0x1949 */
};


typedef struct sbdp_fru_info {
	uint32_t magic_cookie;
	enum sbdp_fru_type type;
	struct sbdp_cpuinfo cpu_info;
} sbdp_fru_info_t;


#ifdef	__cplusplus
}
#endif

#endif /* _SBDP_H */
